#version 330

uniform sampler2D uDiffuseMap;
uniform sampler2D uIlluminationMap;

uniform float ucTexture; // From 0 to 1


in vec2 fTexCoord;

out vec4 fragColor; // first out variable is automatically written to the screen

void main()
{	
	vec4 skyboxColorDay = texture(uDiffuseMap, fTexCoord);
	vec4 skyboxColorEvening = texture(uIlluminationMap, fTexCoord);
	vec4 skyColor = skyboxColorDay * ucTexture + skyboxColorEvening * (1.0f - ucTexture);
	if (ucTexture < 0.0f)
	{
		float black = ucTexture * -1.0f;
		skyColor = vec4(0,0,0,0) * black + skyboxColorEvening * (1.0f - black);
	}
	fragColor = skyColor;
}
