#version 330

uniform mat4 uWorldMatrix;
uniform mat4 uViewMatrix;
uniform mat4 uProjectionMatrix;

in vec3 aPosition;
out vec3 fCubeCoord;

void main()
{
	vec4 position = uProjectionMatrix * uViewMatrix * uWorldMatrix * vec4(aPosition, 1.0f);
	position.z = position.w; // Always max depth
	gl_Position =  position;
	// Flip the x-coordinate because OpenGL.
	fCubeCoord = vec3(-aPosition.x, aPosition.y, aPosition.z);
}

