#version 330

uniform sampler2D uDiffuseMap;
uniform float ucTexAlpha; // From 0 to 1. When 1, all alpha at 1

in vec2 fTexCoord;

out vec4 fragColor; // first out variable is automatically written to the screen

void main()
{
	vec2 adjTex = fTexCoord;
	vec4 color = texture(uDiffuseMap, fTexCoord);
	
	color.w = (1.0f - fTexCoord.x) + ucTexAlpha;
	
	
	fragColor = color;
}
