// Generated by Haxe 3.4.0
(function ($hx_exports, $global) { "use strict";
$hx_exports["kvg"] = $hx_exports["kvg"] || {};
$hx_exports["kvg"]["core"] = $hx_exports["kvg"]["core"] || {};
$hx_exports["wl"] = $hx_exports["wl"] || {};
$hx_exports["wl"]["util"] = $hx_exports["wl"]["util"] || {};
var $hxClasses = {},$estr = function() { return js_Boot.__string_rec(this,''); };
function $extend(from, fields) {
	function Inherit() {} Inherit.prototype = from; var proto = new Inherit();
	for (var name in fields) proto[name] = fields[name];
	if( fields.toString !== Object.prototype.toString ) proto.toString = fields.toString;
	return proto;
}
var wl_core_Signal = function() {
	this.callbacks = [];
};
$hxClasses["wl.core.Signal"] = wl_core_Signal;
wl_core_Signal.__name__ = ["wl","core","Signal"];
wl_core_Signal.prototype = {
	connect: function(callback) {
		this.callbacks.push(callback);
	}
	,disconnect: function(callback) {
		HxOverrides.remove(this.callbacks,callback);
	}
	,emit: function(param) {
		var _g = 0;
		var _g1 = this.callbacks;
		while(_g < _g1.length) {
			var cb = _g1[_g];
			++_g;
			cb(param);
		}
	}
	,__class__: wl_core_Signal
};
var DemoMain = $hx_exports["wl"]["DemoMain"] = function() {
	Math.random = ($_=new wl_util_Random(123),$bind($_,$_.NextFloat));
};
$hxClasses["DemoMain"] = DemoMain;
DemoMain.__name__ = ["DemoMain"];
DemoMain.setup = function() {
};
DemoMain.onSoundReady = function() {
	var fft = wl_sounds_SoundWL.getFFT().waveformLeft;
	DemoMain.canvas = window.document.createElement("canvas");
	DemoMain.ctx2d = DemoMain.canvas.getContext("2d",null);
	DemoMain.canvas.width = fft.length;
	DemoMain.canvas.height = 128;
	DemoMain.ctx2d.fillStyle = "#000";
	DemoMain.ctx2d.fillRect(0,0,fft.length,128);
	DemoMain.canvas.style.position = "fixed";
	DemoMain.canvas.style.right = "0px";
	DemoMain.canvas.style.left = "0px";
};
DemoMain.update = function(ts,partial,frameTime,delta) {
};
DemoMain.prototype = {
	__class__: DemoMain
};
var HxOverrides = function() { };
$hxClasses["HxOverrides"] = HxOverrides;
HxOverrides.__name__ = ["HxOverrides"];
HxOverrides.cca = function(s,index) {
	var x = s.charCodeAt(index);
	if(x != x) {
		return undefined;
	}
	return x;
};
HxOverrides.substr = function(s,pos,len) {
	if(len == null) {
		len = s.length;
	} else if(len < 0) {
		if(pos == 0) {
			len = s.length + len;
		} else {
			return "";
		}
	}
	return s.substr(pos,len);
};
HxOverrides.remove = function(a,obj) {
	var i = a.indexOf(obj);
	if(i == -1) {
		return false;
	}
	a.splice(i,1);
	return true;
};
HxOverrides.iter = function(a) {
	return { cur : 0, arr : a, hasNext : function() {
		return this.cur < this.arr.length;
	}, next : function() {
		return this.arr[this.cur++];
	}};
};
var Main = function() { };
$hxClasses["Main"] = Main;
Main.__name__ = ["Main"];
Main.main = function() {
	$(window).ready(Main.windowReady);
};
Main.windowReady = function(e) {
	wl_util_LoadManager.onComplete = Main.onAssetsLoaded;
	Main.jsonConfigurator = new wl_setup_JsonConfigurator();
	Main.jsonConfigurator.fromJson(haxe_Resource.getString("Demo.json"));
	$("#setup").css("display","none");
	Main.demo = new wl_core_Demo();
	if(!wl_core_Config.DEBUG) {
		$(".debug").css("display","none");
		$("#debug").find("input").attr("checked",null);
		$(".checkbox").css("display","none");
	}
	if(wl_util_LoadManager.get_totalCount() == 0) {
		Main.assetsLoaded = true;
	}
	wl_sounds_SoundWL.onSoundLoaded.connect(Main.onSoundLoaded);
	wl_sounds_SoundWL.init();
};
Main.onAssetsLoaded = function() {
	Main.assetsLoaded = true;
	Main.loadReady();
};
Main.onSoundLoaded = function() {
	Main.soundLoaded = true;
	DemoMain.onSoundReady();
	Main.loadReady();
};
Main.loadReady = function() {
	if(Main.assetsLoaded && Main.soundLoaded) {
		$("#setup").css("display","");
		wl_setup_Setup.init(Main.demo);
	}
};
Math.__name__ = ["Math"];
var Reflect = function() { };
$hxClasses["Reflect"] = Reflect;
Reflect.__name__ = ["Reflect"];
Reflect.field = function(o,field) {
	try {
		return o[field];
	} catch( e ) {
		return null;
	}
};
Reflect.compare = function(a,b) {
	if(a == b) {
		return 0;
	} else if(a > b) {
		return 1;
	} else {
		return -1;
	}
};
Reflect.isEnumValue = function(v) {
	if(v != null) {
		return v.__enum__ != null;
	} else {
		return false;
	}
};
var Std = function() { };
$hxClasses["Std"] = Std;
Std.__name__ = ["Std"];
Std.string = function(s) {
	return js_Boot.__string_rec(s,"");
};
var StringTools = function() { };
$hxClasses["StringTools"] = StringTools;
StringTools.__name__ = ["StringTools"];
StringTools.replace = function(s,sub,by) {
	return s.split(sub).join(by);
};
var Type = function() { };
$hxClasses["Type"] = Type;
Type.__name__ = ["Type"];
Type.getClassName = function(c) {
	var a = c.__name__;
	if(a == null) {
		return null;
	}
	return a.join(".");
};
Type.resolveClass = function(name) {
	var cl = $hxClasses[name];
	if(cl == null || !cl.__name__) {
		return null;
	}
	return cl;
};
Type.createInstance = function(cl,args) {
	var _g = args.length;
	switch(_g) {
	case 0:
		return new cl();
	case 1:
		return new cl(args[0]);
	case 2:
		return new cl(args[0],args[1]);
	case 3:
		return new cl(args[0],args[1],args[2]);
	case 4:
		return new cl(args[0],args[1],args[2],args[3]);
	case 5:
		return new cl(args[0],args[1],args[2],args[3],args[4]);
	case 6:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5]);
	case 7:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6]);
	case 8:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7]);
	case 9:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8]);
	case 10:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9]);
	case 11:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10]);
	case 12:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10],args[11]);
	case 13:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10],args[11],args[12]);
	case 14:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10],args[11],args[12],args[13]);
	default:
		throw new js__$Boot_HaxeError("Too many arguments");
	}
};
var BABYLON_IBehaviorAware = function() { };
$hxClasses["BABYLON.IBehaviorAware"] = BABYLON_IBehaviorAware;
BABYLON_IBehaviorAware.__name__ = ["BABYLON","IBehaviorAware"];
BABYLON_IBehaviorAware.prototype = {
	__class__: BABYLON_IBehaviorAware
};
var ballcluster_Ball = function(ball,scene) {
	this.rings = [];
	BABYLON.TransformNode.call(this,"",scene);
	this.createRing(5,0,1,ball,scene);
	this.createRing(8,2,2.0,ball,scene);
	this.createRing(9,4,2.4,ball,scene);
	this.createRing(8,6,2.0,ball,scene);
	this.createRing(5,8,1.0,ball,scene);
};
$hxClasses["ballcluster.Ball"] = ballcluster_Ball;
ballcluster_Ball.__name__ = ["ballcluster","Ball"];
ballcluster_Ball.__super__ = BABYLON.TransformNode;
ballcluster_Ball.prototype = $extend(BABYLON.TransformNode.prototype,{
	createRing: function(balls,y,radius,ball,scene) {
		var node = new BABYLON.TransformNode("",scene);
		node.position.y = y;
		var _g1 = 0;
		var _g = balls;
		while(_g1 < _g) {
			var v = _g1++;
			var b = ball.createInstance("");
			b.radius = radius;
			b.angle = Math.PI * 2 * v / balls;
			b.position.x = Math.cos(Math.PI * 2 * v / balls) * radius * 2;
			b.position.z = Math.sin(Math.PI * 2 * v / balls) * radius * 2;
			b.originalPosition = b.position.clone();
			b.parent = node;
		}
		this.rings.push(node);
		node.parent = this;
	}
	,update: function(delta) {
		var i = 0;
		var _g = 0;
		var _g1 = this.rings;
		while(_g < _g1.length) {
			var r = _g1[_g];
			++_g;
			i += 0.0028;
			var _g2 = 0;
			var _g3 = r.getChildren();
			while(_g2 < _g3.length) {
				var b = _g3[_g2];
				++_g2;
				b.position.x += (b.originalPosition.x - b.position.x) / 5;
				b.position.z += (b.originalPosition.z - b.position.z) / 5;
				b.position.y += (b.originalPosition.y - b.position.y) / 5;
			}
		}
	}
	,pulse: function() {
		var _g = 0;
		var _g1 = this.rings;
		while(_g < _g1.length) {
			var r = _g1[_g];
			++_g;
			var _g2 = 0;
			var _g3 = r.getChildren();
			while(_g2 < _g3.length) {
				var b = _g3[_g2];
				++_g2;
				var box = b;
				var nextpos = box.position.multiply(new BABYLON.Vector3(4,4,4));
				nextpos.y = r.position.y * 4;
				createjs.Tween.get(box.position).to({ x : nextpos.x, y : nextpos.y, z : nextpos.z},1000);
			}
		}
	}
	,__class__: ballcluster_Ball
});
var wl_core_Part = function() {
	this.exposureTarget = 0;
	this.barAdd = 0;
	this.beatAdd = 0;
	this.customPosts = [];
	this.autoClear = true;
	this.genericPostProcessing = false;
	this.multiPart = false;
	this.clearColor = wl_core_Config.CLEAR_COLOR;
	this.generateDepthMap = true;
	this.renderToScreen = false;
	this.inTransition = false;
	this.running = false;
	this.isActive = false;
};
$hxClasses["wl.core.Part"] = wl_core_Part;
wl_core_Part.__name__ = ["wl","core","Part"];
wl_core_Part.prototype = {
	get_engine: function() {
		return this.scene.getEngine();
	}
	,init: function() {
		this.triggers = new haxe_ds_ObjectMap();
		this.scene = new BABYLON.Scene(wl_core_Graphics.instance.renderer);
		this.renderTo = new BABYLON.RenderTargetTexture("part rt",{ width : wl_core_Config.RESOLUTION[0], height : wl_core_Config.RESOLUTION[1]},this.scene,false);
		this.renderTo.renderList = this.scene.meshes;
		this.scene.customRenderTargets.push(this.renderTo);
		this.scene.renderTargetsEnabled = true;
	}
	,initSyncedPipeline: function(post) {
		this.genericPostProcessing = true;
		if(post == null) {
			post = { };
		}
		post.bloom = true;
		post.chromaticAberration = true;
		post.dof = false;
		post.grain = true;
		post.imageProcessing = true;
		post.sharpen = true;
		post.motionBlur = true;
		post.distort = true;
		this.initPipeline(post);
		this.post.imageProcessing.toneMappingEnabled = true;
		this.post.bloom.bloomKernel = 64;
		this.post.bloom.bloomScale = 1.5;
		this.post.bloom.bloomThreshold = 0.18;
		this.post.bloom.bloomWeight = 0.8;
		this.post.chromaticAberration.aberrationAmount = 0;
		this.post.imageProcessing.vignetteEnabled = true;
		this.post.grain.intensity = 2;
		this.post.grain.animated = true;
		this.lowFilterG = { highLimit : 500, lowLimit : 0, isolate : true};
		this.mediumFilterG = { highLimit : 1500, lowLimit : 500, isolate : true};
		this.highFilterG = { highLimit : 10000, lowLimit : 1500, isolate : true};
		this.allFilterG = { highLimit : 500000, lowLimit : 0, isolate : false};
		this.audioAnalyzerG = new wl_sounds_SoundAnalyzer();
		this.audioAnalyzerG.filters = [this.lowFilterG,this.mediumFilterG,this.highFilterG,this.allFilterG];
		this.audioAnalyzerG.historySize = 6;
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.onBarG));
		this.addTrigger(new wl_core_TimeSig(-1,-1,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.onBeatG));
	}
	,onBarG: function(ts) {
		this.barAdd = 1;
		createjs.Tween.get(this).to({ barAdd : 0},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.quadIn);
	}
	,onBeatG: function(ts) {
		this.beatAdd = 1;
		createjs.Tween.get(this).to({ beatAdd : 0},wl_core_TimeSig.milliseconds(0,1,0,0),createjs.Ease.quadIn);
	}
	,initPipeline: function(post) {
		post.bloom = post.bloom == null ? false : post.bloom;
		post.chromaticAberration = post.chromaticAberration == null ? false : post.chromaticAberration;
		post.dof = post.dof == null ? false : post.dof;
		post.fxaa = post.fxaa == null ? false : post.fxaa;
		post.grain = post.grain == null ? false : post.grain;
		post.imageProcessing = post.imageProcessing == null ? false : post.imageProcessing;
		post.sharpen = post.sharpen == null ? false : post.sharpen;
		this.pipeline = new BABYLON.DefaultRenderingPipeline(this.name + ":pipeline",true,this.scene,[this.camera]);
		this.pipeline.bloomEnabled = post.bloom;
		this.pipeline.chromaticAberrationEnabled = post.chromaticAberration;
		this.pipeline.depthOfFieldEnabled = post.dof;
		this.pipeline.fxaaEnabled = post.fxaa;
		this.pipeline.grainEnabled = post.grain;
		this.pipeline.imageProcessingEnabled = post.imageProcessing;
		this.pipeline.sharpenEnabled = post.sharpen;
		this.post = { };
		this.post.bloom = this.pipeline;
		this.post.chromaticAberration = this.pipeline.chromaticAberration;
		this.post.dof = this.pipeline.depthOfField;
		this.post.fxaa = this.pipeline.fxaa;
		this.post.grain = this.pipeline.grain;
		this.post.imageProcessing = this.pipeline.imageProcessing;
		this.post.sharpen = this.pipeline.sharpen;
		if(post.distort) {
			var tmp = this.camera;
			var tmp1 = this.scene.getEngine();
			this.post.distort = new wl_post_distort_DistortPostProcess(tmp,tmp1);
			this.camera.attachPostProcess(this.post.distort);
			this.customPosts.push(this.post.distort);
		}
		if(post.displacement) {
			var tmp2 = this.camera;
			var tmp3 = this.scene.getEngine();
			this.post.displacement = new wl_post_displacement_Displacement(tmp2,tmp3);
			this.camera.attachPostProcess(this.post.displacement);
			this.customPosts.push(this.post.displacement);
		}
		if(post.motionBlur) {
			this.post.motionBlur = new BABYLON.MotionBlurPostProcess("",this.scene,1.0,this.camera);
			this.post.motionBlur.motionStrength = 1;
			this.customPosts.push(this.post.motionBlur);
		}
	}
	,postInit: function() {
	}
	,setupDatGui: function(folder) {
		if(this.camera != null) {
			var cam = folder.addFolder("camera");
			cam.add(this.camera,"fov");
		}
		var _g = 0;
		var _g1 = this.customPosts;
		while(_g < _g1.length) {
			var pp = _g1[_g];
			++_g;
			if(pp.setupDatGui != null) {
				pp.setupDatGui(folder.addFolder(Type.getClassName(pp == null ? null : js_Boot.getClass(pp))));
			}
		}
		if(this.pipeline != null) {
			wl_debug_PostProcessSliders.applySliders(folder,this.pipeline);
		}
	}
	,start: function(ts) {
		this.running = true;
	}
	,stop: function() {
		this.running = false;
	}
	,setRenderToScreen: function(value) {
		this.renderToScreen = value;
	}
	,update: function(ts,partial,frameTime,delta) {
		if(this.audioAnalyzerG != null) {
			this.audioAnalyzerG.update();
		}
		if(this.genericPostProcessing) {
			this.post.bloom.bloomWeight = 0.05 + (this.barAdd + this.beatAdd) * 0.13 + this.highFilterG.max * 0.1;
			this.post.imageProcessing.exposure = Math.max(0,1 + this.lowFilterG.min * 3.2 + this.exposureTarget);
			this.post.imageProcessing.contrast = 1 + this.lowFilterG.min * 0.4;
			this.post.distort.intensity = this.mediumFilterG.max + this.highFilterG.max;
			this.post.imageProcessing.vignetteWeight = this.lowFilterG.max * 8 + 3.5;
			this.post.grain.intensity = 1 + this.lowFilterG.max * 8. + this.mediumFilterG.max * 3.;
			this.post.chromaticAberration.aberrationAmount = this.highFilterG.max;
		}
	}
	,render: function(ts,frameTime,toScreen) {
		if(toScreen) {
			this.scene.render();
		} else if(this.renderTo != null) {
			this.renderTo.render(false);
		}
	}
	,addTrigger: function(timesig,handler) {
		if(this.triggers.h.__keys__[timesig.__id__] != null) {
			this.triggers.h[timesig.__id__].push(handler);
		} else {
			this.triggers.set(timesig,[handler]);
		}
	}
	,removeTrigger: function(handler,timesig) {
		if(timesig != null && this.triggers.h.__keys__[timesig.__id__] != null) {
			HxOverrides.remove(this.triggers.h[timesig.__id__],handler);
		} else {
			var t = this.triggers.iterator();
			while(t.hasNext()) {
				var t1 = t.next();
				while(t1.indexOf(handler) >= 0) HxOverrides.remove(t1,handler);
			}
		}
	}
	,initStandardScene: function() {
		this.scene.clearColor = this.clearColor;
		this.scene.autoClear = true;
		this.camera = new BABYLON.UniversalCamera("mainCamera",new BABYLON.Vector3(0,5,-10),this.scene);
		this.camera.setTarget(BABYLON.Vector3.Zero());
		if(this.generateDepthMap) {
			this.depthRenderer = this.scene.enableDepthRenderer();
			this.depthMap = this.depthRenderer.getDepthMap();
		}
		wl_debug_ManualControl.attachPart(this);
	}
	,__class__: wl_core_Part
};
var ballcluster_BallCluster = function() {
	this.balls = [];
	wl_core_Part.call(this);
};
$hxClasses["ballcluster.BallCluster"] = ballcluster_BallCluster;
ballcluster_BallCluster.__name__ = ["ballcluster","BallCluster"];
ballcluster_BallCluster.__super__ = wl_core_Part;
ballcluster_BallCluster.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		BABYLON.MeshBuilder.CreateBox("skyBox",{ width : 100, depth : 100, height : 100},this.scene);
		new BABYLON.HemisphericLight("",BABYLON.Vector3.Up(),this.scene);
		this.smallBallMaterial = new BABYLON.StandardMaterial("smallballmat",this.scene);
		this.smallBallMaterial.diffuseColor = new BABYLON.Color3(1,0,0);
		var ball = BABYLON.MeshBuilder.CreateSphere("",{ diameter : 2.5},this.scene);
		ball.material = this.smallBallMaterial;
		ball.isVisible = false;
		this.smallBallMaterial.diffuseColor = BABYLON.Color3.FromHexString("#5d0089");
		this.smallBallMaterial.specularColor = BABYLON.Color3.FromHexString("#ffffff");
		this.smallBallMaterial.emissiveColor = BABYLON.Color3.FromHexString("#0a0007");
		var _g = 0;
		while(_g < 3) {
			var i = _g++;
			var ball1 = new ballcluster_Ball(ball,this.scene);
			ball1.position.x = Math.cos(Math.PI * 2 * i / 3) * 20;
			ball1.position.z = Math.sin(Math.PI * 2 * i / 3) * 20;
			this.balls.push(ball1);
		}
		this.camera.position.x = 0;
		this.camera.position.y = -30;
		this.camera.position.z = 0;
		this.camera.setTarget(BABYLON.Vector3.Zero());
		this.addTrigger(new wl_core_TimeSig(1,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.pulse));
	}
	,pulse: function(ts) {
		var _g = 0;
		var _g1 = this.balls;
		while(_g < _g1.length) {
			var b = _g1[_g];
			++_g;
			b.pulse();
		}
	}
	,update: function(ts,partial,frameTime,delta) {
		var _g = 0;
		var _g1 = this.balls;
		while(_g < _g1.length) {
			var b = _g1[_g];
			++_g;
			b.update(delta);
		}
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,setupDatGui: function(folder) {
		wl_core_Part.prototype.setupDatGui.call(this,folder);
		var f = folder.addFolder("smallball");
		wl_util_DatGuiHelper.addColor(f,this.smallBallMaterial,"emissiveColor");
		wl_util_DatGuiHelper.addColor(f,this.smallBallMaterial,"specularColor");
		wl_util_DatGuiHelper.addColor(f,this.smallBallMaterial,"diffuseColor");
	}
	,__class__: ballcluster_BallCluster
});
var blank_Blank = function() {
	wl_core_Part.call(this);
};
$hxClasses["blank.Blank"] = blank_Blank;
blank_Blank.__name__ = ["blank","Blank"];
blank_Blank.__super__ = wl_core_Part;
blank_Blank.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var sphere = BABYLON.MeshBuilder.CreateSphere("sphere1",{ segments : 16, diameter : 2},this.scene);
		BABYLON.MeshBuilder.CreateGround("ground1",{ height : 6, width : 6, subdivisions : 2},this.scene);
		new BABYLON.HemisphericLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		sphere.position.y = 1;
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: blank_Blank
});
var blank_Blank2 = function() {
	wl_core_Part.call(this);
};
$hxClasses["blank.Blank2"] = blank_Blank2;
blank_Blank2.__name__ = ["blank","Blank2"];
blank_Blank2.__super__ = wl_core_Part;
blank_Blank2.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var box = BABYLON.MeshBuilder.CreateBox("box1",{ width : 2, height : 2, depth : 2},this.scene);
		BABYLON.MeshBuilder.CreateGround("ground1",{ height : 6, width : 6, subdivisions : 2},this.scene);
		new BABYLON.HemisphericLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		box.position.y = 1;
		this.scene.clearColor = new BABYLON.Color4(0,1,0);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: blank_Blank2
});
var blank_SpsBlank = function() {
	wl_core_Part.call(this);
};
$hxClasses["blank.SpsBlank"] = blank_SpsBlank;
blank_SpsBlank.__name__ = ["blank","SpsBlank"];
blank_SpsBlank.__super__ = wl_core_Part;
blank_SpsBlank.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var fact = 100;
		var myPositionFunction = function(particle,i,s) {
			var myPositionFunction1 = Math.random() - 0.5;
			particle.position.x = myPositionFunction1 * fact;
			var myPositionFunction2 = Math.random() - 0.5;
			particle.position.y = myPositionFunction2 * fact;
			var myPositionFunction3 = Math.random() - 0.5;
			particle.position.z = myPositionFunction3 * fact;
			var myPositionFunction4 = Math.random();
			particle.rotation.x = myPositionFunction4 * 3.15;
			var myPositionFunction5 = Math.random();
			particle.rotation.y = myPositionFunction5 * 3.15;
			var myPositionFunction6 = Math.random();
			particle.rotation.z = myPositionFunction6 * 1.5;
			particle.color = new BABYLON.Color4(particle.position.x / fact + 0.5,particle.position.y / fact + 0.5,particle.position.z / fact + 0.5,1.0);
		};
		var triangle = BABYLON.MeshBuilder.CreateDisc("t",{ tessellation : 3, sideOrientation : BABYLON.Mesh.DOUBLESIDE},this.scene);
		var SPS = new BABYLON.SolidParticleSystem("SPS",this.scene,{ updatable : false});
		SPS.addShape(triangle,160000,{ positionFunction : myPositionFunction});
		SPS.buildMesh();
		triangle.dispose();
		this.camera.position.z = -150;
		this.camera.position.y = 50;
		this.camera.setTarget(new BABYLON.Vector3(0,0,0));
		new BABYLON.HemisphericLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		this.scene.clearColor = new BABYLON.Color4(1,1,1);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: blank_SpsBlank
});
var chainedball_Chain = function(p1,pc,p2,scale,scene) {
	this.links = [];
	this.start = p1;
	this.control = pc;
	this.target = p2;
	var anchor1 = BABYLON.MeshBuilder.CreateSphere("anchor",{ diameter : 0.5},scene);
	anchor1.position.copyFrom(p1);
	anchor1.visibility = 0.0;
	anchor1.dispose();
	var linkMesh = this.buildLink(scene);
	linkMesh.scaling.copyFrom(scale);
	linkMesh.bakeCurrentTransformIntoVertices();
	var bb = linkMesh.getBoundingInfo().boundingBox;
	var count = Math.ceil(BABYLON.Curve3.CreateQuadraticBezier(p1,pc,p2,Math.ceil(BABYLON.Vector3.Distance(p1,p2) / (bb.maximum.y - bb.minimum.y) * 1.4)).length() / (bb.maximum.y - bb.minimum.y) * 1.4);
	var directionCurve = BABYLON.Curve3.CreateQuadraticBezier(p1,pc,p2,count);
	var _g1 = 0;
	while(_g1 < count) {
		var i = _g1++;
		var il = linkMesh.createInstance("");
		var node = new BABYLON.TransformNode("",scene);
		il.parent = node;
		il.position.copyFrom(BABYLON.Vector3.Zero());
		var points = directionCurve.getPoints();
		node.position.copyFrom(points[i]);
		node.lookAt(i < points.length - 1 ? points[i + 1] : p2);
		if(i % 2 == 1) {
			il.rotate(BABYLON.Vector3.Up(),Math.PI * 0.5);
			il.rotate(BABYLON.Vector3.Forward(),Math.PI / 2);
		} else {
			il.rotate(BABYLON.Vector3.Right(),Math.PI / 2);
		}
		this.links.push(node);
	}
};
$hxClasses["chainedball.Chain"] = chainedball_Chain;
chainedball_Chain.__name__ = ["chainedball","Chain"];
chainedball_Chain.prototype = {
	updateChain: function() {
		var directionCurve = BABYLON.Curve3.CreateQuadraticBezier(this.start,this.control,this.target,this.links.length);
		var i = 0;
		var _g = 0;
		var _g1 = this.links;
		while(_g < _g1.length) {
			var node = _g1[_g];
			++_g;
			var points = directionCurve.getPoints();
			node.position.copyFrom(points[i]);
			node.lookAt(i < points.length - 1 ? points[i + 1] : this.target);
			++i;
		}
	}
	,buildLink: function(scene) {
		var points = [new BABYLON.Vector3(0.1,0.07,0)];
		var curve = BABYLON.Curve3.CreateCubicBezier(new BABYLON.Vector3(0.1,0.18,0),new BABYLON.Vector3(0.1,0.28,0),new BABYLON.Vector3(-0.1,0.28,0),new BABYLON.Vector3(-0.1,0.18,0),6);
		points = points.concat(curve.getPoints());
		curve = BABYLON.Curve3.CreateCubicBezier(new BABYLON.Vector3(-0.1,-0.18,0),new BABYLON.Vector3(-0.1,-0.28,0),new BABYLON.Vector3(0.1,-0.28,0),new BABYLON.Vector3(0.1,-0.18,0),6);
		points = points.concat(curve.getPoints());
		points.push(points[0].subtract(new BABYLON.Vector3(0,0.015,0)));
		var linkMesh = BABYLON.MeshBuilder.CreateTube("Chain-Link",{ radius : 0.05, path : points, cap : 3, tessellation : 6},scene);
		chainedball_Chain.linkmaterial = wl_library_Library.get_instance().getMaterial(wl_library_Materials.ghost,true);
		chainedball_Chain.linkmaterial.fresnelopacity = chainedball_Chain.linkmaterial.opacityFresnelParameters;
		chainedball_Chain.linkmaterial.alpha = 1.0;
		linkMesh.material = chainedball_Chain.linkmaterial;
		linkMesh.setEnabled(false);
		return linkMesh;
	}
	,ghost: function() {
		chainedball_Chain.linkmaterial.alpha = 0.1;
		chainedball_Chain.linkmaterial.emissiveColor = new BABYLON.Color3(1,1,1);
		chainedball_Chain.linkmaterial.opacityFresnelParameters = chainedball_Chain.linkmaterial.fresnelopacity;
	}
	,normalize: function() {
		chainedball_Chain.linkmaterial.alpha = 1.0;
		chainedball_Chain.linkmaterial.emissiveColor = new BABYLON.Color3(0,0,0);
		chainedball_Chain.linkmaterial.opacityFresnelParameters = null;
	}
	,__class__: chainedball_Chain
};
var chainedball_ChainedBall = function() {
	this.greetNames = ["greet_adapt.png","greet_alumni.png","greet_ananasmurska.png","greet_artline_designs.png","greet_byterapers.png","greet_damones.png","greet_darklite.png","greet_dekadence.png","greet_ekspert.png","greet_epoch.png","greet_hedelmae.png","greet_jumalauta.png","greet_kewlers.png","greet_matt_current.png","greet_paraguay.png","greet_primitive.png","greet_npli.png","greet_pyrotech.png","greet_quadtrip.png","greet_scenesat.png","greet_tahtituho.png","greet_traction.png"];
	this.greetChains = [];
	this.exposureMP = 0;
	this.bgColor = DemoMain.BASE_1.clone().scale(0.15);
	this.chains = [];
	wl_core_Part.call(this);
};
$hxClasses["chainedball.ChainedBall"] = chainedball_ChainedBall;
chainedball_ChainedBall.__name__ = ["chainedball","ChainedBall"];
chainedball_ChainedBall.__super__ = wl_core_Part;
chainedball_ChainedBall.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.lowFilter = { isolate : true, lowLimit : 0, highLimit : 200};
		this.mediumFilter = { isolate : true, lowLimit : 700, highLimit : 1200};
		this.highFilter = { isolate : true, lowLimit : 1000, highLimit : 16000};
		this.analyzer = new wl_sounds_SoundAnalyzer();
		this.analyzer.historySize = 10;
		this.analyzer.filters.push(this.lowFilter);
		this.analyzer.filters.push(this.mediumFilter);
		this.analyzer.filters.push(this.highFilter);
		var rpProp = { };
		rpProp.bloom = true;
		rpProp.chromaticAberration = true;
		rpProp.distort = true;
		rpProp.dof = true;
		rpProp.grain = true;
		rpProp.imageProcessing = true;
		rpProp.sharpen = false;
		rpProp.fxaa = false;
		rpProp.displacement = true;
		this.initPipeline(rpProp);
		this.post.grain.animated = true;
		this.post.displacement.scaleX = 0.04;
		this.post.displacement.scaleY = 0.02;
		this.post.displacement.zoom = 0.5;
		this.post.distort.lineHeight = wl_core_Config.RESOLUTION[1] / 60;
		this.post.imageProcessing.vignetteEnabled = true;
		var sphere = BABYLON.MeshBuilder.CreateSphere("sphere1",{ segments : 16, diameter : 8},this.scene);
		new BABYLON.HemisphericLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		sphere.position.y = 5;
		sphere.position.y = 8;
		var glowCube = BABYLON.MeshBuilder.CreateSphere("box",{ diameter : 500, sideOrientation : BABYLON.Mesh.DOUBLESIDE},null);
		var glowMat = new BABYLON.StandardMaterial("",null);
		glowMat.diffuseColor = DemoMain.BLACK.clone();
		glowMat.ambientColor = DemoMain.BLACK.clone();
		glowMat.emissiveColor = DemoMain.WHITE.clone().scale(0.005);
		glowCube.material = glowMat;
		this.scene.addMesh(glowCube);
		var utscale = new BABYLON.Vector3(8,8,8);
		this.chains.push(new chainedball_Chain(new BABYLON.Vector3(-60,5,-40),new BABYLON.Vector3(-30,0,-20),sphere.position,utscale,this.scene));
		this.chains.push(new chainedball_Chain(new BABYLON.Vector3(-60,5,40),new BABYLON.Vector3(-30,0,20),sphere.position,utscale,this.scene));
		this.chains.push(new chainedball_Chain(new BABYLON.Vector3(60,5,-40),new BABYLON.Vector3(30,0,-20),sphere.position,utscale,this.scene));
		this.chains.push(new chainedball_Chain(new BABYLON.Vector3(60,5,40),new BABYLON.Vector3(30,0,20),sphere.position,utscale,this.scene));
		this.chains.push(new chainedball_Chain(new BABYLON.Vector3(-30,-55,-20),new BABYLON.Vector3(-15,-22,-10),sphere.position,utscale,this.scene));
		this.chains.push(new chainedball_Chain(new BABYLON.Vector3(-30,-55,20),new BABYLON.Vector3(-15,-22,10),sphere.position,utscale,this.scene));
		this.chains.push(new chainedball_Chain(new BABYLON.Vector3(30,-55,-20),new BABYLON.Vector3(15,-22,-10),sphere.position,utscale,this.scene));
		this.chains.push(new chainedball_Chain(new BABYLON.Vector3(30,-55,20),new BABYLON.Vector3(15,-22,10),sphere.position,utscale,this.scene));
		var meshes = [];
		var _g = 0;
		while(_g < 500) {
			++_g;
			var b = BABYLON.MeshBuilder.CreateBox("",{ width : 5, height : 5, depth : 5},this.scene);
			var tmp = wl_util_Random.nextFloat() * 5 * 30;
			b.position.x = -50 + tmp;
			var tmp1 = wl_util_Random.nextFloat() * 5 * 30;
			b.position.z = -250 + tmp1;
			b.position.y = -25;
			b.rotate(new BABYLON.Vector3(Math.PI * 2 * wl_util_Random.nextFloat(),Math.PI * 2 * wl_util_Random.nextFloat(),Math.PI * 2 * wl_util_Random.nextFloat()),Math.PI * wl_util_Random.nextFloat());
			meshes.push(b);
		}
		var g = BABYLON.Mesh.MergeMeshes(meshes,true,true);
		var _g1 = 0;
		while(_g1 < meshes.length) {
			var m = meshes[_g1];
			++_g1;
			m.dispose();
		}
		var gmaterial = new BABYLON.StandardMaterial("",this.scene);
		gmaterial.diffuseColor = new BABYLON.Color3(0.2,0.2,0.2);
		g.material = gmaterial;
		var scale = new BABYLON.Vector3(4,4,4);
		var _g2 = -20;
		while(_g2 < -8) {
			var z = _g2++;
			var _g11 = -2;
			while(_g11 < 5) {
				var x = _g11++;
				var xchange = wl_util_Random.nextFloat() * 4;
				var time = Math.floor(wl_util_Random.nextFloat() * 2000 + 1500);
				var ysize = wl_util_Random.nextFloat() * 15 + 40;
				var xpos = x * 10 - wl_util_Random.nextFloat() * 9;
				var zpos = z * 10 - wl_util_Random.nextFloat() * 9;
				var p2x = xpos + xchange;
				var phase = 5 - wl_util_Random.nextFloat() * 10;
				var p1 = new BABYLON.Vector3(xpos,20,zpos);
				var pc = new BABYLON.Vector3(xpos - phase,20 - ysize / 2,zpos);
				var p2 = new BABYLON.Vector3(p2x,20 - ysize,zpos + (0.5 - wl_util_Random.nextFloat()));
				var c = new chainedball_Chain(p1,pc,p2,scale,this.scene);
				createjs.Tween.get(pc,{ loop : true}).to({ x : xpos + phase},time,createjs.Ease.sineInOut).to({ x : xpos - phase},time,createjs.Ease.sineInOut);
				createjs.Tween.get(p2,{ loop : true}).to({ x : xpos - xchange},time,createjs.Ease.sineInOut).to({ x : p2x},time,createjs.Ease.sineInOut);
				this.chains.push(c);
				if(z > -15 && x > 0 && x < 5) {
					if(this.greetNames.length != 0) {
						var width = 5;
						c.riseSpeed = wl_core_TimeSig.milliseconds(3,0,0,0) - wl_util_Random.range(0,wl_core_TimeSig.milliseconds(1,0,0,0));
						c.batch = 0;
						if(z > -12) {
							width = 8;
							c.batch = 1;
							c.riseSpeed = wl_core_TimeSig.milliseconds(4,2,0,0) - wl_util_Random.range(0,wl_core_TimeSig.milliseconds(1,0,0,0));
						}
						if(z > -14) {
							width = 10;
							c.batch = 2;
							c.riseSpeed = wl_core_TimeSig.milliseconds(8,0,0,0) - wl_util_Random.range(0,wl_core_TimeSig.milliseconds(1,0,0,0));
						}
						var greetbox = BABYLON.MeshBuilder.CreateBox("",{ width : width, height : width - 0.5 * width, depth : 2},this.scene);
						var greetmat = new BABYLON.StandardMaterial("",this.scene);
						var greetname = this.greetNames[0];
						greetmat.diffuseTexture = wl_core_Assets.getTexture(greetname);
						HxOverrides.remove(this.greetNames,greetname);
						greetbox.material = greetmat;
						var greetnode = new BABYLON.TransformNode("",this.scene);
						greetbox.parent = greetnode;
						greetbox.position.z = 0;
						greetnode.position = c.target;
						console.log("added greetchain");
						this.greetChains.push(c);
					}
				}
			}
		}
		this.scene.fogMode = BABYLON.Scene.FOGMODE_EXP;
		this.scene.fogDensity = 0.024;
		this.scene.fogColor = this.bgColor;
		this.clearColor = this.bgColor;
		this.light1 = new BABYLON.SpotLight("",new BABYLON.Vector3(-1,0,0),new BABYLON.Vector3(2.5,0,8),Math.PI / 5,90,this.scene);
		this.light2 = new BABYLON.SpotLight("",new BABYLON.Vector3(1,0,0),new BABYLON.Vector3(-2.5,0,8),Math.PI / 5,90,this.scene);
		this.light1.parent = this.camera;
		this.light2.parent = this.camera;
		this.camera.position = new BABYLON.Vector3(7.8,14.4,-20);
		this.camera.setTarget(new BABYLON.Vector3(0,5,0));
		this.post.imageProcessing.exposure = 0;
		this.startCC = new wl_demo_CameraController(this.camera);
		this.startCC.initLinear([this.camera.position.clone(),new BABYLON.Vector3(35,8,-42)],[new BABYLON.Vector3(0,5,0),new BABYLON.Vector3(0,3,0)]);
		this.chainCC = new wl_demo_CameraController(this.camera);
		this.chainCC.initBezier([new BABYLON.Vector3(0,-12,-209),new BABYLON.Vector3(13,-4,-187),new BABYLON.Vector3(20,-7,-174),new BABYLON.Vector3(20,-7,-170)],[new BABYLON.Vector3(9,-4,0),new BABYLON.Vector3(13,0,0),new BABYLON.Vector3(19,2,0),new BABYLON.Vector3(19,2,0)]);
		this.storyboard = new wl_demo_SceneBoard();
		this.storyboard.add(wl_core_TimeSig.Zero(),new wl_core_TimeSig(5,0,0,0),this.startCC);
		this.storyboard.add(new wl_core_TimeSig(5,0,0,0),new wl_core_TimeSig(15,0,0,0),this.chainCC);
		this.addTrigger(new wl_core_TimeSig(0,0,0,0,wl_core_TimeSig.RELATIVE),function(ts) {
			createjs.Tween.get(sphere.position,{ loop : true}).to({ y : 0},wl_core_TimeSig.milliseconds(3,0,0,0),createjs.Ease.sineInOut).to({ y : 8},wl_core_TimeSig.milliseconds(3,0,0,0),createjs.Ease.sineInOut);
			createjs.Tween.get(_gthis).to({ exposureMP : 1},wl_core_TimeSig.milliseconds(1,0,0,0));
		});
		this.addTrigger(new wl_core_TimeSig(4,0,0,0,wl_core_TimeSig.RELATIVE),function(ts1) {
			createjs.Tween.get(_gthis).to({ exposureMP : 0},wl_core_TimeSig.milliseconds(1,0,0,0)).wait(wl_core_TimeSig.milliseconds(0,2,0,0)).call(function() {
				createjs.Tween.get(_gthis).to({ exposureMP : 1},wl_core_TimeSig.milliseconds(0,2,0,0));
			});
		});
		this.greetChains.sort(function(c1,c2) {
			if(c1.batch == c2.batch) {
				return 0;
			}
			if(c1.batch < c2.batch) {
				return -1;
			}
			return 1;
		});
		this.addTrigger(new wl_core_TimeSig(9,0,0,0,wl_core_TimeSig.RELATIVE),function(ts2) {
			_gthis.addTrigger(new wl_core_TimeSig(-1,1,0,0,wl_core_TimeSig.PATTERN),function(ts3) {
				console.log("greetchain update");
				var i = 0;
				var _g3 = 0;
				var _g12 = _gthis.greetChains.filter(function(gc) {
					return !gc.rising;
				});
				while(_g3 < _g12.length) {
					var gc1 = _g12[_g3];
					++_g3;
					++i;
					if(i == 10) {
						break;
					}
					gc1.rising = true;
					createjs.Tween.get(gc1.start).to({ y : 50},gc1.riseSpeed);
					createjs.Tween.get(gc1.control).to({ y : 30},gc1.riseSpeed);
					createjs.Tween.get(gc1.target).to({ y : 20},gc1.riseSpeed);
				}
			});
		});
		this.addTrigger(new wl_core_TimeSig(6,0,0,0,wl_core_TimeSig.RELATIVE),function(ts4) {
			_gthis.addTrigger(new wl_core_TimeSig(1,0,0,0,wl_core_TimeSig.PATTERN),function(ts5) {
				var _g4 = 0;
				var _g13 = _gthis.chains;
				while(_g4 < _g13.length) {
					var c3 = _g13[_g4];
					++_g4;
					c3.ghost();
				}
			});
			_gthis.addTrigger(new wl_core_TimeSig(1,1,0,0,wl_core_TimeSig.PATTERN),function(ts6) {
				var _g5 = 0;
				var _g14 = _gthis.chains;
				while(_g5 < _g14.length) {
					var c4 = _g14[_g5];
					++_g5;
					c4.normalize();
				}
			});
		});
		this.addTrigger(new wl_core_TimeSig(14,0,0,0,wl_core_TimeSig.RELATIVE),function(ts7) {
			createjs.Tween.get(_gthis).to({ exposureMP : 0},wl_core_TimeSig.milliseconds(1,0,0,0));
		});
	}
	,start: function(ts) {
		this.storyboard.start(ts);
		wl_core_Part.prototype.start.call(this,ts);
		var _g = 0;
		var _g1 = this.chains;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			c.ghost();
		}
		var _g2 = 0;
		var _g11 = this.chains;
		while(_g2 < _g11.length) {
			var c1 = _g11[_g2];
			++_g2;
			c1.normalize();
		}
	}
	,update: function(ts,partial,frameTime,delta) {
		var _g = 0;
		var _g1 = this.chains;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			c.updateChain();
		}
		var time = ts.toMilliseconds() / 1000;
		this.light1.direction.x = 2.5 + 0.2 * Math.cos(time);
		this.light1.direction.y = 0.2 * Math.sin(time);
		this.light1.direction.z = 8 + 0.2 * Math.sin(time);
		this.light2.direction.x = -2.5 + 0.2 * Math.cos(time);
		this.light2.direction.y = 0.2 * Math.cos(time);
		this.light2.direction.z = 8 + 0.2 * Math.sin(time);
		this.storyboard.update(ts,partial,frameTime,delta);
		this.analyzer.update();
		this.post.grain.intensity = this.lowFilter.max * 30 + 5;
		this.post.chromaticAberration.aberrationAmount = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.8) * 120;
		this.post.distort.intensity = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.9) * 0.06;
		this.post.distort.intensityY = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.9) * 0.06;
		this.post.bloom.bloomWeight = this.lowFilter.max * 20;
		this.post.imageProcessing.vignetteWeight = this.lowFilter.max;
		this.post.imageProcessing.exposure = this.exposureMP * Math.min(1.100,0.7 + Math.max(0,this.lowFilter.min - 0.8) * 2.5);
		this.post.displacement.zoom = 0.5 + this.lowFilter.max * 0.25;
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: chainedball_ChainedBall
});
var credits_Credits = function() {
	this.exposureMP = 0;
	this.greetNames = ["exca.png","poro.png","featuring.png","t101.png"];
	this.chains = [];
	wl_core_Part.call(this);
};
$hxClasses["credits.Credits"] = credits_Credits;
credits_Credits.__name__ = ["credits","Credits"];
credits_Credits.__super__ = wl_core_Part;
credits_Credits.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.lowFilter = { isolate : true, lowLimit : 0, highLimit : 200};
		this.mediumFilter = { isolate : true, lowLimit : 400, highLimit : 1000};
		this.highFilter = { isolate : true, lowLimit : 1000, highLimit : 16000};
		this.analyzer = new wl_sounds_SoundAnalyzer();
		this.analyzer.historySize = 10;
		this.analyzer.filters.push(this.lowFilter);
		this.analyzer.filters.push(this.mediumFilter);
		this.analyzer.filters.push(this.highFilter);
		this.initStandardScene();
		var rpProp = { };
		rpProp.bloom = true;
		rpProp.chromaticAberration = true;
		rpProp.distort = true;
		rpProp.dof = true;
		rpProp.grain = true;
		rpProp.imageProcessing = true;
		rpProp.sharpen = false;
		rpProp.fxaa = false;
		rpProp.displacement = false;
		this.initPipeline(rpProp);
		this.post.grain.animated = true;
		this.post.dof.focalLength = 80;
		this.post.dof.focusDistance = 8000;
		this.post.imageProcessing.vignetteEnabled = true;
		var glowCube = BABYLON.MeshBuilder.CreateSphere("box",{ diameter : 545, sideOrientation : BABYLON.Mesh.DOUBLESIDE},null);
		var glowMat = new BABYLON.StandardMaterial("",null);
		glowMat.diffuseColor = DemoMain.BLACK.clone();
		glowMat.ambientColor = DemoMain.BLACK.clone();
		glowMat.specularColor = DemoMain.BLACK.clone();
		glowMat.emissiveColor = DemoMain.BLACK.clone().scale(0.05);
		glowCube.material = glowMat;
		this.scene.addMesh(glowCube);
		this.camera.fov = 0.1;
		this.camera.maxZ = 200;
		this.pl = new BABYLON.HemisphericLight("pl",new BABYLON.Vector3(0,5,8),this.scene);
		this.pl.diffuse = DemoMain.WHITE.clone();
		this.pl.intensity = 0.9;
		this.pl.range = 50;
		this.camera.position = new BABYLON.Vector3(1,0,16);
		this.camera.setTarget(new BABYLON.Vector3());
		var cps = [new BABYLON.Vector3(-8.9,5.1,0),new BABYLON.Vector3(-1.1,5.1,0),new BABYLON.Vector3(2.,5.3,-1),new BABYLON.Vector3(8.,5.3,-1),new BABYLON.Vector3(-7.6,0.7,-2),new BABYLON.Vector3(7.6,0.7,-2),new BABYLON.Vector3(-2.5,-2.45,-3),new BABYLON.Vector3(2.5,-2.45,-3)];
		var cpe = [new BABYLON.Vector3(-9.,11,0),new BABYLON.Vector3(-1.,11,0),new BABYLON.Vector3(1.,11,-1),new BABYLON.Vector3(9.,11,-1),new BABYLON.Vector3(-12.5,11.0,-2),new BABYLON.Vector3(16.5,11,-2),new BABYLON.Vector3(-2.7,11,-3),new BABYLON.Vector3(2.7,11,-3)];
		this.greets = [];
		var c = 0;
		var _g = 0;
		var _g1 = this.greetNames;
		while(_g < _g1.length) {
			var g = _g1[_g];
			++_g;
			var gsps = new greets_GreetSPS(g,this.scene);
			gsps.scaling.set(0.2,0.125,0.2);
			this.greets.push(gsps);
			gsps.position.z = -c;
			gsps.position.x = [-5,5,0,0][c];
			gsps.position.y = [4,4,-0.5,-3.8][c];
			gsps.lookAt(gsps.position.clone().subtract(new BABYLON.Vector3(0,0,-10)));
			var cps1 = cps[c * 2];
			var cc = cpe[c * 2].subtract(cps[c * 2]).scale(0.5);
			var cc1 = new whiteroom_ChainWR(cps1,cps[c * 2].add(cc),cpe[c * 2],new BABYLON.Vector3(1,1,1),this.scene);
			var cps2 = cps[c * 2 + 1];
			var cc2 = cpe[c * 2 + 1].subtract(cps[c * 2 + 1]).scale(0.5);
			var cc21 = new whiteroom_ChainWR(cps2,cps[c * 2 + 1].add(cc2),cpe[c * 2 + 1],new BABYLON.Vector3(1,1,1),this.scene);
			++c;
			this.chains.push(cc1);
			this.chains.push(cc21);
			cc1.normalize();
			cc21.normalize();
		}
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		createjs.Tween.get(this).to({ exposureMP : 1},wl_core_TimeSig.milliseconds(1,0,0,0)).wait(wl_core_TimeSig.milliseconds(2,0,0,0)).to({ exposureMP : 0},wl_core_TimeSig.milliseconds(1,0,0,0));
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		var t = ts.toMilliseconds() / 3000;
		this.camera.position = new BABYLON.Vector3(-1 + Math.sin(t) * 2,Math.cos(t * 0.3) * 0.5,128 + Math.sin(t * 0.2));
		this.camera.setTarget(new BABYLON.Vector3(this.camera.position.x * 0.5,this.camera.position.y,0));
		this.analyzer.update();
		this.post.grain.intensity = this.lowFilter.max * 10 + 5;
		this.post.chromaticAberration.aberrationAmount = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.8) * 120;
		var tmp = this.mediumFilter.max < 0.9 ? 0 : createjs.Ease.quadIn(2 * (this.mediumFilter.max - 0.9)) * 0.035;
		this.post.distort.intensity = tmp;
		this.post.bloom.bloomWeight = this.lowFilter.max * 5;
		this.post.imageProcessing.vignetteWeight = this.lowFilter.max;
		this.post.imageProcessing.exposure = this.exposureMP * Math.min(1.100,0.7 + Math.max(0,this.lowFilter.min - 0.8) * 2.5);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: credits_Credits
});
var BABYLON_IGetSetVerticesData = function() { };
$hxClasses["BABYLON.IGetSetVerticesData"] = BABYLON_IGetSetVerticesData;
BABYLON_IGetSetVerticesData.__name__ = ["BABYLON","IGetSetVerticesData"];
BABYLON_IGetSetVerticesData.prototype = {
	__class__: BABYLON_IGetSetVerticesData
};
var BABYLON_ICullable = function() { };
$hxClasses["BABYLON.ICullable"] = BABYLON_ICullable;
BABYLON_ICullable.__name__ = ["BABYLON","ICullable"];
BABYLON_ICullable.prototype = {
	__class__: BABYLON_ICullable
};
var cubecity_CubeBuilding = function(width,depth,scene,baseMesh) {
	BABYLON.Mesh.call(this,"",scene);
	this.width = width;
	this.depth = depth;
	var grid = this.GenerateBuildingHeight();
	var _g1 = 0;
	var _g = grid.length;
	while(_g1 < _g) {
		var w = _g1++;
		var _g3 = 0;
		var _g2 = grid[w].length;
		while(_g3 < _g2) {
			var d = _g3++;
			var _g5 = 0;
			var _g4 = grid[w][d];
			while(_g5 < _g4) {
				var bo = baseMesh.createInstance("");
				bo.parent = this;
				bo.position.x = w * 5;
				bo.position.z = d * 5;
				bo.position.y = _g5++ * 5;
			}
		}
	}
};
$hxClasses["cubecity.CubeBuilding"] = cubecity_CubeBuilding;
cubecity_CubeBuilding.__name__ = ["cubecity","CubeBuilding"];
cubecity_CubeBuilding.__super__ = BABYLON.Mesh;
cubecity_CubeBuilding.prototype = $extend(BABYLON.Mesh.prototype,{
	GenerateBuildingHeight: function() {
		var array = [];
		var _g1 = 0;
		var _g = this.width;
		while(_g1 < _g) {
			++_g1;
			var innerArray = [];
			var _g3 = 0;
			var _g2 = this.depth;
			while(_g3 < _g2) {
				++_g3;
				innerArray.push(Math.random() * 12 + 1);
			}
			array.push(innerArray);
		}
		return array;
	}
	,__class__: cubecity_CubeBuilding
});
var cubecity_CubeCity = function() {
	this.cubes = [];
	wl_core_Part.call(this);
};
$hxClasses["cubecity.CubeCity"] = cubecity_CubeCity;
cubecity_CubeCity.__name__ = ["cubecity","CubeCity"];
cubecity_CubeCity.__super__ = wl_core_Part;
cubecity_CubeCity.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		BABYLON.MeshBuilder.CreateBox("",{ width : 500, height : 500, depth : 500, sideOrientation : BABYLON.Mesh.BACKSIDE},this.scene).receiveShadows = true;
		this.light = new BABYLON.PointLight("",BABYLON.Vector3.Zero(),this.scene);
		this.light.intensity = 0.5;
		this.light.shadowEnabled = true;
		this.light.position.y = 5;
		this.light.shadowMinZ = 0.1;
		this.light.shadowMaxZ = 50;
		this.shadowGenerator = new BABYLON.ShadowGenerator(1024,this.light);
		var baseMesh = wl_util_ExtendedMeshBuilder.CreateHollowCube("",{ width : 5, height : 5, depth : 5, edge : 0.1},null);
		this.shadowGenerator.getShadowMap().renderList.push(baseMesh);
		var _g = 0;
		while(_g < 5) {
			++_g;
			var cubebuilding = new cubecity_CubeBuilding(5,5,this.scene,baseMesh);
			var tmp = Math.random() * 100;
			cubebuilding.position.x = 50 - tmp;
			var tmp1 = Math.random() * 100;
			cubebuilding.position.z = 50 - tmp1;
			this.shadowGenerator.addShadowCaster(cubebuilding,true);
		}
		this.camera.setTarget(this.light.position);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,setupDatGui: function(folder) {
		wl_core_Part.prototype.setupDatGui.call(this,folder);
		var shadowfolder = folder.addFolder("shadows");
		shadowfolder.add(this.shadowGenerator,"useVarianceShadowMap");
		shadowfolder.add(this.shadowGenerator,"usePoissonSampling");
		shadowfolder.add(this.shadowGenerator,"usePercentageCloserFiltering");
		shadowfolder.add(this.shadowGenerator,"useKernelBlur");
		shadowfolder.add(this.shadowGenerator,"useExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"useContactHardeningShadow");
		shadowfolder.add(this.shadowGenerator,"useCloseExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"useBlurVarianceShadowMap");
		shadowfolder.add(this.shadowGenerator,"useBlurExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"useBlurCloseExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"bias");
		var lightfolder = folder.addFolder("light");
		wl_util_DatGuiHelper.addColor(lightfolder,this.light,"diffuse");
		lightfolder.add(this.light,"intensity");
	}
	,__class__: cubecity_CubeCity
});
var cubecity_HollowCube = function(m,scene) {
	BABYLON.TransformNode.call(this,"",scene);
	m.parent = this;
};
$hxClasses["cubecity.HollowCube"] = cubecity_HollowCube;
cubecity_HollowCube.__name__ = ["cubecity","HollowCube"];
cubecity_HollowCube.__super__ = BABYLON.TransformNode;
cubecity_HollowCube.prototype = $extend(BABYLON.TransformNode.prototype,{
	__class__: cubecity_HollowCube
});
var fallingwall_Chain = function(p1,pc,p2,scale,scene) {
	this.links = [];
	this.start = p1;
	this.control = pc;
	this.target = p2;
	var anchor1 = BABYLON.MeshBuilder.CreateSphere("anchor",{ diameter : 0.5},scene);
	anchor1.position.copyFrom(p1);
	anchor1.visibility = 0.0;
	anchor1.dispose();
	var linkMesh = this.buildLink(scene);
	linkMesh.scaling.copyFrom(scale);
	linkMesh.bakeCurrentTransformIntoVertices();
	var bb = linkMesh.getBoundingInfo().boundingBox;
	var count = Math.ceil(BABYLON.Curve3.CreateQuadraticBezier(p1,pc,p2,Math.ceil(BABYLON.Vector3.Distance(p1,p2) / (bb.maximum.y - bb.minimum.y) * 1.4)).length() / (bb.maximum.y - bb.minimum.y) * 1.4);
	var directionCurve = BABYLON.Curve3.CreateQuadraticBezier(p1,pc,p2,count);
	var _g1 = 0;
	while(_g1 < count) {
		var i = _g1++;
		var il = linkMesh.createInstance("");
		var node = new BABYLON.TransformNode("",scene);
		il.parent = node;
		il.position.copyFrom(BABYLON.Vector3.Zero());
		var points = directionCurve.getPoints();
		node.position.copyFrom(points[i]);
		node.lookAt(i < points.length - 1 ? points[i + 1] : p2);
		if(i % 2 == 1) {
			il.rotate(BABYLON.Vector3.Up(),Math.PI * 0.5);
			il.rotate(BABYLON.Vector3.Forward(),Math.PI / 2);
		} else {
			il.rotate(BABYLON.Vector3.Right(),Math.PI / 2);
		}
		this.links.push(node);
	}
};
$hxClasses["fallingwall.Chain"] = fallingwall_Chain;
fallingwall_Chain.__name__ = ["fallingwall","Chain"];
fallingwall_Chain.prototype = {
	updateChain: function() {
		var directionCurve = BABYLON.Curve3.CreateQuadraticBezier(this.start,this.control,this.target,this.links.length);
		var i = 0;
		var _g = 0;
		var _g1 = this.links;
		while(_g < _g1.length) {
			var node = _g1[_g];
			++_g;
			var points = directionCurve.getPoints();
			node.position.copyFrom(points[i]);
			node.lookAt(i < points.length - 1 ? points[i + 1] : this.target);
			++i;
		}
	}
	,buildLink: function(scene) {
		var points = [new BABYLON.Vector3(0.1,0.07,0)];
		var curve = BABYLON.Curve3.CreateCubicBezier(new BABYLON.Vector3(0.1,0.18,0),new BABYLON.Vector3(0.1,0.28,0),new BABYLON.Vector3(-0.1,0.28,0),new BABYLON.Vector3(-0.1,0.18,0),6);
		points = points.concat(curve.getPoints());
		curve = BABYLON.Curve3.CreateCubicBezier(new BABYLON.Vector3(-0.1,-0.18,0),new BABYLON.Vector3(-0.1,-0.28,0),new BABYLON.Vector3(0.1,-0.28,0),new BABYLON.Vector3(0.1,-0.18,0),6);
		points = points.concat(curve.getPoints());
		points.push(points[0].subtract(new BABYLON.Vector3(0,0.015,0)));
		var linkMesh = BABYLON.MeshBuilder.CreateTube("Chain-Link",{ radius : 0.05, path : points, cap : 3, tessellation : 6},scene);
		fallingwall_Chain.linkmaterial = new BABYLON.StandardMaterial("",scene);
		return linkMesh;
	}
	,__class__: fallingwall_Chain
};
var fallingwall_FallingWall = function() {
	this.startedBar = 0;
	this.exposureMP = 0;
	this.glowPieces = [];
	this.chains = [];
	this.maxboxes = 300;
	this.gen_height = 100;
	this.gen_side = 10;
	this.room_height = 100;
	this.room_side = 15;
	this.boxes = [];
	wl_core_Part.call(this);
};
$hxClasses["fallingwall.FallingWall"] = fallingwall_FallingWall;
fallingwall_FallingWall.__name__ = ["fallingwall","FallingWall"];
fallingwall_FallingWall.__super__ = wl_core_Part;
fallingwall_FallingWall.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var physicsPlugin = new BABYLON.CannonJSPlugin();
		var gravityVector = new BABYLON.Vector3(0,-9.81,0);
		this.scene.enablePhysics(gravityVector,physicsPlugin);
		this.lowFilter = { isolate : true, lowLimit : 0, highLimit : 200};
		this.mediumFilter = { isolate : true, lowLimit : 700, highLimit : 1200};
		this.highFilter = { isolate : true, lowLimit : 1000, highLimit : 16000};
		this.analyzer = new wl_sounds_SoundAnalyzer();
		this.analyzer.historySize = 10;
		this.analyzer.filters.push(this.lowFilter);
		this.analyzer.filters.push(this.mediumFilter);
		this.analyzer.filters.push(this.highFilter);
		var rpProp = { };
		rpProp.bloom = true;
		rpProp.chromaticAberration = true;
		rpProp.distort = true;
		rpProp.dof = false;
		rpProp.grain = true;
		rpProp.imageProcessing = true;
		rpProp.sharpen = false;
		rpProp.fxaa = false;
		rpProp.displacement = true;
		this.initPipeline(rpProp);
		this.post.grain.animated = true;
		this.post.displacement.scaleX = 0.04;
		this.post.displacement.scaleY = 0.02;
		this.post.displacement.zoom = 0.5;
		this.post.distort.lineHeight = wl_core_Config.RESOLUTION[1] / 60;
		this.post.imageProcessing.vignetteEnabled = true;
		this.boxMesh = BABYLON.MeshBuilder.CreateBox("",{ width : 2, height : 2, depth : 2},this.scene);
		this.boxMesh.receiveShadows = true;
		var boxmat = new BABYLON.StandardMaterial("",this.scene);
		this.boxMesh.material = boxmat;
		this.ground = BABYLON.MeshBuilder.CreateGround("ground1",{ width : this.room_side * 2, height : this.room_side * 2},this.scene);
		this.ground.material = boxmat;
		this.ground.physicsImpostor = new BABYLON.PhysicsImpostor(this.ground,BABYLON.PhysicsImpostor.BoxImpostor,{ mass : 0, restitution : 0.9},this.scene);
		this.ground.receiveShadows = true;
		this.buildRoom();
		this.glowmat = new BABYLON.StandardMaterial("",this.scene);
		this.glowmat.diffuseColor = new BABYLON.Color3(0.5,0.5,0.5);
		this.glowmat.emissiveColor = new BABYLON.Color3(0.6,0.6,0.6);
		var singlepieceheight = this.room_height / 40;
		var glowPiece = BABYLON.MeshBuilder.CreateBox("",{ width : this.room_side, height : singlepieceheight, depth : 0.2});
		glowPiece.material = this.glowmat;
		var startplaces = [new BABYLON.Vector3(this.room_side / 2,0,-1),new BABYLON.Vector3(this.room_side / 2,0,this.room_side + 1),new BABYLON.Vector3(this.room_side + 1,0,this.room_side / 2),new BABYLON.Vector3(-1,0,this.room_side / 2)];
		var rotations = [0,0,Math.PI / 2,Math.PI / 2];
		var _g = 0;
		while(_g < 4) {
			var p = _g++;
			var _g2 = 0;
			var _g1 = Math.ceil(this.room_height / (singlepieceheight * 2.5) + 1);
			while(_g2 < _g1) {
				var gb = glowPiece.createInstance("");
				gb.position.x = startplaces[p].x;
				gb.position.z = startplaces[p].z;
				gb.position.y = this.room_height + _g2++ * (singlepieceheight * 2.5);
				gb.rotate(BABYLON.Vector3.Up(),rotations[p]);
				this.glowPieces.push(gb);
			}
		}
		glowPiece.setEnabled(false);
		new BABYLON.GlowLayer("glow",this.scene);
		var shippos = new BABYLON.Vector3(this.room_side / 2,3,this.room_side / 2);
		this.ship = new fallingwall_RisingShip(this.scene,shippos);
		var utscale = new BABYLON.Vector3(1,1,1);
		this.chains.push(new fallingwall_Chain(new BABYLON.Vector3(0,5,0),new BABYLON.Vector3(this.room_side / 4,3,this.room_side / 4),this.ship.position,utscale,this.scene));
		this.chains.push(new fallingwall_Chain(new BABYLON.Vector3(0,5,this.room_side),new BABYLON.Vector3(this.room_side / 4,3,this.room_side * 3 / 4),this.ship.position,utscale,this.scene));
		this.chains.push(new fallingwall_Chain(new BABYLON.Vector3(this.room_side,5,0),new BABYLON.Vector3(this.room_side * 3 / 4,3,this.room_side / 4),this.ship.position,utscale,this.scene));
		this.chains.push(new fallingwall_Chain(new BABYLON.Vector3(this.room_side,5,this.room_side),new BABYLON.Vector3(this.room_side * 3 / 4,3,this.room_side * 3 / 4),this.ship.position,utscale,this.scene));
		this.chains.push(new fallingwall_Chain(new BABYLON.Vector3(this.room_side / 2,2,0),new BABYLON.Vector3(this.room_side / 2,.1,this.room_side / 4),this.ship.position,utscale,this.scene));
		this.chains.push(new fallingwall_Chain(new BABYLON.Vector3(this.room_side / 2,2,this.room_side),new BABYLON.Vector3(this.room_side / 2,.1,this.room_side * 3 / 4),this.ship.position,utscale,this.scene));
		this.chains.push(new fallingwall_Chain(new BABYLON.Vector3(0,2,this.room_side / 2),new BABYLON.Vector3(this.room_side / 4,.1,this.room_side / 2),this.ship.position,utscale,this.scene));
		this.chains.push(new fallingwall_Chain(new BABYLON.Vector3(this.room_side,2,this.room_side / 2),new BABYLON.Vector3(this.room_side * 3 / 4,.1,this.room_side / 2),this.ship.position,utscale,this.scene));
		this.camera.position.x = 10;
		this.camera.position.y = 6;
		this.camera.position.z = -0.5;
		var cameratarget = this.ship.position.clone();
		this.camera.setTarget(cameratarget);
		this.shadowgenerator = new BABYLON.ShadowGenerator(512,this.ship.light);
		var _g3 = 0;
		var _g11 = this.ship.shadowcasters;
		while(_g3 < _g11.length) {
			var sc = _g11[_g3];
			++_g3;
			this.shadowgenerator.addShadowCaster(sc);
		}
		this.addTrigger(new wl_core_TimeSig(0,0,0,0,wl_core_TimeSig.RELATIVE),function(ts) {
			createjs.Tween.get(_gthis.ship.position,{ loop : true}).to({ y : 6},wl_core_TimeSig.milliseconds(3,0,0,0),createjs.Ease.sineInOut).to({ y : 3},wl_core_TimeSig.milliseconds(3,0,0,0),createjs.Ease.sineInOut);
			createjs.Tween.get(_gthis.ship.light).to({ intensity : 1.0, range : 15},wl_core_TimeSig.milliseconds(2,0,0,0));
		});
		this.addTrigger(new wl_core_TimeSig(1,0,0,0,wl_core_TimeSig.RELATIVE),function(ts1) {
			createjs.Tween.get(_gthis.ship.innermat.emissiveColor).to({ r : _gthis.ship.light.diffuse.r, g : _gthis.ship.light.diffuse.g, b : _gthis.ship.light.diffuse.b},wl_core_TimeSig.milliseconds(4,0,0,0));
		});
		this.rndcc = new wl_demo_RandomCameraController(this.camera,8,[],97678,[wl_demo_CameraController.LINEAR],[0,5],new BABYLON.BoundingBox(new BABYLON.Vector3(6.5,3.5,8.01),new BABYLON.Vector3(12.3,10.3,14.3)));
		this.rndcc2 = new wl_demo_RandomCameraController(this.camera,8,[],4627,[wl_demo_CameraController.BEZIER],[7,30],new BABYLON.BoundingBox(new BABYLON.Vector3(6,6,10.0),new BABYLON.Vector3(7,7,10)));
		this.rndcc3 = new wl_demo_RandomCameraController(this.camera,8,[],246,[wl_demo_CameraController.BEZIER],[7,30],new BABYLON.BoundingBox(new BABYLON.Vector3(7,7,11.0),new BABYLON.Vector3(8,8,14)));
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),function(ts2) {
			_gthis.rndcc.swap();
			_gthis.rndcc2.swap();
			_gthis.rndcc3.swap();
		});
		this.addTrigger(new wl_core_TimeSig(1,0,0,0,wl_core_TimeSig.PATTERN),function(ts3) {
			_gthis.ship.enableNewBall();
		});
		this.addTrigger(new wl_core_TimeSig(8,0,0,0,wl_core_TimeSig.RELATIVE),function(ts4) {
			var newpos = _gthis.ship.position.clone();
			var _g4 = 0;
			var _g12 = _gthis.chains;
			while(_g4 < _g12.length) {
				var c = _g12[_g4];
				++_g4;
				c.target = newpos;
				var tmp = c.control.y - 2;
				createjs.Tween.get(c.control).to({ y : tmp},null,createjs.Ease.bounceOut);
			}
			createjs.Tween.get(newpos).to({ y : 0},wl_core_TimeSig.milliseconds(1,0,0,0),createjs.Ease.bounceOut);
			var _g5 = 0;
			while(_g5 < 2) {
				++_g5;
				_gthis.ship.enableNewBall();
			}
		});
		this.addTrigger(new wl_core_TimeSig(10,0,0,0,wl_core_TimeSig.RELATIVE),function(ts5) {
			createjs.Tween.removeTweens(_gthis.ship.position);
			_gthis.ship.rising = true;
		});
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		this.startedBar = ts.bar;
		createjs.Tween.get(this).to({ exposureMP : 1},wl_core_TimeSig.milliseconds(1,0,0,0));
	}
	,buildRoom: function() {
		this.wallmat = new BABYLON.StandardMaterial("",this.scene);
		this.wallmat.specularPower = 0;
		this.wallmat.diffuseColor = DemoMain.BASE_1.clone().scale(0.15);
		var room = new BABYLON.TransformNode("",this.scene);
		var wall = this.generateWall(this.gen_side,this.gen_height,this.room_side,this.room_height);
		wall.receiveShadows = true;
		wall.material = this.wallmat;
		wall.physicsImpostor = new BABYLON.PhysicsImpostor(wall,BABYLON.PhysicsImpostor.BoxImpostor,{ mass : 0, restitution : 0.9},this.scene);
		var wall2 = wall.clone("",room);
		wall2.physicsImpostor = new BABYLON.PhysicsImpostor(wall2,BABYLON.PhysicsImpostor.BoxImpostor,{ mass : 0, restitution : 0.9},this.scene);
		wall2.position.z = this.room_side;
		var wall3 = wall.clone("",room);
		wall3.physicsImpostor = new BABYLON.PhysicsImpostor(wall3,BABYLON.PhysicsImpostor.BoxImpostor,{ mass : 0, restitution : 0.9},this.scene);
		wall3.rotate(BABYLON.Vector3.Up(),Math.PI / 2);
		wall3.position.z = this.room_side;
		wall3.parent = room;
		var wall4 = wall.clone("",room);
		wall4.physicsImpostor = new BABYLON.PhysicsImpostor(wall4,BABYLON.PhysicsImpostor.BoxImpostor,{ mass : 0, restitution : 0.9},this.scene);
		wall4.rotate(BABYLON.Vector3.Up(),Math.PI / 2);
		wall4.position.x = this.room_side;
		wall4.position.z = this.room_side;
		wall4.parent = room;
		return room;
	}
	,generateWall: function(gen_side,gen_height,room_side,room_height) {
		var wallmeshes = [];
		var _g1 = 0;
		while(_g1 < gen_side) {
			var x = _g1++;
			var _g3 = 0;
			while(_g3 < gen_height) {
				var y = _g3++;
				if(wl_util_Random.nextFloat() < 0.05 && y > 10 && x > 1 && x < gen_side - 1) {
					continue;
				}
				var box = BABYLON.MeshBuilder.CreateBox("",{ width : 1, height : 1, depth : 0.1},this.scene);
				wallmeshes.push(box);
				box.position.x = x;
				box.position.y = y + 0.5;
				if(wl_util_Random.nextFloat() < 0.5) {
					var tmp = wl_util_Random.nextFloat();
					box.position.z = tmp / 4;
				}
			}
		}
		var wall = new BABYLON.TransformNode("",this.scene);
		var m = BABYLON.Mesh.MergeMeshes(wallmeshes,true,true);
		var _g = 0;
		while(_g < wallmeshes.length) {
			var b = wallmeshes[_g];
			++_g;
			b.dispose();
		}
		wallmeshes = [];
		var _g11 = 0;
		var _g2 = Math.ceil(room_side / gen_side);
		while(_g11 < _g2) {
			var x1 = _g11++;
			var yoffset = wl_util_Random.nextFloat() * room_height * 0.1;
			var _g31 = 0;
			var _g21 = Math.ceil(room_height / gen_height);
			while(_g31 < _g21) {
				var m2 = m.clone("",wall);
				m2.position.x = x1 * gen_side;
				m2.position.y = _g31++ * gen_height - yoffset;
				wallmeshes.push(m2);
			}
		}
		m.dispose();
		m = BABYLON.Mesh.MergeMeshes(wallmeshes,true,true);
		var _g4 = 0;
		while(_g4 < wallmeshes.length) {
			var b1 = wallmeshes[_g4];
			++_g4;
			b1.dispose();
		}
		return m;
	}
	,dropBox: function() {
		var box = this.boxMesh.createInstance("");
		var tmp = wl_util_Random.nextFloat();
		box.position.z = tmp * this.room_side;
		var tmp1 = wl_util_Random.nextFloat();
		box.position.x = tmp1 * this.room_side;
		var tmp2 = this.room_height * 0.8;
		var tmp3 = wl_util_Random.nextFloat() * this.room_height * 0.2;
		box.position.y = tmp2 + tmp3;
		box.physicsImpostor = new BABYLON.PhysicsImpostor(box,BABYLON.PhysicsImpostor.BoxImpostor,{ mass : 2.1, restitution : 0.4},this.scene);
		box.physicsImpostor.applyForce(new BABYLON.Vector3(0.1 * wl_util_Random.nextFloat(),0.1 * wl_util_Random.nextFloat(),0.1 * wl_util_Random.nextFloat()),BABYLON.Vector3.Zero());
		box.physicsImpostor.registerOnPhysicsCollide(this.ground.physicsImpostor,function(main,collided) {
		});
		this.boxes.push(box);
		this.shadowgenerator.addShadowCaster(box);
	}
	,update: function(ts,partial,frameTime,delta) {
		this.ship.update(ts,delta);
		var _g = 0;
		var _g1 = this.chains;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			c.updateChain();
		}
		var _g2 = 0;
		var _g11 = this.glowPieces;
		while(_g2 < _g11.length) {
			var g = _g11[_g2];
			++_g2;
			g.position.y -= 0.3;
			if(g.position.y < 0) {
				g.position.y = this.room_height + this.room_height / 20;
			}
		}
		this.analyzer.update();
		this.post.grain.intensity = this.lowFilter.max * 30 + 5;
		this.post.chromaticAberration.aberrationAmount = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.8) * 120;
		this.post.distort.intensity = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.9) * 0.06;
		this.post.distort.intensityY = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.9) * 0.06;
		this.post.bloom.bloomWeight = this.lowFilter.max * 5;
		this.post.imageProcessing.vignetteWeight = this.lowFilter.max;
		this.post.imageProcessing.exposure = this.exposureMP * Math.min(1.100,0.7 + Math.max(0,this.lowFilter.min - 0.8) * 2.5);
		this.post.displacement.zoom = 0.5 + this.lowFilter.max * 0.25;
		if(ts.bar - this.startedBar < 8) {
			if(ts.bar % 2 == 0) {
				this.rndcc.updateLength(wl_core_TimeSig.milliseconds(2,0,0,0));
			} else {
				this.rndcc2.updateLength(wl_core_TimeSig.milliseconds(2,0,0,0));
			}
		} else {
			this.rndcc3.updateLength(wl_core_TimeSig.milliseconds(2,0,0,0));
		}
		this.camera.setTarget(this.ship.position);
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,setupDatGui: function(folder) {
		wl_core_Part.prototype.setupDatGui.call(this,folder);
	}
	,__class__: fallingwall_FallingWall
});
var fallingwall_RisingShip = function(scene,pos) {
	this.shadowcasters = [];
	this.zeroOneVector = new BABYLON.Vector3(0.3,0.3,0.3);
	this.balls = [];
	BABYLON.TransformNode.call(this,"",scene);
	this.light = new BABYLON.PointLight("",BABYLON.Vector3.Zero(),scene);
	this.light.parent = this;
	this.light.intensity = 0.1;
	this.light.range = 3;
	this.light.shadowMinZ = 0.05;
	this.light.shadowMaxZ = 20;
	this.light.diffuse = DemoMain.BASE_1.clone();
	this.light.shadowEnabled = true;
	this.position.copyFrom(pos);
	new BABYLON.StandardMaterial("",scene).diffuseColor = new BABYLON.Color3(0.6,0.6,0.6);
	var _g = 0;
	while(_g < 32) {
		++_g;
		var b = BABYLON.MeshBuilder.CreateSphere("",{ diameter : .8},scene);
		b.position.copyFrom(this.position);
		var tmp = b.position.x * wl_util_Random.nextFloat();
		var tmp1 = b.position.x / 2 * wl_util_Random.nextFloat();
		b.position.x = tmp + tmp1;
		var tmp2 = b.position.z * wl_util_Random.nextFloat();
		var tmp3 = b.position.z / 2 * wl_util_Random.nextFloat();
		b.position.z = tmp2 + tmp3;
		b.physicsImpostor = new BABYLON.PhysicsImpostor(b,BABYLON.PhysicsImpostor.SphereImpostor,{ mass : 2, restitution : 0.1},scene);
		this.balls.push(b);
		b.isVisible = false;
		this.shadowcasters.push(b);
	}
	this.centerball = BABYLON.MeshBuilder.CreateSphere("",{ diameter : 2},scene);
	this.centerball.position.copyFrom(this.position);
	this.centerball.physicsImpostor = new BABYLON.PhysicsImpostor(this.centerball,BABYLON.PhysicsImpostor.SphereImpostor,{ mass : 0, restitution : 0.0},scene);
	this.shadowcasters.push(this.centerball);
	BABYLON.Effect.ShadersStore["shipPixelShader"] = haxe_Resource.getString("shipshader.frag");
	this.customProc = new BABYLON.CustomProceduralTexture("ship","ship",1024,scene);
	this.customProc.setFloat("t",0);
	this.customProc.refreshRate = 1;
	this.customProc.hasAlpha = true;
	var centermat = new BABYLON.StandardMaterial("",scene);
	centermat.diffuseTexture = this.customProc;
	centermat.backFaceCulling = false;
	centermat.diffuseColor = new BABYLON.Color3(0.5,0.5,0.5);
	centermat.emissiveColor = new BABYLON.Color3(0.0,0,0);
	this.centerball.material = centermat;
	this.innermat = new BABYLON.StandardMaterial("",scene);
	this.innermat.diffuseColor = centermat.diffuseColor;
	var innerball = BABYLON.MeshBuilder.CreateSphere("",{ diameter : 1.9},scene);
	innerball.material = this.innermat;
	innerball.parent = this;
};
$hxClasses["fallingwall.RisingShip"] = fallingwall_RisingShip;
fallingwall_RisingShip.__name__ = ["fallingwall","RisingShip"];
fallingwall_RisingShip.__super__ = BABYLON.TransformNode;
fallingwall_RisingShip.prototype = $extend(BABYLON.TransformNode.prototype,{
	enableNewBall: function() {
		var hiddenballs = this.balls.filter(function(f) {
			return !f.isVisible;
		});
		if(hiddenballs.length > 0) {
			hiddenballs[0].isVisible = true;
		}
	}
	,update: function(ts,d) {
		if(this.rising) {
			this.position.y += 0.05 * d;
		}
		this.centerball.position.copyFrom(this.position);
		console.log(this.customProc);
		this.customProc.setFloat("t",ts.toMilliseconds() / 1000);
		var _g = 0;
		var _g1 = this.balls;
		while(_g < _g1.length) {
			var b = _g1[_g];
			++_g;
			var impulseStr = this.position.subtract(b.position).normalize().scale(0.2);
			b.physicsImpostor.applyImpulse(impulseStr,BABYLON.Vector3.Zero());
		}
	}
	,__class__: fallingwall_RisingShip
});
var floatingBalls_FloatingBall = function() {
	BABYLON.TransformNode.call(this,"");
	if(floatingBalls_FloatingBall.innerMesh == null) {
		floatingBalls_FloatingBall.innerMesh = BABYLON.MeshBuilder.CreateSphere("sphere1",{ segments : 16, diameter : 1.8, sideOrientation : BABYLON.Mesh.DOUBLESIDE},null);
		var innermat = new BABYLON.StandardMaterial("",null);
		innermat.diffuseColor = new BABYLON.Color3(0.5,0.0,0.5);
		innermat.emissiveColor = new BABYLON.Color3(0.5,0,0.5);
		floatingBalls_FloatingBall.innerMesh.material = innermat;
		floatingBalls_FloatingBall.innerMesh.isVisible = false;
	}
	if(floatingBalls_FloatingBall.quarterMeshes == null) {
		floatingBalls_FloatingBall.quarterMeshes = [];
		var _g = 0;
		while(_g < 4) {
			var m = BABYLON.MeshBuilder.CreateSphere("sphere1",{ segments : 16, diameter : 2, slice : 0.5, arc : 0.5, sideOrientation : BABYLON.Mesh.DOUBLESIDE},null);
			var rot = Math.PI / 2 * _g++;
			m.rotate(BABYLON.Vector3.Left(),rot);
			m.bakeCurrentTransformIntoVertices();
			floatingBalls_FloatingBall.quarterMeshes.push(m);
			m.isVisible = false;
		}
	}
	floatingBalls_FloatingBall.innerMesh.createInstance("").setParent(this);
	var _g1 = 0;
	while(_g1 < 4) {
		var sphere = floatingBalls_FloatingBall.quarterMeshes[_g1++].createInstance("");
		sphere.setParent(this);
		var bbmax = sphere.getBoundingInfo().boundingBox.center.multiplyByFloats(0.5,0.5,0.5);
		createjs.Tween.get(sphere.position,{ loop : true}).to({ y : bbmax.y, z : bbmax.z},2000,createjs.Ease.quadOut).to({ y : 0, z : 0},2000,createjs.Ease.quadOut);
	}
};
$hxClasses["floatingBalls.FloatingBall"] = floatingBalls_FloatingBall;
floatingBalls_FloatingBall.__name__ = ["floatingBalls","FloatingBall"];
floatingBalls_FloatingBall.__super__ = BABYLON.TransformNode;
floatingBalls_FloatingBall.prototype = $extend(BABYLON.TransformNode.prototype,{
	__class__: floatingBalls_FloatingBall
});
var floatingBalls_FloatingBalls = function() {
	this.balls = [];
	wl_core_Part.call(this);
};
$hxClasses["floatingBalls.FloatingBalls"] = floatingBalls_FloatingBalls;
floatingBalls_FloatingBalls.__name__ = ["floatingBalls","FloatingBalls"];
floatingBalls_FloatingBalls.__super__ = wl_core_Part;
floatingBalls_FloatingBalls.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var _g = 0;
		while(_g < 5) {
			var y = _g++;
			var _g1 = 0;
			while(_g1 < 5) {
				var x = _g1++;
				var _g2 = 0;
				while(_g2 < 5) {
					var b = new floatingBalls_FloatingBall();
					b.position.set(x * 3,y * 3,_g2++ * 3);
					this.scene.addTransformNode(b);
					this.balls.push(b);
				}
			}
		}
		new BABYLON.HemisphericLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		var gl = new BABYLON.GlowLayer("glow",this.scene,{ mainTextureSamples : 2});
		gl.isEnabled = true;
		gl.intensity = 1;
		var pipeline = new BABYLON.DefaultRenderingPipeline("default",true,this.scene,[this.scene.activeCamera]);
		pipeline.depthOfFieldBlurLevel = 1;
		pipeline.depthOfFieldEnabled = true;
		pipeline.depthOfField.focalLength = 180;
		pipeline.depthOfField.fStop = 3;
		pipeline.depthOfField.focusDistance = 2250;
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: floatingBalls_FloatingBalls
});
var greets_GreetSPS = function(name,scene) {
	this.conf = [];
	this.phase = 0;
	this.intro = 0;
	var _gthis = this;
	BABYLON.TransformNode.call(this,name,scene);
	var img = wl_core_Assets.get(name);
	var id = wl_util_ExtractPixels.extract(img);
	this.sps = new BABYLON.SolidParticleSystem("sps",scene,{ updatable : true, isPickable : false, enableDepthSort : false, particleIntersection : false, boundingSphereOnly : true});
	var b = BABYLON.MeshBuilder.CreateBox("box",{ width : 1, height : 1, depth : 1});
	var amount = id.width * id.height + 250;
	new wl_util_Random(123);
	var _g1 = 0;
	while(_g1 < amount) {
		var i = _g1++;
		if(i < id.width * id.height) {
			var gpc = { startX : i % id.width - img.width / 2, startY : id.height - Math.floor(i / id.width) - img.height / 2, startZ : 0, targetX : i % id.width - (id.width / 2 - i % id.width) * (wl_util_Random.nextFloat() + 0.5) - img.width / 2, targetY : id.height - (Math.floor(i / id.width) - id.height / 2) * 3 * (wl_util_Random.nextFloat() + 0.5) - img.height / 2, targetZ : (wl_util_Random.nextFloat() - 0.5) * 3, rotX : 0, rotY : 0, rotZ : 0, delay : wl_util_Random.nextFloat() * 0.5 + 1.5, targetScale : 1};
			if(id.data[i * 4] > 0) {
				this.conf.push(gpc);
			}
		}
	}
	var posfunc = function(p,i1,s) {
		if(i1 == null) {
			i1 = p.idx;
		} else {
			i1 = i1;
		}
		var conf = _gthis.conf[i1];
		p.color = DemoMain.WHITE.clone().scale(0.7).toColor4(1);
		var phase = _gthis.phase - conf.delay;
		var introPhase = _gthis.intro - conf.delay * 0.25;
		if(_gthis.intro < 1) {
			if(introPhase > 0) {
				introPhase = 0;
			} else {
				introPhase = introPhase;
			}
			p.position.x = conf.startX;
			p.position.y = conf.startY;
			p.position.z = conf.startZ;
			p.rotation.x = conf.rotX;
			p.rotation.y = conf.rotY;
			p.rotation.z = conf.rotZ;
			p.scaling.x = p.scaling.y = p.scaling.z = 1 + introPhase;
		} else {
			if(phase < 0) {
				phase = 0;
			} else {
				phase = phase;
			}
			p.position.x = conf.startX + (conf.targetX - conf.startX) * phase;
			p.position.y = conf.startY + (conf.targetY - conf.startY) * phase;
			p.position.z = conf.startZ + (conf.targetZ - conf.startZ) * phase;
			p.rotation.x = conf.rotX;
			p.rotation.y = conf.rotY;
			p.rotation.z = conf.rotZ;
			p.scaling.x = p.scaling.y = p.scaling.z = 1 - phase / (4 - conf.delay);
		}
	};
	this.sps.updateParticle = posfunc;
	this.sps.addShape(b,this.conf.length,{ positionFunction : posfunc});
	this.mesh = this.sps.buildMesh();
	this.mesh.parent = this;
	b.dispose();
	this.mesh.visibility = 1;
	this.intro = 1;
	this.sps.setParticles();
};
$hxClasses["greets.GreetSPS"] = greets_GreetSPS;
greets_GreetSPS.__name__ = ["greets","GreetSPS"];
greets_GreetSPS.__super__ = BABYLON.TransformNode;
greets_GreetSPS.prototype = $extend(BABYLON.TransformNode.prototype,{
	animateIn: function(ts) {
		var _gthis = this;
		this.mesh.visibility = 1;
		console.log("ANIMATE IN");
		createjs.Tween.get(this,{ onChange : function() {
			if(_gthis.sps != null) {
				_gthis.sps.setParticles();
			}
		}}).to({ intro : 1},wl_core_TimeSig.milliseconds(0,2,0,0)).to({ phase : 4},wl_core_TimeSig.milliseconds(1,2,0,0)).call(function() {
			createjs.Tween.removeTweens(_gthis);
			_gthis.sps.dispose();
			_gthis.sps = null;
		});
	}
	,__class__: greets_GreetSPS
});
var greets_HairyBall = function(name,scene) {
	this.offset = wl_util_Random.nextFloat() * 0.5;
	BABYLON.TransformNode.call(this,name);
	this.scene = scene;
	if(greets_HairyBall.texture == null) {
		greets_HairyBall.texture = this.generateTexture();
	}
	this.initializeControls();
};
$hxClasses["greets.HairyBall"] = greets_HairyBall;
greets_HairyBall.__name__ = ["greets","HairyBall"];
greets_HairyBall.__super__ = BABYLON.TransformNode;
greets_HairyBall.prototype = $extend(BABYLON.TransformNode.prototype,{
	initializeControls: function() {
		if(greets_HairyBall.baseMesh == null) {
			greets_HairyBall.baseMesh = BABYLON.MeshBuilder.CreateBox("box",{ });
			this.mesh = greets_HairyBall.baseMesh;
			greets_HairyBall.fur = new BABYLON.StandardMaterial("mat",this.scene);
			greets_HairyBall.fur.wireframe = false;
			greets_HairyBall.fur.diffuseColor = DemoMain.HILIGHT;
			this.mesh.material = greets_HairyBall.fur;
		} else {
			this.mesh = greets_HairyBall.baseMesh.createInstance("inst");
		}
		this.mesh.parent = this;
	}
	,generateTexture: function() {
		var r = new wl_util_Random(10);
		var texture = new BABYLON.DynamicTexture("FurTexture " + this.name,256,null,true);
		var context = texture.getContext();
		var _g = 0;
		while(_g < 20000) {
			++_g;
			context.fillStyle = "rgba(255, " + Math.floor(r.NextFloat() * 255) + ", " + Math.floor(r.NextFloat() * 255) + ", 1)";
			context.fillRect(r.NextFloat() * texture.getSize().width,r.NextFloat() * texture.getSize().height,2,2);
		}
		texture.update(false);
		texture.wrapU = BABYLON.Texture.WRAP_ADDRESSMODE;
		texture.wrapV = BABYLON.Texture.WRAP_ADDRESSMODE;
		return texture;
	}
	,__class__: greets_HairyBall
});
var greets_PostTest = function() {
	this.greetNames = ["greet_adapt.png","greet_api.png","greet_alumni.png","greet_asd.png","greet_ananasmurska.png","greet_cncd.png","greet_artline_designs.png","greet_fgj.png","greet_byterapers.png","greet_hbc.png","greet_damones.png","greet_darklite.png","greet_dekadence.png","greet_ekspert.png","greet_epoch.png","greet_fairlight.png","greet_hedelmae.png","greet_jumalauta.png","greet_kewlers.png","greet_matt_current.png","greet_mercury.png","greet_mfx.png","greet_paraguay.png","greet_primitive.png","greet_npli.png","greet_pyrotech.png","greet_quadtrip.png","greet_scenesat.png","greet_tahtituho.png","greet_traction.png"];
	this.camdist = -1300;
	wl_core_Part.call(this);
};
$hxClasses["greets.PostTest"] = greets_PostTest;
greets_PostTest.__name__ = ["greets","PostTest"];
greets_PostTest.__super__ = wl_core_Part;
greets_PostTest.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var glowCube = BABYLON.MeshBuilder.CreateSphere("box",{ diameter : 245, sideOrientation : BABYLON.Mesh.DOUBLESIDE},null);
		var glowMat = new BABYLON.StandardMaterial("",null);
		glowMat.diffuseColor = DemoMain.BLACK.clone();
		glowMat.ambientColor = DemoMain.BLACK.clone();
		glowMat.emissiveColor = DemoMain.WHITE.clone().scale(0.5);
		glowCube.material = glowMat;
		this.scene.addMesh(glowCube);
		this.targetNode = new BABYLON.TransformNode("target",this.scene);
		this.pl = new BABYLON.PointLight("pl",new BABYLON.Vector3(0,0,0),this.scene);
		this.pl.diffuse = DemoMain.WHITE;
		this.pl.intensity = 1;
		this.pl.range = 1550;
		this.camera.position = new BABYLON.Vector3(0,0,this.camdist);
		this.greets = [];
		var c = 0;
		var _g = 0;
		var _g1 = this.greetNames;
		while(_g < _g1.length) {
			var g = _g1[_g];
			++_g;
			var gsps = new greets_GreetSPS(g,this.scene);
			this.greets.push(gsps);
			gsps.position.z = -700 + c * 20;
			gsps.position.x = Math.floor(c / 2) % 2 == 0 ? -80 : 80;
			gsps.position.y = Math.cos(c / 3) * 10 - (c % 2 == 0 ? 0 : 35) + 40;
			gsps.position.y -= Math.floor(c / 4) % 2 == 0 ? 80 : 0;
			++c;
			gsps.lookAt(this.camera.position);
		}
		this.targetNode.position.copyFrom(this.greets[0].position);
		this.setupPostprocessing();
		this.addTrigger(new wl_core_TimeSig(4,0,0,0,wl_core_TimeSig.RELATIVE),function(ts) {
			_gthis.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),function(ts1) {
				if(_gthis.greets.length > 0) {
					_gthis.greets.shift().animateIn(ts1);
					_gthis.greets.shift().animateIn(ts1);
				}
			});
		});
	}
	,setupPostprocessing: function() {
		var plConf = { };
		plConf.dof = false;
		plConf.bloom = true;
		plConf.chromaticAberration = true;
		plConf.imageProcessing = true;
		plConf.grain = true;
		plConf.fxaa = true;
		plConf.sharpen = true;
		plConf.distort = true;
		this.initPipeline(plConf);
		this.post.chromaticAberration.aberrationAmount = 5;
		this.post.imageProcessing.exposure = 1;
		this.post.imageProcessing.toneMappingEnabled = true;
		this.post.imageProcessing.vignetteEnabled = true;
		this.post.imageProcessing.vignetteBlendMode = 1;
		this.post.grain.animated = true;
		this.post.grain.intensity = 15;
		this.post.bloom.bloomWeight = 0.8;
		this.post.bloom.bloomThreshold = 0.01;
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		createjs.Tween.get(this).to({ camdist : -120},wl_core_TimeSig.milliseconds(32,0,0,0),createjs.Ease.quadOut);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		this.camera.position = new BABYLON.Vector3(0,0,this.camdist);
		this.camera.setTarget(this.targetNode.position);
		this.targetNode.position.x += (this.greets.length > 0 ? this.greets[0].position.x - this.targetNode.position.x : 0 - this.targetNode.position.x) / 140;
		this.targetNode.position.y += (this.greets.length > 0 ? this.greets[0].position.y - this.targetNode.position.y : 0 - this.targetNode.position.y) / 140;
		this.targetNode.position.z += (this.greets.length > 0 ? this.greets[0].position.z - this.targetNode.position.z : 0 - this.targetNode.position.z) / 140;
		var _g = 0;
		var _g1 = this.greets;
		while(_g < _g1.length) {
			var g = _g1[_g];
			++_g;
			g.lookAt(this.camera.position);
		}
		this.pl.position = this.camera.position;
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: greets_PostTest
});
var greetwall_GreetWall = function() {
	wl_core_Part.call(this);
};
$hxClasses["greetwall.GreetWall"] = greetwall_GreetWall;
greetwall_GreetWall.__name__ = ["greetwall","GreetWall"];
greetwall_GreetWall.__super__ = wl_core_Part;
greetwall_GreetWall.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var physicsPlugin = new BABYLON.CannonJSPlugin();
		var gravityVector = new BABYLON.Vector3(0,-9.81,0);
		this.scene.enablePhysics(gravityVector,physicsPlugin);
		var light = new BABYLON.HemisphericLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		light.diffuse = new BABYLON.Color3(0.9,0.1,0.1);
		light.intensity = 0.7;
		var ground = BABYLON.MeshBuilder.CreateGround("ground1",{ width : 500, height : 500},this.scene);
		ground.physicsImpostor = new BABYLON.PhysicsImpostor(ground,BABYLON.PhysicsImpostor.BoxImpostor,{ mass : 0, restitution : 0.9},this.scene);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,setupDatGui: function(folder) {
		wl_core_Part.prototype.setupDatGui.call(this,folder);
	}
	,__class__: greetwall_GreetWall
});
var haxe_IMap = function() { };
$hxClasses["haxe.IMap"] = haxe_IMap;
haxe_IMap.__name__ = ["haxe","IMap"];
var haxe_Resource = function() { };
$hxClasses["haxe.Resource"] = haxe_Resource;
haxe_Resource.__name__ = ["haxe","Resource"];
haxe_Resource.getString = function(name) {
	var _g = 0;
	var _g1 = haxe_Resource.content;
	while(_g < _g1.length) {
		var x = _g1[_g];
		++_g;
		if(x.name == name) {
			if(x.str != null) {
				return x.str;
			}
			return haxe_crypto_Base64.decode(x.data).toString();
		}
	}
	return null;
};
var haxe_Timer = function(time_ms) {
	var me = this;
	this.id = setInterval(function() {
		me.run();
	},time_ms);
};
$hxClasses["haxe.Timer"] = haxe_Timer;
haxe_Timer.__name__ = ["haxe","Timer"];
haxe_Timer.delay = function(f,time_ms) {
	var t = new haxe_Timer(time_ms);
	t.run = function() {
		t.stop();
		f();
	};
	return t;
};
haxe_Timer.prototype = {
	stop: function() {
		if(this.id == null) {
			return;
		}
		clearInterval(this.id);
		this.id = null;
	}
	,run: function() {
	}
	,__class__: haxe_Timer
};
var haxe_io_Bytes = function(data) {
	this.length = data.byteLength;
	this.b = new Uint8Array(data);
	this.b.bufferValue = data;
	data.hxBytes = this;
	data.bytes = this.b;
};
$hxClasses["haxe.io.Bytes"] = haxe_io_Bytes;
haxe_io_Bytes.__name__ = ["haxe","io","Bytes"];
haxe_io_Bytes.ofString = function(s) {
	var a = [];
	var i = 0;
	while(i < s.length) {
		var c = s.charCodeAt(i++);
		if(55296 <= c && c <= 56319) {
			c = c - 55232 << 10 | s.charCodeAt(i++) & 1023;
		}
		if(c <= 127) {
			a.push(c);
		} else if(c <= 2047) {
			a.push(192 | c >> 6);
			a.push(128 | c & 63);
		} else if(c <= 65535) {
			a.push(224 | c >> 12);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		} else {
			a.push(240 | c >> 18);
			a.push(128 | c >> 12 & 63);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		}
	}
	return new haxe_io_Bytes(new Uint8Array(a).buffer);
};
haxe_io_Bytes.prototype = {
	getString: function(pos,len) {
		if(pos < 0 || len < 0 || pos + len > this.length) {
			throw new js__$Boot_HaxeError(haxe_io_Error.OutsideBounds);
		}
		var s = "";
		var b = this.b;
		var fcc = String.fromCharCode;
		var i = pos;
		var max = pos + len;
		while(i < max) {
			var c = b[i++];
			if(c < 128) {
				if(c == 0) {
					break;
				}
				s += fcc(c);
			} else if(c < 224) {
				s += fcc((c & 63) << 6 | b[i++] & 127);
			} else if(c < 240) {
				s += fcc((c & 31) << 12 | (b[i++] & 127) << 6 | b[i++] & 127);
			} else {
				var u = (c & 15) << 18 | (b[i++] & 127) << 12 | (b[i++] & 127) << 6 | b[i++] & 127;
				s += fcc((u >> 10) + 55232);
				s += fcc(u & 1023 | 56320);
			}
		}
		return s;
	}
	,toString: function() {
		return this.getString(0,this.length);
	}
	,__class__: haxe_io_Bytes
};
var haxe_crypto_Base64 = function() { };
$hxClasses["haxe.crypto.Base64"] = haxe_crypto_Base64;
haxe_crypto_Base64.__name__ = ["haxe","crypto","Base64"];
haxe_crypto_Base64.decode = function(str,complement) {
	if(complement == null) {
		complement = true;
	}
	if(complement) {
		while(HxOverrides.cca(str,str.length - 1) == 61) str = HxOverrides.substr(str,0,-1);
	}
	return new haxe_crypto_BaseCode(haxe_crypto_Base64.BYTES).decodeBytes(haxe_io_Bytes.ofString(str));
};
var haxe_crypto_BaseCode = function(base) {
	var len = base.length;
	var nbits = 1;
	while(len > 1 << nbits) ++nbits;
	if(nbits > 8 || len != 1 << nbits) {
		throw new js__$Boot_HaxeError("BaseCode : base length must be a power of two.");
	}
	this.base = base;
	this.nbits = nbits;
};
$hxClasses["haxe.crypto.BaseCode"] = haxe_crypto_BaseCode;
haxe_crypto_BaseCode.__name__ = ["haxe","crypto","BaseCode"];
haxe_crypto_BaseCode.prototype = {
	initTable: function() {
		var tbl = [];
		var _g = 0;
		while(_g < 256) tbl[_g++] = -1;
		var _g1 = 0;
		var _g2 = this.base.length;
		while(_g1 < _g2) {
			var i = _g1++;
			tbl[this.base.b[i]] = i;
		}
		this.tbl = tbl;
	}
	,decodeBytes: function(b) {
		var nbits = this.nbits;
		if(this.tbl == null) {
			this.initTable();
		}
		var tbl = this.tbl;
		var size = b.length * nbits >> 3;
		var out = new haxe_io_Bytes(new ArrayBuffer(size));
		var buf = 0;
		var curbits = 0;
		var pin = 0;
		var pout = 0;
		while(pout < size) {
			while(curbits < 8) {
				curbits += nbits;
				buf <<= nbits;
				var i = tbl[b.b[pin++]];
				if(i == -1) {
					throw new js__$Boot_HaxeError("BaseCode : invalid encoded char");
				}
				buf |= i;
			}
			curbits -= 8;
			out.b[pout++] = buf >> curbits & 255 & 255;
		}
		return out;
	}
	,__class__: haxe_crypto_BaseCode
};
var haxe_ds_BalancedTree = function() {
};
$hxClasses["haxe.ds.BalancedTree"] = haxe_ds_BalancedTree;
haxe_ds_BalancedTree.__name__ = ["haxe","ds","BalancedTree"];
haxe_ds_BalancedTree.prototype = {
	set: function(key,value) {
		this.root = this.setLoop(key,value,this.root);
	}
	,get: function(key) {
		var node = this.root;
		while(node != null) {
			var c = this.compare(key,node.key);
			if(c == 0) {
				return node.value;
			}
			if(c < 0) {
				node = node.left;
			} else {
				node = node.right;
			}
		}
		return null;
	}
	,setLoop: function(k,v,node) {
		if(node == null) {
			return new haxe_ds_TreeNode(null,k,v,null);
		}
		var c = this.compare(k,node.key);
		if(c == 0) {
			return new haxe_ds_TreeNode(node.left,k,v,node.right,node == null ? 0 : node._height);
		} else if(c < 0) {
			return this.balance(this.setLoop(k,v,node.left),node.key,node.value,node.right);
		} else {
			var nr = this.setLoop(k,v,node.right);
			return this.balance(node.left,node.key,node.value,nr);
		}
	}
	,balance: function(l,k,v,r) {
		var hl = l == null ? 0 : l._height;
		var hr = r == null ? 0 : r._height;
		if(hl > hr + 2) {
			var _this = l.left;
			var _this1 = l.right;
			if((_this == null ? 0 : _this._height) >= (_this1 == null ? 0 : _this1._height)) {
				return new haxe_ds_TreeNode(l.left,l.key,l.value,new haxe_ds_TreeNode(l.right,k,v,r));
			} else {
				return new haxe_ds_TreeNode(new haxe_ds_TreeNode(l.left,l.key,l.value,l.right.left),l.right.key,l.right.value,new haxe_ds_TreeNode(l.right.right,k,v,r));
			}
		} else if(hr > hl + 2) {
			var _this2 = r.right;
			var _this3 = r.left;
			if((_this2 == null ? 0 : _this2._height) > (_this3 == null ? 0 : _this3._height)) {
				return new haxe_ds_TreeNode(new haxe_ds_TreeNode(l,k,v,r.left),r.key,r.value,r.right);
			} else {
				return new haxe_ds_TreeNode(new haxe_ds_TreeNode(l,k,v,r.left.left),r.left.key,r.left.value,new haxe_ds_TreeNode(r.left.right,r.key,r.value,r.right));
			}
		} else {
			return new haxe_ds_TreeNode(l,k,v,r,(hl > hr ? hl : hr) + 1);
		}
	}
	,compare: function(k1,k2) {
		return Reflect.compare(k1,k2);
	}
	,__class__: haxe_ds_BalancedTree
};
var haxe_ds_TreeNode = function(l,k,v,r,h) {
	if(h == null) {
		h = -1;
	}
	this.left = l;
	this.key = k;
	this.value = v;
	this.right = r;
	if(h == -1) {
		var tmp;
		var _this = this.left;
		var _this1 = this.right;
		if((_this == null ? 0 : _this._height) > (_this1 == null ? 0 : _this1._height)) {
			var _this2 = this.left;
			if(_this2 == null) {
				tmp = 0;
			} else {
				tmp = _this2._height;
			}
		} else {
			var _this3 = this.right;
			if(_this3 == null) {
				tmp = 0;
			} else {
				tmp = _this3._height;
			}
		}
		this._height = tmp + 1;
	} else {
		this._height = h;
	}
};
$hxClasses["haxe.ds.TreeNode"] = haxe_ds_TreeNode;
haxe_ds_TreeNode.__name__ = ["haxe","ds","TreeNode"];
haxe_ds_TreeNode.prototype = {
	__class__: haxe_ds_TreeNode
};
var haxe_ds_Either = { __ename__ : true, __constructs__ : ["Left","Right"] };
haxe_ds_Either.Left = function(v) { var $x = ["Left",0,v]; $x.__enum__ = haxe_ds_Either; $x.toString = $estr; return $x; };
haxe_ds_Either.Right = function(v) { var $x = ["Right",1,v]; $x.__enum__ = haxe_ds_Either; $x.toString = $estr; return $x; };
var haxe_ds_EnumValueMap = function() {
	haxe_ds_BalancedTree.call(this);
};
$hxClasses["haxe.ds.EnumValueMap"] = haxe_ds_EnumValueMap;
haxe_ds_EnumValueMap.__name__ = ["haxe","ds","EnumValueMap"];
haxe_ds_EnumValueMap.__interfaces__ = [haxe_IMap];
haxe_ds_EnumValueMap.__super__ = haxe_ds_BalancedTree;
haxe_ds_EnumValueMap.prototype = $extend(haxe_ds_BalancedTree.prototype,{
	compare: function(k1,k2) {
		var d = k1[1] - k2[1];
		if(d != 0) {
			return d;
		}
		var p1 = k1.slice(2);
		var p2 = k2.slice(2);
		if(p1.length == 0 && p2.length == 0) {
			return 0;
		}
		return this.compareArgs(p1,p2);
	}
	,compareArgs: function(a1,a2) {
		var ld = a1.length - a2.length;
		if(ld != 0) {
			return ld;
		}
		var _g1 = 0;
		var _g = a1.length;
		while(_g1 < _g) {
			var i = _g1++;
			var d = this.compareArg(a1[i],a2[i]);
			if(d != 0) {
				return d;
			}
		}
		return 0;
	}
	,compareArg: function(v1,v2) {
		if(Reflect.isEnumValue(v1) && Reflect.isEnumValue(v2)) {
			return this.compare(v1,v2);
		} else if((v1 instanceof Array) && v1.__enum__ == null && ((v2 instanceof Array) && v2.__enum__ == null)) {
			return this.compareArgs(v1,v2);
		} else {
			return Reflect.compare(v1,v2);
		}
	}
	,__class__: haxe_ds_EnumValueMap
});
var haxe_ds_ObjectMap = function() {
	this.h = { __keys__ : { }};
};
$hxClasses["haxe.ds.ObjectMap"] = haxe_ds_ObjectMap;
haxe_ds_ObjectMap.__name__ = ["haxe","ds","ObjectMap"];
haxe_ds_ObjectMap.__interfaces__ = [haxe_IMap];
haxe_ds_ObjectMap.prototype = {
	set: function(key,value) {
		var id = key.__id__ || (key.__id__ = ++haxe_ds_ObjectMap.count);
		this.h[id] = value;
		this.h.__keys__[id] = key;
	}
	,keys: function() {
		var a = [];
		for( var key in this.h.__keys__ ) {
		if(this.h.hasOwnProperty(key)) {
			a.push(this.h.__keys__[key]);
		}
		}
		return HxOverrides.iter(a);
	}
	,iterator: function() {
		return { ref : this.h, it : this.keys(), hasNext : function() {
			return this.it.hasNext();
		}, next : function() {
			var i = this.it.next();
			return this.ref[i.__id__];
		}};
	}
	,__class__: haxe_ds_ObjectMap
};
var haxe_ds_StringMap = function() {
	this.h = { };
};
$hxClasses["haxe.ds.StringMap"] = haxe_ds_StringMap;
haxe_ds_StringMap.__name__ = ["haxe","ds","StringMap"];
haxe_ds_StringMap.__interfaces__ = [haxe_IMap];
haxe_ds_StringMap.prototype = {
	setReserved: function(key,value) {
		if(this.rh == null) {
			this.rh = { };
		}
		this.rh["$" + key] = value;
	}
	,getReserved: function(key) {
		if(this.rh == null) {
			return null;
		} else {
			return this.rh["$" + key];
		}
	}
	,existsReserved: function(key) {
		if(this.rh == null) {
			return false;
		}
		return this.rh.hasOwnProperty("$" + key);
	}
	,__class__: haxe_ds_StringMap
};
var haxe_io_Error = { __ename__ : true, __constructs__ : ["Blocked","Overflow","OutsideBounds","Custom"] };
haxe_io_Error.Blocked = ["Blocked",0];
haxe_io_Error.Blocked.toString = $estr;
haxe_io_Error.Blocked.__enum__ = haxe_io_Error;
haxe_io_Error.Overflow = ["Overflow",1];
haxe_io_Error.Overflow.toString = $estr;
haxe_io_Error.Overflow.__enum__ = haxe_io_Error;
haxe_io_Error.OutsideBounds = ["OutsideBounds",2];
haxe_io_Error.OutsideBounds.toString = $estr;
haxe_io_Error.OutsideBounds.__enum__ = haxe_io_Error;
haxe_io_Error.Custom = function(e) { var $x = ["Custom",3,e]; $x.__enum__ = haxe_io_Error; $x.toString = $estr; return $x; };
var haxe_io_FPHelper = function() { };
$hxClasses["haxe.io.FPHelper"] = haxe_io_FPHelper;
haxe_io_FPHelper.__name__ = ["haxe","io","FPHelper"];
haxe_io_FPHelper.i32ToFloat = function(i) {
	var exp = i >>> 23 & 255;
	var sig = i & 8388607;
	if(sig == 0 && exp == 0) {
		return 0.0;
	}
	return (1 - (i >>> 31 << 1)) * (1 + Math.pow(2,-23) * sig) * Math.pow(2,exp - 127);
};
haxe_io_FPHelper.floatToI32 = function(f) {
	if(f == 0) {
		return 0;
	}
	var af = f < 0 ? -f : f;
	var exp = Math.floor(Math.log(af) / 0.6931471805599453);
	if(exp < -127) {
		exp = -127;
	} else if(exp > 128) {
		exp = 128;
	}
	var sig = Math.round((af / Math.pow(2,exp) - 1) * 8388608);
	if(sig == 8388608 && exp < 128) {
		sig = 0;
		++exp;
	}
	return (f < 0 ? -2147483648 : 0) | exp + 127 << 23 | sig;
};
var henri19_Henri19 = function() {
	this.mixphase = 0;
	this.planets = [];
	wl_core_Part.call(this);
};
$hxClasses["henri19.Henri19"] = henri19_Henri19;
henri19_Henri19.__name__ = ["henri19","Henri19"];
henri19_Henri19.__super__ = wl_core_Part;
henri19_Henri19.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.camera.fov = 0.5;
		this.initSyncedPipeline(null);
		this.box = BABYLON.MeshBuilder.CreateBox("",{ width : 2600, height : 2600, depth : 2600, sideOrientation : BABYLON.Mesh.BACKSIDE},this.scene);
		new BABYLON.HemisphericLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		var pp = [];
		var ppl = [];
		var tpp = [];
		var trnd = new wl_util_Random(251525);
		var _g = 0;
		while(_g < 10) {
			var sphere = new henri19_Planet("palnet",this.scene,null,2);
			var tmp = wl_util_Random.nextFloat();
			sphere.position.x = tmp * 100;
			var tmp1 = wl_util_Random.nextFloat();
			sphere.position.y = tmp1 * 100;
			var tmp2 = wl_util_Random.nextFloat() * 100;
			sphere.position.z = tmp2 + _g++ * 150;
			ppl.push(sphere.position);
			pp.push(new BABYLON.Vector3(sphere.position.x + (wl_util_Random.nextFloat() - 0.5) * 80,sphere.position.y + (wl_util_Random.nextFloat() - 0.5) * 80,sphere.position.z - 75));
			tpp.push(new BABYLON.Vector3(sphere.position.x + (trnd.NextFloat() - 0.5) * 120,sphere.position.y + (trnd.NextFloat() - 0.5) * 120,sphere.position.z + 75));
			tpp.push(new BABYLON.Vector3(sphere.position.x + (trnd.NextFloat() - 0.5) * 120,sphere.position.y + (trnd.NextFloat() - 0.5) * 120,sphere.position.z + 75));
			tpp.push(new BABYLON.Vector3(sphere.position.x + (trnd.NextFloat() - 0.5) * 120,sphere.position.y + (trnd.NextFloat() - 0.5) * 120,sphere.position.z + 75));
			tpp.push(new BABYLON.Vector3(sphere.position.x + (trnd.NextFloat() - 0.5) * 120,sphere.position.y + (trnd.NextFloat() - 0.5) * 120,sphere.position.z + 75));
			sphere.cloudColor = new BABYLON.Vector3(wl_util_Random.nextFloat(),wl_util_Random.nextFloat(),wl_util_Random.nextFloat());
			var tmp3 = wl_util_Random.nextFloat() * 60;
			sphere.scaling.x = sphere.scaling.y = sphere.scaling.z = tmp3 + 10;
			this.planets.push(sphere);
		}
		HxOverrides.remove(tpp,tpp[tpp.length - 2]);
		this.space = new henri19_SpaceSphere("space henri19",this.scene);
		this.mixfilter = new wl_post_texturemix_TextureMix(this.camera,this.scene.getEngine());
		this.camera.attachPostProcess(this.mixfilter);
		this.cc = new wl_demo_CameraController(this.camera);
		this.cc.initBezier(pp,ppl);
		this.trailEmitter = BABYLON.MeshBuilder.CreateBox("",{ width : 1, height : 1, depth : 1},this.scene);
		this.trailController = new wl_demo_TransformNodeController(this.trailEmitter);
		this.trailController.initBezier(tpp,tpp);
		this.trailLight = new BABYLON.PointLight("trail light",new BABYLON.Vector3(0,0,0),this.scene);
		this.trailLight.parent = this.trailEmitter;
		this.trailEmitter.visibility = 0;
		var trail = new BABYLON.TrailMesh("new",this.trailEmitter,this.scene,1.5,600,true);
		var trailmat = new BABYLON.StandardMaterial("trailmat",this.scene);
		trailmat.emissiveColor = BABYLON.Color3.White();
		trailmat.diffuseColor = BABYLON.Color3.White();
		trailmat.specularColor = BABYLON.Color3.White();
		trail.material = trailmat;
		var gl = new BABYLON.GlowLayer("glow",this.scene,{ mainTextureSamples : 4});
		gl.isEnabled = true;
		gl.intensity = 0.3;
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.onsecondbar));
	}
	,onsecondbar: function(ts) {
	}
	,postInit: function() {
		wl_core_Part.prototype.postInit.call(this);
		this.mixfilter.set_mixTo(wl_core_Demo.instance.getPart("intro.Intro2"));
	}
	,update: function(ts,partial,frameTime,delta) {
		this.mixfilter.phase = Math.sin(ts.toMilliseconds() / wl_core_TimeSig.milliseconds(2,0,0,0)) * 0.3 + 0.9;
		if(ts.bar >= 21) {
			this.mixfilter.phase = Math.max(this.mixfilter.phase,(ts.toMilliseconds() - wl_core_TimeSig.milliseconds(23,0,0,0)) / wl_core_TimeSig.milliseconds(1,0,0,0) * 4);
		}
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		this.cc.update(ts.toMilliseconds() / wl_core_TimeSig.milliseconds(32,0,0,0));
		this.trailController.update(ts.toMilliseconds() / wl_core_TimeSig.milliseconds(32,0,0,0));
		this.space.mesh.position.copyFrom(this.camera.position);
		this.box.position.copyFrom(this.camera.position);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: henri19_Henri19
});
var henri19_Planet = function(name,scene,isPure,radius) {
	this.cloudColor = new BABYLON.Vector3(1,1,1);
	this.time = 0;
	var _gthis = this;
	BABYLON.TransformNode.call(this,name,scene,isPure);
	this.mesh = BABYLON.MeshBuilder.CreateSphere(name + "Mesh",{ segments : 42},scene);
	if(henri19_Planet.noiseMap != null) {
		henri19_Planet.noiseMap = wl_core_Assets.getTexture("perlin-2048.png");
	}
	this.customMaterial = new BABYLON.CustomMaterial(name + "Material",scene);
	this.customMaterial.AddUniform("noiseMap","sampler2D");
	this.customMaterial.AddUniform("time","float");
	this.customMaterial.AddUniform("cloudColor","vec3");
	this.customMaterial.Fragment_Before_FragColor(haxe_Resource.getString("planetmateria.frag"));
	var tmp = wl_util_Random.nextFloat() < 0.5 ? wl_core_Assets.getTexture("perlin-2048.png") : wl_core_Assets.getTexture("plasma_seamless.jpg");
	this.customMaterial.diffuseTexture = tmp;
	this.customMaterial.specularColor = new BABYLON.Color3(0,0,0);
	var tmp1 = wl_util_Random.nextFloat();
	var tmp2 = wl_util_Random.nextFloat();
	var tmp3 = wl_util_Random.nextFloat();
	this.customMaterial.diffuseColor = new BABYLON.Color3(tmp1,tmp2,tmp3);
	var tmp4 = wl_util_Random.nextFloat();
	var tmp5 = wl_util_Random.nextFloat();
	var tmp6 = wl_util_Random.nextFloat();
	this.customMaterial.emissiveColor = new BABYLON.Color3(tmp4,tmp5,tmp6).scale(0.0);
	this.customMaterial.onBindObservable.add(function(ab,es) {
		_gthis.customMaterial.getEffect().setTexture("noiseMap",henri19_Planet.noiseMap);
		_gthis.customMaterial.getEffect().setFloat("time",_gthis.time);
		_gthis.customMaterial.getEffect().setVector3("cloudColor",_gthis.cloudColor);
	});
	this.mesh.material = this.customMaterial;
	this.mesh.parent = this;
	wl_core_Demo.instance.onUpdate.connect(function(ts) {
		var tmp7 = ts.toMilliseconds();
		var tmp8 = wl_core_TimeSig.milliseconds(2,0,0,0);
		_gthis.time = tmp7 / tmp8;
	});
};
$hxClasses["henri19.Planet"] = henri19_Planet;
henri19_Planet.__name__ = ["henri19","Planet"];
henri19_Planet.__super__ = BABYLON.TransformNode;
henri19_Planet.prototype = $extend(BABYLON.TransformNode.prototype,{
	__class__: henri19_Planet
});
var henri19_SpaceSphere = function(name,scene,isPure) {
	BABYLON.TransformNode.call(this,name,scene,isPure);
	this.mesh = BABYLON.MeshBuilder.CreateSphere("spacesphere",{ },scene);
	this.mesh.scaling.set(2000,2000,2000);
	BABYLON.Effect.ShadersStore["spaceFragmentShader"] = haxe_Resource.getString("space.frag");
	BABYLON.Effect.ShadersStore["spaceVertexShader"] = haxe_Resource.getString("space.vert");
	this.sm = new BABYLON.ShaderMaterial("spaceShader",scene,{ vertex : "space", fragment : "space"},{ attributes : ["position","normal","uv"], uniforms : ["world","worldView","worldViewProjection","view","projection"]});
	this.sm.setTexture("perlin",wl_core_Assets.getTexture("perlin-2048.png",true));
	this.sm.setTexture("noise",wl_core_Assets.getTexture("stars.png",true));
	this.mesh.material = this.sm;
	this.sm.sideOrientation = 0;
};
$hxClasses["henri19.SpaceSphere"] = henri19_SpaceSphere;
henri19_SpaceSphere.__name__ = ["henri19","SpaceSphere"];
henri19_SpaceSphere.__super__ = BABYLON.TransformNode;
henri19_SpaceSphere.prototype = $extend(BABYLON.TransformNode.prototype,{
	__class__: henri19_SpaceSphere
});
var wl_core_ShaderBase = function() {
	this.staticDone = false;
	this._defaultAttributes = ["position","normal","uv","world0","world1","world2","world3"];
	this._defaultUniforms = ["world","viewProjection"];
	console.log("init simple shader: " + Std.string(this.staticDone));
	if(!this.staticDone) {
		console.log("init simple shader");
		BABYLON.Effect.ShadersStore["simpleVertexShader"] = haxe_Resource.getString("simple.vert");
		this.staticDone = true;
	}
};
$hxClasses["wl.core.ShaderBase"] = wl_core_ShaderBase;
wl_core_ShaderBase.__name__ = ["wl","core","ShaderBase"];
wl_core_ShaderBase.prototype = {
	UseDefaultAttributes: function(customAttributes) {
		if(customAttributes != null) {
			return this._defaultAttributes.concat(customAttributes);
		} else {
			return this._defaultAttributes;
		}
	}
	,UseDefaultUniforms: function(customUniforms) {
		if(customUniforms != null) {
			return this._defaultUniforms.concat(customUniforms);
		} else {
			return this._defaultUniforms;
		}
	}
	,__class__: wl_core_ShaderBase
};
var henritesti_HenriShader = function() {
	this.uniforms = ["time"];
	this.color = new BABYLON.Color4(1,1,1,1);
	wl_core_ShaderBase.call(this);
	BABYLON.Effect.ShadersStore["henriPixelShader"] = haxe_Resource.getString("henrishader.frag");
};
$hxClasses["henritesti.HenriShader"] = henritesti_HenriShader;
henritesti_HenriShader.__name__ = ["henritesti","HenriShader"];
henritesti_HenriShader.__super__ = wl_core_ShaderBase;
henritesti_HenriShader.prototype = $extend(wl_core_ShaderBase.prototype,{
	update: function(ts) {
	}
	,__class__: henritesti_HenriShader
});
var henritesti_HenriTesti = function() {
	wl_core_Part.call(this);
};
$hxClasses["henritesti.HenriTesti"] = henritesti_HenriTesti;
henritesti_HenriTesti.__name__ = ["henritesti","HenriTesti"];
henritesti_HenriTesti.__super__ = wl_core_Part;
henritesti_HenriTesti.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var sphere = BABYLON.MeshBuilder.CreateSphere("sphere1",{ segments : 16, diameter : 1},this.scene);
		var light = new BABYLON.PointLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		light.position.y = 1;
		light.shadowEnabled = true;
		light.intensity = 0.5;
		light.shadowMinZ = 0.05;
		light.shadowMaxZ = 200;
		light.diffuse = DemoMain.HILIGHT.clone();
		var room = BABYLON.MeshBuilder.CreateBox("",{ width : 100, height : 100, depth : 100, sideOrientation : BABYLON.Mesh.BACKSIDE},this.scene);
		room.receiveShadows = true;
		var roomMat = new BABYLON.StandardMaterial("",this.scene);
		roomMat.diffuseColor = DemoMain.LIGHT.clone();
		roomMat.ambientColor = DemoMain.LIGHT.clone();
		room.material = roomMat;
		sphere.position.y = 1;
		this.scene.ambientColor = new BABYLON.Color3(0.1,0.1,0.1);
		new BABYLON.ShadowGenerator(512,light).addShadowCaster(sphere);
		this.testshader = new henritesti_HenriShader();
		this.customProc = new BABYLON.CustomProceduralTexture("henri","henri",2048,this.scene);
		this.customProc.setFloat("t",0);
		this.customProc.refreshRate = 10;
		this.customProc.hasAlpha = true;
		var mat = new BABYLON.StandardMaterial("",this.scene);
		mat.diffuseTexture = this.customProc;
		mat.diffuseTexture.hasAlpha = true;
		mat.backFaceCulling = false;
		sphere.material = mat;
		var rpProp = { };
		rpProp.bloom = true;
		rpProp.chromaticAberration = true;
		rpProp.distort = false;
		rpProp.dof = true;
		rpProp.grain = true;
		rpProp.imageProcessing = true;
		rpProp.sharpen = false;
		rpProp.fxaa = true;
		this.initPipeline(rpProp);
		this.post.grain.intensity = 10;
		this.post.grain.animated = true;
		this.post.bloom.bloomThreshold = 0.9;
		this.post.bloom.bloomScale = 1;
		this.post.chromaticAberration.aberrationAmount = 1;
		this.post.dof.focalLength = 80;
		this.post.dof.focusDistance = 4000;
	}
	,update: function(ts,partial,frameTime,delta) {
		this.customProc.setFloat("t",ts.toMilliseconds() / 5200);
		this.customProc.render();
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: henritesti_HenriTesti
});
var intro_Intro = function() {
	wl_core_Part.call(this);
};
$hxClasses["intro.Intro"] = intro_Intro;
intro_Intro.__name__ = ["intro","Intro"];
intro_Intro.__super__ = wl_core_Part;
intro_Intro.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initSyncedPipeline(null);
		this.box = BABYLON.MeshBuilder.CreateBox("",{ width : 2600, height : 2600, depth : 2600, sideOrientation : BABYLON.Mesh.BACKSIDE},this.scene);
		this.shooter = new BABYLON.TransformNode("",this.scene);
		this.shooter.setPivotPoint(new BABYLON.Vector3(0,0,45));
		var tube = wl_util_ExtendedMeshBuilder.CreateTube("",{ height : 40, diameter : 10, wallThickness : 3, tessellation : 32});
		tube.rotate(BABYLON.Vector3.Right(),Math.PI / 180 * 90);
		tube.position.z = 55;
		var itube = wl_util_ExtendedMeshBuilder.CreateTube("",{ height : 0.2, diameter : 9.5, wallThickness : 5, tessellation : 32});
		itube.rotate(BABYLON.Vector3.Right(),Math.PI / 180 * 90);
		itube.position.z = 45;
		var itubeMaterial = new BABYLON.StandardMaterial("innertubemat",this.scene);
		itube.material = itubeMaterial;
		itubeMaterial.diffuseColor = new BABYLON.Color3(0.4,0.2,0.1);
		itubeMaterial.emissiveColor = new BABYLON.Color3(0.6,0.3,0.1);
		var pl = new BABYLON.PointLight("pointlight",new BABYLON.Vector3(0,0,45),this.scene);
		pl.diffuse = new BABYLON.Color3(0.3,0.15,0.2);
		pl.position.z = 31;
		pl.intensity = 0.3;
		pl.parent = this.shooter;
		this.beam = BABYLON.MeshBuilder.CreateCylinder("",{ diameter : 0.15, height : 200},this.scene);
		this.beam.parent = this.shooter;
		var beamMat = new BABYLON.StandardMaterial("",this.scene);
		beamMat.emissiveColor = new BABYLON.Color3(1,1,1);
		this.beam.material = beamMat;
		this.beam.rotate(BABYLON.Vector3.Right(),Math.PI / 180 * 90);
		var gl = new BABYLON.GlowLayer("glow",this.scene,{ mainTextureSamples : 2});
		gl.isEnabled = true;
		gl.intensity = 1;
		var spaceSphere = new henri19_SpaceSphere("",this.scene);
		this.emitter = BABYLON.MeshBuilder.CreateBox("",{ size : 1},this.scene);
		this.emitter.position.z = 29;
		this.emitter.visibility = 0.0;
		this.emitter.parent = this.shooter;
		this.tubeParticles = new BABYLON.ParticleSystem("particles",10000,this.scene);
		this.tubeParticles.particleEmitterType = new BABYLON.SphereParticleEmitter(2);
		this.tubeParticles.particleTexture = wl_core_Assets.getTexture("particleTexture.png");
		this.tubeParticles.color1 = BABYLON.Color3.FromHexString("#FF8F1F").toColor4(0.5);
		this.tubeParticles.color2 = BABYLON.Color3.FromHexString("#FF6F2F").toColor4(0.5);
		this.tubeParticles.maxLifeTime = 9;
		this.tubeParticles.minSize = .01;
		this.tubeParticles.maxSize = .3;
		this.tubeParticles.emitter = this.emitter;
		this.tubeParticles.preWarmCycles = 100;
		this.tubeParticles.preWarmStepOffset = 5;
		this.tubeParticles.emitRate = 1000;
		this.tubeParticles.maxEmitPower = 1;
		this.tubeParticles.start();
		this.camera.minZ = 0.01;
		this.camera.position.x = 1.127;
		this.camera.position.y = 0.155;
		this.camera.position.z = -11.345;
		this.camera.setTarget(BABYLON.Vector3.Zero());
		this.post.imageProcessing.exposure = 0;
		this.exposureTarget = -4;
		this.rndCC = new wl_demo_RandomCameraController(this.camera,1,[this.emitter],12456351,[wl_demo_CameraController.BEZIER],[3,10],new BABYLON.BoundingBox(new BABYLON.Vector3(30,0,0),new BABYLON.Vector3(100,100,100)));
	}
	,start: function(ts) {
		createjs.Tween.get(this).to({ exposureTarget : 0},wl_core_TimeSig.milliseconds(4,0,0,0));
		createjs.Tween.get(this.post.distort).wait(wl_core_TimeSig.milliseconds(7,0,0,0)).to({ brightness : 2},wl_core_TimeSig.milliseconds(1,0,0,0),createjs.Ease.quadIn);
		createjs.Tween.get(this.shooter.rotation).wait(wl_core_TimeSig.milliseconds(4,0,0,0)).to({ y : -0.02, x : 0.002},wl_core_TimeSig.milliseconds(4,0,0,0),createjs.Ease.quadIn);
		wl_core_Part.prototype.start.call(this,ts);
		if(ts.bar >= 8) {
			this.beam.visibility = 0;
			this.camera.fov = 0.1;
			this.rndCC.start();
		}
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		if(ts.bar >= 8) {
			this.exposureTarget = 1.5;
			this.camera.fov = 0.2;
			this.rndCC.updateLength(wl_core_TimeSig.milliseconds(24,0,0,0));
		}
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,true);
	}
	,setupPostprocessing: function() {
		var plConf = { };
		plConf.dof = true;
		plConf.bloom = true;
		plConf.chromaticAberration = true;
		plConf.imageProcessing = true;
		plConf.grain = true;
		plConf.fxaa = true;
		plConf.sharpen = true;
		plConf.distort = true;
		this.initPipeline(plConf);
		this.post.dof.focalLength = 36;
		this.post.dof.focusDistance = 2300;
		this.post.dof.fStop = 1.5;
		this.post.dof.lensSize = 67;
		this.post.chromaticAberration.aberrationAmount = 5;
		this.post.imageProcessing.exposure = 2;
		this.post.imageProcessing.toneMappingEnabled = false;
		this.post.imageProcessing.vignetteEnabled = false;
		this.post.grain.animated = true;
		this.post.grain.intensity = 15;
	}
	,__class__: intro_Intro
});
var js__$Boot_HaxeError = function(val) {
	Error.call(this);
	this.val = val;
	this.message = String(val);
	if(Error.captureStackTrace) {
		Error.captureStackTrace(this,js__$Boot_HaxeError);
	}
};
$hxClasses["js._Boot.HaxeError"] = js__$Boot_HaxeError;
js__$Boot_HaxeError.__name__ = ["js","_Boot","HaxeError"];
js__$Boot_HaxeError.wrap = function(val) {
	if((val instanceof Error)) {
		return val;
	} else {
		return new js__$Boot_HaxeError(val);
	}
};
js__$Boot_HaxeError.__super__ = Error;
js__$Boot_HaxeError.prototype = $extend(Error.prototype,{
	__class__: js__$Boot_HaxeError
});
var js_Boot = function() { };
$hxClasses["js.Boot"] = js_Boot;
js_Boot.__name__ = ["js","Boot"];
js_Boot.getClass = function(o) {
	if((o instanceof Array) && o.__enum__ == null) {
		return Array;
	} else {
		var cl = o.__class__;
		if(cl != null) {
			return cl;
		}
		var name = js_Boot.__nativeClassName(o);
		if(name != null) {
			return js_Boot.__resolveNativeClass(name);
		}
		return null;
	}
};
js_Boot.__string_rec = function(o,s) {
	if(o == null) {
		return "null";
	}
	if(s.length >= 5) {
		return "<...>";
	}
	var t = typeof(o);
	if(t == "function" && (o.__name__ || o.__ename__)) {
		t = "object";
	}
	switch(t) {
	case "function":
		return "<function>";
	case "object":
		if(o instanceof Array) {
			if(o.__enum__) {
				if(o.length == 2) {
					return o[0];
				}
				var str = o[0] + "(";
				s += "\t";
				var _g1 = 2;
				var _g = o.length;
				while(_g1 < _g) {
					var i = _g1++;
					if(i != 2) {
						str += "," + js_Boot.__string_rec(o[i],s);
					} else {
						str += js_Boot.__string_rec(o[i],s);
					}
				}
				return str + ")";
			}
			var l = o.length;
			var i1;
			var str1 = "[";
			s += "\t";
			var _g11 = 0;
			var _g2 = l;
			while(_g11 < _g2) {
				var i2 = _g11++;
				str1 += (i2 > 0 ? "," : "") + js_Boot.__string_rec(o[i2],s);
			}
			str1 += "]";
			return str1;
		}
		var tostr;
		try {
			tostr = o.toString;
		} catch( e ) {
			return "???";
		}
		if(tostr != null && tostr != Object.toString && typeof(tostr) == "function") {
			var s2 = o.toString();
			if(s2 != "[object Object]") {
				return s2;
			}
		}
		var k = null;
		var str2 = "{\n";
		s += "\t";
		var hasp = o.hasOwnProperty != null;
		for( var k in o ) {
		if(hasp && !o.hasOwnProperty(k)) {
			continue;
		}
		if(k == "prototype" || k == "__class__" || k == "__super__" || k == "__interfaces__" || k == "__properties__") {
			continue;
		}
		if(str2.length != 2) {
			str2 += ", \n";
		}
		str2 += s + k + " : " + js_Boot.__string_rec(o[k],s);
		}
		s = s.substring(1);
		str2 += "\n" + s + "}";
		return str2;
	case "string":
		return o;
	default:
		return String(o);
	}
};
js_Boot.__interfLoop = function(cc,cl) {
	if(cc == null) {
		return false;
	}
	if(cc == cl) {
		return true;
	}
	var intf = cc.__interfaces__;
	if(intf != null) {
		var _g1 = 0;
		var _g = intf.length;
		while(_g1 < _g) {
			var i = intf[_g1++];
			if(i == cl || js_Boot.__interfLoop(i,cl)) {
				return true;
			}
		}
	}
	return js_Boot.__interfLoop(cc.__super__,cl);
};
js_Boot.__instanceof = function(o,cl) {
	if(cl == null) {
		return false;
	}
	switch(cl) {
	case Array:
		if((o instanceof Array)) {
			return o.__enum__ == null;
		} else {
			return false;
		}
		break;
	case Bool:
		return typeof(o) == "boolean";
	case Dynamic:
		return true;
	case Float:
		return typeof(o) == "number";
	case Int:
		if(typeof(o) == "number") {
			return (o|0) === o;
		} else {
			return false;
		}
		break;
	case String:
		return typeof(o) == "string";
	default:
		if(o != null) {
			if(typeof(cl) == "function") {
				if(o instanceof cl) {
					return true;
				}
				if(js_Boot.__interfLoop(js_Boot.getClass(o),cl)) {
					return true;
				}
			} else if(typeof(cl) == "object" && js_Boot.__isNativeObj(cl)) {
				if(o instanceof cl) {
					return true;
				}
			}
		} else {
			return false;
		}
		if(cl == Class ? o.__name__ != null : false) {
			return true;
		}
		if(cl == Enum ? o.__ename__ != null : false) {
			return true;
		}
		return o.__enum__ == cl;
	}
};
js_Boot.__nativeClassName = function(o) {
	var name = js_Boot.__toStr.call(o).slice(8,-1);
	if(name == "Object" || name == "Function" || name == "Math" || name == "JSON") {
		return null;
	}
	return name;
};
js_Boot.__isNativeObj = function(o) {
	return js_Boot.__nativeClassName(o) != null;
};
js_Boot.__resolveNativeClass = function(name) {
	return $global[name];
};
var js_babylon_Promise = function() { };
$hxClasses["js.babylon.Promise"] = js_babylon_Promise;
js_babylon_Promise.__name__ = ["js","babylon","Promise"];
var js_babylon_ReadonlyArray = function() { };
$hxClasses["js.babylon.ReadonlyArray"] = js_babylon_ReadonlyArray;
js_babylon_ReadonlyArray.__name__ = ["js","babylon","ReadonlyArray"];
var js_babylon_Partial = function() { };
$hxClasses["js.babylon.Partial"] = js_babylon_Partial;
js_babylon_Partial.__name__ = ["js","babylon","Partial"];
var js_babylon_PromiseLike = function() { };
$hxClasses["js.babylon.PromiseLike"] = js_babylon_PromiseLike;
js_babylon_PromiseLike.__name__ = ["js","babylon","PromiseLike"];
var js_babylon_ArrayLike = function() { };
$hxClasses["js.babylon.ArrayLike"] = js_babylon_ArrayLike;
js_babylon_ArrayLike.__name__ = ["js","babylon","ArrayLike"];
var js_babylon_GamepadButton = function() { };
$hxClasses["js.babylon.GamepadButton"] = js_babylon_GamepadButton;
js_babylon_GamepadButton.__name__ = ["js","babylon","GamepadButton"];
var BABYLON_Window = function() { };
$hxClasses["BABYLON.Window"] = BABYLON_Window;
BABYLON_Window.__name__ = ["BABYLON","Window"];
BABYLON_Window.prototype = {
	__class__: BABYLON_Window
};
var BABYLON_WebGLRenderingContext = function() { };
$hxClasses["BABYLON.WebGLRenderingContext"] = BABYLON_WebGLRenderingContext;
BABYLON_WebGLRenderingContext.__name__ = ["BABYLON","WebGLRenderingContext"];
BABYLON_WebGLRenderingContext.prototype = {
	__class__: BABYLON_WebGLRenderingContext
};
var BABYLON_Document = function() { };
$hxClasses["BABYLON.Document"] = BABYLON_Document;
BABYLON_Document.__name__ = ["BABYLON","Document"];
BABYLON_Document.prototype = {
	__class__: BABYLON_Document
};
var BABYLON_HTMLCanvasElement = function() { };
$hxClasses["BABYLON.HTMLCanvasElement"] = BABYLON_HTMLCanvasElement;
BABYLON_HTMLCanvasElement.__name__ = ["BABYLON","HTMLCanvasElement"];
BABYLON_HTMLCanvasElement.prototype = {
	__class__: BABYLON_HTMLCanvasElement
};
var BABYLON_CanvasRenderingContext2D = function() { };
$hxClasses["BABYLON.CanvasRenderingContext2D"] = BABYLON_CanvasRenderingContext2D;
BABYLON_CanvasRenderingContext2D.__name__ = ["BABYLON","CanvasRenderingContext2D"];
BABYLON_CanvasRenderingContext2D.prototype = {
	__class__: BABYLON_CanvasRenderingContext2D
};
var BABYLON_WebGLBuffer = function() { };
$hxClasses["BABYLON.WebGLBuffer"] = BABYLON_WebGLBuffer;
BABYLON_WebGLBuffer.__name__ = ["BABYLON","WebGLBuffer"];
BABYLON_WebGLBuffer.prototype = {
	__class__: BABYLON_WebGLBuffer
};
var BABYLON_WebGLProgram = function() { };
$hxClasses["BABYLON.WebGLProgram"] = BABYLON_WebGLProgram;
BABYLON_WebGLProgram.__name__ = ["BABYLON","WebGLProgram"];
BABYLON_WebGLProgram.prototype = {
	__class__: BABYLON_WebGLProgram
};
var BABYLON_MouseEvent = function() { };
$hxClasses["BABYLON.MouseEvent"] = BABYLON_MouseEvent;
BABYLON_MouseEvent.__name__ = ["BABYLON","MouseEvent"];
BABYLON_MouseEvent.prototype = {
	__class__: BABYLON_MouseEvent
};
var BABYLON_Navigator = function() { };
$hxClasses["BABYLON.Navigator"] = BABYLON_Navigator;
BABYLON_Navigator.__name__ = ["BABYLON","Navigator"];
BABYLON_Navigator.prototype = {
	__class__: BABYLON_Navigator
};
var BABYLON_HTMLVideoElement = function() { };
$hxClasses["BABYLON.HTMLVideoElement"] = BABYLON_HTMLVideoElement;
BABYLON_HTMLVideoElement.__name__ = ["BABYLON","HTMLVideoElement"];
BABYLON_HTMLVideoElement.prototype = {
	__class__: BABYLON_HTMLVideoElement
};
var BABYLON_Screen = function() { };
$hxClasses["BABYLON.Screen"] = BABYLON_Screen;
BABYLON_Screen.__name__ = ["BABYLON","Screen"];
BABYLON_Screen.prototype = {
	__class__: BABYLON_Screen
};
var BABYLON_EXT_$disjoint_$timer_$query = function() { };
$hxClasses["BABYLON.EXT_disjoint_timer_query"] = BABYLON_EXT_$disjoint_$timer_$query;
BABYLON_EXT_$disjoint_$timer_$query.__name__ = ["BABYLON","EXT_disjoint_timer_query"];
BABYLON_EXT_$disjoint_$timer_$query.prototype = {
	__class__: BABYLON_EXT_$disjoint_$timer_$query
};
var BABYLON_WebGLUniformLocation = function() { };
$hxClasses["BABYLON.WebGLUniformLocation"] = BABYLON_WebGLUniformLocation;
BABYLON_WebGLUniformLocation.__name__ = ["BABYLON","WebGLUniformLocation"];
BABYLON_WebGLUniformLocation.prototype = {
	__class__: BABYLON_WebGLUniformLocation
};
var BABYLON_IDisposable = function() { };
$hxClasses["BABYLON.IDisposable"] = BABYLON_IDisposable;
BABYLON_IDisposable.__name__ = ["BABYLON","IDisposable"];
BABYLON_IDisposable.prototype = {
	__class__: BABYLON_IDisposable
};
var BABYLON_IActiveMeshCandidateProvider = function() { };
$hxClasses["BABYLON.IActiveMeshCandidateProvider"] = BABYLON_IActiveMeshCandidateProvider;
BABYLON_IActiveMeshCandidateProvider.__name__ = ["BABYLON","IActiveMeshCandidateProvider"];
BABYLON_IActiveMeshCandidateProvider.prototype = {
	__class__: BABYLON_IActiveMeshCandidateProvider
};
var BABYLON_IAnimatable = function() { };
$hxClasses["BABYLON.IAnimatable"] = BABYLON_IAnimatable;
BABYLON_IAnimatable.__name__ = ["BABYLON","IAnimatable"];
BABYLON_IAnimatable.prototype = {
	__class__: BABYLON_IAnimatable
};
var BABYLON_ISceneComponent = function() { };
$hxClasses["BABYLON.ISceneComponent"] = BABYLON_ISceneComponent;
BABYLON_ISceneComponent.__name__ = ["BABYLON","ISceneComponent"];
BABYLON_ISceneComponent.prototype = {
	__class__: BABYLON_ISceneComponent
};
var BABYLON_ISceneSerializableComponent = function() { };
$hxClasses["BABYLON.ISceneSerializableComponent"] = BABYLON_ISceneSerializableComponent;
BABYLON_ISceneSerializableComponent.__name__ = ["BABYLON","ISceneSerializableComponent"];
BABYLON_ISceneSerializableComponent.__interfaces__ = [BABYLON_ISceneComponent];
BABYLON_ISceneSerializableComponent.prototype = {
	__class__: BABYLON_ISceneSerializableComponent
};
var BABYLON_IAnimationKey = function() { };
$hxClasses["BABYLON.IAnimationKey"] = BABYLON_IAnimationKey;
BABYLON_IAnimationKey.__name__ = ["BABYLON","IAnimationKey"];
BABYLON_IAnimationKey.prototype = {
	__class__: BABYLON_IAnimationKey
};
var BABYLON_IEasingFunction = function() { };
$hxClasses["BABYLON.IEasingFunction"] = BABYLON_IEasingFunction;
BABYLON_IEasingFunction.__name__ = ["BABYLON","IEasingFunction"];
BABYLON_IEasingFunction.prototype = {
	__class__: BABYLON_IEasingFunction
};
var BABYLON_Behavior = function() { };
$hxClasses["BABYLON.Behavior"] = BABYLON_Behavior;
BABYLON_Behavior.__name__ = ["BABYLON","Behavior"];
BABYLON_Behavior.prototype = {
	__class__: BABYLON_Behavior
};
var BABYLON_ICollisionCoordinator = function() { };
$hxClasses["BABYLON.ICollisionCoordinator"] = BABYLON_ICollisionCoordinator;
BABYLON_ICollisionCoordinator.__name__ = ["BABYLON","ICollisionCoordinator"];
BABYLON_ICollisionCoordinator.prototype = {
	__class__: BABYLON_ICollisionCoordinator
};
var BABYLON_SerializedMesh = function() { };
$hxClasses["BABYLON.SerializedMesh"] = BABYLON_SerializedMesh;
BABYLON_SerializedMesh.__name__ = ["BABYLON","SerializedMesh"];
BABYLON_SerializedMesh.prototype = {
	__class__: BABYLON_SerializedMesh
};
var BABYLON_SerializedSubMesh = function() { };
$hxClasses["BABYLON.SerializedSubMesh"] = BABYLON_SerializedSubMesh;
BABYLON_SerializedSubMesh.__name__ = ["BABYLON","SerializedSubMesh"];
BABYLON_SerializedSubMesh.prototype = {
	__class__: BABYLON_SerializedSubMesh
};
var BABYLON_SerializedGeometry = function() { };
$hxClasses["BABYLON.SerializedGeometry"] = BABYLON_SerializedGeometry;
BABYLON_SerializedGeometry.__name__ = ["BABYLON","SerializedGeometry"];
BABYLON_SerializedGeometry.prototype = {
	__class__: BABYLON_SerializedGeometry
};
var BABYLON_BabylonMessage = function() { };
$hxClasses["BABYLON.BabylonMessage"] = BABYLON_BabylonMessage;
BABYLON_BabylonMessage.__name__ = ["BABYLON","BabylonMessage"];
BABYLON_BabylonMessage.prototype = {
	__class__: BABYLON_BabylonMessage
};
var BABYLON_SerializedColliderToWorker = function() { };
$hxClasses["BABYLON.SerializedColliderToWorker"] = BABYLON_SerializedColliderToWorker;
BABYLON_SerializedColliderToWorker.__name__ = ["BABYLON","SerializedColliderToWorker"];
BABYLON_SerializedColliderToWorker.prototype = {
	__class__: BABYLON_SerializedColliderToWorker
};
var BABYLON_WorkerReply = function() { };
$hxClasses["BABYLON.WorkerReply"] = BABYLON_WorkerReply;
BABYLON_WorkerReply.__name__ = ["BABYLON","WorkerReply"];
BABYLON_WorkerReply.prototype = {
	__class__: BABYLON_WorkerReply
};
var BABYLON_CollisionReplyPayload = function() { };
$hxClasses["BABYLON.CollisionReplyPayload"] = BABYLON_CollisionReplyPayload;
BABYLON_CollisionReplyPayload.__name__ = ["BABYLON","CollisionReplyPayload"];
BABYLON_CollisionReplyPayload.prototype = {
	__class__: BABYLON_CollisionReplyPayload
};
var BABYLON_InitPayload = function() { };
$hxClasses["BABYLON.InitPayload"] = BABYLON_InitPayload;
BABYLON_InitPayload.__name__ = ["BABYLON","InitPayload"];
var BABYLON_CollidePayload = function() { };
$hxClasses["BABYLON.CollidePayload"] = BABYLON_CollidePayload;
BABYLON_CollidePayload.__name__ = ["BABYLON","CollidePayload"];
BABYLON_CollidePayload.prototype = {
	__class__: BABYLON_CollidePayload
};
var BABYLON_UpdatePayload = function() { };
$hxClasses["BABYLON.UpdatePayload"] = BABYLON_UpdatePayload;
BABYLON_UpdatePayload.__name__ = ["BABYLON","UpdatePayload"];
BABYLON_UpdatePayload.prototype = {
	__class__: BABYLON_UpdatePayload
};
var BABYLON_ICollisionDetector = function() { };
$hxClasses["BABYLON.ICollisionDetector"] = BABYLON_ICollisionDetector;
BABYLON_ICollisionDetector.__name__ = ["BABYLON","ICollisionDetector"];
BABYLON_ICollisionDetector.prototype = {
	__class__: BABYLON_ICollisionDetector
};
var BABYLON_ICameraInput = function() { };
$hxClasses["BABYLON.ICameraInput"] = BABYLON_ICameraInput;
BABYLON_ICameraInput.__name__ = ["BABYLON","ICameraInput"];
BABYLON_ICameraInput.prototype = {
	__class__: BABYLON_ICameraInput
};
var BABYLON_CameraInputsMap = function() { };
$hxClasses["BABYLON.CameraInputsMap"] = BABYLON_CameraInputsMap;
BABYLON_CameraInputsMap.__name__ = ["BABYLON","CameraInputsMap"];
var BABYLON_VRDisplay = function() { };
$hxClasses["BABYLON.VRDisplay"] = BABYLON_VRDisplay;
BABYLON_VRDisplay.__name__ = ["BABYLON","VRDisplay"];
BABYLON_VRDisplay.prototype = {
	__class__: BABYLON_VRDisplay
};
var BABYLON_VRLayer = function() { };
$hxClasses["BABYLON.VRLayer"] = BABYLON_VRLayer;
BABYLON_VRLayer.__name__ = ["BABYLON","VRLayer"];
BABYLON_VRLayer.prototype = {
	__class__: BABYLON_VRLayer
};
var BABYLON_VRDisplayCapabilities = function() { };
$hxClasses["BABYLON.VRDisplayCapabilities"] = BABYLON_VRDisplayCapabilities;
BABYLON_VRDisplayCapabilities.__name__ = ["BABYLON","VRDisplayCapabilities"];
BABYLON_VRDisplayCapabilities.prototype = {
	__class__: BABYLON_VRDisplayCapabilities
};
var BABYLON_VREyeParameters = function() { };
$hxClasses["BABYLON.VREyeParameters"] = BABYLON_VREyeParameters;
BABYLON_VREyeParameters.__name__ = ["BABYLON","VREyeParameters"];
BABYLON_VREyeParameters.prototype = {
	__class__: BABYLON_VREyeParameters
};
var BABYLON_VRFieldOfView = function() { };
$hxClasses["BABYLON.VRFieldOfView"] = BABYLON_VRFieldOfView;
BABYLON_VRFieldOfView.__name__ = ["BABYLON","VRFieldOfView"];
BABYLON_VRFieldOfView.prototype = {
	__class__: BABYLON_VRFieldOfView
};
var BABYLON_VRFrameData = function() { };
$hxClasses["BABYLON.VRFrameData"] = BABYLON_VRFrameData;
BABYLON_VRFrameData.__name__ = ["BABYLON","VRFrameData"];
BABYLON_VRFrameData.prototype = {
	__class__: BABYLON_VRFrameData
};
var BABYLON_VRPose = function() { };
$hxClasses["BABYLON.VRPose"] = BABYLON_VRPose;
BABYLON_VRPose.__name__ = ["BABYLON","VRPose"];
BABYLON_VRPose.prototype = {
	__class__: BABYLON_VRPose
};
var BABYLON_VRStageParameters = function() { };
$hxClasses["BABYLON.VRStageParameters"] = BABYLON_VRStageParameters;
BABYLON_VRStageParameters.__name__ = ["BABYLON","VRStageParameters"];
BABYLON_VRStageParameters.prototype = {
	__class__: BABYLON_VRStageParameters
};
var BABYLON_EngineOptions = function() { };
$hxClasses["BABYLON.EngineOptions"] = BABYLON_EngineOptions;
BABYLON_EngineOptions.__name__ = ["BABYLON","EngineOptions"];
BABYLON_EngineOptions.prototype = {
	__class__: BABYLON_EngineOptions
};
var BABYLON_IDisplayChangedEventArgs = function() { };
$hxClasses["BABYLON.IDisplayChangedEventArgs"] = BABYLON_IDisplayChangedEventArgs;
BABYLON_IDisplayChangedEventArgs.__name__ = ["BABYLON","IDisplayChangedEventArgs"];
BABYLON_IDisplayChangedEventArgs.prototype = {
	__class__: BABYLON_IDisplayChangedEventArgs
};
var BABYLON_ImageBitmap = function() { };
$hxClasses["BABYLON.ImageBitmap"] = BABYLON_ImageBitmap;
BABYLON_ImageBitmap.__name__ = ["BABYLON","ImageBitmap"];
BABYLON_ImageBitmap.prototype = {
	__class__: BABYLON_ImageBitmap
};
var BABYLON_WebGLQuery = function() { };
$hxClasses["BABYLON.WebGLQuery"] = BABYLON_WebGLQuery;
BABYLON_WebGLQuery.__name__ = ["BABYLON","WebGLQuery"];
var BABYLON_WebGLSampler = function() { };
$hxClasses["BABYLON.WebGLSampler"] = BABYLON_WebGLSampler;
BABYLON_WebGLSampler.__name__ = ["BABYLON","WebGLSampler"];
var BABYLON_WebGLSync = function() { };
$hxClasses["BABYLON.WebGLSync"] = BABYLON_WebGLSync;
BABYLON_WebGLSync.__name__ = ["BABYLON","WebGLSync"];
var BABYLON_WebGLTransformFeedback = function() { };
$hxClasses["BABYLON.WebGLTransformFeedback"] = BABYLON_WebGLTransformFeedback;
BABYLON_WebGLTransformFeedback.__name__ = ["BABYLON","WebGLTransformFeedback"];
var BABYLON_WebGLVertexArrayObject = function() { };
$hxClasses["BABYLON.WebGLVertexArrayObject"] = BABYLON_WebGLVertexArrayObject;
BABYLON_WebGLVertexArrayObject.__name__ = ["BABYLON","WebGLVertexArrayObject"];
var BABYLON_GamepadButtonChanges = function() { };
$hxClasses["BABYLON.GamepadButtonChanges"] = BABYLON_GamepadButtonChanges;
BABYLON_GamepadButtonChanges.__name__ = ["BABYLON","GamepadButtonChanges"];
BABYLON_GamepadButtonChanges.prototype = {
	__class__: BABYLON_GamepadButtonChanges
};
var BABYLON_IEnvironmentHelperOptions = function() { };
$hxClasses["BABYLON.IEnvironmentHelperOptions"] = BABYLON_IEnvironmentHelperOptions;
BABYLON_IEnvironmentHelperOptions.__name__ = ["BABYLON","IEnvironmentHelperOptions"];
BABYLON_IEnvironmentHelperOptions.prototype = {
	__class__: BABYLON_IEnvironmentHelperOptions
};
var BABYLON_IEffectLayerOptions = function() { };
$hxClasses["BABYLON.IEffectLayerOptions"] = BABYLON_IEffectLayerOptions;
BABYLON_IEffectLayerOptions.__name__ = ["BABYLON","IEffectLayerOptions"];
BABYLON_IEffectLayerOptions.prototype = {
	__class__: BABYLON_IEffectLayerOptions
};
var BABYLON_IGlowLayerOptions = function() { };
$hxClasses["BABYLON.IGlowLayerOptions"] = BABYLON_IGlowLayerOptions;
BABYLON_IGlowLayerOptions.__name__ = ["BABYLON","IGlowLayerOptions"];
BABYLON_IGlowLayerOptions.prototype = {
	__class__: BABYLON_IGlowLayerOptions
};
var BABYLON_IHighlightLayerOptions = function() { };
$hxClasses["BABYLON.IHighlightLayerOptions"] = BABYLON_IHighlightLayerOptions;
BABYLON_IHighlightLayerOptions.__name__ = ["BABYLON","IHighlightLayerOptions"];
BABYLON_IHighlightLayerOptions.prototype = {
	__class__: BABYLON_IHighlightLayerOptions
};
var BABYLON_IShadowLight = function() { };
$hxClasses["BABYLON.IShadowLight"] = BABYLON_IShadowLight;
BABYLON_IShadowLight.__name__ = ["BABYLON","IShadowLight"];
BABYLON_IShadowLight.prototype = {
	__class__: BABYLON_IShadowLight
};
var BABYLON_ILoadingScreen = function() { };
$hxClasses["BABYLON.ILoadingScreen"] = BABYLON_ILoadingScreen;
BABYLON_ILoadingScreen.__name__ = ["BABYLON","ILoadingScreen"];
BABYLON_ILoadingScreen.prototype = {
	__class__: BABYLON_ILoadingScreen
};
var BABYLON_ISceneLoaderPluginExtensions = function() { };
$hxClasses["BABYLON.ISceneLoaderPluginExtensions"] = BABYLON_ISceneLoaderPluginExtensions;
BABYLON_ISceneLoaderPluginExtensions.__name__ = ["BABYLON","ISceneLoaderPluginExtensions"];
var BABYLON_ISceneLoaderPluginFactory = function() { };
$hxClasses["BABYLON.ISceneLoaderPluginFactory"] = BABYLON_ISceneLoaderPluginFactory;
BABYLON_ISceneLoaderPluginFactory.__name__ = ["BABYLON","ISceneLoaderPluginFactory"];
BABYLON_ISceneLoaderPluginFactory.prototype = {
	__class__: BABYLON_ISceneLoaderPluginFactory
};
var BABYLON_ISceneLoaderPlugin = function() { };
$hxClasses["BABYLON.ISceneLoaderPlugin"] = BABYLON_ISceneLoaderPlugin;
BABYLON_ISceneLoaderPlugin.__name__ = ["BABYLON","ISceneLoaderPlugin"];
BABYLON_ISceneLoaderPlugin.prototype = {
	__class__: BABYLON_ISceneLoaderPlugin
};
var BABYLON_ISceneLoaderPluginAsync = function() { };
$hxClasses["BABYLON.ISceneLoaderPluginAsync"] = BABYLON_ISceneLoaderPluginAsync;
BABYLON_ISceneLoaderPluginAsync.__name__ = ["BABYLON","ISceneLoaderPluginAsync"];
BABYLON_ISceneLoaderPluginAsync.prototype = {
	__class__: BABYLON_ISceneLoaderPluginAsync
};
var BABYLON_IImageProcessingConfigurationDefines = function() { };
$hxClasses["BABYLON.IImageProcessingConfigurationDefines"] = BABYLON_IImageProcessingConfigurationDefines;
BABYLON_IImageProcessingConfigurationDefines.__name__ = ["BABYLON","IImageProcessingConfigurationDefines"];
BABYLON_IImageProcessingConfigurationDefines.prototype = {
	__class__: BABYLON_IImageProcessingConfigurationDefines
};
var BABYLON_ISize = function() { };
$hxClasses["BABYLON.ISize"] = BABYLON_ISize;
BABYLON_ISize.__name__ = ["BABYLON","ISize"];
BABYLON_ISize.prototype = {
	__class__: BABYLON_ISize
};
var BABYLON_ISimplifier = function() { };
$hxClasses["BABYLON.ISimplifier"] = BABYLON_ISimplifier;
BABYLON_ISimplifier.__name__ = ["BABYLON","ISimplifier"];
BABYLON_ISimplifier.prototype = {
	__class__: BABYLON_ISimplifier
};
var BABYLON_ISimplificationSettings = function() { };
$hxClasses["BABYLON.ISimplificationSettings"] = BABYLON_ISimplificationSettings;
BABYLON_ISimplificationSettings.__name__ = ["BABYLON","ISimplificationSettings"];
BABYLON_ISimplificationSettings.prototype = {
	__class__: BABYLON_ISimplificationSettings
};
var BABYLON_ISimplificationTask = function() { };
$hxClasses["BABYLON.ISimplificationTask"] = BABYLON_ISimplificationTask;
BABYLON_ISimplificationTask.__name__ = ["BABYLON","ISimplificationTask"];
BABYLON_ISimplificationTask.prototype = {
	__class__: BABYLON_ISimplificationTask
};
var BABYLON_IParticleSystem = function() { };
$hxClasses["BABYLON.IParticleSystem"] = BABYLON_IParticleSystem;
BABYLON_IParticleSystem.__name__ = ["BABYLON","IParticleSystem"];
BABYLON_IParticleSystem.prototype = {
	__class__: BABYLON_IParticleSystem
};
var BABYLON_PhysicsImpostorJoint = function() { };
$hxClasses["BABYLON.PhysicsImpostorJoint"] = BABYLON_PhysicsImpostorJoint;
BABYLON_PhysicsImpostorJoint.__name__ = ["BABYLON","PhysicsImpostorJoint"];
BABYLON_PhysicsImpostorJoint.prototype = {
	__class__: BABYLON_PhysicsImpostorJoint
};
var BABYLON_IPhysicsEnginePlugin = function() { };
$hxClasses["BABYLON.IPhysicsEnginePlugin"] = BABYLON_IPhysicsEnginePlugin;
BABYLON_IPhysicsEnginePlugin.__name__ = ["BABYLON","IPhysicsEnginePlugin"];
BABYLON_IPhysicsEnginePlugin.prototype = {
	__class__: BABYLON_IPhysicsEnginePlugin
};
var BABYLON_PhysicsForceAndContactPoint = function() { };
$hxClasses["BABYLON.PhysicsForceAndContactPoint"] = BABYLON_PhysicsForceAndContactPoint;
BABYLON_PhysicsForceAndContactPoint.__name__ = ["BABYLON","PhysicsForceAndContactPoint"];
BABYLON_PhysicsForceAndContactPoint.prototype = {
	__class__: BABYLON_PhysicsForceAndContactPoint
};
var BABYLON_PhysicsRadialExplosionEventData = function() { };
$hxClasses["BABYLON.PhysicsRadialExplosionEventData"] = BABYLON_PhysicsRadialExplosionEventData;
BABYLON_PhysicsRadialExplosionEventData.__name__ = ["BABYLON","PhysicsRadialExplosionEventData"];
BABYLON_PhysicsRadialExplosionEventData.prototype = {
	__class__: BABYLON_PhysicsRadialExplosionEventData
};
var BABYLON_PhysicsGravitationalFieldEventData = function() { };
$hxClasses["BABYLON.PhysicsGravitationalFieldEventData"] = BABYLON_PhysicsGravitationalFieldEventData;
BABYLON_PhysicsGravitationalFieldEventData.__name__ = ["BABYLON","PhysicsGravitationalFieldEventData"];
BABYLON_PhysicsGravitationalFieldEventData.prototype = {
	__class__: BABYLON_PhysicsGravitationalFieldEventData
};
var BABYLON_PhysicsUpdraftEventData = function() { };
$hxClasses["BABYLON.PhysicsUpdraftEventData"] = BABYLON_PhysicsUpdraftEventData;
BABYLON_PhysicsUpdraftEventData.__name__ = ["BABYLON","PhysicsUpdraftEventData"];
BABYLON_PhysicsUpdraftEventData.prototype = {
	__class__: BABYLON_PhysicsUpdraftEventData
};
var BABYLON_PhysicsVortexEventData = function() { };
$hxClasses["BABYLON.PhysicsVortexEventData"] = BABYLON_PhysicsVortexEventData;
BABYLON_PhysicsVortexEventData.__name__ = ["BABYLON","PhysicsVortexEventData"];
BABYLON_PhysicsVortexEventData.prototype = {
	__class__: BABYLON_PhysicsVortexEventData
};
var BABYLON_PhysicsImpostorParameters = function() { };
$hxClasses["BABYLON.PhysicsImpostorParameters"] = BABYLON_PhysicsImpostorParameters;
BABYLON_PhysicsImpostorParameters.__name__ = ["BABYLON","PhysicsImpostorParameters"];
BABYLON_PhysicsImpostorParameters.prototype = {
	__class__: BABYLON_PhysicsImpostorParameters
};
var BABYLON_IPhysicsEnabledObject = function() { };
$hxClasses["BABYLON.IPhysicsEnabledObject"] = BABYLON_IPhysicsEnabledObject;
BABYLON_IPhysicsEnabledObject.__name__ = ["BABYLON","IPhysicsEnabledObject"];
BABYLON_IPhysicsEnabledObject.prototype = {
	__class__: BABYLON_IPhysicsEnabledObject
};
var BABYLON_PhysicsJointData = function() { };
$hxClasses["BABYLON.PhysicsJointData"] = BABYLON_PhysicsJointData;
BABYLON_PhysicsJointData.__name__ = ["BABYLON","PhysicsJointData"];
BABYLON_PhysicsJointData.prototype = {
	__class__: BABYLON_PhysicsJointData
};
var BABYLON_IMotorEnabledJoint = function() { };
$hxClasses["BABYLON.IMotorEnabledJoint"] = BABYLON_IMotorEnabledJoint;
BABYLON_IMotorEnabledJoint.__name__ = ["BABYLON","IMotorEnabledJoint"];
BABYLON_IMotorEnabledJoint.prototype = {
	__class__: BABYLON_IMotorEnabledJoint
};
var BABYLON_DistanceJointData = function() { };
$hxClasses["BABYLON.DistanceJointData"] = BABYLON_DistanceJointData;
BABYLON_DistanceJointData.__name__ = ["BABYLON","DistanceJointData"];
BABYLON_DistanceJointData.__interfaces__ = [BABYLON_PhysicsJointData];
BABYLON_DistanceJointData.prototype = {
	__class__: BABYLON_DistanceJointData
};
var BABYLON_SpringJointData = function() { };
$hxClasses["BABYLON.SpringJointData"] = BABYLON_SpringJointData;
BABYLON_SpringJointData.__name__ = ["BABYLON","SpringJointData"];
BABYLON_SpringJointData.__interfaces__ = [BABYLON_PhysicsJointData];
BABYLON_SpringJointData.prototype = {
	__class__: BABYLON_SpringJointData
};
var BABYLON_IRenderingManagerAutoClearSetup = function() { };
$hxClasses["BABYLON.IRenderingManagerAutoClearSetup"] = BABYLON_IRenderingManagerAutoClearSetup;
BABYLON_IRenderingManagerAutoClearSetup.__name__ = ["BABYLON","IRenderingManagerAutoClearSetup"];
BABYLON_IRenderingManagerAutoClearSetup.prototype = {
	__class__: BABYLON_IRenderingManagerAutoClearSetup
};
var BABYLON_IAssetsProgressEvent = function() { };
$hxClasses["BABYLON.IAssetsProgressEvent"] = BABYLON_IAssetsProgressEvent;
BABYLON_IAssetsProgressEvent.__name__ = ["BABYLON","IAssetsProgressEvent"];
BABYLON_IAssetsProgressEvent.prototype = {
	__class__: BABYLON_IAssetsProgressEvent
};
var BABYLON_ITextureAssetTask = function() { };
$hxClasses["BABYLON.ITextureAssetTask"] = BABYLON_ITextureAssetTask;
BABYLON_ITextureAssetTask.__name__ = ["BABYLON","ITextureAssetTask"];
BABYLON_ITextureAssetTask.prototype = {
	__class__: BABYLON_ITextureAssetTask
};
var BABYLON_DDSInfo = function() { };
$hxClasses["BABYLON.DDSInfo"] = BABYLON_DDSInfo;
BABYLON_DDSInfo.__name__ = ["BABYLON","DDSInfo"];
BABYLON_DDSInfo.prototype = {
	__class__: BABYLON_DDSInfo
};
var BABYLON_EnvironmentTextureInfo = function() { };
$hxClasses["BABYLON.EnvironmentTextureInfo"] = BABYLON_EnvironmentTextureInfo;
BABYLON_EnvironmentTextureInfo.__name__ = ["BABYLON","EnvironmentTextureInfo"];
BABYLON_EnvironmentTextureInfo.prototype = {
	__class__: BABYLON_EnvironmentTextureInfo
};
var BABYLON_IValueGradient = function() { };
$hxClasses["BABYLON.IValueGradient"] = BABYLON_IValueGradient;
BABYLON_IValueGradient.__name__ = ["BABYLON","IValueGradient"];
BABYLON_IValueGradient.prototype = {
	__class__: BABYLON_IValueGradient
};
var BABYLON_IFileRequest = function() { };
$hxClasses["BABYLON.IFileRequest"] = BABYLON_IFileRequest;
BABYLON_IFileRequest.__name__ = ["BABYLON","IFileRequest"];
BABYLON_IFileRequest.prototype = {
	__class__: BABYLON_IFileRequest
};
var BABYLON_MediaRecorder = function() { };
$hxClasses["BABYLON.MediaRecorder"] = BABYLON_MediaRecorder;
BABYLON_MediaRecorder.__name__ = ["BABYLON","MediaRecorder"];
BABYLON_MediaRecorder.prototype = {
	__class__: BABYLON_MediaRecorder
};
var BABYLON_MediaRecorderOptions = function() { };
$hxClasses["BABYLON.MediaRecorderOptions"] = BABYLON_MediaRecorderOptions;
BABYLON_MediaRecorderOptions.__name__ = ["BABYLON","MediaRecorderOptions"];
BABYLON_MediaRecorderOptions.prototype = {
	__class__: BABYLON_MediaRecorderOptions
};
var BABYLON_MediaRecorderConstructor = function() { };
$hxClasses["BABYLON.MediaRecorderConstructor"] = BABYLON_MediaRecorderConstructor;
BABYLON_MediaRecorderConstructor.__name__ = ["BABYLON","MediaRecorderConstructor"];
BABYLON_MediaRecorderConstructor.prototype = {
	__class__: BABYLON_MediaRecorderConstructor
};
var BABYLON_VideoRecorderOptions = function() { };
$hxClasses["BABYLON.VideoRecorderOptions"] = BABYLON_VideoRecorderOptions;
BABYLON_VideoRecorderOptions.__name__ = ["BABYLON","VideoRecorderOptions"];
BABYLON_VideoRecorderOptions.prototype = {
	__class__: BABYLON_VideoRecorderOptions
};
var BABYLON_VRTeleportationOptions = function() { };
$hxClasses["BABYLON.VRTeleportationOptions"] = BABYLON_VRTeleportationOptions;
BABYLON_VRTeleportationOptions.__name__ = ["BABYLON","VRTeleportationOptions"];
BABYLON_VRTeleportationOptions.prototype = {
	__class__: BABYLON_VRTeleportationOptions
};
var BABYLON_WebVROptions = function() { };
$hxClasses["BABYLON.WebVROptions"] = BABYLON_WebVROptions;
BABYLON_WebVROptions.__name__ = ["BABYLON","WebVROptions"];
BABYLON_WebVROptions.prototype = {
	__class__: BABYLON_WebVROptions
};
var BABYLON_VRExperienceHelperOptions = function() { };
$hxClasses["BABYLON.VRExperienceHelperOptions"] = BABYLON_VRExperienceHelperOptions;
BABYLON_VRExperienceHelperOptions.__name__ = ["BABYLON","VRExperienceHelperOptions"];
BABYLON_VRExperienceHelperOptions.__interfaces__ = [BABYLON_WebVROptions];
BABYLON_VRExperienceHelperOptions.prototype = {
	__class__: BABYLON_VRExperienceHelperOptions
};
var BABYLON_DevicePose = function() { };
$hxClasses["BABYLON.DevicePose"] = BABYLON_DevicePose;
BABYLON_DevicePose.__name__ = ["BABYLON","DevicePose"];
BABYLON_DevicePose.prototype = {
	__class__: BABYLON_DevicePose
};
var BABYLON_PoseControlled = function() { };
$hxClasses["BABYLON.PoseControlled"] = BABYLON_PoseControlled;
BABYLON_PoseControlled.__name__ = ["BABYLON","PoseControlled"];
BABYLON_PoseControlled.prototype = {
	__class__: BABYLON_PoseControlled
};
var BABYLON_IOctreeContainer = function() { };
$hxClasses["BABYLON.IOctreeContainer"] = BABYLON_IOctreeContainer;
BABYLON_IOctreeContainer.__name__ = ["BABYLON","IOctreeContainer"];
BABYLON_IOctreeContainer.prototype = {
	__class__: BABYLON_IOctreeContainer
};
var BABYLON_MutableGamepadButton = function() { };
$hxClasses["BABYLON.MutableGamepadButton"] = BABYLON_MutableGamepadButton;
BABYLON_MutableGamepadButton.__name__ = ["BABYLON","MutableGamepadButton"];
BABYLON_MutableGamepadButton.prototype = {
	__class__: BABYLON_MutableGamepadButton
};
var BABYLON_ExtendedGamepadButton = function() { };
$hxClasses["BABYLON.ExtendedGamepadButton"] = BABYLON_ExtendedGamepadButton;
BABYLON_ExtendedGamepadButton.__name__ = ["BABYLON","ExtendedGamepadButton"];
BABYLON_ExtendedGamepadButton.prototype = {
	__class__: BABYLON_ExtendedGamepadButton
};
var BABYLON_IShadowGenerator = function() { };
$hxClasses["BABYLON.IShadowGenerator"] = BABYLON_IShadowGenerator;
BABYLON_IShadowGenerator.__name__ = ["BABYLON","IShadowGenerator"];
BABYLON_IShadowGenerator.prototype = {
	__class__: BABYLON_IShadowGenerator
};
var BABYLON_IInternalTextureTracker = function() { };
$hxClasses["BABYLON.IInternalTextureTracker"] = BABYLON_IInternalTextureTracker;
BABYLON_IInternalTextureTracker.__name__ = ["BABYLON","IInternalTextureTracker"];
BABYLON_IInternalTextureTracker.prototype = {
	__class__: BABYLON_IInternalTextureTracker
};
var BABYLON_IInternalTextureLoader = function() { };
$hxClasses["BABYLON.IInternalTextureLoader"] = BABYLON_IInternalTextureLoader;
BABYLON_IInternalTextureLoader.__name__ = ["BABYLON","IInternalTextureLoader"];
BABYLON_IInternalTextureLoader.prototype = {
	__class__: BABYLON_IInternalTextureLoader
};
var BABYLON_IMultiRenderTargetOptions = function() { };
$hxClasses["BABYLON.IMultiRenderTargetOptions"] = BABYLON_IMultiRenderTargetOptions;
BABYLON_IMultiRenderTargetOptions.__name__ = ["BABYLON","IMultiRenderTargetOptions"];
BABYLON_IMultiRenderTargetOptions.prototype = {
	__class__: BABYLON_IMultiRenderTargetOptions
};
var BABYLON_VideoTextureSettings = function() { };
$hxClasses["BABYLON.VideoTextureSettings"] = BABYLON_VideoTextureSettings;
BABYLON_VideoTextureSettings.__name__ = ["BABYLON","VideoTextureSettings"];
BABYLON_VideoTextureSettings.prototype = {
	__class__: BABYLON_VideoTextureSettings
};
var BABYLON_IDracoCompressionConfiguration = function() { };
$hxClasses["BABYLON.IDracoCompressionConfiguration"] = BABYLON_IDracoCompressionConfiguration;
BABYLON_IDracoCompressionConfiguration.__name__ = ["BABYLON","IDracoCompressionConfiguration"];
BABYLON_IDracoCompressionConfiguration.prototype = {
	__class__: BABYLON_IDracoCompressionConfiguration
};
var BABYLON_IParticleEmitterType = function() { };
$hxClasses["BABYLON.IParticleEmitterType"] = BABYLON_IParticleEmitterType;
BABYLON_IParticleEmitterType.__name__ = ["BABYLON","IParticleEmitterType"];
BABYLON_IParticleEmitterType.prototype = {
	__class__: BABYLON_IParticleEmitterType
};
var BABYLON_HDRInfo = function() { };
$hxClasses["BABYLON.HDRInfo"] = BABYLON_HDRInfo;
BABYLON_HDRInfo.__name__ = ["BABYLON","HDRInfo"];
BABYLON_HDRInfo.prototype = {
	__class__: BABYLON_HDRInfo
};
var BABYLON_CubeMapInfo = function() { };
$hxClasses["BABYLON.CubeMapInfo"] = BABYLON_CubeMapInfo;
BABYLON_CubeMapInfo.__name__ = ["BABYLON","CubeMapInfo"];
BABYLON_CubeMapInfo.prototype = {
	__class__: BABYLON_CubeMapInfo
};
var js_html_compat_ArrayBuffer = function(a) {
	if((a instanceof Array) && a.__enum__ == null) {
		this.a = a;
		this.byteLength = a.length;
	} else {
		var len = a;
		this.a = [];
		var _g1 = 0;
		var _g = len;
		while(_g1 < _g) this.a[_g1++] = 0;
		this.byteLength = len;
	}
};
$hxClasses["js.html.compat.ArrayBuffer"] = js_html_compat_ArrayBuffer;
js_html_compat_ArrayBuffer.__name__ = ["js","html","compat","ArrayBuffer"];
js_html_compat_ArrayBuffer.sliceImpl = function(begin,end) {
	var u = new Uint8Array(this,begin,end == null ? null : end - begin);
	var result = new ArrayBuffer(u.byteLength);
	new Uint8Array(result).set(u);
	return result;
};
js_html_compat_ArrayBuffer.prototype = {
	slice: function(begin,end) {
		return new js_html_compat_ArrayBuffer(this.a.slice(begin,end));
	}
	,__class__: js_html_compat_ArrayBuffer
};
var js_html_compat_Float32Array = function() { };
$hxClasses["js.html.compat.Float32Array"] = js_html_compat_Float32Array;
js_html_compat_Float32Array.__name__ = ["js","html","compat","Float32Array"];
js_html_compat_Float32Array._new = function(arg1,offset,length) {
	var arr;
	if(typeof(arg1) == "number") {
		arr = [];
		var _g1 = 0;
		var _g = arg1;
		while(_g1 < _g) {
			var i = _g1++;
			arr[i] = 0;
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = 0;
		var _g2 = [];
		var _g21 = 0;
		var _g11 = arr.length << 2;
		while(_g21 < _g11) {
			var i1 = _g21++;
			_g2.push(0);
		}
		arr.buffer = new js_html_compat_ArrayBuffer(_g2);
	} else if(js_Boot.__instanceof(arg1,js_html_compat_ArrayBuffer)) {
		var buffer = arg1;
		if(offset == null) {
			offset = 0;
		}
		if(length == null) {
			length = buffer.byteLength - offset >> 2;
		}
		arr = [];
		var _g12 = 0;
		var _g3 = length;
		while(_g12 < _g3) {
			var i2 = _g12++;
			var val = buffer.a[offset++] | buffer.a[offset++] << 8 | buffer.a[offset++] << 16 | buffer.a[offset++] << 24;
			arr.push(haxe_io_FPHelper.i32ToFloat(val));
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = offset;
		arr.buffer = buffer;
	} else if((arg1 instanceof Array) && arg1.__enum__ == null) {
		arr = arg1.slice();
		var buffer1 = [];
		var _g4 = 0;
		while(_g4 < arr.length) {
			var f = arr[_g4];
			++_g4;
			var i3 = haxe_io_FPHelper.floatToI32(f);
			buffer1.push(i3 & 255);
			buffer1.push(i3 >> 8 & 255);
			buffer1.push(i3 >> 16 & 255);
			buffer1.push(i3 >>> 24);
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(buffer1);
	} else {
		throw new js__$Boot_HaxeError("TODO " + Std.string(arg1));
	}
	arr.subarray = js_html_compat_Float32Array._subarray;
	arr.set = js_html_compat_Float32Array._set;
	return arr;
};
js_html_compat_Float32Array._set = function(arg,offset) {
	if(js_Boot.__instanceof(arg.buffer,js_html_compat_ArrayBuffer)) {
		var a = arg;
		if(arg.byteLength + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g1 = 0;
		var _g = arg.byteLength;
		while(_g1 < _g) {
			var i = _g1++;
			this[i + offset] = a[i];
		}
	} else if((arg instanceof Array) && arg.__enum__ == null) {
		var a1 = arg;
		if(a1.length + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g11 = 0;
		var _g2 = a1.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			this[i1 + offset] = a1[i1];
		}
	} else {
		throw new js__$Boot_HaxeError("TODO");
	}
};
js_html_compat_Float32Array._subarray = function(start,end) {
	var a = js_html_compat_Float32Array._new(this.slice(start,end));
	a.byteOffset = start * 4;
	return a;
};
var js_html_compat_Uint8Array = function() { };
$hxClasses["js.html.compat.Uint8Array"] = js_html_compat_Uint8Array;
js_html_compat_Uint8Array.__name__ = ["js","html","compat","Uint8Array"];
js_html_compat_Uint8Array._new = function(arg1,offset,length) {
	var arr;
	if(typeof(arg1) == "number") {
		arr = [];
		var _g1 = 0;
		var _g = arg1;
		while(_g1 < _g) {
			var i = _g1++;
			arr[i] = 0;
		}
		arr.byteLength = arr.length;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(arr);
	} else if(js_Boot.__instanceof(arg1,js_html_compat_ArrayBuffer)) {
		var buffer = arg1;
		if(offset == null) {
			offset = 0;
		}
		if(length == null) {
			length = buffer.byteLength - offset;
		}
		if(offset == 0) {
			arr = buffer.a;
		} else {
			arr = buffer.a.slice(offset,offset + length);
		}
		arr.byteLength = arr.length;
		arr.byteOffset = offset;
		arr.buffer = buffer;
	} else if((arg1 instanceof Array) && arg1.__enum__ == null) {
		arr = arg1.slice();
		arr.byteLength = arr.length;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(arr);
	} else {
		throw new js__$Boot_HaxeError("TODO " + Std.string(arg1));
	}
	arr.subarray = js_html_compat_Uint8Array._subarray;
	arr.set = js_html_compat_Uint8Array._set;
	return arr;
};
js_html_compat_Uint8Array._set = function(arg,offset) {
	if(js_Boot.__instanceof(arg.buffer,js_html_compat_ArrayBuffer)) {
		var a = arg;
		if(arg.byteLength + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g1 = 0;
		var _g = arg.byteLength;
		while(_g1 < _g) {
			var i = _g1++;
			this[i + offset] = a[i];
		}
	} else if((arg instanceof Array) && arg.__enum__ == null) {
		var a1 = arg;
		if(a1.length + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g11 = 0;
		var _g2 = a1.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			this[i1 + offset] = a1[i1];
		}
	} else {
		throw new js__$Boot_HaxeError("TODO");
	}
};
js_html_compat_Uint8Array._subarray = function(start,end) {
	var a = js_html_compat_Uint8Array._new(this.slice(start,end));
	a.byteOffset = start;
	return a;
};
var lavaplanet_LavaGround = function(name,scene) {
	BABYLON.TransformNode.call(this,name,scene);
	var ground = BABYLON.Mesh.CreateGroundFromHeightMap("ground",lavaplanet_LavaGroundHeightMap.value,600,600,250,0,18,scene);
	var groundMaterial = new lavaplanet_LavaShader();
	ground.material = groundMaterial.material;
	wl_core_Demo.instance.onUpdate.connect(function(ts) {
		groundMaterial.update(ts);
	});
};
$hxClasses["lavaplanet.LavaGround"] = lavaplanet_LavaGround;
lavaplanet_LavaGround.__name__ = ["lavaplanet","LavaGround"];
lavaplanet_LavaGround.__super__ = BABYLON.TransformNode;
lavaplanet_LavaGround.prototype = $extend(BABYLON.TransformNode.prototype,{
	__class__: lavaplanet_LavaGround
});
var lavaplanet_LavaGroundHeightMap = function() { };
$hxClasses["lavaplanet.LavaGroundHeightMap"] = lavaplanet_LavaGroundHeightMap;
lavaplanet_LavaGroundHeightMap.__name__ = ["lavaplanet","LavaGroundHeightMap"];
var lavaplanet_LavaPlanet = function() {
	wl_core_Part.call(this);
};
$hxClasses["lavaplanet.LavaPlanet"] = lavaplanet_LavaPlanet;
lavaplanet_LavaPlanet.__name__ = ["lavaplanet","LavaPlanet"];
lavaplanet_LavaPlanet.__super__ = wl_core_Part;
lavaplanet_LavaPlanet.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initSyncedPipeline(null);
		new BABYLON.HemisphericLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		BABYLON.MeshBuilder.CreateBox("",{ width : 600, height : 600, depth : 600, sideOrientation : BABYLON.Mesh.BACKSIDE},this.scene);
		this.ground = new lavaplanet_LavaGround("ground",this.scene);
		this.camera.position.set(4.48,20.93,-6.85);
		this.camera.rotation.x = 0.88;
		new lavaplanet_Monitor("",this.scene).continuousTextDisplay(spaceintro_SpaceIntro.loopText);
		this.exposureTarget = -4;
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		createjs.Tween.get(this.camera.position).to({ x : 7.72, y : 219.18, z : -91.52},wl_core_TimeSig.milliseconds(10,0,0,0),createjs.Ease.cubicIn);
		createjs.Tween.get(this).to({ exposureTarget : 0},wl_core_TimeSig.milliseconds(1,0,0,0)).wait(wl_core_TimeSig.milliseconds(6,0,0,0)).to({ exposureTarget : -4},wl_core_TimeSig.milliseconds(2,0,0,0),createjs.Ease.cubicIn);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: lavaplanet_LavaPlanet
});
var lavaplanet_LavaShader = function() {
	this.lava = "\r\nin vec2 vUv;\r\nuniform float time;\r\nuniform sampler2D basetex;\r\nfloat hash21(in vec2 n){ return fract(sin(dot(n, vec2(12.9898, 4.1414))) * 43758.5453); }\r\nmat2 makem2(in float theta){float c = cos(theta);float s = sin(theta);return mat2(c,-s,s,c);}\r\nfloat noise( in vec2 x ){return texture(basetex, x*.01).x;}\r\n\r\nvec2 gradn(vec2 p)\r\n{\r\n\tfloat ep = .09;\r\n\tfloat gradx = noise(vec2(p.x+ep,p.y))-noise(vec2(p.x-ep,p.y));\r\n\tfloat grady = noise(vec2(p.x,p.y+ep))-noise(vec2(p.x,p.y-ep));\r\n\treturn vec2(gradx,grady);\r\n}\r\n\r\nfloat flow(in vec2 p)\r\n{\r\n\tfloat z=2.;\r\n\tfloat rz = 0.;\r\n\tvec2 bp = p;\r\n\tfor (float i= 1.;i < 7.;i++ )\r\n\t{\r\n\t\t//primary flow speed\r\n\t\tp += time*.6;\r\n\t\t\r\n\t\t//secondary flow speed (speed of the perceived flow)\r\n\t\tbp += time*1.9;\r\n\t\t\r\n\t\t//displacement field (try changing time multiplier)\r\n\t\tvec2 gr = gradn(i*p*.34+time*1.);\r\n\t\t\r\n\t\t//rotation of the displacement field\r\n\t\tgr*=makem2(time*6.-(0.05*p.x+0.03*p.y)*40.);\r\n\t\t\r\n\t\t//displace the system\r\n\t\tp += gr*.5;\r\n\t\t\r\n\t\t//add noise octave\r\n\t\trz+= (sin(noise(p)*7.)*0.5+0.5)/z;\r\n\t\t\r\n\t\t//blend factor (blending displaced system with base system)\r\n\t\t//you could call this advection factor (.5 being low, .95 being high)\r\n\t\tp = mix(bp,p,.77);\r\n\t\t\r\n\t\t//intensity scaling\r\n\t\tz *= 1.4;\r\n\t\t//octave scaling\r\n\t\tp *= 2.;\r\n\t\tbp *= 1.9;\r\n\t}\r\n\treturn rz;\t\r\n}\r\n\r\nvec3 colend(vec2 p){\r\n    float rz = flow(p);\r\n\t\r\n\tvec3 col = vec3(.2,0.07,0.01)/rz;\r\n\tcol=pow(col,vec3(1.4));\r\n    return col;\r\n}\r\n\r\nvoid main( )\r\n{\r\n\tvec2 p = vUv;\r\n\tp*= 3.;\r\n\t\r\n\tgl_FragColor = vec4(colend(p),1.0);\r\n}";
	this.uniforms = ["time","basetex"];
	wl_core_ShaderBase.call(this);
	BABYLON.Effect.ShadersStore["testPixelShader"] = this.lava;
	var tmp = this.UseDefaultAttributes(null);
	var tmp1 = this.UseDefaultUniforms(this.uniforms);
	this.material = new BABYLON.ShaderMaterial("testshader",null,{ vertexElement : "simple", fragmentElement : "test"},{ attributes : tmp, uniforms : tmp1, needAlphaBlending : true});
	this.material.fogEnabled = true;
	this.material.setFloat("time",0);
	this.material.setTexture("basetex",wl_core_Assets.getTexture("graynoise.png"));
	this.material.isReady(null,null);
};
$hxClasses["lavaplanet.LavaShader"] = lavaplanet_LavaShader;
lavaplanet_LavaShader.__name__ = ["lavaplanet","LavaShader"];
lavaplanet_LavaShader.__super__ = wl_core_ShaderBase;
lavaplanet_LavaShader.prototype = $extend(wl_core_ShaderBase.prototype,{
	update: function(ts) {
		this.material.setFloat("time",ts.toMilliseconds() / 200000);
	}
	,__class__: lavaplanet_LavaShader
});
var lavaplanet_Monitor = function(name,scene) {
	this.lineCarret = 0;
	this.carret = 0;
	BABYLON.TransformNode.call(this,name,scene);
	var textPlane = BABYLON.MeshBuilder.CreatePlane("textplane",{ width : 20, height : 15},scene);
	this.textTexture = new BABYLON.DynamicTexture("introText",{ width : 1200, height : 900},scene,false);
	var mat = new BABYLON.StandardMaterial("mat",scene);
	mat.diffuseTexture = this.textTexture;
	this.textTexture.drawText("",null,null,"10px arial bold","#000000","#000000",true);
	textPlane.material = mat;
	mat.specularColor = new BABYLON.Color3(0,0,0);
	mat.emissiveColor = new BABYLON.Color3(0.0,0.2,0.0);
	mat.emissiveTexture = this.textTexture;
	mat.specularPower = 0;
	var monitorMat = new BABYLON.PBRMaterial("monitor material",scene);
	monitorMat.metallic = 0;
	monitorMat.specularIntensity = 0;
	monitorMat.albedoTexture = wl_core_Assets.getTexture("Paint_Scratched_White_1K_albedo.png");
	var monitor = wl_util_ExtendedMeshBuilder.createSinkBox(24,19,25,0.8,5,scene);
	monitor.material = monitorMat;
	textPlane.parent = monitor;
	monitor.position.z = 13;
	monitor.position.y = 2;
	monitorMat.albedoColor = new BABYLON.Color3(0.6,0.5,0.5);
	var light = new BABYLON.PointLight("",new BABYLON.Vector3(0,10,-5),scene);
	light.intensity = 0.02;
	light.diffuse = new BABYLON.Color3(1,1,1);
	light.radius = 80;
	textPlane.position.y = -0.5;
	textPlane.position.z = -12.13;
	monitor.parent = this;
};
$hxClasses["lavaplanet.Monitor"] = lavaplanet_Monitor;
lavaplanet_Monitor.__name__ = ["lavaplanet","Monitor"];
lavaplanet_Monitor.__super__ = BABYLON.TransformNode;
lavaplanet_Monitor.prototype = $extend(BABYLON.TransformNode.prototype,{
	continuousTextDisplay: function(text) {
		var _gthis = this;
		this.text = text;
		wl_core_Demo.instance.onUpdate.connect(function(ts) {
			var yOffset = 64 + 21 * _gthis.lineCarret;
			var xOffset = 42 + 17 * _gthis.carret;
			var t = text[_gthis.lineCarret % text.length];
			_gthis.textTexture.drawText(t.charAt(_gthis.carret),xOffset,yOffset,"bold 20px Roboto Mono","#00ff00",null,true);
			_gthis.carret++;
			if(_gthis.carret >= t.length) {
				_gthis.lineCarret++;
				_gthis.carret = 0;
				if(_gthis.lineCarret > 38) {
					_gthis.lineCarret = 0;
					_gthis.textTexture.drawText("",xOffset,yOffset,"bold 20px Roboto Mono","#00ff00","#000000",true);
				}
			}
			_gthis.position.y = Math.sin(0.002 * ts.toMilliseconds()) + 8;
			_gthis.rotation.x = Math.PI / 180 * 30 + Math.sin(0.0002 * ts.toMilliseconds()) * 0.1;
			_gthis.rotation.z = Math.sin(0.0005 * ts.toMilliseconds()) * 0.1;
		});
	}
	,__class__: lavaplanet_Monitor
});
var meteorfield_Meteorfield = function() {
	wl_core_Part.call(this);
};
$hxClasses["meteorfield.Meteorfield"] = meteorfield_Meteorfield;
meteorfield_Meteorfield.__name__ = ["meteorfield","Meteorfield"];
meteorfield_Meteorfield.__super__ = wl_core_Part;
meteorfield_Meteorfield.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		BABYLON.MeshBuilder.CreateBox("",{ width : 600, height : 600, depth : 600, sideOrientation : BABYLON.Mesh.BACKSIDE},this.scene);
		new BABYLON.HemisphericLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		var fieldDiameter = 600;
		var grey = 0.0;
		var myPositionFunction = function(particle,i,s) {
			var scaleX = Math.random() * 2 + 0.8;
			var scaleY = Math.random() + 0.8;
			var scaleZ = Math.random() * 2 + 0.8;
			particle.scale.x = scaleX;
			particle.scale.y = scaleY;
			particle.scale.z = scaleZ;
			var myPositionFunction1 = Math.random() - 0.5;
			particle.position.x = myPositionFunction1 * fieldDiameter;
			var myPositionFunction2 = Math.random() - 0.5;
			particle.position.y = myPositionFunction2 * fieldDiameter;
			var myPositionFunction3 = Math.random() - 0.5;
			particle.position.z = myPositionFunction3 * fieldDiameter;
			var myPositionFunction4 = Math.random();
			particle.rotation.x = myPositionFunction4 * 3.5;
			var myPositionFunction5 = Math.random();
			particle.rotation.y = myPositionFunction5 * 3.5;
			var myPositionFunction6 = Math.random();
			particle.rotation.z = myPositionFunction6 * 3.5;
			grey = 1.0 - Math.random() * 0.3;
			particle.color = new BABYLON.Color4(grey,grey,grey,1);
		};
		var SPS = new BABYLON.SolidParticleSystem("SPS",this.scene,{ updatable : false});
		var sphere = BABYLON.MeshBuilder.CreateBox("s",{ width : 6, depth : 6, height : 6},this.scene);
		SPS.addShape(sphere,1000,{ positionFunction : myPositionFunction});
		SPS.buildMesh().material = new BABYLON.StandardMaterial("",this.scene);
		sphere.dispose();
		var k = new Date().getTime();
		this.scene.registerBeforeRender(function() {
			k += 0.02;
		});
		var rpProp = { };
		rpProp.motionBlur = true;
		this.initPipeline(rpProp);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		this.camera.rotation.y += 0.002;
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: meteorfield_Meteorfield
});
var multicube_HollowCube = function(m,scene) {
	BABYLON.TransformNode.call(this,"",scene);
	m.parent = this;
};
$hxClasses["multicube.HollowCube"] = multicube_HollowCube;
multicube_HollowCube.__name__ = ["multicube","HollowCube"];
multicube_HollowCube.__super__ = BABYLON.TransformNode;
multicube_HollowCube.prototype = $extend(BABYLON.TransformNode.prototype,{
	__class__: multicube_HollowCube
});
var multicube_MultiCube = function() {
	this.exposureMP = 0;
	this.cubes = [];
	wl_core_Part.call(this);
};
$hxClasses["multicube.MultiCube"] = multicube_MultiCube;
multicube_MultiCube.__name__ = ["multicube","MultiCube"];
multicube_MultiCube.__super__ = wl_core_Part;
multicube_MultiCube.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.lowFilter = { isolate : true, lowLimit : 0, highLimit : 200};
		this.mediumFilter = { isolate : true, lowLimit : 700, highLimit : 1200};
		this.highFilter = { isolate : true, lowLimit : 1000, highLimit : 16000};
		this.analyzer = new wl_sounds_SoundAnalyzer();
		this.analyzer.historySize = 10;
		this.analyzer.filters.push(this.lowFilter);
		this.analyzer.filters.push(this.mediumFilter);
		this.analyzer.filters.push(this.highFilter);
		var rpProp = { };
		rpProp.bloom = true;
		rpProp.chromaticAberration = true;
		rpProp.distort = true;
		rpProp.dof = false;
		rpProp.grain = true;
		rpProp.imageProcessing = true;
		rpProp.sharpen = false;
		rpProp.fxaa = false;
		rpProp.displacement = false;
		this.initPipeline(rpProp);
		this.post.distort.lineHeight = wl_core_Config.RESOLUTION[1] / 60;
		BABYLON.MeshBuilder.CreateBox("",{ width : 300, height : 300, depth : 300, sideOrientation : BABYLON.Mesh.BACKSIDE},this.scene).receiveShadows = true;
		this.light = new BABYLON.PointLight("",BABYLON.Vector3.Zero(),this.scene);
		this.light.diffuse = DemoMain.BASE_1;
		this.light.intensity = 0.6;
		this.light.shadowEnabled = true;
		this.light.position.y = 0;
		this.shadowGenerator = new BABYLON.ShadowGenerator(1024,this.light);
		var redbox = BABYLON.MeshBuilder.CreateBox("",{ width : 5, height : 5, depth : 5});
		redbox.isVisible = false;
		var redmat = new BABYLON.StandardMaterial("",this.scene);
		redmat.diffuseColor = new BABYLON.Color3(1,0,0);
		redbox.material = redmat;
		this.light.parent = redbox;
		var meshes = [];
		meshes.push(wl_util_ExtendedMeshBuilder.CreateHollowCube("",{ width : 5, height : 5, depth : 5, edge : 0.05},this.scene));
		var _g = -3;
		while(_g < 3) {
			var x = _g++;
			var _g1 = -3;
			while(_g1 < 3) {
				var y = _g1++;
				var _g2 = -3;
				while(_g2 < 3) {
					var nbox = wl_util_ExtendedMeshBuilder.CreateHollowCube("",{ width : 5, height : 5, depth : 5, edge : 0.05},this.scene);
					meshes.push(nbox);
					nbox.position = new BABYLON.Vector3(x * 6,y * 6,_g2++ * 6);
				}
			}
		}
		var m = BABYLON.Mesh.MergeMeshes(meshes,true,true);
		var _g3 = 0;
		while(_g3 < meshes.length) {
			var m1 = meshes[_g3];
			++_g3;
			m1.dispose();
		}
		this.shadowGenerator.getShadowMap().renderList.push(m);
		redbox.position.x = -10;
		this.camera.fov = 2.83;
		this.camera.position.z = -20;
		this.camera.position = new BABYLON.Vector3(-89,120,-96);
		createjs.Tween.get(redbox.position,{ loop : true}).to({ x : 10},5000,createjs.Ease.circOut).to({ x : -10},5000,createjs.Ease.sineInOut);
		this.camera.setTarget(this.light.position);
		this.rndcc = new wl_demo_RandomCameraController(this.camera,8,[],97678,[wl_demo_CameraController.LINEAR],[5,15],new BABYLON.BoundingBox(new BABYLON.Vector3(22.01,22.01,22.01),new BABYLON.Vector3(50.3,50.3,50.3)));
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),function(ts) {
			_gthis.rndcc.swap();
			var tmp = wl_util_Random.nextFloat() * 0.8;
			_gthis.camera.fov = tmp + 1.8;
		});
		this.camera.setTarget(this.light.position);
	}
	,start: function(ts) {
		createjs.Tween.get(this).to({ exposureMP : 1},wl_core_TimeSig.milliseconds(1,0,0,0));
		wl_core_Part.prototype.start.call(this,ts);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		this.analyzer.update();
		this.post.grain.intensity = this.lowFilter.max * 30 + 5;
		this.post.chromaticAberration.aberrationAmount = this.mediumFilter.max < 0.6 ? 0 : (this.mediumFilter.max - 0.6) * 120;
		this.post.distort.intensity = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.9) * 0.015;
		this.post.distort.intensityY = this.highFilter.max < 0.5 ? 0 : (this.highFilter.max - 0.7) * 0.015;
		this.post.bloom.bloomWeight = this.lowFilter.max * 20;
		this.post.imageProcessing.vignetteWeight = this.lowFilter.max * 2;
		this.post.imageProcessing.exposure = this.exposureMP * Math.min(1.100,0.7 + Math.max(0,this.lowFilter.min - 0.8) * 2.5) * 2;
	}
	,render: function(ts,frameTime,toScreen) {
		this.rndcc.updateLength(wl_core_TimeSig.milliseconds(1,0,0,0));
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,setupDatGui: function(folder) {
		wl_core_Part.prototype.setupDatGui.call(this,folder);
		var shadowfolder = folder.addFolder("shadows");
		shadowfolder.add(this.shadowGenerator,"useVarianceShadowMap");
		shadowfolder.add(this.shadowGenerator,"usePoissonSampling");
		shadowfolder.add(this.shadowGenerator,"usePercentageCloserFiltering");
		shadowfolder.add(this.shadowGenerator,"useKernelBlur");
		shadowfolder.add(this.shadowGenerator,"useExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"useContactHardeningShadow");
		shadowfolder.add(this.shadowGenerator,"useCloseExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"useBlurVarianceShadowMap");
		shadowfolder.add(this.shadowGenerator,"useBlurExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"useBlurCloseExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"bias");
		var lightfolder = folder.addFolder("light");
		wl_util_DatGuiHelper.addColor(lightfolder,this.light,"diffuse");
		lightfolder.add(this.light,"intensity");
	}
	,__class__: multicube_MultiCube
});
var petetesti_PeteTesti = function() {
	wl_core_Part.call(this);
};
$hxClasses["petetesti.PeteTesti"] = petetesti_PeteTesti;
petetesti_PeteTesti.__name__ = ["petetesti","PeteTesti"];
petetesti_PeteTesti.__super__ = wl_core_Part;
petetesti_PeteTesti.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.BuildingShip();
	}
	,BuildingShip: function() {
		new BABYLON.HemisphericLight("",new BABYLON.Vector3(0,-1,0),this.scene);
		wl_util_builders_SpaceshipBuilder.BuildSpaceShip(this.scene);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: petetesti_PeteTesti
});
var petetesti_Testshader = function() {
	this.uniforms = ["time"];
	this.color = new BABYLON.Color4(1,1,1,1);
	wl_core_ShaderBase.call(this);
	BABYLON.Effect.ShadersStore["testPixelShader"] = haxe_Resource.getString("testshader.frag");
};
$hxClasses["petetesti.Testshader"] = petetesti_Testshader;
petetesti_Testshader.__name__ = ["petetesti","Testshader"];
petetesti_Testshader.__super__ = wl_core_ShaderBase;
petetesti_Testshader.prototype = $extend(wl_core_ShaderBase.prototype,{
	update: function(ts) {
	}
	,__class__: petetesti_Testshader
});
var physicalballcluster_PhysicalBallCluster = function() {
	wl_core_Part.call(this);
};
$hxClasses["physicalballcluster.PhysicalBallCluster"] = physicalballcluster_PhysicalBallCluster;
physicalballcluster_PhysicalBallCluster.__name__ = ["physicalballcluster","PhysicalBallCluster"];
physicalballcluster_PhysicalBallCluster.__super__ = wl_core_Part;
physicalballcluster_PhysicalBallCluster.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var physicsPlugin = new BABYLON.CannonJSPlugin();
		var gravityVector = new BABYLON.Vector3(0,-9.81,0);
		this.scene.enablePhysics(gravityVector,physicsPlugin);
		new BABYLON.HemisphericLight("light1",new BABYLON.Vector3(0,1,0),this.scene).intensity = 0.7;
		this.baseSphere = BABYLON.MeshBuilder.CreateSphere("sphere1",{ diameter : 0.5},this.scene);
		this.baseSphere.position.y = 2;
		var ground = BABYLON.MeshBuilder.CreateGround("ground1",{ width : 12, height : 12},this.scene);
		ground.position.y = -2;
		this.baseSphere.physicsImpostor = new BABYLON.PhysicsImpostor(this.baseSphere,BABYLON.PhysicsImpostor.SphereImpostor,{ mass : 1, restitution : 0.9},this.scene);
		ground.physicsImpostor = new BABYLON.PhysicsImpostor(ground,BABYLON.PhysicsImpostor.BoxImpostor,{ mass : 0, restitution : 0.9},this.scene);
		var boxBase = BABYLON.MeshBuilder.CreateBox("ground1",{ width : 1, height : 1, depth : 1},this.scene);
		var _g = -10;
		while(_g < 10) {
			var x = _g++;
			var _g1 = -10;
			while(_g1 < 10) {
				var box = boxBase.createInstance("");
				var tmp = wl_util_Random.nextFloat();
				box.position.x = x + tmp;
				var tmp1 = wl_util_Random.nextFloat();
				box.position.z = _g1++ + tmp1;
				box.position.y = wl_util_Random.nextFloat();
				box.scaling.y = 1 + box.position.y;
				box.physicsImpostor = new BABYLON.PhysicsImpostor(box,BABYLON.PhysicsImpostor.BoxImpostor,{ mass : 0, restitution : 0.9},this.scene);
			}
		}
		window.document.addEventListener("keydown",$bind(this,this.onKeyDown));
	}
	,onKeyDown: function() {
		var sphere = this.baseSphere.createInstance("");
		var tmp = wl_util_Random.nextFloat() * 20;
		sphere.position.y = 10 + tmp;
		var tmp1 = wl_util_Random.nextFloat() * 12;
		sphere.position.x = 6 - tmp1;
		var tmp2 = wl_util_Random.nextFloat() * 12;
		sphere.position.z = 6 - tmp2;
		sphere.physicsImpostor = new BABYLON.PhysicsImpostor(sphere,BABYLON.PhysicsImpostor.SphereImpostor,{ mass : 1, restitution : 0.9},this.scene);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,setupDatGui: function(folder) {
		wl_core_Part.prototype.setupDatGui.call(this,folder);
	}
	,__class__: physicalballcluster_PhysicalBallCluster
});
var rotocube_HollowCube = function(m,scene) {
	BABYLON.TransformNode.call(this,"",scene);
	m.parent = this;
	this.speed = 0.005 - (0.005 * wl_util_Random.nextFloat() + .002);
};
$hxClasses["rotocube.HollowCube"] = rotocube_HollowCube;
rotocube_HollowCube.__name__ = ["rotocube","HollowCube"];
rotocube_HollowCube.__super__ = BABYLON.TransformNode;
rotocube_HollowCube.prototype = $extend(BABYLON.TransformNode.prototype,{
	__class__: rotocube_HollowCube
});
var rotocube_RotoCube = function() {
	this.exposureMP = 0;
	this.cubes = [];
	wl_core_Part.call(this);
};
$hxClasses["rotocube.RotoCube"] = rotocube_RotoCube;
rotocube_RotoCube.__name__ = ["rotocube","RotoCube"];
rotocube_RotoCube.__super__ = wl_core_Part;
rotocube_RotoCube.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.lowFilter = { isolate : true, lowLimit : 0, highLimit : 200};
		this.mediumFilter = { isolate : true, lowLimit : 700, highLimit : 1200};
		this.highFilter = { isolate : true, lowLimit : 1000, highLimit : 16000};
		this.analyzer = new wl_sounds_SoundAnalyzer();
		this.analyzer.historySize = 10;
		this.analyzer.filters.push(this.lowFilter);
		this.analyzer.filters.push(this.mediumFilter);
		this.analyzer.filters.push(this.highFilter);
		var rpProp = { };
		rpProp.bloom = true;
		rpProp.chromaticAberration = true;
		rpProp.distort = true;
		rpProp.dof = true;
		rpProp.grain = true;
		rpProp.imageProcessing = true;
		rpProp.sharpen = false;
		rpProp.fxaa = false;
		rpProp.displacement = false;
		this.initPipeline(rpProp);
		this.post.grain.animated = true;
		this.post.distort.lineHeight = wl_core_Config.RESOLUTION[1] / 60;
		this.post.imageProcessing.vignetteEnabled = true;
		var room = BABYLON.MeshBuilder.CreateBox("",{ width : 20, height : 20, depth : 20, sideOrientation : BABYLON.Mesh.BACKSIDE},this.scene);
		room.receiveShadows = true;
		var roomMat = new BABYLON.StandardMaterial("",this.scene);
		room.material = roomMat;
		roomMat.diffuseColor = DemoMain.WHITE.scale(0.15);
		this.light = new BABYLON.PointLight("",BABYLON.Vector3.Zero(),this.scene);
		this.light.diffuse = DemoMain.WHITE;
		this.light.intensity = 1.5;
		this.light.shadowEnabled = true;
		this.light.position.y = 5;
		this.light.shadowMinZ = 0.1;
		this.light.shadowMaxZ = 50;
		this.shadowGenerator = new BABYLON.ShadowGenerator(1024,this.light);
		var _g = 1;
		while(_g < 4) {
			var i = _g++;
			var bo = wl_util_ExtendedMeshBuilder.CreateHollowCube("",{ width : 1, height : 1, depth : 1, edge : 0.1},this.scene);
			bo.receiveShadows = false;
			this.shadowGenerator.getShadowMap().renderList.push(bo);
			var hollowcube = new rotocube_HollowCube(bo,this.scene);
			hollowcube.scaling.multiplyInPlace(new BABYLON.Vector3(i,i,i));
			hollowcube.position.copyFrom(this.light.position);
			this.cubes.push(hollowcube);
		}
		this.rndcc = new wl_demo_RandomCameraController(this.camera,8,[],97678,[wl_demo_CameraController.LINEAR],[5,15],new BABYLON.BoundingBox(new BABYLON.Vector3(2.01,2.01,2.01),new BABYLON.Vector3(6.3,6.3,6.3)));
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),function(ts) {
			_gthis.rndcc.swap();
			var tmp = wl_util_Random.nextFloat() * 0.9;
			_gthis.camera.fov = tmp + 0.7;
		});
		this.camera.setTarget(this.light.position);
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		this.rndcc.swap();
		createjs.Tween.get(this).to({ exposureMP : 1},wl_core_TimeSig.milliseconds(1,0,0,0));
	}
	,update: function(ts,partial,frameTime,delta) {
		var _g = 0;
		var _g1 = this.cubes;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			c.rotate(BABYLON.Vector3.Up(),delta * c.speed);
			c.rotate(BABYLON.Vector3.Right(),delta * c.speed);
			c.rotate(BABYLON.Vector3.Forward(),delta * c.speed);
		}
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		this.analyzer.update();
		this.post.grain.intensity = this.lowFilter.max * 30 + 5;
		this.post.chromaticAberration.aberrationAmount = this.mediumFilter.max < 0.6 ? 0 : (this.mediumFilter.max - 0.6) * 120;
		this.post.distort.intensity = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.9) * 0.02;
		this.post.distort.intensityY = this.highFilter.max < 0.5 ? 0 : (this.highFilter.max - 0.7) * 0.02;
		this.post.bloom.bloomWeight = this.lowFilter.max * 10;
		this.post.imageProcessing.vignetteWeight = this.lowFilter.max * 2;
		this.post.imageProcessing.exposure = this.exposureMP * Math.min(1.100,0.7 + Math.max(0,this.lowFilter.min - 0.8) * 2.5);
	}
	,render: function(ts,frameTime,toScreen) {
		this.rndcc.updateLength(wl_core_TimeSig.milliseconds(1,0,0,0));
		this.camera.setTarget(new BABYLON.Vector3(0,6,0));
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,setupDatGui: function(folder) {
		wl_core_Part.prototype.setupDatGui.call(this,folder);
		var shadowfolder = folder.addFolder("shadows");
		shadowfolder.add(this.shadowGenerator,"useVarianceShadowMap");
		shadowfolder.add(this.shadowGenerator,"usePoissonSampling");
		shadowfolder.add(this.shadowGenerator,"usePercentageCloserFiltering");
		shadowfolder.add(this.shadowGenerator,"useKernelBlur");
		shadowfolder.add(this.shadowGenerator,"useExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"useContactHardeningShadow");
		shadowfolder.add(this.shadowGenerator,"useCloseExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"useBlurVarianceShadowMap");
		shadowfolder.add(this.shadowGenerator,"useBlurExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"useBlurCloseExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"bias");
		var lightfolder = folder.addFolder("light");
		wl_util_DatGuiHelper.addColor(lightfolder,this.light,"diffuse");
		lightfolder.add(this.light,"intensity");
	}
	,__class__: rotocube_RotoCube
});
var shatterball_ShatterBallPart = function() {
	wl_core_Part.call(this);
};
$hxClasses["shatterball.ShatterBallPart"] = shatterball_ShatterBallPart;
shatterball_ShatterBallPart.__name__ = ["shatterball","ShatterBallPart"];
shatterball_ShatterBallPart.__super__ = wl_core_Part;
shatterball_ShatterBallPart.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		new BABYLON.HemisphericLight("",BABYLON.Vector3.Down(),this.scene);
		this.emitter = BABYLON.MeshBuilder.CreateSphere("",{ diameter : 4, segments : 20, updatable : true},this.scene);
		this.particleSystem = new BABYLON.ParticleSystem("",50000,this.scene);
		this.particleSystem.particleTexture = wl_core_Assets.getTexture("flare.png");
		this.particleSystem.emitRate = 1500;
		this.particleSystem.emitter = this.emitter;
		this.particleSystem.blendMode = 0;
		this.particleSystem.minAngularSpeed = 0;
		this.particleSystem.maxAngularSpeed = Math.PI;
		this.particleSystem.minEmitPower = 0.5;
		this.particleSystem.maxEmitPower = 1.5;
		this.particleSystem.updateSpeed = 0.005;
		this.particleSystem.createSphereEmitter(2,0.1);
		this.addTrigger(new wl_core_TimeSig(0,0,0,0,wl_core_TimeSig.RELATIVE),function(ts) {
			_gthis.particleSystem.start();
		});
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: shatterball_ShatterBallPart
});
var smokecorridor_SmokeCorridor = function() {
	wl_core_Part.call(this);
};
$hxClasses["smokecorridor.SmokeCorridor"] = smokecorridor_SmokeCorridor;
smokecorridor_SmokeCorridor.__name__ = ["smokecorridor","SmokeCorridor"];
smokecorridor_SmokeCorridor.__super__ = wl_core_Part;
smokecorridor_SmokeCorridor.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		new BABYLON.HemisphericLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		var vertexPosition = "vec3 v = position;" + "v.x += sin(time*0.01) * 0.5*(1.-v.y/110.);" + "v.z += cos(time*0.01) * 0.5*(1.-v.y/110.);" + "positionUpdated = v;";
		this.sleeveMaterial = new BABYLON.CustomMaterial("customMaterial",this.scene);
		this.sleeveMaterial.diffuseColor = new BABYLON.Color3(0.2,0.9,0.4);
		this.sleeveMaterial.AddUniform("time","float");
		this.sleeveMaterial.Vertex_Before_PositionUpdated(vertexPosition);
		this.sleeveMaterial.onBindObservable.add(function(ab,es) {
			_gthis.sleeveMaterial.getEffect().setFloat("time",_gthis.time.toMilliseconds());
		});
		var wireMaterial = new BABYLON.CustomMaterial("customMaterial",this.scene);
		wireMaterial.diffuseColor = new BABYLON.Color3(1,1,1);
		wireMaterial.AddUniform("time","float");
		wireMaterial.Vertex_Before_PositionUpdated(vertexPosition);
		wireMaterial.onBindObservable.add(function(ab1,es1) {
			wireMaterial.getEffect().setFloat("time",_gthis.time.toMilliseconds());
		});
		var n1 = wl_util_builders_ElectricalWireBuilder.BuildExposedWireBunch(10,30,1,10,3,this.sleeveMaterial,wireMaterial,100);
		var n2 = wl_util_builders_ElectricalWireBuilder.BuildExposedWireBunch(20,50,0.8,20,4,this.sleeveMaterial,wireMaterial,100);
		var n3 = wl_util_builders_ElectricalWireBuilder.BuildExposedWireBunch(40,100,3,100,4,this.sleeveMaterial,wireMaterial,100);
		n1.position.x = -40;
		n2.position.x = 0;
		n3.position.x = 100;
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		this.time = ts;
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: smokecorridor_SmokeCorridor
});
var spaceintro_SpaceIntro = function() {
	this.lineChangeDelay = 0;
	this.rndCarret = 0;
	this.carret = 0;
	this.lineCarret = 0;
	this.blinkinCarretFont = "webdings";
	this.blinkingCarretChacter = "g";
	this.introText = ["...","0x28157 [INFO] Object found","0x92991 [INSTRUCTION] End stasis","...","0x92992 [INSTRUCTION] Power up","0x88738 [INSTRUCTION] Activate all systems","0xff102 [CRITICAL] Power lost","0xff102 [ERROR] Life support failed","0xfefda [ERROR] Assembly failed","0xff039 [INSTRUCTION] Initialize Protocol 'Last Resort'"];
	wl_core_Part.call(this);
};
$hxClasses["spaceintro.SpaceIntro"] = spaceintro_SpaceIntro;
spaceintro_SpaceIntro.__name__ = ["spaceintro","SpaceIntro"];
spaceintro_SpaceIntro.__super__ = wl_core_Part;
spaceintro_SpaceIntro.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		BABYLON.MeshBuilder.CreateBox("",{ width : 2600, height : 2600, depth : 2600, sideOrientation : BABYLON.Mesh.BACKSIDE},this.scene);
		this.initSyncedPipeline(null);
		this.initSceneboard();
		new BABYLON.DirectionalLight("light1",new BABYLON.Vector3(0,-1,2),this.scene).intensity = 0.3;
		this.scene.clearColor = new BABYLON.Color4(0.25,0,0,1);
		this.spaceShip = new BABYLON.TransformNode("spaceship",this.scene);
		var textPlane = BABYLON.MeshBuilder.CreatePlane("textplane",{ width : 20, height : 15},this.scene);
		this.textTexture = new BABYLON.DynamicTexture("introText",{ width : 1200, height : 900},this.scene,false);
		var mat = new BABYLON.StandardMaterial("mat",this.scene);
		mat.diffuseTexture = this.textTexture;
		this.textTexture.drawText("",null,null,"10px arial bold","#000000","#000000",true);
		textPlane.material = mat;
		mat.specularColor = new BABYLON.Color3(0,0,0);
		mat.emissiveColor = new BABYLON.Color3(0.0,0.2,0.0);
		mat.emissiveTexture = this.textTexture;
		mat.specularPower = 0;
		var monitorMat = new BABYLON.PBRMaterial("monitor material",this.scene);
		monitorMat.metallic = 0;
		monitorMat.specularIntensity = 0;
		var monitor = wl_util_ExtendedMeshBuilder.createSinkBox(24,19,25,0.8,5,this.scene);
		monitor.material = monitorMat;
		textPlane.parent = monitor;
		monitor.position.z = 13;
		monitor.position.y = 2;
		this.light = new BABYLON.PointLight("",new BABYLON.Vector3(0,10,-5),this.scene);
		this.light.intensity = 0.02;
		this.light.diffuse = new BABYLON.Color3(1,1,1);
		this.light.radius = 80;
		textPlane.position.y = -0.5;
		textPlane.position.z = -12.13;
		monitor.rotate(BABYLON.Vector3.Right(),Math.PI / 180 * 15);
		var plane2 = BABYLON.MeshBuilder.CreatePlane("textplane",{ width : 20, height : 15},this.scene);
		var mat2 = new BABYLON.StandardMaterial("monitor2",this.scene);
		plane2.material = mat2;
		mat2.diffuseColor = new BABYLON.Color3(0,0.2,0);
		var monitor2 = wl_util_ExtendedMeshBuilder.createSinkBox(24,19,25,0.8,5,this.scene);
		monitor2.material = monitorMat;
		plane2.parent = monitor2;
		monitor2.position.x = -30;
		monitor2.position.z = 13;
		monitor2.position.y = 2;
		plane2.position.y = -0.5;
		plane2.position.z = -12.13;
		monitor2.rotate(BABYLON.Vector3.Right(),Math.PI / 180 * 15);
		var plane3 = BABYLON.MeshBuilder.CreatePlane("textplane",{ width : 20, height : 15},this.scene);
		var mat3 = new BABYLON.StandardMaterial("monitor2",this.scene);
		mat3.diffuseColor = new BABYLON.Color3(0,0.0,0.5);
		plane3.material = mat3;
		var monitor3 = wl_util_ExtendedMeshBuilder.createSinkBox(24,19,25,0.8,5,this.scene);
		monitor3.material = monitorMat;
		plane3.parent = monitor3;
		monitor3.position.x = 30;
		monitor3.position.z = 13;
		monitor3.position.y = 2;
		plane3.position.y = -0.5;
		plane3.position.z = -12.13;
		monitor3.rotate(BABYLON.Vector3.Right(),Math.PI / 180 * 15);
		this.cockpit = wl_util_builders_CockpitBuilder.BuildCockpit(this.scene);
		this.cockpit.position.z = 10;
		this.cockpit.position.y = -4;
		this.window = this.cockpit.getChildren(function(n) {
			return n.name == "window-front";
		})[0];
		this.window.material.alpha = 0.6;
		this.cockpit.parent = this.spaceShip;
		monitor.parent = this.spaceShip;
		monitor2.parent = this.spaceShip;
		monitor3.parent = this.spaceShip;
		this.space = new henri19_SpaceSphere("spaceshpere",this.scene);
		var trailPoints = [];
		var _g = 0;
		while(_g < 50) {
			++_g;
			trailPoints.push(new BABYLON.Vector3(wl_util_Random.nextFloat() * 320,wl_util_Random.nextFloat() * 320,120 + wl_util_Random.nextFloat() * 210));
		}
		var trailEmitter = BABYLON.MeshBuilder.CreateBox("",{ },this.scene);
		trailEmitter.visibility = 0;
		this.trailController = new wl_demo_TransformNodeController(trailEmitter);
		this.trailController.initBezier(trailPoints,trailPoints);
		new BABYLON.PointLight("trail light",new BABYLON.Vector3(0,0,0),this.scene).parent = trailEmitter;
		var trail = new BABYLON.TrailMesh("new",trailEmitter,this.scene,1.5,600,true);
		var trailmat = new BABYLON.StandardMaterial("trailmat",this.scene);
		trailmat.emissiveColor = BABYLON.Color3.White();
		trailmat.diffuseColor = BABYLON.Color3.White();
		trailmat.specularColor = BABYLON.Color3.White();
		trail.material = trailmat;
		this.mixfilter = new wl_post_texturemix_TextureMix(this.camera,this.scene.getEngine());
		this.camera.attachPostProcess(this.mixfilter);
		this.mixfilter.phase = 3.0;
		var gl = new BABYLON.GlowLayer("glow",this.scene,{ mainTextureSamples : 2});
		gl.isEnabled = true;
		gl.intensity = 0.3;
		this.addTrigger(new wl_core_TimeSig(38,0,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.onexit));
	}
	,onexit: function(ts) {
		createjs.Tween.get(this).to({ exposureTarget : -5},wl_core_TimeSig.milliseconds(2,0,0,0));
		createjs.Tween.get(this.post.distort).to({ brightness : -3},wl_core_TimeSig.milliseconds(2,0,0,0));
	}
	,blinkCarret: function(ts) {
		this.blink(this.blinkingCarretChacter);
	}
	,clearBlinkCarrect: function(ts) {
		this.blink("");
	}
	,startDemo: function(ts) {
		console.log("Start demo");
		this.removeTrigger($bind(this,this.blinkCarret),null);
		this.removeTrigger($bind(this,this.clearBlinkCarrect),null);
		this.startTextInput(ts);
	}
	,blink: function(text) {
		this.textTexture.drawText(text,32,64,"bold 20px webdings","#00ff00","#000000",true);
	}
	,startTextInput: function(ts) {
		var _g = 0;
		while(_g < 12) this.addTrigger(new wl_core_TimeSig(-1,-1,_g++,0,wl_core_TimeSig.PATTERN),$bind(this,this.writeText));
	}
	,postInit: function() {
		wl_core_Part.prototype.postInit.call(this);
		this.mixfilter.set_mixTo(wl_core_Demo.instance.getPart("intro.Intro2"));
	}
	,writeText: function(ts) {
		var _g = 0;
		while(_g < 6) {
			++_g;
			this.lineChangeDelay--;
			if(this.lineChangeDelay >= 0) {
				return;
			}
			var yOffset = 64 + 21 * this.lineCarret;
			var xOffset = 42 + 17 * this.carret;
			var text = "";
			if(!this.introDone && this.lineCarret < this.introText.length) {
				text = this.introText[this.lineCarret];
			} else {
				text = spaceintro_SpaceIntro.loopText[(this.lineCarret + this.rndCarret) % spaceintro_SpaceIntro.loopText.length];
			}
			this.textTexture.drawText(text.charAt(this.carret),xOffset,yOffset,"bold 20px robotoregular","#00ff00",null,true);
			this.carret++;
			if(this.carret >= text.length) {
				this.lineCarret++;
				this.lineChangeDelay = 4;
				this.carret = 0;
				if(this.lineCarret > 38) {
					this.lineCarret = 0;
					this.introDone = true;
					this.textTexture.drawText("",xOffset,yOffset,"bold 20px robotoregular","#00ff00","#000000",true);
				}
			}
		}
	}
	,initSceneboard: function() {
		this.storyboard = new wl_demo_SceneBoard();
		var controller1 = new wl_demo_CameraController(this.camera);
		controller1.initLinear([new BABYLON.Vector3(-37,15,-93),new BABYLON.Vector3(-35,18,-70)],[new BABYLON.Vector3(-3.55,6,5),new BABYLON.Vector3(0.55,5,12)]);
		var controller2 = new wl_demo_CameraController(this.camera);
		controller2.initLinear([new BABYLON.Vector3(10,10,-10),new BABYLON.Vector3(12,29,-11)],[new BABYLON.Vector3(1.55,5,5),new BABYLON.Vector3(0.55,15,12)]);
		this.storyboard.add(new wl_core_TimeSig(0,0,0,0,wl_core_TimeSig.RELATIVE),new wl_core_TimeSig(8,0,0,0,wl_core_TimeSig.RELATIVE),controller1);
		this.storyboard.add(new wl_core_TimeSig(8,0,0,0,wl_core_TimeSig.RELATIVE),new wl_core_TimeSig(16,0,0,0,wl_core_TimeSig.RELATIVE),controller2);
		this.storyboard.BoardItems[0].Run(this.storyboard.BoardItems[0].startTime);
	}
	,start: function(ts) {
		var _gthis = this;
		wl_core_Part.prototype.start.call(this,ts);
		this.startDemo(ts);
		this.storyboard.start(ts);
		var tmp = createjs.Tween.get(this.camera).wait(wl_core_TimeSig.milliseconds(1,0,0,0));
		var tmp1 = wl_core_TimeSig.milliseconds(1,0,0,0);
		var tmp2 = createjs.Ease.getBackOut(0.5);
		tmp.to({ fov : 0.19},tmp1,tmp2);
		createjs.Tween.get(this.mixfilter).to({ phase : 0},wl_core_TimeSig.milliseconds(2,0,0,0));
		this.addTrigger(new wl_core_TimeSig(8,0,0,0,wl_core_TimeSig.RELATIVE),function(ts1) {
			_gthis.camera.fov = 0.88;
		});
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		this.storyboard.update(ts,partial,frameTime,delta);
		this.space.mesh.rotation.y = ts.toMilliseconds() / wl_core_TimeSig.milliseconds(4,0,0,0) * 0.3 + 0.7;
		this.space.mesh.rotation.z = 2.;
		this.space.mesh.rotation.x = ts.toMilliseconds() / wl_core_TimeSig.milliseconds(2,0,0,0) * 0.4 + 1.1;
		this.trailController.update(ts.toMilliseconds() / wl_core_TimeSig.milliseconds(12,0,0,0));
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: spaceintro_SpaceIntro
});
var whiteroom_ChainWR = function(p1,pc,p2,scale,scene) {
	this.links = [];
	this.start = p1;
	this.control = pc;
	this.target = p2;
	var anchor1 = BABYLON.MeshBuilder.CreateSphere("anchor",{ diameter : 0.5},scene);
	anchor1.position.copyFrom(p1);
	anchor1.visibility = 0.0;
	anchor1.dispose();
	var linkMesh = this.buildLink(scene);
	linkMesh.scaling.copyFrom(scale);
	linkMesh.bakeCurrentTransformIntoVertices();
	var bb = linkMesh.getBoundingInfo().boundingBox;
	var count = Math.ceil(BABYLON.Curve3.CreateQuadraticBezier(p1,pc,p2,Math.ceil(BABYLON.Vector3.Distance(p1,p2) / (bb.maximum.y - bb.minimum.y) * 1.4)).length() / (bb.maximum.y - bb.minimum.y) * 1.4);
	var directionCurve = BABYLON.Curve3.CreateQuadraticBezier(p1,pc,p2,count);
	var _g1 = 0;
	while(_g1 < count) {
		var i = _g1++;
		var il = linkMesh.createInstance("");
		var node = new BABYLON.TransformNode("",scene);
		il.parent = node;
		il.position.copyFrom(BABYLON.Vector3.Zero());
		var points = directionCurve.getPoints();
		node.position.copyFrom(points[i]);
		node.lookAt(i < points.length - 1 ? points[i + 1] : p2);
		if(i % 2 == 1) {
			il.rotate(BABYLON.Vector3.Up(),Math.PI * 0.5);
			il.rotate(BABYLON.Vector3.Forward(),Math.PI / 2);
		} else {
			il.rotate(BABYLON.Vector3.Right(),Math.PI / 2);
		}
		this.links.push(node);
	}
};
$hxClasses["whiteroom.ChainWR"] = whiteroom_ChainWR;
whiteroom_ChainWR.__name__ = ["whiteroom","ChainWR"];
whiteroom_ChainWR.prototype = {
	updateChain: function() {
		var directionCurve = BABYLON.Curve3.CreateQuadraticBezier(this.start,this.control,this.target,this.links.length);
		var i = 0;
		var _g = 0;
		var _g1 = this.links;
		while(_g < _g1.length) {
			var node = _g1[_g];
			++_g;
			var points = directionCurve.getPoints();
			node.position.copyFrom(points[i]);
			node.lookAt(i < points.length - 1 ? points[i + 1] : this.target);
			++i;
		}
	}
	,buildLink: function(scene) {
		var points = [new BABYLON.Vector3(0.1,0.07,0)];
		var curve = BABYLON.Curve3.CreateCubicBezier(new BABYLON.Vector3(0.1,0.18,0),new BABYLON.Vector3(0.1,0.28,0),new BABYLON.Vector3(-0.1,0.28,0),new BABYLON.Vector3(-0.1,0.18,0),6);
		points = points.concat(curve.getPoints());
		curve = BABYLON.Curve3.CreateCubicBezier(new BABYLON.Vector3(-0.1,-0.18,0),new BABYLON.Vector3(-0.1,-0.28,0),new BABYLON.Vector3(0.1,-0.28,0),new BABYLON.Vector3(0.1,-0.18,0),6);
		points = points.concat(curve.getPoints());
		points.push(points[0].subtract(new BABYLON.Vector3(0,0.015,0)));
		var linkMesh = BABYLON.MeshBuilder.CreateTube("Chain-Link",{ radius : 0.04, path : points, cap : 3, tessellation : 6},scene);
		whiteroom_ChainWR.linkmaterial = wl_library_Library.get_instance().getMaterial(wl_library_Materials.ghost2,true);
		whiteroom_ChainWR.linkmaterial.fresnelopacity = whiteroom_ChainWR.linkmaterial.opacityFresnelParameters;
		whiteroom_ChainWR.linkmaterial.alpha = 1.0;
		linkMesh.material = whiteroom_ChainWR.linkmaterial;
		linkMesh.setEnabled(false);
		return linkMesh;
	}
	,ghost: function() {
		whiteroom_ChainWR.linkmaterial.alpha = 0.1;
		whiteroom_ChainWR.linkmaterial.emissiveColor = new BABYLON.Color3(1,1,1);
		whiteroom_ChainWR.linkmaterial.opacityFresnelParameters = whiteroom_ChainWR.linkmaterial.fresnelopacity;
	}
	,normalize: function() {
		whiteroom_ChainWR.linkmaterial.alpha = 1.0;
		whiteroom_ChainWR.linkmaterial.emissiveColor = new BABYLON.Color3(0,0,0);
		whiteroom_ChainWR.linkmaterial.opacityFresnelParameters = null;
	}
	,__class__: whiteroom_ChainWR
};
var whiteroom_ReflectiveBall = function(name,scene,isPure) {
	BABYLON.TransformNode.call(this,name,scene,isPure);
	this.material = new BABYLON.StandardMaterial("rballmat",scene);
	this.mesh = BABYLON.MeshBuilder.CreateIcoSphere("rball",{ radius : 1, subdivisions : 4},scene);
	this.mesh.material = this.material;
	this.material.diffuseColor = DemoMain.BASE_3.clone();
	this.material.emissiveColor = DemoMain.BASE_1.clone().scale(0.1);
	this.material.ambientColor = DemoMain.BASE_2.clone();
	this.mesh.parent = this;
};
$hxClasses["whiteroom.ReflectiveBall"] = whiteroom_ReflectiveBall;
whiteroom_ReflectiveBall.__name__ = ["whiteroom","ReflectiveBall"];
whiteroom_ReflectiveBall.__super__ = BABYLON.TransformNode;
whiteroom_ReflectiveBall.prototype = $extend(BABYLON.TransformNode.prototype,{
	__class__: whiteroom_ReflectiveBall
});
var whiteroom_WallCube = function() {
	this.level = 0;
	this.levels = [];
	BABYLON.TransformNode.call(this,"");
	if(whiteroom_WallCube.innerMeshes == null) {
		whiteroom_WallCube.innerMeshes = [];
		var cols = [DemoMain.WHITE.clone().scale(1)];
		var _g = 0;
		while(_g < 1) {
			var innerMesh = BABYLON.MeshBuilder.CreateBox("box",{ width : 1, height : 1, depth : 1},null);
			var innermat = new BABYLON.StandardMaterial("",null);
			innermat.diffuseColor = cols[_g++ % cols.length];
			innermat.ambientColor = BABYLON.Color3.White();
			innerMesh.material = innermat;
			innerMesh.isVisible = false;
			innerMesh.receiveShadows = false;
			whiteroom_WallCube.innerMeshes.push(innerMesh);
		}
	}
	var s = 1;
	var _g1 = 0;
	while(_g1 < 40) {
		++_g1;
		this.levels.push(s);
		s += wl_util_Random.nextFloat() > 0.2 ? 0 : 0.5;
		if(s < 0) {
			s = 0;
		}
	}
	var innersphere = whiteroom_WallCube.innerMeshes[wl_util_Random.next() % 1].createInstance("");
	innersphere.setParent(this);
	this.mesh = innersphere;
};
$hxClasses["whiteroom.WallCube"] = whiteroom_WallCube;
whiteroom_WallCube.__name__ = ["whiteroom","WallCube"];
whiteroom_WallCube.__super__ = BABYLON.TransformNode;
whiteroom_WallCube.prototype = $extend(BABYLON.TransformNode.prototype,{
	__class__: whiteroom_WallCube
});
var whiteroom_WhiteRoom = function() {
	this.startedBar = 0;
	this.cubesZ = [];
	this.cubesY = [];
	this.cubesX = [];
	this.ambientAmount = 0;
	this.balls = [];
	wl_core_Part.call(this);
};
$hxClasses["whiteroom.WhiteRoom"] = whiteroom_WhiteRoom;
whiteroom_WhiteRoom.__name__ = ["whiteroom","WhiteRoom"];
whiteroom_WhiteRoom.__super__ = wl_core_Part;
whiteroom_WhiteRoom.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.lowFilter = { isolate : true, lowLimit : 0, highLimit : 200};
		this.mediumFilter = { isolate : true, lowLimit : 400, highLimit : 1000};
		this.highFilter = { isolate : true, lowLimit : 1000, highLimit : 16000};
		this.analyzer = new wl_sounds_SoundAnalyzer();
		this.analyzer.historySize = 10;
		this.analyzer.filters.push(this.lowFilter);
		this.analyzer.filters.push(this.mediumFilter);
		this.analyzer.filters.push(this.highFilter);
		var xvals = [0.7,0,0.2,0.8,0.3,0.0,0.5,0.6,0.7];
		var zvals = [0.0,0.2,0.7,0.5,0.1,0.8,0.0,0.1,0.3];
		var _g1 = 0;
		var _g = zvals.length;
		while(_g1 < _g) {
			var i = _g1++;
			var xp = (xvals[i] - 0.5) * 30;
			var zp = (zvals[i] - 0.5) * 30;
			new whiteroom_ChainWR(new BABYLON.Vector3(xp,-20,zp),new BABYLON.Vector3(xp + 1,0,zp),new BABYLON.Vector3(xp,20,zp),new BABYLON.Vector3(2,2,2),this.scene);
		}
		var _g11 = 0;
		while(_g11 < 9) {
			var y = _g11++;
			var _g3 = 0;
			while(_g3 < 9) {
				var x = _g3++;
				var _g5 = 0;
				while(_g5 < 9) {
					var z = _g5++;
					if((z == 0 || z == 8) && (x > 0 && x < 8) && (y > 0 && y < 8) || (y == 0 || y == 8) && (z > 0 && z < 8) && (x > 0 && x < 8) || (x == 0 || x == 8) && (z > 0 && z < 8) && (y > 0 && y < 8)) {
						var b = new whiteroom_WallCube();
						b.scaling.set(wl_util_Random.nextFloat(),wl_util_Random.nextFloat(),wl_util_Random.nextFloat());
						b.position.set(x - 4.5,y - 4.5,z - 4.5);
						this.scene.addTransformNode(b);
						this.balls.push(b);
						if(x == 0 || x == 8) {
							this.cubesX.push(b);
						}
						if(y == 0 || y == 8) {
							this.cubesY.push(b);
						}
						if(z == 0 || z == 8) {
							this.cubesZ.push(b);
						}
					}
				}
			}
		}
		this.light = new BABYLON.DirectionalLight("pl",new BABYLON.Vector3(),this.scene);
		this.light.intensity = 0.2;
		this.light.diffuse = DemoMain.WHITE.clone();
		this.light.specular = DemoMain.BASE_1.clone();
		this.light2 = new BABYLON.DirectionalLight("pl",new BABYLON.Vector3(),this.scene);
		this.light2.intensity = 0.2;
		this.light2.diffuse = DemoMain.WHITE.clone();
		this.light2.specular = DemoMain.BASE_1.clone();
		this.scene.fogMode = BABYLON.Scene.FOGMODE_EXP;
		this.scene.fogDensity = 0.025;
		this.scene.fogColor = DemoMain.BLACK.clone();
		this.scene.clearColor = DemoMain.WHITE.clone();
		this.camera.minZ = 0.01;
		var _g2 = 0;
		var _g12 = this.balls;
		while(_g2 < _g12.length) ++_g2;
		this.glowCube = BABYLON.MeshBuilder.CreateSphere("box",{ diameter : 145, sideOrientation : BABYLON.Mesh.DOUBLESIDE},null);
		var glowMat = new BABYLON.StandardMaterial("",null);
		glowMat.diffuseColor = DemoMain.BLACK.clone();
		glowMat.ambientColor = DemoMain.BLACK.clone();
		glowMat.emissiveColor = DemoMain.BLACK.clone().scale(0.000);
		this.glowCube.material = glowMat;
		this.scene.addMesh(this.glowCube);
		this.scene.ambientColor = DemoMain.WHITE.clone();
		var rpProp = { };
		rpProp.bloom = true;
		rpProp.chromaticAberration = true;
		rpProp.distort = true;
		rpProp.dof = true;
		rpProp.grain = true;
		rpProp.imageProcessing = true;
		rpProp.sharpen = false;
		rpProp.fxaa = false;
		rpProp.displacement = false;
		this.initPipeline(rpProp);
		this.post.distort.lineHeight = wl_core_Config.RESOLUTION[1] / 50;
		this.post.grain.intensity = 10;
		this.post.grain.animated = true;
		this.post.bloom.bloomThreshold = 0.9;
		this.post.chromaticAberration.aberrationAmount = 1;
		this.post.dof.focalLength = 80;
		this.post.dof.focusDistance = 4000;
		this.post.imageProcessing.vignetteEnabled = true;
		this.camera.fov = 1.4;
		this.camera.position.x = -9 / 4.2;
		this.camera.position.y = -9 / 4.2;
		this.camera.position.z = -9 / 4.2;
		this.camera.setTarget(new BABYLON.Vector3());
		this.addTrigger(new wl_core_TimeSig(-1,-1,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.onBar));
		var tmp = wl_util_Random.nextFloat() - 0.5;
		this.light.direction.x = tmp * 3;
		var tmp1 = wl_util_Random.nextFloat() - 0.5;
		this.light.direction.y = tmp1 * 3;
		var tmp2 = wl_util_Random.nextFloat() - 0.5;
		this.light.direction.z = tmp2 * 3;
		var tmp3 = wl_util_Random.nextFloat() - 0.5;
		this.light2.direction.x = tmp3 * 3;
		var tmp4 = wl_util_Random.nextFloat() - 0.5;
		this.light2.direction.y = tmp4 * 3;
		var tmp5 = wl_util_Random.nextFloat() - 0.5;
		this.light2.direction.z = tmp5 * 3;
		this.rndcc = new wl_demo_RandomCameraController(this.camera,8,[],97678,[wl_demo_CameraController.LINEAR],[0,5],new BABYLON.BoundingBox(new BABYLON.Vector3(0.01,0.01,0.01),new BABYLON.Vector3(2.3,2.3,2.3)));
		this.rndcc2 = new wl_demo_RandomCameraController(this.camera,8,[],4627,[wl_demo_CameraController.BEZIER],[7,30],new BABYLON.BoundingBox(new BABYLON.Vector3(-10,-10,5.0),new BABYLON.Vector3(10,10,8)));
		this.rndcc3 = new wl_demo_RandomCameraController(this.camera,8,[],246,[wl_demo_CameraController.BEZIER],[7,30],new BABYLON.BoundingBox(new BABYLON.Vector3(-10,-10,7.0),new BABYLON.Vector3(10,10,12)));
		var _g4 = 0;
		var _g13 = this.rndcc.ccs;
		while(_g4 < _g13.length) {
			var cc = _g13[_g4];
			++_g4;
			cc.updateLook = false;
		}
		this.ccs = [new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera)];
		this.ccs[0].initBezier([new BABYLON.Vector3(7,0,-2),new BABYLON.Vector3(5,0,2.5)],[new BABYLON.Vector3(0,0,0),new BABYLON.Vector3(0,0,2)]);
		this.ccs[1].initBezier([new BABYLON.Vector3(15,0,0),new BABYLON.Vector3(10,0,0)],[new BABYLON.Vector3(0,0,0),new BABYLON.Vector3(0,0,0)]);
		this.ccs[2].initBezier([new BABYLON.Vector3(15,0,0),new BABYLON.Vector3(10,0,0)],[new BABYLON.Vector3(0,0,0),new BABYLON.Vector3(0,0,0)]);
		this.ccs[3].initBezier([new BABYLON.Vector3(15,0,0),new BABYLON.Vector3(10,0,0)],[new BABYLON.Vector3(0,0,0),new BABYLON.Vector3(0,0,0)]);
	}
	,onBar: function(ts) {
		if(ts.beat % 2 == 0) {
			if(ts.beat == 0) {
				this.rndcc.swap();
				this.rndcc2.swap();
				this.rndcc3.swap();
				this.camera.setTarget(new BABYLON.Vector3(wl_util_Random.nextFloat(),wl_util_Random.nextFloat(),wl_util_Random.nextFloat()));
			}
			var tmp = wl_util_Random.nextFloat() - 0.5;
			this.light.direction.x = tmp * 3;
			var tmp1 = wl_util_Random.nextFloat() - 0.5;
			this.light.direction.y = tmp1 * 3;
			var tmp2 = wl_util_Random.nextFloat() - 0.5;
			this.light.direction.z = tmp2 * 3;
			var tmp3 = wl_util_Random.nextFloat() - 0.5;
			this.light2.direction.x = tmp3 * 3;
			var tmp4 = wl_util_Random.nextFloat() - 0.5;
			this.light2.direction.y = tmp4 * 3;
			var tmp5 = wl_util_Random.nextFloat() - 0.5;
			this.light2.direction.z = tmp5 * 3;
			var nc1 = new BABYLON.Vector3(this.light.direction.x + (wl_util_Random.nextFloat() - 0.5) * 0.25,this.light.direction.y + (wl_util_Random.nextFloat() - 0.5) * 0.25,this.light.direction.z + (wl_util_Random.nextFloat() - 0.5) * 0.25);
			var nc2 = new BABYLON.Vector3(this.light2.direction.x + (wl_util_Random.nextFloat() - 0.5) * 0.25,this.light2.direction.y + (wl_util_Random.nextFloat() - 0.5) * 0.25,this.light2.direction.z + (wl_util_Random.nextFloat() - 0.5) * 0.25);
			createjs.Tween.get(this.light.direction).to({ x : nc1.x, y : nc1.y, z : nc1.z},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.quadInOut);
			createjs.Tween.get(this.light2.direction).to({ x : nc2.x, y : nc2.y, z : nc2.z},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.quadInOut);
			var _g = 0;
			var _g1 = this.cubesX;
			while(_g < _g1.length) {
				var b = _g1[_g];
				++_g;
				createjs.Tween.get(b.scaling).to({ x : b.levels[Math.min(b.levels.length,b.level++)]},wl_core_TimeSig.milliseconds(0,1,0,0));
			}
			var _g2 = 0;
			var _g11 = this.cubesY;
			while(_g2 < _g11.length) {
				var b1 = _g11[_g2];
				++_g2;
				createjs.Tween.get(b1.scaling).to({ y : b1.levels[Math.min(b1.levels.length,b1.level++)]},wl_core_TimeSig.milliseconds(0,1,0,0));
			}
			var _g3 = 0;
			var _g12 = this.cubesZ;
			while(_g3 < _g12.length) {
				var b2 = _g12[_g3];
				++_g3;
				createjs.Tween.get(b2.scaling).to({ z : b2.levels[Math.min(b2.levels.length,b2.level++)]},wl_core_TimeSig.milliseconds(0,1,0,0));
			}
			this.ambientAmount = 1;
			this.updateAmbient();
			createjs.Tween.get(this,{ onChange : $bind(this,this.updateAmbient)}).wait(wl_core_TimeSig.milliseconds(0,1,0,0)).to({ ambientAmount : 0.5},wl_core_TimeSig.milliseconds(0,1,0,0),createjs.Ease.quadOut);
		}
	}
	,updateAmbient: function() {
		var intensity = createjs.Ease.quadOut(this.ambientAmount);
		var tmp = DemoMain.WHITE.clone();
		this.glowCube.material.emissiveColor = tmp.scale(intensity * 0.05);
		var tmp1 = createjs.Ease.quadOut(this.ambientAmount);
		this.scene.ambientColor.r = tmp1 * 0.0;
		var tmp2 = createjs.Ease.quadOut(this.ambientAmount);
		this.scene.ambientColor.g = tmp2 * 0.0;
		var tmp3 = createjs.Ease.quadOut(this.ambientAmount);
		this.scene.ambientColor.b = tmp3 * 0.0;
		this.light.intensity = intensity;
		this.light2.intensity = intensity;
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		this.startedBar = ts.bar;
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		if(ts.bar - this.startedBar < 8) {
			if(ts.bar % 2 == 0) {
				this.rndcc.updateLength(wl_core_TimeSig.milliseconds(2,0,0,0));
			} else {
				this.rndcc2.updateLength(wl_core_TimeSig.milliseconds(2,0,0,0));
			}
		} else {
			this.rndcc3.updateLength(wl_core_TimeSig.milliseconds(2,0,0,0));
		}
		this.analyzer.update();
		this.post.grain.intensity = this.lowFilter.max * 30 + 5;
		this.post.chromaticAberration.aberrationAmount = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.8) * 120;
		this.post.bloom.bloomWeight = this.lowFilter.max * 2;
		this.post.imageProcessing.vignetteWeight = this.lowFilter.max;
		this.post.distort.intensity = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.9) * 0.04;
		this.post.distort.intensityY = this.highFilter.max < 0.5 ? 0 : (this.highFilter.max - 0.5) * 0.03;
		this.post.imageProcessing.exposure = Math.min(1.100,0.7 + Math.max(0,this.lowFilter.min - 0.8) * 2.5);
		this.post.imageProcessing.exposure = 0.9;
		this.post.imageProcessing.contrast = 1.9 + this.lowFilter.max;
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: whiteroom_WhiteRoom
});
var wl_core_Assets = $hx_exports["kvg"]["core"]["assets"] = function() {
};
$hxClasses["wl.core.Assets"] = wl_core_Assets;
wl_core_Assets.__name__ = ["wl","core","Assets"];
wl_core_Assets.register = function(id,type,data,compressed) {
	if(compressed) {
		throw new js__$Boot_HaxeError("Compression not implemented.");
	}
	if(type == "png" || type == "jpg") {
		var img = new Image();
		img.src = "data:image/" + (type == "jpg" ? "jpeg" : type) + ";base64," + data;
		var _this = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this.setReserved(id,img);
		} else {
			_this.h[id] = img;
		}
	} else if(type == "mp3" || type == "ogg") {
		var _this1 = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this1.setReserved(id,data);
		} else {
			_this1.h[id] = data;
		}
	} else if(type == "json") {
		var _this2 = wl_core_Assets._assets;
		var value = JSON.parse(data);
		if(__map_reserved[id] != null) {
			_this2.setReserved(id,value);
		} else {
			_this2.h[id] = value;
		}
	} else if(type == "object") {
		var _this3 = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this3.setReserved(id,data);
		} else {
			_this3.h[id] = data;
		}
	}
};
wl_core_Assets.get = function(id) {
	var _this = wl_core_Assets._assets;
	if(!(__map_reserved[id] != null ? _this.existsReserved(id) : _this.h.hasOwnProperty(id))) {
		console.log("Asset " + id + " not found");
	}
	var _this1 = wl_core_Assets._assets;
	if(__map_reserved[id] != null) {
		return _this1.getReserved(id);
	} else {
		return _this1.h[id];
	}
};
wl_core_Assets.getTexture = function(id,noMipmap) {
	var img = wl_core_Assets.get(id);
	if(img == null) {
		throw new js__$Boot_HaxeError("Texture " + id + " not found.");
	}
	return new BABYLON.Texture(img.src,null,noMipmap);
};
wl_core_Assets.prototype = {
	__class__: wl_core_Assets
};
var wl_core_Config = $hx_exports["wl"]["Config"] = function() {
	throw new js__$Boot_HaxeError("Config is static only.");
};
$hxClasses["wl.core.Config"] = wl_core_Config;
wl_core_Config.__name__ = ["wl","core","Config"];
wl_core_Config.prototype = {
	__class__: wl_core_Config
};
var wl_core_Demo = $hx_exports["Demo"] = function() {
	this.waitingFirstFrame = true;
	this.allowUpdate = false;
	this.previousUpdate = 0;
	this.partMap = new haxe_ds_StringMap();
	wl_core_Demo.instance = this;
};
$hxClasses["wl.core.Demo"] = wl_core_Demo;
wl_core_Demo.__name__ = ["wl","core","Demo"];
wl_core_Demo.prototype = {
	getPart: function(name) {
		var _this = this.partMap;
		if(__map_reserved[name] != null) {
			return _this.getReserved(name);
		} else {
			return _this.h[name];
		}
	}
	,getParts: function() {
		return this.parts;
	}
	,init: function(container,callback) {
		var _gthis = this;
		this.onUpdate = new wl_core_Signal();
		this.partChanged = new wl_core_Signal();
		wl_util_Random.init(wl_core_Config.SEED);
		this.graphics = new wl_core_Graphics(container);
		wl_sounds_SoundWL.onSoundComplete.connect($bind(this,this.onSoundEnd));
		container.appendChild(this.graphics.canvas);
		haxe_Timer.delay(function() {
			_gthis.previousTS = wl_core_TimeSig.create(0);
			_gthis.graphics.onRender.connect($bind(_gthis,_gthis.onRender));
			_gthis.initializeParts();
			if(wl_core_Config.DEBUG) {
				_gthis.initializeDebug();
			}
			createjs.Ticker.setPaused(true);
			callback();
		},100);
	}
	,initDemoComposer: function() {
	}
	,onSoundEnd: function() {
		this.end();
	}
	,initializeDebug: function() {
		wl_debug_Debug.init(this);
		wl_debug_ManualControl.init();
		this.graphics.canvas.classList.add("debugCanvas");
	}
	,initializeParts: function() {
		this.parts = [];
		var _g = 0;
		var _g1 = wl_core_Config.TIMELINE;
		while(_g < _g1.length) {
			var tl = _g1[_g];
			++_g;
			var id;
			if(tl.partId == null) {
				var o = tl.part;
				id = Type.getClassName(o == null ? null : js_Boot.getClass(o));
			} else {
				id = tl.partId;
			}
			tl.part.name = id;
			var _this = this.partMap;
			var key = tl.partId;
			console.log(tl.partId + " exists in partmap? " + Std.string(__map_reserved[key] != null ? _this.existsReserved(key) : _this.h.hasOwnProperty(key)) + " force new part is false? " + (tl.forceNewPart == null ? "null" : "" + tl.forceNewPart));
			var tmp;
			var _this1 = this.partMap;
			var key1 = tl.partId;
			if(__map_reserved[key1] != null ? _this1.existsReserved(key1) : _this1.h.hasOwnProperty(key1)) {
				tmp = !tl.forceNewPart;
			} else {
				tmp = false;
			}
			if(tmp) {
				var _this2 = this.partMap;
				var key2 = tl.partId;
				tl.part = __map_reserved[key2] != null ? _this2.getReserved(key2) : _this2.h[key2];
				tl.part.multiPart = true;
			} else {
				var _this3 = this.partMap;
				var key3 = tl.partId;
				var value = tl.part;
				if(__map_reserved[key3] != null) {
					_this3.setReserved(key3,value);
				} else {
					_this3.h[key3] = value;
				}
				this.parts.push(tl.part);
			}
		}
		var _g2 = 0;
		var _g11 = this.parts;
		while(_g2 < _g11.length) {
			var part = _g11[_g2];
			++_g2;
			part.init();
		}
		console.log(this.parts);
		var _g3 = 0;
		var _g12 = this.parts;
		while(_g3 < _g12.length) {
			var part1 = _g12[_g3];
			++_g3;
			part1.render(this.previousTS,0);
		}
		var _g4 = 0;
		var _g13 = this.parts;
		while(_g4 < _g13.length) {
			var part2 = _g13[_g4];
			++_g4;
			part2.postInit();
		}
	}
	,start: function() {
		var _gthis = this;
		this.previousRts = this.parts[0];
		this.graphics.start();
		haxe_Timer.delay(function() {
			wl_sounds_SoundWL.start();
			_gthis.allowUpdate = true;
			_gthis.waitingFirstFrame = false;
			console.log("allow upds.");
		},400);
		haxe_Timer.delay(function() {
			_gthis.parts[0].update(new wl_core_TimeSig(0),0,10,10);
			_gthis.parts[0].setRenderToScreen(true);
			_gthis.parts[0].render(new wl_core_TimeSig(0),10);
			_gthis.onRender(0);
		},40);
	}
	,end: function() {
		this.graphics.stop();
	}
	,onRender: function(time) {
		createjs.Tween.tick(time,false);
		var rts = null;
		var _g = 0;
		var _g1 = this.parts;
		while(_g < _g1.length) {
			var p = _g1[_g];
			++_g;
			if(p.running) {
				if(rts == null && p.renderToScreen) {
					rts = p;
				} else {
					p.render(this.previousTS,time,false);
				}
			}
		}
		if(rts == null) {
			rts = this.previousRts;
		}
		if(rts != null) {
			this.previousRts = rts;
			rts.render(this.previousTS,time,true);
		}
		if(wl_core_Config.DEBUG) {
			wl_debug_Debug.onrender();
		}
		if(this.allowUpdate) {
			this.update();
		}
	}
	,update: function() {
		var ts = wl_sounds_SoundWL.getPosition();
		var ms = ts.toMilliseconds();
		var frameTime = ms - this.previousUpdate;
		var delta = frameTime / 16.666666666666668;
		this.previousUpdate = ms;
		if(delta == 0) {
			return;
		}
		var _g1 = 0;
		var _g = wl_core_Config.TIMELINE.length;
		while(_g1 < _g) {
			var tl = wl_core_Config.TIMELINE[_g1++];
			if(ts.isInside(tl.runOn,tl.runOff)) {
				var p = tl.part;
				p.timeline = tl;
				var inTransition = ts.isInside(tl.runOn,tl.rtsOn) || ts.isInside(tl.rtsOff,tl.runOff);
				p.setRenderToScreen(tl.renderToScreen && !inTransition);
				if(!p.running) {
					this.partChanged.emit(p);
					p.start(ts);
				}
				p.isActive = true;
			}
		}
		if(wl_debug_Debug.paused) {
			0;
		} else {
			frameTime;
		}
		var _g2 = 0;
		var _g11 = this.parts;
		while(_g2 < _g11.length) {
			var p1 = _g11[_g2];
			++_g2;
			if(p1.isActive) {
				p1.update(ts,(ts.toMilliseconds() - p1.timeline.runOn.toMilliseconds()) / (p1.timeline.runOff.toMilliseconds() - p1.timeline.runOn.toMilliseconds()),wl_debug_Debug.paused ? 0 : frameTime,delta);
			} else if(p1.running) {
				p1.stop();
			}
			p1.isActive = false;
		}
		while(this.previousTS.isSmallerThan(ts)) {
			var _g3 = 0;
			var _g12 = this.parts;
			while(_g3 < _g12.length) {
				var p2 = _g12[_g3];
				++_g3;
				if(p2.running) {
					var key = p2.triggers.keys();
					while(key.hasNext()) {
						var key1 = key.next();
						var matches = key1.matchesPattern(this.previousTS,p2.timeline.runOn);
						if(matches && !key1.triggered) {
							var triggers = p2.triggers.h[key1.__id__];
							key1.triggered = true;
							var _g21 = 0;
							while(_g21 < triggers.length) {
								var toCall = triggers[_g21];
								++_g21;
								toCall(this.previousTS);
							}
						} else if(!matches) {
							key1.triggered = false;
						}
					}
				}
			}
			this.previousTS.addTicks(1);
		}
		this.onUpdate.emit(ts);
		if(wl_core_Config.DEBUG) {
			wl_debug_Debug.onupdate();
		}
	}
	,GetRenderingPart: function() {
		console.log("getting active render part");
		return this.parts.filter(function(p) {
			if(p.running) {
				return p.renderToScreen;
			} else {
				return false;
			}
		})[0];
	}
	,__class__: wl_core_Demo
};
var wl_core_Graphics = function(container) {
	this.last = 0;
	this.stopped = true;
	this.container = container;
	if(wl_core_Graphics.instance == null) {
		wl_core_Graphics.instance = this;
	} else {
		console.log("Creating multiple Graphics instances. Are you sure?");
	}
	this.initGraphics();
};
$hxClasses["wl.core.Graphics"] = wl_core_Graphics;
wl_core_Graphics.__name__ = ["wl","core","Graphics"];
wl_core_Graphics.prototype = {
	initGraphics: function() {
		this.onRender = new wl_core_Signal();
		this.interval = 1000 / wl_core_Config.FPS;
		this.canvas = window.document.createElement("canvas");
		this.canvas.id = "demoCanvas";
		var eo = { };
		eo.preserveDrawingBuffer = true;
		eo.stencil = true;
		this.renderer = new BABYLON.Engine(this.canvas,true,eo);
		this.canvas.width = wl_core_Config.RESOLUTION[0];
		this.canvas.height = wl_core_Config.RESOLUTION[1];
		console.log("Using webgl version: " + this.renderer.webGLVersion);
	}
	,start: function() {
		this.last = 0;
		this.stopped = false;
		this.renderLoop(0);
	}
	,stop: function() {
		this.stopped = true;
	}
	,renderLoop: function(time) {
		this.delta = time - this.last;
		if(wl_core_Config.FPS < 0 || this.delta >= this.interval) {
			this.last = time;
			this.renderer.beginFrame();
			this.onRender.emit(this.delta);
			this.renderer.endFrame();
		}
		if(!this.stopped) {
			window.requestAnimationFrame($bind(this,this.renderLoop));
		}
	}
	,__class__: wl_core_Graphics
};
var wl_core_TimeSig = $hx_exports["wl"]["TimeSig"] = function(bar,beat,tick,delay,pattern) {
	this.triggered = false;
	this.delay = 0;
	this.set_bar(bar == null ? 0 : bar);
	this.set_beat(beat == null ? 0 : beat);
	this.set_tick(tick == null ? 0 : tick);
	this.delay = delay == null ? 0 : delay;
	this.pattern = pattern == null ? wl_core_TimeSig.ABSOLUTE : pattern;
};
$hxClasses["wl.core.TimeSig"] = wl_core_TimeSig;
wl_core_TimeSig.__name__ = ["wl","core","TimeSig"];
wl_core_TimeSig.create = function(time) {
	return new wl_core_TimeSig().fromTime(time);
};
wl_core_TimeSig.milliseconds = function(bar,beat,tick,delay) {
	return (bar * wl_core_Config.BEATS_PER_BAR / wl_core_Config.BEATS_PER_MINUTE + beat / wl_core_Config.BEATS_PER_MINUTE + tick / wl_core_Config.TICKS_PER_BEAT / wl_core_Config.BEATS_PER_MINUTE) * 60 * 1000 + Math.floor(delay / 255 * (60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT));
};
wl_core_TimeSig.Zero = function() {
	return new wl_core_TimeSig(0,0,0,0,wl_core_TimeSig.RELATIVE);
};
wl_core_TimeSig.prototype = {
	set_beat: function(value) {
		this.beat = value;
		return this.beat;
	}
	,set_bar: function(value) {
		this.bar = value;
		return this.bar;
	}
	,set_tick: function(value) {
		this.tick = value;
		return this.tick;
	}
	,adjust: function() {
	}
	,matchesPattern: function(time,begin) {
		if(this.pattern == wl_core_TimeSig.ABSOLUTE) {
			return this.equals(time);
		} else if(this.pattern == wl_core_TimeSig.RELATIVE) {
			if(time.bar == begin.bar + this.bar && time.beat == begin.beat + this.beat) {
				return time.tick == begin.tick + this.tick;
			} else {
				return false;
			}
		} else if(this.pattern == wl_core_TimeSig.PATTERN) {
			if((this.bar == -1 || time.bar % this.bar == 0) && (this.beat == -1 || time.beat % wl_core_Config.BEATS_PER_BAR == this.beat)) {
				if(this.tick != -1) {
					return time.tick % wl_core_Config.TICKS_PER_BEAT == this.tick;
				} else {
					return true;
				}
			} else {
				return false;
			}
		}
		return false;
	}
	,add: function(ts) {
		this.addBars(ts.bar);
		this.addBeats(ts.beat);
		this.addTicks(ts.tick);
	}
	,addBars: function(bars) {
		var _g = this;
		_g.set_bar(_g.bar + bars);
	}
	,addBeats: function(beats) {
		var _g = this;
		_g.set_beat(_g.beat + beats);
		var _g1 = this;
		_g1.set_bar(_g1.bar + Math.floor(this.beat / wl_core_Config.BEATS_PER_BAR));
		var _g2 = this;
		_g2.set_beat(_g2.beat % wl_core_Config.BEATS_PER_BAR);
	}
	,addTicks: function(ticks) {
		var _g = this;
		_g.set_tick(_g.tick + ticks);
		while(this.tick >= wl_core_Config.TICKS_PER_BEAT) {
			var _g1 = this;
			_g1.set_tick(_g1.tick - wl_core_Config.TICKS_PER_BEAT);
			var _g2 = this;
			_g2.set_beat(_g2.beat + 1);
		}
		while(this.beat >= wl_core_Config.BEATS_PER_BAR) {
			var _g3 = this;
			_g3.set_beat(_g3.beat - wl_core_Config.BEATS_PER_BAR);
			var _g4 = this;
			_g4.set_bar(_g4.bar + 1);
		}
	}
	,subtract: function(ts) {
		this.subtractBars(ts.bar);
		this.subtractBeats(ts.beat);
		this.subtractTicks(ts.tick);
	}
	,subtractBars: function(bars) {
		var _g = this;
		_g.set_bar(_g.bar - bars);
	}
	,subtractBeats: function(beats) {
		var _g = this;
		_g.set_beat(_g.beat - beats);
		while(this.beat < 0) {
			var _g1 = this;
			_g1.set_bar(_g1.bar - 1);
			var _g2 = this;
			_g2.set_beat(_g2.beat + wl_core_Config.BEATS_PER_BAR);
		}
	}
	,subtractTicks: function(ticks) {
		var _g = this;
		_g.set_tick(_g.tick - ticks);
		while(this.tick < 0) {
			var _g1 = this;
			_g1.set_tick(_g1.tick + wl_core_Config.TICKS_PER_BEAT);
			var _g2 = this;
			_g2.set_beat(_g2.beat - 1);
		}
		while(this.beat < 0) {
			var _g3 = this;
			_g3.set_bar(_g3.bar - 1);
			var _g4 = this;
			_g4.set_beat(_g4.beat + wl_core_Config.BEATS_PER_BAR);
		}
	}
	,fromTime: function(time) {
		var totalBeats = wl_core_Config.BEATS_PER_MINUTE * time;
		var comp = time < 0 ? Math.ceil : Math.floor;
		this.set_bar(comp(totalBeats / wl_core_Config.BEATS_PER_BAR));
		this.set_beat(comp(totalBeats % wl_core_Config.BEATS_PER_BAR));
		this.set_tick(comp((totalBeats - comp(totalBeats)) * wl_core_Config.TICKS_PER_BEAT));
		this.delay = 0;
		this.delay = Math.floor(255 * (time * 60 * 1000 - this.toMilliseconds()) / (60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT) % 255);
		return this;
	}
	,isInside: function(begin,end) {
		if(this.isSmallerThan(end)) {
			return this.isLargerThan(begin);
		} else {
			return false;
		}
	}
	,isInsideFloat: function(begin,end) {
		if(this.toMilliseconds() >= begin) {
			return this.toMilliseconds() <= end;
		} else {
			return false;
		}
	}
	,isSmallerThan: function(other) {
		var ticks = this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick;
		var tickso = other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
		if(ticks >= tickso) {
			if(ticks == tickso) {
				return this.delay < other.delay;
			} else {
				return false;
			}
		} else {
			return true;
		}
	}
	,isLargerThan: function(other) {
		var ticks = this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick;
		var tickso = other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
		if(ticks <= tickso) {
			if(ticks == tickso) {
				return this.delay >= other.delay;
			} else {
				return false;
			}
		} else {
			return true;
		}
	}
	,toMilliseconds: function() {
		return (this.bar * wl_core_Config.BEATS_PER_BAR / wl_core_Config.BEATS_PER_MINUTE + this.beat / wl_core_Config.BEATS_PER_MINUTE + this.tick / wl_core_Config.TICKS_PER_BEAT / wl_core_Config.BEATS_PER_MINUTE) * 60 * 1000 + Math.floor(this.delay / 255 * (60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT));
	}
	,equals: function(other) {
		return this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick == other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
	}
	,clone: function() {
		return new wl_core_TimeSig(this.bar,this.beat,this.tick,this.delay,this.pattern);
	}
	,toString: function(full) {
		return this.bar + ":" + this.beat + ":" + this.tick + (full ? " / " + this.delay + "\n[" + this.pattern + "]" : "");
	}
	,__class__: wl_core_TimeSig
};
var wl_debug_CustomCameraControl = function() {
	this.availableKeys = [];
	this.keysDown = [];
	this.shift = 16;
	this.down = 70;
	this.up = 82;
	this.right = 68;
	this.left = 65;
	this.backward = 83;
	this.forward = 87;
	this.availableKeys = [this.forward,this.backward,this.left,this.right,this.up,this.down,this.shift];
};
$hxClasses["wl.debug.CustomCameraControl"] = wl_debug_CustomCameraControl;
wl_debug_CustomCameraControl.__name__ = ["wl","debug","CustomCameraControl"];
wl_debug_CustomCameraControl.__interfaces__ = [BABYLON_ICameraInput];
wl_debug_CustomCameraControl.prototype = {
	getClassName: function() {
		return "CustomCameraController";
	}
	,getSimpleName: function() {
		return "CustomCameraController";
	}
	,attachControl: function(element,noPreventDefault) {
		var _gthis = this;
		if(this.onCanvasBlurObserver != null) {
			return;
		}
		console.log(noPreventDefault);
		this.scene = this.camera.getScene();
		this.engine = this.scene.getEngine();
		this.onCanvasBlurObserver = this.engine.onCanvasBlurObservable.add(function(engine,eventState) {
			_gthis.keysDown = [];
		});
		this.onKeyboardObserver = this.scene.onKeyboardObservable.add(function(info,eventState1) {
			var evt = info.event;
			if(info.type == BABYLON.KeyboardEventTypes.KEYDOWN) {
				if(_gthis.availableKeys.indexOf(evt.keyCode) == -1) {
					return;
				}
				if(_gthis.shift == evt.keyCode) {
					_gthis.shiftDown = true;
				} else if(_gthis.keysDown.indexOf(evt.keyCode) == -1) {
					_gthis.keysDown.push(evt.keyCode);
				}
			} else {
				if(_gthis.shift == evt.keyCode) {
					_gthis.shiftDown = false;
				}
				var index = _gthis.keysDown.indexOf(evt.keyCode);
				if(index >= 0) {
					_gthis.keysDown.splice(index,1);
				}
			}
		});
	}
	,detachControl: function(element) {
		console.log("detach");
		if(this.scene != null) {
			if(this.onKeyboardObserver != null) {
				this.scene.onKeyboardObservable.remove(this.onKeyboardObserver);
			}
		}
		if(this.engine != null) {
			if(this.onCanvasBlurObserver != null) {
				this.engine.onCanvasBlurObservable.remove(this.onCanvasBlurObserver);
			}
		}
		this.keysDown = [];
		this.onCanvasBlurObserver = null;
		this.onKeyboardObserver = null;
	}
	,checkInputs: function() {
		if(this.onKeyboardObserver != null) {
			var _g1 = 0;
			var _g = this.keysDown.length;
			while(_g1 < _g) {
				var index = _g1++;
				var keyCode = this.keysDown[index];
				var speed = this.camera._computeLocalCameraSpeed();
				if(this.shiftDown) {
					speed /= 10.0;
				}
				if(this.left == keyCode) {
					this.camera._localDirection.copyFromFloats(-speed,0,0);
				} else if(this.forward == keyCode) {
					this.camera._localDirection.copyFromFloats(0,0,speed);
				} else if(this.right == keyCode) {
					this.camera._localDirection.copyFromFloats(speed,0,0);
				} else if(this.backward == keyCode) {
					this.camera._localDirection.copyFromFloats(0,0,-speed);
				} else if(this.up == keyCode) {
					this.camera._localDirection.copyFromFloats(0,speed,0);
				} else if(this.down == keyCode) {
					this.camera._localDirection.copyFromFloats(0,-speed,0);
				}
				if(this.camera.getScene().useRightHandedSystem) {
					this.camera._localDirection.z *= -1;
				}
				this.camera.getViewMatrix().invertToRef(this.camera._cameraTransformMatrix);
				BABYLON.Vector3.TransformNormalToRef(this.camera._localDirection,this.camera._cameraTransformMatrix,this.camera._transformedDirection);
				this.camera.cameraDirection.addInPlace(this.camera._transformedDirection);
			}
		}
	}
	,_onLostFocus: function(e) {
		this.keysDown = [];
	}
	,__class__: wl_debug_CustomCameraControl
};
var wl_debug_Debug = function() {
};
$hxClasses["wl.debug.Debug"] = wl_debug_Debug;
wl_debug_Debug.__name__ = ["wl","debug","Debug"];
wl_debug_Debug.init = function(demo) {
	wl_debug_Debug.gui = new dat.gui.GUI();
	window.document.addEventListener("keydown",wl_debug_Debug.onKeyDown);
	wl_debug_Debug.debugDiv = $(".debug");
	wl_debug_Debug.debugTimeSig = wl_debug_Debug.debugDiv.find("#debug_timesig");
	var tldiv = wl_debug_Debug.debugDiv.find("#timeline_parts");
	var _g = 0;
	var _g1 = wl_core_Config.TIMELINE;
	while(_g < _g1.length) {
		var tl = _g1[_g];
		++_g;
		var tlel = $("<li>" + Std.string(tl) + "</li>");
		tldiv.append(tlel);
		tlel.click(wl_debug_Debug.tlClick(tl));
		wl_debug_Debug.datGuiPart(tl.part);
	}
	wl_debug_Debug.sceneInspector = new wl_debug_SceneInspector();
	wl_debug_Debug.stats = new Stats();
	wl_debug_Debug.stats.showPanel(1);
	wl_debug_Debug.stats.dom.style.position = "absolute";
	wl_debug_Debug.stats.dom.style.bottom = "0px";
	wl_debug_Debug.stats.dom.style.top = null;
	wl_debug_Debug.debugDiv.eq(0).append(wl_debug_Debug.stats.dom);
	wl_debug_Debug.stats.begin();
	wl_debug_Debug.editModeCb = wl_debug_Debug.debugDiv.find("#editMode");
	console.log(wl_debug_Debug.editModeCb);
	wl_debug_Debug.editModeCb.removeAttr("checked");
	wl_debug_Debug.editModeCb.change(function(eventData) {
		wl_debug_Debug.editMode = eventData.target.checked;
		var activePart = wl_core_Demo.instance.GetRenderingPart();
		if(wl_debug_Debug.editMode) {
			wl_debug_Debug.sceneInspector.activate(activePart);
		} else {
			wl_debug_Debug.sceneInspector.disable(activePart);
		}
		if(!wl_debug_Debug.editMode) {
			wl_debug_ManualControl.attachPart(activePart);
			wl_debug_Debug.Continue();
		} else {
			wl_debug_Debug.Pause();
		}
	});
	wl_core_Demo.instance.partChanged.connect(function(part) {
		console.log("Part changed");
		if(wl_debug_Debug.editMode) {
			wl_debug_Debug.sceneInspector.activate(part);
		}
	});
};
wl_debug_Debug.datGuiPart = function(part) {
	var name = part.name;
	while(wl_debug_Debug.usedFolderNames.indexOf(name) >= 0) name += ">";
	var folder = wl_debug_Debug.gui.addFolder(name);
	wl_debug_Debug.usedFolderNames.push(name);
	var composer = Reflect.field(part,"composer");
	if(composer != null) {
		var _g = 0;
		var _g1 = composer.passes;
		while(_g < _g1.length) {
			var pass = _g1[_g];
			++_g;
			if(pass.setupDatGui != null) {
				pass.setupDatGui(folder);
			}
		}
	}
	var occlusioncomposer = Reflect.field(part,"occlusionComposer");
	if(occlusioncomposer != null) {
		var _g2 = 0;
		var _g11 = occlusioncomposer.passes;
		while(_g2 < _g11.length) {
			var pass1 = _g11[_g2];
			++_g2;
			if(pass1.setupDatGui != null) {
				pass1.setupDatGui(folder);
			}
		}
	}
	part.setupDatGui(folder);
};
wl_debug_Debug.tlClick = function(tl) {
	return function() {
		var curtime = wl_sounds_SoundWL.instance.getPosition();
		var tlpos = tl.rtsOn.toMilliseconds();
		wl_sounds_SoundWL.instance.setPosition(tlpos);
		createjs.Tween.tick(Math.floor(tlpos - curtime),false);
		wl_core_Demo.instance.previousTS.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	};
};
wl_debug_Debug.onupdate = function() {
	var ts = wl_sounds_SoundWL.getPosition();
	wl_debug_Debug.debugTimeSig.html(StringTools.replace(ts.toString(),"\n","<br/>") + "<br/>" + Math.round(ts.toMilliseconds() / 100) / 10 + "s");
};
wl_debug_Debug.onrender = function() {
	wl_debug_Debug.stats.update();
};
wl_debug_Debug.onKeyDown = function(e) {
	if(e.keyCode == 9) {
		if(wl_debug_Debug.editMode) {
			wl_debug_Debug.editModeCb.prop("checked",false).trigger("change");
		} else {
			wl_debug_Debug.editModeCb.prop("checked",true).trigger("change");
		}
		console.log(wl_debug_Debug.editModeCb);
		console.log(wl_debug_Debug.editMode);
		e.preventDefault();
	}
	if(e.keyCode == 90) {
		console.log("Time captured: " + Std.string(wl_core_Demo.instance.previousTS));
	}
	if(e.keyCode == 109 || e.keyCode == 188) {
		if(wl_sounds_SoundWL.instance != null) {
			wl_sounds_SoundWL.instance.setPosition(wl_sounds_SoundWL.instance.getPosition() - 5000);
			createjs.Tween.tick(-5000,false);
			wl_core_Demo.instance.previousTS.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
		}
	}
	if(e.keyCode == 107 || e.keyCode == 190) {
		if(wl_sounds_SoundWL.instance != null) {
			wl_sounds_SoundWL.instance.setPosition(wl_sounds_SoundWL.instance.getPosition() + 5000);
			createjs.Tween.tick(5000,false);
			wl_core_Demo.instance.previousTS.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
		}
	}
	if(e.keyCode == 32) {
		wl_debug_Debug.PauseOrContinue();
	}
};
wl_debug_Debug.PauseOrContinue = function() {
	if(wl_debug_Debug.paused) {
		wl_debug_Debug.Continue();
	} else {
		wl_debug_Debug.Pause();
	}
};
wl_debug_Debug.Pause = function() {
	wl_debug_Debug.paused = true;
	wl_sounds_SoundWL.instance.paused = wl_debug_Debug.paused;
	createjs.Tween.removeAllTweens();
};
wl_debug_Debug.Continue = function() {
	wl_debug_Debug.paused = false;
	wl_sounds_SoundWL.instance.paused = wl_debug_Debug.paused;
};
wl_debug_Debug.prototype = {
	__class__: wl_debug_Debug
};
var wl_debug_ManualControl = function() {
	throw new js__$Boot_HaxeError("Manual control is static");
};
$hxClasses["wl.debug.ManualControl"] = wl_debug_ManualControl;
wl_debug_ManualControl.__name__ = ["wl","debug","ManualControl"];
wl_debug_ManualControl.init = function() {
	if(wl_debug_ManualControl.inited) {
		return;
	}
	wl_debug_ManualControl.inited = true;
};
wl_debug_ManualControl.onMouseDown = function(event) {
	console.log("mouse down");
};
wl_debug_ManualControl.onMouseUp = function(event) {
	console.log("Mouse up");
};
wl_debug_ManualControl.onKeyDown = function(event) {
};
wl_debug_ManualControl.update = function() {
};
wl_debug_ManualControl.attachPart = function(part) {
	if(!wl_core_Config.DEBUG) {
		return;
	}
	part.camera.attachControl(wl_core_Graphics.instance.canvas,true);
	part.camera.inputs.add(new wl_debug_CustomCameraControl());
};
wl_debug_ManualControl.prototype = {
	__class__: wl_debug_ManualControl
};
var wl_debug_PostProcessSliders = function() {
};
$hxClasses["wl.debug.PostProcessSliders"] = wl_debug_PostProcessSliders;
wl_debug_PostProcessSliders.__name__ = ["wl","debug","PostProcessSliders"];
wl_debug_PostProcessSliders.applySliders = function(folder,pipeline) {
	wl_debug_PostProcessSliders.applyFXAA(folder.addFolder("FXAA"),pipeline);
	wl_debug_PostProcessSliders.applySharpen(folder.addFolder("Sharpen"),pipeline);
	wl_debug_PostProcessSliders.applyDoF(folder.addFolder("DoF"),pipeline);
	wl_debug_PostProcessSliders.applyBloom(folder.addFolder("Bloom"),pipeline);
	if(pipeline.imageProcessing != null) {
		wl_debug_PostProcessSliders.applyImageProcessing(folder.addFolder("ImageProcessing"),pipeline);
	}
	wl_debug_PostProcessSliders.applyChromaticAberration(folder.addFolder("ChromaticAberration"),pipeline);
	wl_debug_PostProcessSliders.applyGrain(folder.addFolder("Grain"),pipeline);
};
wl_debug_PostProcessSliders.applyFXAA = function(folder,pipeline) {
	folder.add(pipeline,"fxaaEnabled");
};
wl_debug_PostProcessSliders.applySharpen = function(folder,pipeline) {
	folder.add(pipeline,"sharpenEnabled");
	folder.add(pipeline.sharpen,"colorAmount");
	folder.add(pipeline.sharpen,"edgeAmount");
};
wl_debug_PostProcessSliders.applyDoF = function(folder,pipeline) {
	folder.add(pipeline,"depthOfFieldEnabled");
	folder.add(pipeline.depthOfField,"focalLength").min(0).max(200).step(1);
	folder.add(pipeline.depthOfField,"focusDistance").min(0).max(5000).step(0.1);
	folder.add(pipeline.depthOfField,"fStop").min(0).max(20).step(0.01);
	folder.add(pipeline.depthOfField,"lensSize").min(0).max(500).step(0.01);
	folder.add(pipeline,"depthOfFieldBlurLevel").min(0).max(2).step(1);
};
wl_debug_PostProcessSliders.applyBloom = function(folder,pipeline) {
	folder.add(pipeline,"bloomEnabled");
	folder.add(pipeline.bloom,"kernel");
	folder.add(pipeline.bloom,"bloomScale");
	folder.add(pipeline.bloom,"threshold");
	folder.add(pipeline.bloom,"weight");
};
wl_debug_PostProcessSliders.applyImageProcessing = function(folder,pipeline) {
	folder.add(pipeline,"imageProcessingEnabled");
	folder.add(pipeline.imageProcessing,"toneMappingEnabled");
	folder.add(pipeline.imageProcessing,"exposure").min(-5).max(5000).step(0.01);
	folder.add(pipeline.imageProcessing,"contrast").min(-5).max(5).step(0.01);
	folder.add(pipeline.imageProcessing,"vignetteEnabled");
	folder.add(pipeline.imageProcessing,"vignetteCentreX").min(-1).max(1).step(0.01);
	folder.add(pipeline.imageProcessing,"vignetteCentreY").min(-1).max(1).step(0.01);
	folder.addColor(pipeline.imageProcessing,"vignetteColor");
	folder.add(pipeline.imageProcessing,"vignetteStretch").min(0).max(1).step(0.01);
	folder.add(pipeline.imageProcessing,"vignetteWeight").min(0).max(20).step(0.01);
};
wl_debug_PostProcessSliders.applyChromaticAberration = function(folder,pipeline) {
	folder.add(pipeline,"chromaticAberrationEnabled");
	folder.add(pipeline.chromaticAberration,"aberrationAmount").min(0).max(100).step(0.01);
	folder.add(pipeline.chromaticAberration,"radialIntensity").min(-5).max(5).step(0.01);
	var dir = folder.addFolder("direction");
	dir.add(pipeline.chromaticAberration.direction,"x").min(-1).max(1).step(0.01);
	dir.add(pipeline.chromaticAberration.direction,"y").min(-1).max(1).step(0.01);
	var center = folder.addFolder("center position");
	center.add(pipeline.chromaticAberration.centerPosition,"x").min(-1).max(1).step(0.01);
	center.add(pipeline.chromaticAberration.centerPosition,"y").min(-1).max(1).step(0.01);
};
wl_debug_PostProcessSliders.applyGrain = function(folder,pipeline) {
	folder.add(pipeline,"grainEnabled");
	folder.add(pipeline.grain,"intensity").min(0).max(500).step(0.1);
	folder.add(pipeline.grain,"animated");
};
wl_debug_PostProcessSliders.prototype = {
	__class__: wl_debug_PostProcessSliders
};
var wl_debug_SceneInspector = function() {
	this._democanvas = window.document.getElementById("demoCanvas");
};
$hxClasses["wl.debug.SceneInspector"] = wl_debug_SceneInspector;
wl_debug_SceneInspector.__name__ = ["wl","debug","SceneInspector"];
wl_debug_SceneInspector.prototype = {
	activate: function(part) {
		if(this._previous != null && part.name != this._previous.name) {
			this._previous.scene.debugLayer.hide();
		}
		if(!part.scene.debugLayer.isVisible()) {
			part.scene.debugLayer.show();
		}
		this._previous = part;
		this._democanvas.style.maxWidth = "70%";
		this._democanvas.style.maxHeight = "70%";
		this.HideOrShowCurrentEditors(false);
	}
	,disable: function(part) {
		if(this._previous != null && part.name != this._previous.name) {
			this._previous.scene.debugLayer.hide();
		}
		this._previous = part;
		this._democanvas.style.maxWidth = "";
		this._democanvas.style.maxHeight = "";
		this._democanvas.width = wl_core_Config.RESOLUTION[0];
		this._democanvas.height = wl_core_Config.RESOLUTION[1];
		this.HideOrShowCurrentEditors(true);
	}
	,HideOrShowCurrentEditors: function(hidden) {
		var sceneExplorer = window.document.getElementById("scene-explorer-host");
		var inspector = window.document.getElementById("inspector-host");
		if(hidden) {
			if(sceneExplorer != null) {
				sceneExplorer.style.display = "none";
			}
			if(inspector != null) {
				inspector.style.display = "none";
			}
		} else {
			if(sceneExplorer != null) {
				sceneExplorer.style.display = "block";
			}
			if(inspector != null) {
				inspector.style.display = "block";
			}
		}
	}
	,__class__: wl_debug_SceneInspector
};
var wl_demo_BoardItem = function(startTime,endTime,controller) {
	this.startTime = startTime;
	this.controller = controller;
	this.endTime = endTime;
};
$hxClasses["wl.demo.BoardItem"] = wl_demo_BoardItem;
wl_demo_BoardItem.__name__ = ["wl","demo","BoardItem"];
wl_demo_BoardItem.prototype = {
	Run: function(ts) {
		if((ts.isLargerThan(this.startTime) || ts.equals(this.startTime)) && ts.isSmallerThan(this.endTime)) {
			this.controller.update((ts.toMilliseconds() - this.startTime.toMilliseconds()) / (this.endTime.toMilliseconds() - this.startTime.toMilliseconds()));
		}
	}
	,__class__: wl_demo_BoardItem
};
var wl_demo_IController = function() { };
$hxClasses["wl.demo.IController"] = wl_demo_IController;
wl_demo_IController.__name__ = ["wl","demo","IController"];
wl_demo_IController.prototype = {
	__class__: wl_demo_IController
};
var wl_demo_CameraController = function(camera) {
	this.ignoreStop = false;
	this.updateLook = true;
	this.updatePath = true;
	if(camera != null) {
		this.attachCamera(camera);
	}
};
$hxClasses["wl.demo.CameraController"] = wl_demo_CameraController;
wl_demo_CameraController.__name__ = ["wl","demo","CameraController"];
wl_demo_CameraController.__interfaces__ = [wl_demo_IController];
wl_demo_CameraController.stopAllControl = function() {
	wl_demo_CameraController.STOPPED = true;
};
wl_demo_CameraController.prototype = {
	attachCamera: function(camera) {
		this.camera = camera;
	}
	,set_mode: function(mode) {
		this.mode = mode;
		return mode;
	}
	,initStatic: function(position,lookAt) {
		this.position = position;
		this.lookAt = lookAt;
		this.set_mode(wl_demo_CameraController.STATIC);
	}
	,initFollow: function(target,followOffset,followLookOffset) {
		this.set_mode(wl_demo_CameraController.FOLLOW);
		this.follow = target;
		this.followOffset = followOffset == null ? new BABYLON.Vector3(0,0,0) : followOffset;
		this.followLookOffset = followLookOffset == null ? new BABYLON.Vector3(0,0,0) : followLookOffset;
	}
	,initLinear: function(points,lookAts) {
		this.set_mode(wl_demo_CameraController.LINEAR);
		this.points = points;
		this.lookAts = lookAts;
	}
	,initBezier: function(points,lookAts) {
		this.set_mode(wl_demo_CameraController.BEZIER);
		this.points = points;
		this.lookAts = lookAts;
		this.path = BABYLON.Curve3.CreateCatmullRomSpline(points,2000);
		this.lookPath = BABYLON.Curve3.CreateCatmullRomSpline(lookAts,2000);
	}
	,showbezierPaths: function(scene) {
	}
	,update: function(phase) {
		if(wl_demo_CameraController.STOPPED && !this.ignoreStop) {
			return;
		}
		if(this.mode == wl_demo_CameraController.STATIC) {
			if(this.updatePath) {
				this.camera.position.x = this.position.x;
				this.camera.position.y = this.position.y;
				this.camera.position.z = this.position.z;
			}
			if(this.updateLook) {
				this.camera.setTarget(this.lookAt);
			}
		} else if(this.mode == wl_demo_CameraController.LINEAR) {
			if(this.updatePath) {
				var a = this.points[0];
				var b = this.points[1];
				var c = new BABYLON.Vector3(0,0,0);
				BABYLON.Vector3.LerpToRef(a,b,phase,c);
				this.camera.position.x = c.x;
				this.camera.position.y = c.y;
				this.camera.position.z = c.z;
			}
			if(this.updateLook) {
				var a1 = this.lookAts[0];
				var b1 = this.lookAts[1];
				var c1 = new BABYLON.Vector3(0,0,0);
				BABYLON.Vector3.LerpToRef(a1,b1,phase,c1);
				this.camera.setTarget(c1);
			}
		} else if(this.mode == wl_demo_CameraController.FOLLOW) {
			if(this.updatePath) {
				this.camera.position.x = this.follow.position.x + this.followOffset.x;
				this.camera.position.y = this.follow.position.y + this.followOffset.y;
				this.camera.position.z = this.follow.position.z + this.followOffset.z;
			}
			if(this.updateLook) {
				this.camera.setTarget(this.follow.position.add(this.followLookOffset));
			}
		} else if(this.mode == wl_demo_CameraController.BEZIER) {
			if(phase < 0) {
				phase = 0;
			} else if(phase > 1) {
				phase = 1;
			}
			if(this.updatePath) {
				var p = this.path.getPoints()[Math.floor(Math.min(phase * this.path.getPoints().length,this.path.getPoints().length - 1))];
				this.camera.position.x = p.x;
				this.camera.position.y = p.y;
				this.camera.position.z = p.z;
			}
			if(this.updateLook) {
				var p1 = this.lookPath.getPoints()[Math.floor(Math.min(phase * this.path.getPoints().length,this.path.getPoints().length - 1))];
				this.camera.setTarget(p1);
				this.lookAt = p1;
			}
			this.position = this.camera.position;
		}
	}
	,__class__: wl_demo_CameraController
};
var wl_demo_RandomCameraController = function(camera,cameraAmount,follow,seed,allowTypes,distanceRange,bounds) {
	this.distanceRange = [];
	this.cameraSwap = 0;
	this.current = 0;
	if(allowTypes.length == 0) {
		throw new js__$Boot_HaxeError("Random camera requires at least 1 type");
	}
	this.md = distanceRange[0];
	this.bounds = bounds;
	this.rnd = distanceRange[1] - distanceRange[0];
	this.distanceRange = distanceRange;
	this.random = new wl_util_Random(seed);
	this.follow = follow;
	this.camera = camera;
	this.ccs = [];
	var _g1 = 0;
	while(_g1 < cameraAmount) {
		++_g1;
		var cc = new wl_demo_CameraController(this.camera);
		var type = allowTypes[this.random.Next() % allowTypes.length];
		if(type == wl_demo_CameraController.FOLLOW) {
			this.initFollow(cc);
		} else if(type == wl_demo_CameraController.LINEAR) {
			this.initLinear(cc);
		} else if(type == wl_demo_CameraController.STATIC) {
			this.initStatic(cc);
		} else if(type == wl_demo_CameraController.BEZIER) {
			this.initBezier(cc);
		}
		this.ccs.push(cc);
	}
};
$hxClasses["wl.demo.RandomCameraController"] = wl_demo_RandomCameraController;
wl_demo_RandomCameraController.__name__ = ["wl","demo","RandomCameraController"];
wl_demo_RandomCameraController.prototype = {
	start: function() {
		this.cameraSwap = new Date().getTime();
	}
	,swap: function() {
		this.cameraSwap = new Date().getTime();
		this.current = (this.current + 1) % this.ccs.length;
	}
	,updatePartial: function(val) {
		this.ccs[this.current].update(val);
	}
	,updateLength: function(time) {
		var partial = (new Date().getTime() - this.cameraSwap) / time;
		this.ccs[this.current].update(partial);
	}
	,getRndPoint: function() {
		var v = this.bounds.minimum.clone();
		var add = this.bounds.maximum.subtract(this.bounds.minimum);
		add = add.multiply(new BABYLON.Vector3(this.random.NextFloat(),this.random.NextFloat(),this.random.NextFloat()));
		v = v.addInPlace(add);
		return v;
	}
	,initFollow: function(cc) {
		var obj = this.follow.length > 0 ? this.follow[this.random.Next() % this.follow.length] : new BABYLON.TransformNode("");
		var dir = new BABYLON.Vector3(this.random.NextFloat() - 0.5,this.random.NextFloat() - 0.5,this.random.NextFloat() - 0.5);
		dir.normalize();
		dir.scale(this.random.NextFloat() * this.rnd + this.md);
		cc.initFollow(obj,dir,new BABYLON.Vector3(this.random.NextFloat() * this.md / 10,this.random.NextFloat() * this.md / 10,this.random.NextFloat() * this.md / 10));
	}
	,initStatic: function(cc) {
		var obj = this.follow.length > 0 ? this.follow[this.random.Next() % this.follow.length] : new BABYLON.TransformNode("");
		cc.initStatic(this.getRndPoint(),obj.position);
	}
	,initLinear: function(cc) {
		var obj = this.follow.length > 0 ? this.follow[this.random.Next() % this.follow.length] : new BABYLON.TransformNode("");
		cc.initLinear([this.getRndPoint(),this.getRndPoint()],[obj.position.clone(),obj.position.clone().add(new BABYLON.Vector3(this.random.NextFloat() * 20 - 10,this.random.NextFloat() * 20 - 10,this.random.NextFloat() * 20 - 10))]);
	}
	,initBezier: function(cc) {
		var obj = this.follow.length > 0 ? this.follow[this.random.Next() % this.follow.length] : new BABYLON.TransformNode("");
		var start = this.getRndPoint();
		var end = this.getRndPoint();
		var pos = [start];
		var looks = [obj.position.clone(),obj.position.clone()];
		var dx = end.x - start.x;
		var dy = end.y - start.y;
		var dz = end.z - start.z;
		var _g = 1;
		while(_g < 6) {
			var i = _g++;
			looks.push(obj.position.clone());
			pos.push(new BABYLON.Vector3(this.random.NextFloat() * dx / 10 - dx / 20 + i / 6 * dx + start.x,this.random.NextFloat() * dy / 10 - dy / 20 + i / 6 * dy + start.y,this.random.NextFloat() * dz / 10 - dz / 20 + i / 6 * dz + start.z));
		}
		pos.push(end);
		cc.initBezier(pos,looks);
	}
	,__class__: wl_demo_RandomCameraController
};
var wl_demo_SceneBoard = function() {
	this.startTime = new wl_core_TimeSig();
	this.BoardItems = [];
};
$hxClasses["wl.demo.SceneBoard"] = wl_demo_SceneBoard;
wl_demo_SceneBoard.__name__ = ["wl","demo","SceneBoard"];
wl_demo_SceneBoard.prototype = {
	add: function(startTime,endTime,controller) {
		this.BoardItems.push(new wl_demo_BoardItem(startTime,endTime,controller));
	}
	,start: function(ts) {
		this.startTime = ts.clone();
	}
	,update: function(ts,partial,frameTime,delta) {
		var _g = 0;
		var _g1 = this.BoardItems;
		while(_g < _g1.length) {
			var b = _g1[_g];
			++_g;
			var ts2 = ts.clone();
			ts2.subtract(this.startTime);
			b.Run(ts2);
		}
	}
	,__class__: wl_demo_SceneBoard
};
var wl_demo_TimeLine = function(instance,runOn,runOff,partId,renderToScreen,rtsOn,rtsOff,forceNewPart,extra) {
	console.log("Timeline init:" + (forceNewPart == null ? "null" : "" + forceNewPart));
	this.part = instance;
	this.partId = partId;
	this.runOn = runOn;
	this.runOff = runOff;
	this.rtsOn = rtsOn == null ? runOn.clone() : rtsOn;
	this.rtsOff = rtsOff == null ? runOff.clone() : rtsOff;
	this.renderToScreen = renderToScreen == null ? true : renderToScreen;
	this.forceNewPart = forceNewPart == null ? false : forceNewPart;
	this.extra = extra;
};
$hxClasses["wl.demo.TimeLine"] = wl_demo_TimeLine;
wl_demo_TimeLine.__name__ = ["wl","demo","TimeLine"];
wl_demo_TimeLine.prototype = {
	toString: function() {
		return this.part.name + ":" + this.rtsOn.toString() + " - " + this.rtsOff.toString();
	}
	,__class__: wl_demo_TimeLine
};
var wl_demo_TransformNodeController = function(node) {
	this.ignoreStop = false;
	this.updateLook = true;
	this.updatePath = true;
	if(node != null) {
		this.attachCamera(node);
	}
};
$hxClasses["wl.demo.TransformNodeController"] = wl_demo_TransformNodeController;
wl_demo_TransformNodeController.__name__ = ["wl","demo","TransformNodeController"];
wl_demo_TransformNodeController.__interfaces__ = [wl_demo_IController];
wl_demo_TransformNodeController.stopAllControl = function() {
	wl_demo_TransformNodeController.STOPPED = true;
};
wl_demo_TransformNodeController.prototype = {
	attachCamera: function(node) {
		this.node = node;
	}
	,set_mode: function(mode) {
		this.mode = mode;
		return mode;
	}
	,initStatic: function(position,lookAt) {
		this.position = position;
		this.lookAt = lookAt;
		this.set_mode(wl_demo_TransformNodeController.STATIC);
	}
	,initFollow: function(target,followOffset,followLookOffset) {
		this.set_mode(wl_demo_TransformNodeController.FOLLOW);
		this.follow = target;
		this.followOffset = followOffset == null ? new BABYLON.Vector3(0,0,0) : followOffset;
		this.followLookOffset = followLookOffset == null ? new BABYLON.Vector3(0,0,0) : followLookOffset;
	}
	,initLinear: function(points,lookAts) {
		this.set_mode(wl_demo_TransformNodeController.LINEAR);
		this.points = points;
		this.lookAts = lookAts;
	}
	,initBezier: function(points,lookAts) {
		this.set_mode(wl_demo_TransformNodeController.BEZIER);
		this.points = points;
		this.lookAts = lookAts;
		this.path = BABYLON.Curve3.CreateCatmullRomSpline(points,2000);
		this.lookPath = BABYLON.Curve3.CreateCatmullRomSpline(lookAts,2000);
	}
	,showbezierPaths: function(scene) {
	}
	,update: function(phase) {
		if(wl_demo_TransformNodeController.STOPPED && !this.ignoreStop) {
			return;
		}
		if(this.mode == wl_demo_CameraController.STATIC) {
			if(this.updatePath) {
				this.node.position.x = this.position.x;
				this.node.position.y = this.position.y;
				this.node.position.z = this.position.z;
			}
			if(this.updateLook) {
				this.node.lookAt(this.lookAt);
			}
		} else if(this.mode == wl_demo_CameraController.LINEAR) {
			if(this.updatePath) {
				var a = this.points[0];
				var b = this.points[1];
				var c = new BABYLON.Vector3(0,0,0);
				BABYLON.Vector3.LerpToRef(a,b,phase,c);
				this.node.position.x = c.x;
				this.node.position.y = c.y;
				this.node.position.z = c.z;
			}
			if(this.updateLook) {
				var a1 = this.lookAts[0];
				var b1 = this.lookAts[1];
				var c1 = new BABYLON.Vector3(0,0,0);
				BABYLON.Vector3.LerpToRef(a1,b1,phase,c1);
				this.node.lookAt(c1);
			}
		} else if(this.mode == wl_demo_CameraController.FOLLOW) {
			if(this.updatePath) {
				this.node.position.x = this.follow.position.x + this.followOffset.x;
				this.node.position.y = this.follow.position.y + this.followOffset.y;
				this.node.position.z = this.follow.position.z + this.followOffset.z;
			}
			if(this.updateLook) {
				this.node.lookAt(this.follow.position.add(this.followLookOffset));
			}
		} else if(this.mode == wl_demo_CameraController.BEZIER) {
			if(phase < 0) {
				phase = 0;
			} else if(phase > 1) {
				phase = 1;
			}
			if(this.updatePath) {
				var p = this.path.getPoints()[Math.floor(Math.min(phase * this.path.getPoints().length,this.path.getPoints().length - 1))];
				this.node.position.x = p.x;
				this.node.position.y = p.y;
				this.node.position.z = p.z;
			}
			if(this.updateLook) {
				var p1 = this.lookPath.getPoints()[Math.floor(Math.min(phase * this.path.getPoints().length,this.path.getPoints().length - 1))];
				this.node.lookAt(p1);
				this.lookAt = p1;
			}
			this.position = this.node.position;
		}
	}
	,__class__: wl_demo_TransformNodeController
};
var wl_library_Library = function() {
	if(wl_library_Library.inst == null) {
		wl_library_Library.inst = this;
	} else {
		console.log("Creating multiple Library instances. Are you sure?");
	}
	this.materials = new wl_library_MaterialBuilders();
	this.staticMaterials = new haxe_ds_EnumValueMap();
};
$hxClasses["wl.library.Library"] = wl_library_Library;
wl_library_Library.__name__ = ["wl","library","Library"];
wl_library_Library.get_instance = function() {
	if(wl_library_Library.inst == null) {
		wl_library_Library.instance = new wl_library_Library();
	}
	return wl_library_Library.inst;
};
wl_library_Library.prototype = {
	getMaterial: function(type,asStatic) {
		if(asStatic) {
			var m = this.staticMaterials.get(type);
			if(m == null) {
				m = Reflect.field(this.materials,type[0]).apply(this.materials,[]);
				this.staticMaterials.set(type,m);
			}
			return m;
		}
		return Reflect.field(this.materials,type[0]).apply(this.materials,[]);
	}
	,__class__: wl_library_Library
};
var wl_library_MaterialBuilders = function() {
};
$hxClasses["wl.library.MaterialBuilders"] = wl_library_MaterialBuilders;
wl_library_MaterialBuilders.__name__ = ["wl","library","MaterialBuilders"];
wl_library_MaterialBuilders.prototype = {
	chrome: function() {
		return new BABYLON.StandardMaterial("",null);
	}
	,whiteChrome: function() {
		return new BABYLON.StandardMaterial("",null);
	}
	,ghost: function() {
		var xray_mat = new BABYLON.StandardMaterial("xray",null);
		xray_mat.emissiveColor = new BABYLON.Color3(1,1,1);
		xray_mat.alpha = 0.2;
		var fresnel_params = { };
		fresnel_params.isEnabled = true;
		fresnel_params.leftColor = new BABYLON.Color3(0.5,0.6,1);
		fresnel_params.rightColor = new BABYLON.Color3(0,0,0);
		fresnel_params.power = 2;
		fresnel_params.bias = 0.1;
		var fresnel_params2 = { };
		fresnel_params2.isEnabled = true;
		fresnel_params2.leftColor = new BABYLON.Color3(1,1,1);
		fresnel_params2.rightColor = new BABYLON.Color3(0.2,0.2,0.2);
		fresnel_params2.power = 2;
		fresnel_params2.bias = 0.5;
		xray_mat.emissiveFresnelParameters = fresnel_params;
		xray_mat.opacityFresnelParameters = fresnel_params2;
		return xray_mat;
	}
	,ghost2: function() {
		var xray_mat = new BABYLON.StandardMaterial("xray",null);
		xray_mat.emissiveColor = new BABYLON.Color3(1,1,1);
		xray_mat.alpha = 0.2;
		var fresnel_params = { };
		fresnel_params.isEnabled = true;
		fresnel_params.leftColor = new BABYLON.Color3(0.5,0.6,1);
		fresnel_params.rightColor = new BABYLON.Color3(0,0,0);
		fresnel_params.power = 2;
		fresnel_params.bias = 0.1;
		var fresnel_params2 = { };
		fresnel_params2.isEnabled = true;
		fresnel_params2.leftColor = new BABYLON.Color3(1,1,1);
		fresnel_params2.rightColor = new BABYLON.Color3(0.2,0.2,0.2);
		fresnel_params2.power = 2;
		fresnel_params2.bias = 0.5;
		xray_mat.emissiveFresnelParameters = fresnel_params;
		xray_mat.opacityFresnelParameters = fresnel_params2;
		return xray_mat;
	}
	,__class__: wl_library_MaterialBuilders
};
var wl_library_Materials = { __ename__ : true, __constructs__ : ["chrome","whiteChrome","ghost","ghost2"] };
wl_library_Materials.chrome = ["chrome",0];
wl_library_Materials.chrome.toString = $estr;
wl_library_Materials.chrome.__enum__ = wl_library_Materials;
wl_library_Materials.whiteChrome = ["whiteChrome",1];
wl_library_Materials.whiteChrome.toString = $estr;
wl_library_Materials.whiteChrome.__enum__ = wl_library_Materials;
wl_library_Materials.ghost = ["ghost",2];
wl_library_Materials.ghost.toString = $estr;
wl_library_Materials.ghost.__enum__ = wl_library_Materials;
wl_library_Materials.ghost2 = ["ghost2",3];
wl_library_Materials.ghost2.toString = $estr;
wl_library_Materials.ghost2.__enum__ = wl_library_Materials;
var wl_post_displacement_Displacement = function(camera,engine) {
	this.time = 0;
	this.zoom = 0.01;
	this.scaleY = 0.01;
	this.scaleX = 0.01;
	var _gthis = this;
	BABYLON.Effect.ShadersStore["displacementFragmentShader"] = haxe_Resource.getString("displacement.frag");
	var t = wl_core_Assets.getTexture("perlin-512.png");
	BABYLON.PostProcess.call(this,"displacementPostProcess","displacement",["scaleX","scaleY","zoom","offset"],["tDispMap"],1.0,null,BABYLON.Texture.NEAREST_SAMPLINGMODE,engine,false);
	this.onApplyObservable.add(function(e,es) {
		e.setFloat("scaleX",_gthis.scaleX);
		e.setFloat("scaleY",_gthis.scaleY);
		e.setFloat("zoom",_gthis.zoom);
		e.setTexture("tDispMap",t);
		var tmp = _gthis.time / 15;
		var tmp1 = _gthis.time / 18;
		_gthis.getEffect().setArray2("offset",[tmp,tmp1]);
	});
	this.getEffect().setTexture("tDispMap",t);
	wl_core_Demo.instance.onUpdate.connect(function(ts) {
		var tmp2 = ts.toMilliseconds();
		_gthis.time = tmp2 / 1000;
	});
};
$hxClasses["wl.post.displacement.Displacement"] = wl_post_displacement_Displacement;
wl_post_displacement_Displacement.__name__ = ["wl","post","displacement","Displacement"];
wl_post_displacement_Displacement.__super__ = BABYLON.PostProcess;
wl_post_displacement_Displacement.prototype = $extend(BABYLON.PostProcess.prototype,{
	setupDatGui: function(folder) {
		var _gthis = this;
		folder.add(this,"scaleX").step(0.0001).min(0).max(1).onChange(function(value) {
			_gthis.scaleX = value;
		});
		folder.add(this,"scaleY").step(0.0001).min(0).max(1).onChange(function(value1) {
			_gthis.scaleY = value1;
		});
		folder.add(this,"zoom").step(0.0001).min(0).max(100).onChange(function(value2) {
			_gthis.zoom = value2;
		});
	}
	,__class__: wl_post_displacement_Displacement
});
var wl_post_distort_DistortPostProcess = function(camera,engine) {
	this.brightness = 0;
	this.autoOffset = false;
	this.offsetSpeed = 0.001;
	this.offset = 0;
	this.lineHeight = wl_core_Config.RESOLUTION[1] / 4;
	this.intensityY = 0;
	this.intensity = 0;
	var _gthis = this;
	BABYLON.Effect.ShadersStore["distortFragmentShader"] = haxe_Resource.getString("distort.frag");
	BABYLON.PostProcess.call(this,"distortPostProcess","distort",["intensity","intensityY","height","offsetY","brightness"],null,1.0,null,BABYLON.Texture.NEAREST_SAMPLINGMODE,engine,false);
	this.onApplyObservable.add(function(e,es) {
		e.setFloat("intensity",_gthis.intensity);
		e.setFloat("intensityY",_gthis.intensityY);
		e.setFloat("height",_gthis.lineHeight);
		e.setFloat("offsetY",_gthis.offset);
		e.setFloat("brightness",_gthis.brightness);
	});
	wl_core_Demo.instance.onUpdate.connect(function(ts) {
		var _gthis1 = _gthis.offsetSpeed;
		var tmp = ts.toMilliseconds();
		_gthis.offset = _gthis1 * tmp;
	});
};
$hxClasses["wl.post.distort.DistortPostProcess"] = wl_post_distort_DistortPostProcess;
wl_post_distort_DistortPostProcess.__name__ = ["wl","post","distort","DistortPostProcess"];
wl_post_distort_DistortPostProcess.__super__ = BABYLON.PostProcess;
wl_post_distort_DistortPostProcess.prototype = $extend(BABYLON.PostProcess.prototype,{
	setupDatGui: function(folder) {
		folder.add(this,"intensityY").min(0).max(1).step(0.001);
		folder.add(this,"intensity").min(0).max(1).step(0.001);
		folder.add(this,"height").min(0).max(1080).step(0.1);
		folder.add(this,"offsetSpeed").min(0).max(1).step(0.0001);
		folder.add(this,"autoOffset");
	}
	,__class__: wl_post_distort_DistortPostProcess
});
var wl_post_texturemix_TextureMix = function(camera,engine) {
	this.time = 0;
	this.phase = 0.5;
	var _gthis = this;
	BABYLON.Effect.ShadersStore["texturemixFragmentShader"] = haxe_Resource.getString("texturemix.frag");
	var t = wl_core_Assets.getTexture("perlin-512.png");
	t.wrapU = BABYLON.Texture.WRAP_ADDRESSMODE;
	t.wrapV = BABYLON.Texture.WRAP_ADDRESSMODE;
	var t2 = wl_core_Assets.getTexture("plasma_seamless.jpg");
	t2.wrapU = BABYLON.Texture.WRAP_ADDRESSMODE;
	t2.wrapV = BABYLON.Texture.WRAP_ADDRESSMODE;
	BABYLON.PostProcess.call(this,"texturemixPostProcess","texturemix",["phase","time"],["mixmap","textureSampler2"],1.0,null,BABYLON.Texture.NEAREST_SAMPLINGMODE,engine,false);
	this.onApplyObservable.add(function(e,es) {
		e.setFloat("phase",_gthis.phase);
		e.setTexture("mixmap",t);
		if(_gthis.mixTo != null) {
			e.setTexture("textureSampler2",_gthis.mixTo.renderTo);
		}
		e.setFloat("time",_gthis.time);
	});
	wl_core_Demo.instance.onUpdate.connect(function(ts) {
		var tmp = ts.toMilliseconds();
		_gthis.time = tmp / 1000;
	});
};
$hxClasses["wl.post.texturemix.TextureMix"] = wl_post_texturemix_TextureMix;
wl_post_texturemix_TextureMix.__name__ = ["wl","post","texturemix","TextureMix"];
wl_post_texturemix_TextureMix.__super__ = BABYLON.PostProcess;
wl_post_texturemix_TextureMix.prototype = $extend(BABYLON.PostProcess.prototype,{
	setupDatGui: function(folder) {
		var _gthis = this;
		folder.add(this,"phase").step(0.0001).min(0).max(1).onChange(function(value) {
			_gthis.phase = value;
		});
	}
	,set_mixTo: function(p) {
		this.mixTo = p;
		console.log("MIX TO UPDATED");
		return p;
	}
	,__class__: wl_post_texturemix_TextureMix
});
var wl_setup_JsonConfigurator = function() {
};
$hxClasses["wl.setup.JsonConfigurator"] = wl_setup_JsonConfigurator;
wl_setup_JsonConfigurator.__name__ = ["wl","setup","JsonConfigurator"];
wl_setup_JsonConfigurator.prototype = {
	fromJson: function(json) {
		var config = JSON.parse(json);
		this.audioSettingsfromJson(config);
		this.visualSettingsfromJson(config);
		this.timelineFromJson(config);
	}
	,audioSettingsfromJson: function(config) {
		wl_core_Config.BEATS_PER_MINUTE = config.audio.beatsPerMinute;
		wl_core_Config.BEATS_PER_BAR = config.audio.beatsPerBar;
		wl_core_Config.TICKS_PER_BEAT = config.audio.ticksPerBeat;
		wl_core_Config.MUSIC_BEGIN = config.audio.musicBegin;
		wl_core_Config.SONG_PATH = config.audio.songPath;
		wl_core_Config.ENABLE_FFT = config.audio.enableFFT;
	}
	,visualSettingsfromJson: function(config) {
		wl_core_Config.FPS = config.visual.targetFps;
		wl_core_Config.RESOLUTION = config.visual.resolution;
		wl_core_Config.ANTIALIAS = config.visual.antiAlias;
		wl_core_Config.ENABLE_SHADOWS = config.visual.enableShadows;
		wl_core_Config.CLEAR_COLOR = BABYLON.Color4.FromHexString(config.visual.clearColor);
		console.log(wl_core_Config.CLEAR_COLOR);
		wl_core_Config.SHADOW_MAP_SIZE = config.visual.shadowMapSize;
	}
	,timelineFromJson: function(config) {
		var tl = config.timeline;
		var convertedTl = [];
		var ignoreParts = window.location.hash.indexOf("Coverride=") >= 0;
		if(window.location.hash.indexOf("override=") >= 0) {
			convertedTl = [];
			var m = new RegExp("override=(.*)","").exec(window.location.hash);
			console.log("overriding timeline with " + m[1]);
			convertedTl.push(this.tlFromConfig({ "partId" : "override", "type" : m[1], "renderToScreen" : true, "runOn" : [0,0,0,0], "runOff" : [128,0,0,0], "extra" : "", "forceNewPart" : false}));
		}
		if(!ignoreParts) {
			var _g = 0;
			while(_g < tl.length) {
				var c = tl[_g];
				++_g;
				convertedTl.push(this.tlFromConfig(c));
			}
		}
		wl_core_Config.TIMELINE = convertedTl;
	}
	,tlFromConfig: function(config) {
		return new wl_demo_TimeLine(Type.createInstance(Type.resolveClass(config.type),[]),this.mainTimesigFromArray(config.runOn),this.mainTimesigFromArray(config.runOff),config.partId,config.renderToScreen,this.mainTimesigFromArray(config.rtsOn),this.mainTimesigFromArray(config.rtsOff),config.forceNewPart,config.extra);
	}
	,mainTimesigFromArray: function(tsArray) {
		if(tsArray == null) {
			return null;
		}
		return new wl_core_TimeSig(tsArray.length > 0 ? tsArray[0] : null,tsArray.length > 1 ? tsArray[1] : null,tsArray.length > 2 ? tsArray[2] : null,tsArray.length > 3 ? tsArray[3] : null,wl_core_TimeSig.ABSOLUTE);
	}
	,__class__: wl_setup_JsonConfigurator
};
var wl_setup_Setup = function() {
	throw new js__$Boot_HaxeError("Setup is static only.");
};
$hxClasses["wl.setup.Setup"] = wl_setup_Setup;
wl_setup_Setup.__name__ = ["wl","setup","Setup"];
wl_setup_Setup.init = function(demo) {
	wl_setup_Setup.setupDiv = $("#setup");
	wl_setup_Setup.demoDiv = $("#demo");
	wl_setup_Setup.resolution = wl_setup_Setup.setupDiv.find("#resolution");
	var fullscreen = wl_setup_Setup.setupDiv.find("#fullscreen");
	var start = wl_setup_Setup.setupDiv.find("#start");
	fullscreen.click(wl_setup_Setup.fullScreenClickHandler);
	start.click(wl_setup_Setup.startClickHandler);
	wl_setup_Setup.demo = demo;
	if(window.location.protocol.indexOf("file") >= 0) {
		$("#localWarning").css("display","");
	}
};
wl_setup_Setup.hideSetup = function() {
	wl_setup_Setup.setupDiv.remove();
};
wl_setup_Setup.startRun = function() {
	if(wl_setup_Setup.setupDiv.find("#muted").find("input")["is"](":checked")) {
		wl_core_Config.MUTED = true;
	}
	var debug = wl_setup_Setup.setupDiv.find("#debug").find("input")["is"](":checked");
	wl_core_Config.DEBUG = debug;
	if(debug) {
		$(".debug").css("display","block");
	} else {
		$(".debug").css("display","none");
	}
	wl_setup_Setup.loadImg = wl_core_Assets.get("loadingImage.png");
	wl_setup_Setup.loadImg.style.position = "absolute";
	wl_setup_Setup.loadImg.style.left = "0px";
	wl_setup_Setup.loadImg.style.right = "0px";
	wl_setup_Setup.loadImg.style.top = "0px";
	wl_setup_Setup.loadImg.style.bottom = "0px";
	wl_setup_Setup.loadImg.style.width = "100%";
	wl_setup_Setup.loadImg.style.height = "100%";
	wl_setup_Setup.demoDiv.append(wl_setup_Setup.loadImg);
	wl_setup_Setup.demo.init(wl_setup_Setup.demoDiv[0],function() {
		wl_setup_Setup.loadImg.remove();
		wl_setup_Setup.demo.start();
	});
	window.document.getElementById("demo").style.display = "block";
};
wl_setup_Setup.fullScreenClickHandler = function(e) {
	wl_setup_Setup.hideSetup();
	try {
		wl_setup_Setup.demoDiv[0].requestFullscreen();
	} catch( e1 ) {
		throw new js__$Boot_HaxeError("Full screen could not be initialized. Please reload and try again.");
	}
	var w = window.screen.width;
	var h = window.screen.height;
	var ratio = wl_core_Config.RATIO;
	var lockAspect = $("#aspectLock input").val() == "on";
	if(lockAspect && w / ratio < h) {
		h = w * 720 / 1280;
	} else if(lockAspect && h < w / ratio) {
		w = h * 1280 / 720;
	}
	wl_core_Config.RESOLUTION[0] = Math.floor(w);
	wl_core_Config.RESOLUTION[1] = Math.floor(h);
	wl_setup_Setup.demoDiv.css("background","black");
	haxe_Timer.delay(wl_setup_Setup.startRun,5000);
};
wl_setup_Setup.startClickHandler = function(e) {
	$("#zoomWarning").css("display","none");
	$("#demo").css("transform","").css("-webkit-transform","");
	var lockAspect = $("#aspectLock input").val() == "on";
	$("#muted input")["is"](":checked");
	var resolutionType = $("#resolution .active input[name='options']").val();
	wl_setup_Setup.hideSetup();
	var w = 1280;
	var h = 720;
	if(resolutionType == "b") {
		w = 1920;
		h = 1080;
	} else if(resolutionType == "c") {
		w = window.innerWidth;
		h = window.innerHeight;
		var ratio = wl_core_Config.RATIO;
		if(lockAspect && w / ratio < h) {
			h = w / ratio;
		} else if(lockAspect && h < w / ratio) {
			w = h * ratio;
		}
	}
	wl_core_Config.RESOLUTION[0] = w;
	wl_core_Config.RESOLUTION[1] = h;
	wl_setup_Setup.demoDiv.css("width",w + "px").css("height",h + "px");
	haxe_Timer.delay(wl_setup_Setup.startRun,50);
};
wl_setup_Setup.prototype = {
	__class__: wl_setup_Setup
};
var wl_sounds_SoundAnalyzer = function() {
	this.historySize = 6;
	this.filters = [];
	this.historyLeft = [];
	this.historyRight = [];
	var _g1 = 0;
	var _g = wl_sounds_SoundWL.FFT_PRECISION;
	while(_g1 < _g) {
		++_g1;
		this.historyLeft.push([]);
		this.historyRight.push([]);
	}
};
$hxClasses["wl.sounds.SoundAnalyzer"] = wl_sounds_SoundAnalyzer;
wl_sounds_SoundAnalyzer.__name__ = ["wl","sounds","SoundAnalyzer"];
wl_sounds_SoundAnalyzer.prototype = {
	update: function() {
		var _g = 0;
		var _g1 = this.filters;
		while(_g < _g1.length) {
			var filter = _g1[_g];
			++_g;
			filter.min = 1;
			filter.max = 0;
			filter.triggered = false;
			if(filter.channels == null) {
				filter.channels = wl_sounds_Channels.both;
			}
		}
		var fft = wl_sounds_SoundWL.getFFT();
		var band = wl_sounds_SoundWL.sampleRate / wl_sounds_SoundWL.FFT_PRECISION;
		if(fft.frequencyLeft == null) {
			return;
		}
		var _g11 = 0;
		var _g2 = fft.frequencyLeft.length;
		while(_g11 < _g2) {
			var i = _g11++;
			var hL = this.historyLeft[i];
			hL.push(fft.frequencyLeft[i] / 255);
			var hR = this.historyRight[i];
			hR.push(fft.frequencyRight[i] / 255);
			while(hL.length > this.historySize) {
				hL.shift();
				hR.shift();
			}
			var sumL = 0;
			var _g21 = 0;
			while(_g21 < hL.length) {
				var v = hL[_g21];
				++_g21;
				sumL += v;
			}
			sumL /= this.historySize;
			var sumR = 0;
			var _g22 = 0;
			while(_g22 < hR.length) {
				var v1 = hR[_g22];
				++_g22;
				sumR += v1;
			}
			sumR /= this.historySize;
			var hz = band * i;
			var _g23 = 0;
			var _g3 = this.filters;
			while(_g23 < _g3.length) {
				var filter1 = _g3[_g23];
				++_g23;
				if(filter1.isolate ? hz >= filter1.lowLimit && hz <= filter1.highLimit : hz > filter1.highLimit || hz < filter1.lowLimit) {
					var sum = filter1.channels == wl_sounds_Channels.both ? (sumL + sumR) / 2 : filter1.channels == wl_sounds_Channels.right ? sumR : sumL;
					filter1.min = filter1.min > sum ? sum : filter1.min;
					filter1.max = filter1.max < sum ? sum : filter1.max;
					filter1.triggered = true;
				}
			}
		}
		var _g4 = 0;
		var _g12 = this.filters;
		while(_g4 < _g12.length) ++_g4;
	}
	,__class__: wl_sounds_SoundAnalyzer
};
var wl_sounds_Channels = { __ename__ : true, __constructs__ : ["left","right","both"] };
wl_sounds_Channels.left = ["left",0];
wl_sounds_Channels.left.toString = $estr;
wl_sounds_Channels.left.__enum__ = wl_sounds_Channels;
wl_sounds_Channels.right = ["right",1];
wl_sounds_Channels.right.toString = $estr;
wl_sounds_Channels.right.__enum__ = wl_sounds_Channels;
wl_sounds_Channels.both = ["both",2];
wl_sounds_Channels.both.toString = $estr;
wl_sounds_Channels.both.__enum__ = wl_sounds_Channels;
var wl_sounds_SoundWL = function() {
	throw new js__$Boot_HaxeError("Sound is static");
};
$hxClasses["wl.sounds.SoundWL"] = wl_sounds_SoundWL;
wl_sounds_SoundWL.__name__ = ["wl","sounds","SoundWL"];
wl_sounds_SoundWL.init = function() {
	wl_sounds_SoundWL.loadMusicFile();
	wl_sounds_SoundWL.context = createjs.Sound.activePlugin.context;
	wl_sounds_SoundWL.sampleRate = createjs.Sound.activePlugin.context.sampleRate;
	wl_sounds_SoundWL.dynamicsCompressorNode = createjs.Sound.activePlugin.dynamicsCompressorNode;
	wl_sounds_SoundWL.gainNode = createjs.Sound.activePlugin.gainNode;
	if(wl_core_Config.ENABLE_FFT) {
		wl_sounds_SoundWL.initializeFFT();
	}
};
wl_sounds_SoundWL.setVolume = function(volume) {
	wl_sounds_SoundWL.volume = volume;
	if(wl_sounds_SoundWL.instance != null) {
		wl_sounds_SoundWL.instance.volume = volume;
	}
};
wl_sounds_SoundWL.getPosition = function() {
	if(wl_sounds_SoundWL.instance != null) {
		wl_sounds_SoundWL.time.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	} else if(wl_sounds_SoundWL.context != null) {
		wl_sounds_SoundWL.time.fromTime((wl_sounds_SoundWL.context.currentTime - wl_sounds_SoundWL.startTime) / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	}
	return wl_sounds_SoundWL.time;
};
wl_sounds_SoundWL.getFFT = function() {
	return wl_sounds_SoundWL.FFT;
};
wl_sounds_SoundWL.updateFFT = function() {
	if(!wl_debug_Debug.paused && (wl_sounds_SoundWL.instance != null || wl_sounds_SoundWL.context != null) && wl_core_Config.ENABLE_FFT && wl_sounds_SoundWL.analyserNodeLeft != null) {
		wl_sounds_SoundWL.analyserNodeLeft.getFloatFrequencyData(wl_sounds_SoundWL.freqFloatDataLeft);
		wl_sounds_SoundWL.analyserNodeLeft.getByteFrequencyData(wl_sounds_SoundWL.freqByteDataLeft);
		wl_sounds_SoundWL.analyserNodeLeft.getByteTimeDomainData(wl_sounds_SoundWL.timeByteDataLeft);
		wl_sounds_SoundWL.analyserNodeRight.getFloatFrequencyData(wl_sounds_SoundWL.freqFloatDataRight);
		wl_sounds_SoundWL.analyserNodeRight.getByteFrequencyData(wl_sounds_SoundWL.freqByteDataRight);
		wl_sounds_SoundWL.analyserNodeRight.getByteTimeDomainData(wl_sounds_SoundWL.timeByteDataRight);
	}
};
wl_sounds_SoundWL.start = function() {
	wl_sounds_SoundWL.instance = createjs.Sound.play("music");
	wl_sounds_SoundWL.instance.on("complete",wl_sounds_SoundWL.handleComplete);
	wl_sounds_SoundWL.instance.volume = wl_core_Config.MUTED ? 0 : wl_sounds_SoundWL.volume;
	if(wl_core_Config.ENABLE_FFT) {
		wl_core_Graphics.instance.onRender.disconnect(wl_sounds_SoundWL.updateFFT);
		wl_core_Graphics.instance.onRender.connect(wl_sounds_SoundWL.updateFFT);
	}
	wl_sounds_SoundWL.onSoundReady.emit();
};
wl_sounds_SoundWL.handleComplete = function() {
	wl_sounds_SoundWL.onSoundComplete.emit();
};
wl_sounds_SoundWL.loadMusicFile = function() {
	var sounds = [{ id : "music", src : wl_core_Config.SONG_PATH}];
	createjs.Sound.alternateExtensions = ["mp3"];
	createjs.Sound.addEventListener("fileload",wl_sounds_SoundWL.handleLoad);
	createjs.Sound.registerSounds(sounds);
};
wl_sounds_SoundWL.initializeFFT = function() {
	var context = wl_sounds_SoundWL.context;
	var fftsize = wl_sounds_SoundWL.FFT_PRECISION;
	if(context != null && $bind(context,context.createAnalyser) != null) {
		var mergerNode = context.createChannelMerger(2);
		wl_sounds_SoundWL.analyserNodeLeft = context.createAnalyser();
		wl_sounds_SoundWL.analyserNodeLeft.fftSize = fftsize;
		wl_sounds_SoundWL.analyserNodeLeft.smoothingTimeConstant = 0.0;
		wl_sounds_SoundWL.analyserNodeRight = context.createAnalyser();
		wl_sounds_SoundWL.analyserNodeRight.fftSize = fftsize;
		wl_sounds_SoundWL.analyserNodeRight.smoothingTimeConstant = 0.0;
		wl_sounds_SoundWL.dynamicsCompressorNode.disconnect();
		var splitterNode = context.createChannelSplitter(2);
		wl_sounds_SoundWL.gainNode.disconnect();
		wl_sounds_SoundWL.gainNode.connect(splitterNode);
		splitterNode.connect(wl_sounds_SoundWL.analyserNodeLeft,0,0);
		splitterNode.connect(wl_sounds_SoundWL.analyserNodeRight,1,0);
		wl_sounds_SoundWL.freqFloatDataLeft = new Float32Array(wl_sounds_SoundWL.analyserNodeLeft.frequencyBinCount);
		wl_sounds_SoundWL.freqByteDataLeft = new Uint8Array(wl_sounds_SoundWL.analyserNodeLeft.frequencyBinCount);
		wl_sounds_SoundWL.timeByteDataLeft = new Uint8Array(wl_sounds_SoundWL.analyserNodeLeft.frequencyBinCount);
		wl_sounds_SoundWL.freqFloatDataRight = new Float32Array(wl_sounds_SoundWL.analyserNodeRight.frequencyBinCount);
		wl_sounds_SoundWL.freqByteDataRight = new Uint8Array(wl_sounds_SoundWL.analyserNodeRight.frequencyBinCount);
		wl_sounds_SoundWL.timeByteDataRight = new Uint8Array(wl_sounds_SoundWL.analyserNodeRight.frequencyBinCount);
		wl_sounds_SoundWL.analyserNodeLeft.connect(mergerNode,0,0);
		wl_sounds_SoundWL.analyserNodeRight.connect(mergerNode,0,1);
		mergerNode.connect(context.destination);
	} else {
		console.log("FFT could not be initialized.");
	}
	wl_sounds_SoundWL.FFT.dbLeft = wl_sounds_SoundWL.freqFloatDataLeft;
	wl_sounds_SoundWL.FFT.frequencyLeft = wl_sounds_SoundWL.freqByteDataLeft;
	wl_sounds_SoundWL.FFT.waveformLeft = wl_sounds_SoundWL.timeByteDataLeft;
	wl_sounds_SoundWL.FFT.dbRight = wl_sounds_SoundWL.freqFloatDataRight;
	wl_sounds_SoundWL.FFT.frequencyRight = wl_sounds_SoundWL.freqByteDataRight;
	wl_sounds_SoundWL.FFT.waveformRight = wl_sounds_SoundWL.timeByteDataRight;
};
wl_sounds_SoundWL.handleLoad = function() {
	wl_sounds_SoundWL.loaded = true;
	wl_sounds_SoundWL.onSoundLoaded.emit();
};
wl_sounds_SoundWL.prototype = {
	__class__: wl_sounds_SoundWL
};
var wl_util_DatGuiHelper = function() {
};
$hxClasses["wl.util.DatGuiHelper"] = wl_util_DatGuiHelper;
wl_util_DatGuiHelper.__name__ = ["wl","util","DatGuiHelper"];
wl_util_DatGuiHelper.addVector = function(folder,vector,step,callback) {
	if(step == null) {
		step = 0.1;
	}
	folder.add(vector,"x").step(step).onChange(callback);
	folder.add(vector,"y").step(step).onChange(callback);
	folder.add(vector,"z").step(step).onChange(callback);
};
wl_util_DatGuiHelper.addColor = function(folder,obu,property) {
	obu[property + "_x"] = "#000000";
	folder.addColor(obu,property + "_x").onChange(function(data) {
		console.log(data);
		var color = BABYLON.Color3.FromHexString(data);
		console.log(color);
		obu[property].r = color.r;
		obu[property].g = color.g;
		obu[property].b = color.b;
	});
};
wl_util_DatGuiHelper.prototype = {
	__class__: wl_util_DatGuiHelper
};
var wl_util_ExtendedMeshBuilder = function() {
};
$hxClasses["wl.util.ExtendedMeshBuilder"] = wl_util_ExtendedMeshBuilder;
wl_util_ExtendedMeshBuilder.__name__ = ["wl","util","ExtendedMeshBuilder"];
wl_util_ExtendedMeshBuilder.BuildRingDisc = function(diameter,innerDiameter,height,scene,tessellation) {
	if(tessellation == null) {
		tessellation = 40;
	}
	var outerdisc = BABYLON.MeshBuilder.CreateCylinder("",{ diameter : diameter, tessellation : tessellation, height : height},null);
	var innerDisc = BABYLON.MeshBuilder.CreateCylinder("",{ diameter : innerDiameter, tessellation : tessellation, height : height * 2},null);
	var csg = BABYLON.CSG.FromMesh(outerdisc);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(innerDisc));
	var mesh = csg.toMesh("name",null,scene,false);
	outerdisc.dispose();
	innerDisc.dispose();
	return mesh;
};
wl_util_ExtendedMeshBuilder.CreateRoom = function(name,options,scene) {
	var outerBox = BABYLON.MeshBuilder.CreateBox(name + "outer",options,null);
	options.size -= options.wallThickness;
	options.width -= options.wallThickness;
	options.height -= options.wallThickness;
	options.depth -= options.wallThickness;
	var innerBox = BABYLON.MeshBuilder.CreateBox(name + "inner",options,null);
	var csg = BABYLON.CSG.FromMesh(outerBox);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(innerBox));
	outerBox.dispose();
	innerBox.dispose();
	return csg.toMesh(name,null,scene,false);
};
wl_util_ExtendedMeshBuilder.CreateTube = function(name,options,scene) {
	var outertube = BABYLON.MeshBuilder.CreateCylinder(name + "outer",options,null);
	options.diameter -= options.wallThickness;
	options.diameterBottom -= options.wallThickness;
	options.diameterTop -= options.wallThickness;
	options.height *= 1.1;
	var innertube = BABYLON.MeshBuilder.CreateCylinder(name + "inner",options,null);
	var csg = BABYLON.CSG.FromMesh(outertube);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(innertube));
	var mesh = csg.toMesh(name,null,scene,false);
	outertube.dispose();
	innertube.dispose();
	return mesh;
};
wl_util_ExtendedMeshBuilder.CreateTrashTube = function(name,options,scene) {
	var targetHeight = options.height;
	var targetDiameter = options.diameter;
	var outertube = BABYLON.MeshBuilder.CreateCylinder(name + "outer",options,null);
	options.diameter -= options.wallThickness;
	options.diameterBottom -= options.wallThickness;
	options.diameterTop -= options.wallThickness;
	options.height *= 1.1;
	var innertube = BABYLON.MeshBuilder.CreateCylinder(name + "inner",options,null);
	var csg = BABYLON.CSG.FromMesh(outertube);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(innertube));
	var mesh = csg.toMesh(name,null,scene,false);
	outertube.dispose();
	innertube.dispose();
	mesh.translate(new BABYLON.Vector3(0,1,0),targetHeight / 2);
	var meshes = [];
	meshes.push(mesh);
	var _g1 = 0;
	var _g = targetHeight;
	while(_g1 < _g) {
		var i = _g1++;
		if(wl_util_Random.nextFloat() < 0.5 || i > 250) {
			continue;
		}
		var b = BABYLON.MeshBuilder.CreateBox("",{ width : 40 * wl_util_Random.nextFloat(), size : wl_util_Random.nextFloat() + .25},null);
		meshes.push(b);
		var tmp = options.diameter * wl_util_Random.nextFloat();
		b.position.x = tmp - options.diameter / 2;
		var tmp1 = options.diameter * wl_util_Random.nextFloat() * 0.5;
		var tmp2 = options.diameter * 0.2 * wl_util_Random.nextFloat();
		b.position.z = tmp1 + tmp2;
		b.rotate(new BABYLON.Vector3(0,1,0),wl_util_Random.nextFloat() * Math.PI * 2);
		b.position.y = i;
	}
	var ringplaces = [55,98,151,213,276,320,350,370];
	var ringRadiuses = [targetDiameter - 10,targetDiameter - 11,targetDiameter - 11,targetDiameter - 12,targetDiameter - 11,targetDiameter - 12,targetDiameter - 12,targetDiameter - 12,targetDiameter - 12,targetDiameter - 12];
	var _g2 = 0;
	while(_g2 < 8) {
		var i1 = _g2++;
		var cyl = wl_util_ExtendedMeshBuilder.BuildRingDisc(targetDiameter,ringRadiuses[i1],5,null);
		cyl.position.y = ringplaces[i1];
		meshes.push(cyl);
	}
	return BABYLON.Mesh.MergeMeshes(meshes,true);
};
wl_util_ExtendedMeshBuilder.CreateGrate = function(name,options,scene) {
	var box = BABYLON.MeshBuilder.CreateBox("",options);
	box.translate(new BABYLON.Vector3(0,0,1),options.depth / 2);
	box.translate(BABYLON.Vector3.Right(),options.width / 2.0);
	box.bakeCurrentTransformIntoVertices();
	var csg = BABYLON.CSG.FromMesh(box);
	var _g1 = 0;
	var _g = Math.floor(options.width / options.gridSize);
	while(_g1 < _g) {
		var x = _g1++;
		var _g3 = 0;
		var _g2 = options.depth / options.gridSize;
		while(_g3 < _g2) {
			var holeb = BABYLON.MeshBuilder.CreateBox("",{ width : options.gridSize - options.gridSpacing, depth : options.gridSize - options.gridSpacing, height : options.height * 4});
			holeb.position.x = x * options.gridSize + options.gridSize / 2;
			holeb.position.z = _g3++ * options.gridSize + options.gridSize / 2;
			csg.subtractInPlace(BABYLON.CSG.FromMesh(holeb));
			holeb.dispose();
		}
	}
	var mesh = csg.toMesh("",null,null,false);
	mesh.translate(BABYLON.Vector3.Right(),-options.width / 2);
	mesh.bakeCurrentTransformIntoVertices();
	box.dispose();
	return mesh;
};
wl_util_ExtendedMeshBuilder.CreateWindowedTube = function(radius,length,height,tubeMaterial,glowMaterial) {
	var tube = BABYLON.MeshBuilder.CreateTube("",{ path : [new BABYLON.Vector3(0,0,0),new BABYLON.Vector3(0,height,length * 0.05),new BABYLON.Vector3(0,height,length * 0.8),new BABYLON.Vector3(0,height,length * 0.95),new BABYLON.Vector3(0,0,length)], radius : radius},null);
	var cylinder = BABYLON.MeshBuilder.CreateCylinder("",{ diameter : radius, height : length * 0.75},null);
	cylinder.rotate(BABYLON.Vector3.Right(),Math.PI / 2);
	cylinder.position.y = height + radius;
	cylinder.position.z = length / 2;
	var csg = BABYLON.CSG.FromMesh(tube);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(cylinder));
	var mesh = csg.toMesh("",null,null,false);
	tube.dispose();
	cylinder.dispose();
	var glowstick = BABYLON.MeshBuilder.CreateCylinder("",{ diameter : radius * 1.65, height : length * 0.8},null);
	glowstick.rotate(BABYLON.Vector3.Right(),Math.PI / 2);
	glowstick.position.z = length / 2;
	glowstick.position.y = height;
	glowstick.material = glowMaterial;
	glowstick.parent = mesh;
	mesh.material = tubeMaterial;
	mesh.bakeCurrentTransformIntoVertices();
	glowstick.bakeCurrentTransformIntoVertices();
	mesh.setPivotPoint(new BABYLON.Vector3(0,0,length / 2));
	return mesh;
};
wl_util_ExtendedMeshBuilder.CreateHollowCube = function(name,options,scene) {
	var outerBox = BABYLON.MeshBuilder.CreateBox(name + "outer",options,null);
	options.edge = options.edge != null ? options.edge : 0.1;
	options.edge = 1 - options.edge;
	console.log(options.edge);
	var heightOptions = JSON.parse(JSON.stringify(options));
	heightOptions.height *= 1.5;
	heightOptions.width *= options.edge;
	heightOptions.depth *= options.edge;
	var heightBox = BABYLON.MeshBuilder.CreateBox("",heightOptions,null);
	var widthOptions = JSON.parse(JSON.stringify(options));
	widthOptions.width *= 1.5;
	widthOptions.height *= options.edge;
	widthOptions.depth *= options.edge;
	var widthBox = BABYLON.MeshBuilder.CreateBox("",widthOptions,null);
	var depthOptions = JSON.parse(JSON.stringify(options));
	depthOptions.depth *= 1.5;
	depthOptions.height *= options.edge;
	depthOptions.width *= options.edge;
	var depthBox = BABYLON.MeshBuilder.CreateBox("",depthOptions,null);
	var csg = BABYLON.CSG.FromMesh(outerBox);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(heightBox));
	csg.subtractInPlace(BABYLON.CSG.FromMesh(depthBox));
	csg.subtractInPlace(BABYLON.CSG.FromMesh(widthBox));
	heightBox.dispose();
	depthBox.dispose();
	widthBox.dispose();
	outerBox.dispose();
	return csg.toMesh(name,null,scene,false);
};
wl_util_ExtendedMeshBuilder.createGratedSphere = function(diameter,scene) {
	var sphere = BABYLON.MeshBuilder.CreateSphere("",{ diameter : diameter},scene);
	var csg = BABYLON.CSG.FromMesh(sphere);
	var _g = 0;
	while(_g < 2) {
		++_g;
		var box = BABYLON.MeshBuilder.CreateBox("",{ depth : diameter, width : diameter * 0.1, height : diameter * 0.1});
		box.rotate(new BABYLON.Vector3(wl_util_Random.nextFloat(),wl_util_Random.nextFloat(),wl_util_Random.nextFloat()),wl_util_Random.nextFloat() * Math.PI * 2);
		csg.subtractInPlace(BABYLON.CSG.FromMesh(box));
		box.dispose();
	}
	sphere.dispose();
	return csg.toMesh("",null,scene,false);
};
wl_util_ExtendedMeshBuilder.createBrokenSphere = function(depth,width,scene) {
	var meshes = [];
	var _g1 = Math.ceil(-depth / 2);
	var _g = Math.ceil(depth / 2);
	while(_g1 < _g) {
		++_g1;
		var _g3 = Math.ceil(-width / 2);
		var _g2 = Math.ceil(width / 2);
		while(_g3 < _g2) {
			++_g3;
			var box = BABYLON.MeshBuilder.CreateBox("",{ width : 2, height : 2, depth : 2});
			box.rotate(new BABYLON.Vector3(Math.random() * Math.PI * 2,Math.random() * Math.PI * 2,Math.random() * Math.PI * 2),Math.random() * Math.PI * 2);
			meshes.push(box);
		}
	}
	var mesh = BABYLON.Mesh.MergeMeshes(meshes,true,true);
	var _g4 = 0;
	while(_g4 < meshes.length) {
		var m = meshes[_g4];
		++_g4;
		m.dispose();
	}
	scene.addMesh(mesh);
	return mesh;
};
wl_util_ExtendedMeshBuilder.createGround = function(depth,width,scene) {
	var meshes = [];
	var sideSize = Math.ceil(depth * width) / 10;
	var _g1 = 0;
	while(_g1 < depth) {
		var z = _g1++;
		var _g3 = 0;
		while(_g3 < width) {
			var mesh = BABYLON.MeshBuilder.CreateBox("",{ width : sideSize + wl_util_Random.nextFloat(), height : sideSize + wl_util_Random.nextFloat(), depth : sideSize + wl_util_Random.nextFloat()},null);
			var tmp = width * wl_util_Random.nextFloat();
			mesh.position.x = _g3++ * sideSize + tmp;
			var tmp1 = depth * wl_util_Random.nextFloat();
			mesh.position.z = z * sideSize + tmp1;
			mesh.rotate(new BABYLON.Vector3(Math.random() * Math.PI * 2,Math.random() * Math.PI * 2,Math.random() * Math.PI * 2),Math.random() * Math.PI * 2);
			meshes.push(mesh);
		}
	}
	var m = BABYLON.Mesh.MergeMeshes(meshes,true,true);
	var _g = 0;
	while(_g < meshes.length) {
		var mi = meshes[_g];
		++_g;
		mi.dispose();
	}
	return m;
};
wl_util_ExtendedMeshBuilder.createSinkBox = function(width,height,depth,sinkDepth,edgeSize,scene) {
	var bOuter = BABYLON.MeshBuilder.CreateBox("",{ width : width, height : height, depth : depth});
	var bInner = BABYLON.MeshBuilder.CreateBox("",{ width : width - edgeSize, height : height - edgeSize, depth : depth + sinkDepth});
	bInner.position.z -= depth;
	var csg = BABYLON.CSG.FromMesh(bOuter);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(bInner));
	var mesh = csg.toMesh("",null,scene,false);
	bInner.dispose();
	bOuter.dispose();
	return mesh;
};
wl_util_ExtendedMeshBuilder.prototype = {
	__class__: wl_util_ExtendedMeshBuilder
};
var wl_util_ExtractPixels = function() {
	throw new js__$Boot_HaxeError("Extract pixels is a static class");
};
$hxClasses["wl.util.ExtractPixels"] = wl_util_ExtractPixels;
wl_util_ExtractPixels.__name__ = ["wl","util","ExtractPixels"];
wl_util_ExtractPixels.extract = function(img,sx,sy,w,h) {
	if(sx == null) {
		sx = 0;
	} else {
		sx = sx;
	}
	if(sy == null) {
		sy = 0;
	} else {
		sy = sy;
	}
	if(w == null) {
		w = img.width;
	} else {
		w = w;
	}
	if(h == null) {
		h = img.height;
	} else {
		h = h;
	}
	var canvas = window.document.createElement("canvas");
	var ctx = canvas.getContext("2d",null);
	canvas.width = w;
	canvas.height = h;
	ctx.drawImage(img,-sx,-sy,w,h);
	return ctx.getImageData(0,0,w,h);
};
wl_util_ExtractPixels.prototype = {
	__class__: wl_util_ExtractPixels
};
var wl_util_LoadManager = $hx_exports["wl"]["util"]["LoadManafer"] = function() {
};
$hxClasses["wl.util.LoadManager"] = wl_util_LoadManager;
wl_util_LoadManager.__name__ = ["wl","util","LoadManager"];
wl_util_LoadManager.get_totalCount = function() {
	return wl_util_LoadManager._totalCount + wl_util_LoadManager.loadersWaiting.length;
};
wl_util_LoadManager.onload = function() {
	wl_util_LoadManager.managerDone = true;
	wl_util_LoadManager.checkAllDone();
};
wl_util_LoadManager.checkAllDone = function() {
	if(wl_util_LoadManager.managerDone || wl_util_LoadManager._totalCount == 0 && wl_util_LoadManager.loadersWaiting.length == 0) {
		wl_util_LoadManager.onComplete();
	}
};
wl_util_LoadManager.onerror = function() {
};
wl_util_LoadManager.onprogress = function(s,p,t) {
	console.log(s + "," + p + "," + t);
};
wl_util_LoadManager.addLoader = function(loaderClass) {
	var ldr = Type.createInstance(loaderClass,[wl_util_LoadManager.loadingManager]);
	wl_util_LoadManager._totalCount++;
	return ldr;
};
wl_util_LoadManager.addManualLoader = function(loader) {
	wl_util_LoadManager.loadersWaiting.push(loader);
};
wl_util_LoadManager.manualLoaderComplete = function(loader) {
	HxOverrides.remove(wl_util_LoadManager.loadersWaiting,loader);
	wl_util_LoadManager.checkAllDone();
};
wl_util_LoadManager.prototype = {
	__class__: wl_util_LoadManager
};
var wl_util_MathUtil = function() {
};
$hxClasses["wl.util.MathUtil"] = wl_util_MathUtil;
wl_util_MathUtil.__name__ = ["wl","util","MathUtil"];
wl_util_MathUtil.clamp = function(low,high,val) {
	if(val < low) {
		return low;
	} else if(val > high) {
		return high;
	} else {
		return val;
	}
};
wl_util_MathUtil.FromVector3 = function(position,sphereRadius) {
	return [(270 + Math.atan2(position.x,position.z) * 180 / Math.PI) % 360 - 180,90 - Math.acos(position.y / sphereRadius) * 180 / Math.PI];
};
wl_util_MathUtil.componentLerp = function(v1,v2,phase,easex,easey,easez,setTo) {
	if(setTo == null) {
		setTo = new THREE.Vector3();
	} else {
		setTo = setTo;
	}
	setTo.set(easex(1 - phase) * v1.x + easex(phase) * v2.x,easey(1 - phase) * v1.y + easey(phase) * v2.y,easez(1 - phase) * v1.z + easez(phase) * v2.z);
	return setTo;
};
wl_util_MathUtil.getShortestAngle = function(a1,a2) {
	var d = a1 - a2;
	var max = Math.PI * 2;
	return d - Math.floor((d - -Math.PI) / max) * max;
};
wl_util_MathUtil.prototype = {
	__class__: wl_util_MathUtil
};
var wl_util_Random = function(seed) {
	this.seed = 123;
	this.Init(seed);
};
$hxClasses["wl.util.Random"] = wl_util_Random;
wl_util_Random.__name__ = ["wl","util","Random"];
wl_util_Random.init = function(seed) {
	wl_util_Random.instance.Init(seed);
};
wl_util_Random.next = function() {
	return wl_util_Random.instance.Next();
};
wl_util_Random.nextFloat = function() {
	return wl_util_Random.instance.NextFloat();
};
wl_util_Random.range = function(low,high) {
	return wl_util_Random.instance.Range(low,high);
};
wl_util_Random.prototype = {
	Init: function(seed) {
		this.seed = seed;
	}
	,Next: function() {
		var test = 16807 * Math.floor(this.seed % 127773) - 2836 * Math.floor(this.seed / 127773);
		if(test < 0) {
			test += 2147483647;
		}
		this.seed = test;
		return this.seed;
	}
	,NextFloat: function() {
		return this.Next() / 2147483647;
	}
	,Range: function(low,high) {
		return Math.floor(this.NextFloat() * (high - low) + low);
	}
	,__class__: wl_util_Random
};
var wl_util_builders_CockpitBuilder = function() { };
$hxClasses["wl.util.builders.CockpitBuilder"] = wl_util_builders_CockpitBuilder;
wl_util_builders_CockpitBuilder.__name__ = ["wl","util","builders","CockpitBuilder"];
wl_util_builders_CockpitBuilder.BuildCockpit = function(scene) {
	var parent = new BABYLON.TransformNode("Cockpit",scene);
	var box = BABYLON.MeshBuilder.CreateBox("",{ width : 100, height : 16, depth : 20},scene);
	box.position.z = 15;
	var belowBox = BABYLON.MeshBuilder.CreateBox("",{ width : 155, height : 16, depth : 5},scene);
	belowBox.position.y -= 16;
	belowBox.position.z = 19;
	var arc_left = wl_util_builders_CockpitBuilder.createArc("arc_left",scene);
	arc_left.position.x = 50;
	arc_left.position.z = -5.370;
	arc_left.rotate(BABYLON.Vector3.Up(),-Math.PI / 180 * 90);
	var arc_right = wl_util_builders_CockpitBuilder.createArc("arc_right",scene);
	arc_right.position.x = -50;
	arc_right.position.z = -5.370;
	arc_right.rotate(BABYLON.Vector3.Up(),Math.PI / 180 * 180);
	var boxL = BABYLON.MeshBuilder.CreateBox("",{ width : 20, height : 16, depth : 100},scene);
	var boxR = BABYLON.MeshBuilder.CreateBox("",{ width : 20, height : 16, depth : 100},scene);
	boxL.position.x = -70.258;
	boxL.position.z = -55.158;
	boxR.position.x = 70.258;
	boxR.position.z = -55.158;
	var boxLB = BABYLON.MeshBuilder.CreateBox("",{ width : 5, height : 16, depth : 130},scene);
	boxLB.position.x = -80;
	boxLB.position.y = -16;
	boxLB.position.z = -40.158;
	var boxLR = BABYLON.MeshBuilder.CreateBox("",{ width : 5, height : 16, depth : 130},scene);
	boxLR.position.x = 80;
	boxLR.position.y = -16;
	boxLR.position.z = -40.158;
	var floor = BABYLON.MeshBuilder.CreateBox("floor",{ width : 200, height : 1, depth : 200},scene);
	floor.position.y = -25;
	var wleft = wl_util_builders_CockpitBuilder.createWindowArc("",scene);
	wleft.rotate(BABYLON.Vector3.Right(),Math.PI / 180 * 90);
	wleft.rotate(BABYLON.Vector3.Forward(),Math.PI / 180 * 90);
	wleft.position.x = -90;
	wleft.position.y = -24.247;
	wleft.position.z = -28.697;
	var wright = wl_util_builders_CockpitBuilder.createWindowArc("",scene);
	wright.rotate(BABYLON.Vector3.Right(),Math.PI / 180 * 90);
	wright.rotate(BABYLON.Vector3.Forward(),Math.PI / 180 * 90);
	wright.position.x = 90;
	wright.position.y = -24.247;
	wright.position.z = -28.697;
	var wf = wl_util_builders_CockpitBuilder.createWindow("window-front",scene);
	wf.rotate(BABYLON.Vector3.Right(),Math.PI / 180 * 90);
	wf.rotate(BABYLON.Vector3.Forward(),Math.PI / 180 * 90);
	wf.position.y = -24.903;
	wf.position.z = -29.478;
	var wallR = BABYLON.MeshBuilder.CreateBox("",{ width : 1, height : 100, depth : 200},scene);
	wallR.position.x = 90;
	wallR.position.z = -52;
	wallR.position.y = 10;
	box.parent = parent;
	arc_left.parent = parent;
	arc_right.parent = parent;
	boxL.parent = parent;
	boxR.parent = parent;
	parent.rotate(BABYLON.Vector3.Right(),Math.PI / 180 * 5);
	belowBox.parent = parent;
	boxLB.parent = parent;
	boxLR.parent = parent;
	floor.parent = parent;
	wleft.parent = parent;
	wright.parent = parent;
	wf.parent = parent;
	wallR.parent = parent;
	wl_util_builders_CockpitBuilder.createGlowingTube().parent = parent;
	var wm = new BABYLON.StandardMaterial("window",scene);
	wf.material = wm;
	wm.specularColor = new BABYLON.Color3(0.1,0.1,0.9);
	wm.diffuseColor = new BABYLON.Color3(0.4,0.4,0.9);
	wm.specularPower = 55;
	var arcMat = new BABYLON.StandardMaterial("arc",scene);
	arcMat.emissiveColor = new BABYLON.Color3(0,0,1);
	wleft.material = arcMat;
	wright.material = arcMat;
	var floormat = new BABYLON.PBRMaterial("floormat",scene);
	floormat.bumpTexture = wl_core_Assets.getTexture("Scifi_Floor3_1K_normal.png");
	floormat.albedoTexture = wl_core_Assets.getTexture("Scifi_Floor3_1K_albedo.png");
	floormat.metallicTexture = wl_core_Assets.getTexture("Scifi_Floor3_1K_metallic.png");
	floormat.ambientTexture = wl_core_Assets.getTexture("Scifi_Floor3_1K_ao.png");
	floormat.emissiveTexture = wl_core_Assets.getTexture("Scifi_Floor3_1K_emissive.png");
	floor.material = floormat;
	var bgmat = new BABYLON.PBRMaterial("bgmat",scene);
	bgmat.albedoTexture = wl_core_Assets.getTexture("Scifi_Panel8_1K_albedo.png");
	bgmat.bumpTexture = wl_core_Assets.getTexture("Scifi_Panel8_1K_normal.png");
	bgmat.metallicTexture = wl_core_Assets.getTexture("Scifi_Panel8_1K_metallic.png");
	bgmat.ambientTexture = wl_core_Assets.getTexture("Scifi_Panel8_1K_ao.png");
	bgmat.environmentIntensity = 0.2;
	bgmat.directIntensity = 0.85;
	bgmat.metallic = 1;
	belowBox.material = bgmat;
	boxLB.material = bgmat;
	boxLR.material = bgmat;
	var counterMat = new BABYLON.PBRMaterial("counter",scene);
	counterMat.albedoTexture = wl_core_Assets.getTexture("Paint_MachinePaint_1K_albedo.png");
	counterMat.bumpTexture = wl_core_Assets.getTexture("Paint_MachinePaint_1K_normal.png");
	counterMat.metallic = 0;
	boxL.material = counterMat;
	boxR.material = counterMat;
	box.material = counterMat;
	arc_left.material = counterMat;
	arc_right.material = counterMat;
	return parent;
};
wl_util_builders_CockpitBuilder.createArc = function(name,scene) {
	var arc_left_in = BABYLON.MeshBuilder.CreateCylinder("Left arc",{ diameter : 50, height : 16, arc : 0.25, enclose : true},scene);
	var arc_left_sub = BABYLON.MeshBuilder.CreateCylinder("Left arc",{ diameter : 25, height : 20, arc : 0.25},scene);
	arc_left_sub.position.x -= 2;
	arc_left_sub.position.z += 2;
	var csg = BABYLON.CSG.FromMesh(arc_left_in);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(arc_left_sub));
	var arc = csg.toMesh(name,null,scene,false);
	arc_left_in.dispose();
	arc_left_sub.dispose();
	return arc;
};
wl_util_builders_CockpitBuilder.createWindowArc = function(name,scene) {
	var arc_left_in = BABYLON.MeshBuilder.CreateCylinder("Left arc",{ diameter : 160, height : 8, arc : 0.25, enclose : true},scene);
	var arc_left_sub = BABYLON.MeshBuilder.CreateCylinder("Left arc",{ diameter : 156, height : 20, arc : 0.25},scene);
	arc_left_sub.position.x -= 1;
	arc_left_sub.position.z += 1;
	var csg = BABYLON.CSG.FromMesh(arc_left_in);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(arc_left_sub));
	var arc = csg.toMesh(name,null,scene,false);
	arc_left_in.dispose();
	arc_left_sub.dispose();
	return arc;
};
wl_util_builders_CockpitBuilder.createWindow = function(name,scene) {
	var arc_left_in = BABYLON.MeshBuilder.CreateCylinder("Left arc",{ diameter : 160, height : 180, arc : 0.25, enclose : true},scene);
	var arc_left_sub = BABYLON.MeshBuilder.CreateCylinder("Left arc",{ diameter : 159., height : 280, arc : 0.25},scene);
	arc_left_sub.position.x -= 0.7;
	arc_left_sub.position.z += 0.7;
	var csg = BABYLON.CSG.FromMesh(arc_left_in);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(arc_left_sub));
	var arc = csg.toMesh(name,null,scene,false);
	arc_left_in.dispose();
	arc_left_sub.dispose();
	return arc;
};
wl_util_builders_CockpitBuilder.createGlowingTube = function() {
	var container = new BABYLON.TransformNode("glowtube",null);
	var cylinder = BABYLON.MeshBuilder.CreateCylinder("cyl",{ diameter : 3, arc : 0.5, enclose : true, height : 100},null);
	cylinder.rotate(new BABYLON.Vector3(1,0,0),Math.PI);
	cylinder.rotate(BABYLON.Vector3.Up(),Math.PI / 180 * 90);
	cylinder.rotate(new BABYLON.Vector3(0,0,1),Math.PI / 180 * 90);
	cylinder.position.x = 60;
	cylinder.position.z = -50;
	cylinder.position.y = 6.603;
	var cylinder2 = BABYLON.MeshBuilder.CreateCylinder("cyl",{ diameter : 3, arc : 0.5, enclose : true, height : 100},null);
	cylinder2.rotate(new BABYLON.Vector3(1,0,0),Math.PI);
	cylinder2.rotate(BABYLON.Vector3.Up(),-Math.PI / 180 * 90);
	cylinder2.rotate(new BABYLON.Vector3(0,0,1),Math.PI / 180 * 90);
	cylinder2.position.x = -60;
	cylinder2.position.z = -50;
	cylinder2.position.y = 6.603;
	var cylinder3 = BABYLON.MeshBuilder.CreateCylinder("cyl",{ diameter : 3, enclose : true, height : 140},null);
	cylinder3.rotate(new BABYLON.Vector3(1,0,0),Math.PI);
	cylinder3.rotate(new BABYLON.Vector3(0,0,1),Math.PI / 180 * 90);
	cylinder3.rotate(new BABYLON.Vector3(1,0,0),Math.PI / 180 * 180);
	cylinder3.position.z = -2;
	cylinder3.position.y = 6.603;
	cylinder.parent = container;
	cylinder2.parent = container;
	cylinder3.parent = container;
	var mat = new BABYLON.StandardMaterial("tubeglow",null);
	mat.emissiveColor = new BABYLON.Color3(1,0.6,0);
	cylinder.material = mat;
	cylinder2.material = mat;
	cylinder3.material = mat;
	return container;
};
var wl_util_builders_ElectricalWireBuilder = function() {
};
$hxClasses["wl.util.builders.ElectricalWireBuilder"] = wl_util_builders_ElectricalWireBuilder;
wl_util_builders_ElectricalWireBuilder.__name__ = ["wl","util","builders","ElectricalWireBuilder"];
wl_util_builders_ElectricalWireBuilder.BuildExposedWireBunch = function(wirecount,height,radius,scatterRadius,heightSegments,sleeveMaterial,wireMaterial,wireContinuation) {
	if(wireContinuation == null) {
		wireContinuation = 0;
	}
	var stackNode = new BABYLON.TransformNode("Wirestack");
	var _g1 = 0;
	while(_g1 < wirecount) {
		var i = _g1++;
		var wire = wl_util_builders_ElectricalWireBuilder.BuildExposedWire(height,radius,scatterRadius,heightSegments,sleeveMaterial,wireMaterial);
		wire.position.x = Math.sin(i * Math.PI * 2 / wirecount) * radius;
		wire.position.z = Math.cos(i * Math.PI * 2 / wirecount) * radius;
		wire.parent = stackNode;
	}
	if(wireContinuation > 0) {
		var tube = wl_util_builders_ElectricalWireBuilder.BuildTube([new BABYLON.Vector3(0,height * 0.98,0),new BABYLON.Vector3(0,height + wireContinuation,0)],radius * 2);
		tube.material = sleeveMaterial;
		tube.parent = stackNode;
	}
	return stackNode;
};
wl_util_builders_ElectricalWireBuilder.BuildExposedWire = function(height,radius,scatterRadius,heightSegments,sleeveMaterial,wireMaterial) {
	var path = BABYLON.Curve3.CreateQuadraticBezier(new BABYLON.Vector3(0,height,0),new BABYLON.Vector3(0,height / 2,0),new BABYLON.Vector3((0.5 - wl_util_Random.nextFloat()) * scatterRadius,0,(0.5 - wl_util_Random.nextFloat()) * scatterRadius),heightSegments).getPoints();
	console.log(path);
	var outer = wl_util_builders_ElectricalWireBuilder.BuildTube(path,radius);
	var additionVector = path[path.length - 2].add(path[path.length - 1]);
	var wirePath = [];
	wirePath.push(path[path.length - 1].multiply(new BABYLON.Vector3(1,0.99,1)));
	wirePath.push(additionVector.multiply(new BABYLON.Vector3(1,-1,1)));
	var innerwire = wl_util_builders_ElectricalWireBuilder.BuildTube(wirePath,radius * 0.85);
	var node = new BABYLON.TransformNode("Wire");
	outer.parent = node;
	innerwire.parent = node;
	innerwire.material = wireMaterial;
	outer.material = sleeveMaterial;
	return node;
};
wl_util_builders_ElectricalWireBuilder.BuildTube = function(path,radius) {
	return BABYLON.MeshBuilder.CreateTube("wiretube",{ path : path, radius : radius, sideOrientation : BABYLON.Mesh.DOUBLESIDE, updatable : false, cap : BABYLON.Mesh.CAP_ALL},null);
};
wl_util_builders_ElectricalWireBuilder.prototype = {
	__class__: wl_util_builders_ElectricalWireBuilder
};
var wl_util_builders_ElectricalWireoptions = function() {
	this.scatterRadius = 1.2;
	this.radius = 1;
	this.height = 5;
	this.WireCount = 20;
};
$hxClasses["wl.util.builders.ElectricalWireoptions"] = wl_util_builders_ElectricalWireoptions;
wl_util_builders_ElectricalWireoptions.__name__ = ["wl","util","builders","ElectricalWireoptions"];
wl_util_builders_ElectricalWireoptions.prototype = {
	__class__: wl_util_builders_ElectricalWireoptions
};
var wl_util_builders_SpaceshipBuilder = function() { };
$hxClasses["wl.util.builders.SpaceshipBuilder"] = wl_util_builders_SpaceshipBuilder;
wl_util_builders_SpaceshipBuilder.__name__ = ["wl","util","builders","SpaceshipBuilder"];
wl_util_builders_SpaceshipBuilder.BuildSpaceShip = function(scene) {
	var container = new BABYLON.TransformNode("",scene);
	wl_util_builders_SpaceshipBuilder.createCylinder(scene);
	var cylinder2 = wl_util_builders_SpaceshipBuilder.createCylinder(scene);
	var cylinder3 = wl_util_builders_SpaceshipBuilder.createCylinder(scene);
	cylinder2.position.y = 1;
	cylinder2.position.x = 1;
	cylinder3.position.y = 1;
	cylinder3.position.x = -1;
	return container;
};
wl_util_builders_SpaceshipBuilder.createCylinder = function(scene) {
	var cylinder1 = BABYLON.MeshBuilder.CreateCylinder("cylinder1",{ height : 8, diameter : 2},scene);
	cylinder1.rotate(BABYLON.Vector3.Right(),Math.PI / 180 * 90);
	cylinder1.bakeCurrentTransformIntoVertices();
	var cone = wl_util_builders_SpaceshipBuilder.buildCone(scene);
	cone.position.z = -4.5;
	cone.parent = cylinder1;
	return cylinder1;
};
wl_util_builders_SpaceshipBuilder.buildCone = function(scene) {
	var cylinder1 = BABYLON.MeshBuilder.CreateCylinder("cylinder1",{ height : 1, diameterBottom : 1.3, diameterTop : 1},scene);
	var cylinder2 = BABYLON.MeshBuilder.CreateCylinder("cylinder1",{ height : 1, diameterBottom : 1.3, diameterTop : 1},scene);
	cylinder2.position.y -= 0.1;
	var csg = BABYLON.CSG.FromMesh(cylinder1);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(cylinder2));
	cylinder1.dispose();
	cylinder2.dispose();
	var cone = csg.toMesh("",null,scene,false);
	cone.rotate(new BABYLON.Vector3(1,0,0),Math.PI / 2);
	return cone;
};
var $_, $fid = 0;
function $bind(o,m) { if( m == null ) return null; if( m.__id__ == null ) m.__id__ = $fid++; var f; if( o.hx__closures__ == null ) o.hx__closures__ = {}; else f = o.hx__closures__[m.__id__]; if( f == null ) { f = function(){ return f.method.apply(f.scope, arguments); }; f.scope = o; f.method = m; o.hx__closures__[m.__id__] = f; } return f; }
$hxClasses["Math"] = Math;
String.prototype.__class__ = $hxClasses["String"] = String;
String.__name__ = ["String"];
$hxClasses["Array"] = Array;
Array.__name__ = ["Array"];
Date.prototype.__class__ = $hxClasses["Date"] = Date;
Date.__name__ = ["Date"];
var Int = $hxClasses["Int"] = { __name__ : ["Int"]};
var Dynamic = $hxClasses["Dynamic"] = { __name__ : ["Dynamic"]};
var Float = $hxClasses["Float"] = Number;
Float.__name__ = ["Float"];
var Bool = Boolean;
Bool.__ename__ = ["Bool"];
var Class = $hxClasses["Class"] = { __name__ : ["Class"]};
var Enum = { };
haxe_Resource.content = [{ name : "aspect.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "colorhilight.frag", data : "dW5pZm9ybSBmbG9hdCByYW5nZTsNCnVuaWZvcm0gZmxvYXQgdmFsdWUxOw0KdW5pZm9ybSBmbG9hdCB2YWx1ZTI7DQp1bmlmb3JtIGZsb2F0IG9yaWdpbmFsOw0KdW5pZm9ybSBmbG9hdCBhbW91bnQ7DQp1bmlmb3JtIHZlYzQgY29sb3IxOw0KdW5pZm9ybSB2ZWM0IGNvbG9yMjsNCnVuaWZvcm0gdmVjMiB0aWxlOw0KdW5pZm9ybSBzYW1wbGVyMkQgdERpZmZ1c2U7DQp2YXJ5aW5nIHZlYzIgdlV2Ow0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgl2ZWM0IGMgPSB0ZXh0dXJlMkQodERpZmZ1c2UsdXYqdGlsZSk7DQoJDQoJLy9NYWtlIGNvbnRpbnVvdXMgdHJpYW5nbGUgZnVuY3Rpb24NCglmbG9hdCB2YWwxID0gdmFsdWUxKjIuOw0KCXZhbDEgPSB2YWwxIDwgMS4gPyB2YWwxIDogMi4tdmFsMTsNCglmbG9hdCB2YWwyID0gdmFsdWUyKjIuOw0KCXZhbDEgPSB2YWwyIDwgMS4gPyB2YWwyIDogMi4tdmFsMjsNCgkNCglmbG9hdCB0aW1lb2ZmMSA9IG1vZCh2YWwxLCAxLiArIHJhbmdlKTsNCglmbG9hdCB0aW1lb2ZmMiA9IG1vZCh2YWwyLCAxLiArIHJhbmdlKTsNCgkNCglmbG9hdCBtcDEgPSAoYWJzKGMuciAtIHRpbWVvZmYxKSA+IHJhbmdlKSA/IDEuIDogMC47DQoJZmxvYXQgbXAyID0gKGFicyhjLmcgLSB0aW1lb2ZmMikgPiByYW5nZSkgPyAxLiA6IDAuOw0KCQ0KCWZsb2F0IGF2ZyA9IChjLnIrYy5nK2MuYikvMy47DQoJdmVjNCBhZHMxID0gY29sb3IxICogYWJzKGF2ZyAtIHRpbWVvZmYxKTsNCgl2ZWM0IGFkczIgPSBjb2xvcjIgKiBhYnMoYXZnIC0gdGltZW9mZjIpOw0KCQ0KCXZlYzQgY29sID0gKDEuLSBtcDEpICogYWRzMSArICgxLiAtIG1wMikqYWRzMjsNCgkNCglnbF9GcmFnQ29sb3IgPSBjKm9yaWdpbmFsICsgY29sKmFtb3VudDsNCn0NCg"},{ name : "rgbshift.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "space.frag", data : "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"},{ name : "gray.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdW5pZm9ybSBmbG9hdCBncmF5Ow0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgl2ZWM0IGMgPSB0ZXh0dXJlMkQodERpZmZ1c2UsdXYpOw0KCWZsb2F0IGdyID0gZG90KGMucmdiLCB2ZWMzKDAuMjk5LCAwLjU4NywgMC4xMTQpKTsNCiAgICB2ZWMzIGZjID0gbWl4KGMucmdiLCB2ZWMzKGdyKSwgZ3JheSk7DQoJZ2xfRnJhZ0NvbG9yID12ZWM0KGZjLDEuKTsNCn0NCg"},{ name : "vhs.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gZmxvYXQgaW50ZW5zaXR5Ow0KdW5pZm9ybSBmbG9hdCBqaXR0ZXI7DQp1bmlmb3JtIGZsb2F0IHNpemU7DQp1bmlmb3JtIHNhbXBsZXIyRCB0RGlmZnVzZTsNCnVuaWZvcm0gc2FtcGxlcjJEIHROb2lzZTsNCnVuaWZvcm0gZmxvYXQgdGltZTsNCnVuaWZvcm0gZmxvYXQgaG9sZFRpbWU7DQp1bmlmb3JtIGZsb2F0IGNvbG9yTm9pc2U7DQoNCmZsb2F0IHJhbmQodmVjMiBjbyl7DQogICAgcmV0dXJuIGZyYWN0KHNpbihkb3QoY28ueHkgLHZlYzIoMTIuOTg5OCw3OC4yMzMpKSkgKiA0Mzc1OC41NDUzKTsNCn0NCg0Kdm9pZCBtYWluKCkgew0KCXZlYzIgdXYgPSB2VXY7DQoJDQoJdXYueCArPSAocmFuZCh2ZWMyKHRpbWUqMC4xLCB1di55KjE5MjAuKSktMC41KSowLjAwOCpqaXR0ZXI7DQoJdXYueSArPSAocmFuZCh2ZWMyKHRpbWUpKS0wLjUpKjAuMDEqaml0dGVyOw0KCQ0KCXZlYzQgYmFzZSA9ICh2ZWM0KC0wLjUpK3ZlYzQocmFuZCh2ZWMyKHV2LnkqMTA4MC4sdGltZSkpLHJhbmQodmVjMigxMDgwLix0aW1lKzEuMCkpLHJhbmQodmVjMigxMDgwLix0aW1lKzIuMCkpLDApKSowLjEqY29sb3JOb2lzZTsNCgliYXNlICs9IHRleHR1cmUyRCh0RGlmZnVzZSx1dik7DQoJZmxvYXQgbm9pc2UgPSB0ZXh0dXJlMkQodE5vaXNlLHV2K3ZlYzIodGltZSx0aW1lKjAuMSkpLnI7DQoJDQoJaWYoKG5vaXNlKm1vZCh1di55ICsgaG9sZFRpbWUqMC4yLCAxLikgPiBzaXplKSB8fCANCgkJKG5vaXNlKm1vZCh1di55ICsgKGhvbGRUaW1lKzEuNSkqMC4yLCAxLikgPiBzaXplKSB8fA0KCQkobm9pc2UqbW9kKHV2LnkgKyAoaG9sZFRpbWUrMy4pKjAuMiwgMS4pID4gc2l6ZSkpIGJhc2UrPXZlYzQoMS4pKmludGVuc2l0eTsNCgkNCgkNCglnbF9GcmFnQ29sb3IgPSBiYXNlOw0KfQ0K"},{ name : "cga.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gZmxvYXQgYW1vdW50Ow0KdW5pZm9ybSBzYW1wbGVyMkQgdERpZmZ1c2U7DQp1bmlmb3JtIHZlYzIgcmVzb2x1dGlvbjsNCg0KdW5pZm9ybSB2ZWMzIGNvbG9yc1sxNl07DQoNCnZvaWQgbWFpbigpIHsNCgl2ZWMyIHV2ID0gdlV2Ow0KCXZlYzQgYyA9IHRleHR1cmUyRCh0RGlmZnVzZSx1dik7DQoJZmxvYXQgY2xvc2VzdCA9IDk5OTk5LjsNCiAgICB2ZWMzIHNlbGVjdGVkPXZlYzMoMC4pOw0KICAgIGZvcihpbnQgaSA9IDA7IGkgPCAxNjsgaSsrKQ0KICAgIHsNCiAgICAgICAgZmxvYXQgZCA9IGRpc3RhbmNlKGNvbG9yc1tpXSwgYy5yZ2IpOw0KICAgICAgICBpZihjbG9zZXN0ID4gZCkNCiAgICAgICAgew0KICAgICAgICAgCWNsb3Nlc3QgPSBkOw0KICAgICAgICAgICAgc2VsZWN0ZWQgPSBjb2xvcnNbaV07DQogICAgICAgIH0NCiAgICB9DQoJZ2xfRnJhZ0NvbG9yID0gbWl4KGMsdmVjNChzZWxlY3RlZCwxLiksIGFtb3VudCk7DQp9DQo"},{ name : "henrishader.frag", data : "I2RlZmluZSBQSSAzLjE0MTU5Mg0KDQp1bmlmb3JtIGZsb2F0IHQ7DQppbiB2ZWMyIHZVVjsNCg0Kdm9pZCBtYWluKCl7DQoJdmVjMiB1diA9IHZVVjsNCgkNCgl2ZWMyIHV2TyA9IHV2Ow0KICAgIHV2LngrPXQqMC4wMTsNCiAgICB1di55Kz10KjAuMDAyNTsNCiAgICBmbG9hdCBpbnRlbnNpdHkgPSANCiAgICAgICAgY29zKHV2LnkqMTUuKyB1di54KjE0LisgdCArIGNvcyh1di55KjAuICt1di54KjE1LikqNS4wICkqNS4gKw0KICAgICAgICBzaW4odXYueSozNS4tIHV2LngqMjQuKyB0KjIuNjcgKyBjb3ModXYueSowLiArdXYueCoxNS4pKjQuNyApKjMuICsNCiAgICAgICAgc2luKHV2LngqMjAuK3V2LnkqMTAuLXQqMi41KSozLjArDQogICAgICAgIHNpbih1di54KiB1di55ICsxLjUrIHQqMC41KSoxLjA7DQogICAgaW50ZW5zaXR5Lz0gMTQuOyANCiAgICAgICAgLy9zaW4odXYueCozMC4wK3QrMTcuMCp1di55KmNvcyh0K3V2LngqNS4wKSkNCiAgICAgICAvLyArc2luKHV2LnkqMTkuKzUwLjA1KmNvcyh1di54KjMuK3QqMC4wMikpKjEuMDsNCiAgICANCiAgICBpbnRlbnNpdHkgPSAxLi1zbW9vdGhzdGVwKDAuMSwgMC4yLCBpbnRlbnNpdHkpOw0KICAgIA0KIC8vICAgZmxvYXQgZCA9IGxlbmd0aCh1dk8ueS0wLjUpOw0KICAvLyAgaW50ZW5zaXR5ICo9IHNtb290aHN0ZXAoMC4wLCAwLjUsIDAuNS1kKTsNCiAgICAvLyBUaW1lIHZhcnlpbmcgcGl4ZWwgY29sb3INCiAgICB2ZWM0IGNvbCA9IHZlYzQoMS4wLCAxLjAsIDEuMCwgMS4wKSppbnRlbnNpdHk7DQoNCgkNCgkNCglnbF9GcmFnQ29sb3IgPSBjb2w7DQp9DQo"},{ name : "dof.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ0KICAgIA"},{ name : "gray.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "Demo.json", data : "ew0KCSJuYW1lIjogIlN0ZWxsYXIgRXhwbG9yZXIgLSBDaGFwdGVyIFR3byIsDQoJInRpbWVsaW5lIiA6IFsNCgkJew0KCQkJInBhcnRJZCI6ICJpbnRyby5JbnRybyIsDQoJCQkidHlwZSI6ICJpbnRyby5JbnRybyIsDQoJCQkicmVuZGVyVG9TY3JlZW4iOiB0cnVlLA0KCQkJInJ1bk9uIjogWzAsMCwwLDBdLA0KCQkJInJ1bk9mZiI6IFs4LDAsMCwwXSwNCgkJCSJleHRyYSI6IiIsDQoJCQkiZm9yY2VOZXdQYXJ0IjogZmFsc2UNCgkJfSwNCgkJew0KCQkJInBhcnRJZCI6ICJpbnRyby5JbnRybzIiLA0KCQkJInR5cGUiOiAiaW50cm8uSW50cm8iLA0KCQkJInJlbmRlclRvU2NyZWVuIjogZmFsc2UsDQoJCQkicnVuT24iOiBbOCwwLDAsMF0sDQoJCQkicnVuT2ZmIjogWzI4LDAsMCwwXSwNCgkJCSJleHRyYSI6IiIsDQoJCQkiZm9yY2VOZXdQYXJ0IjogZmFsc2UNCgkJfSwNCgkJew0KCQkJInBhcnRJZCI6ICJoZW5yaTE5LkhlbnJpMTkiLA0KCQkJInR5cGUiOiAiaGVucmkxOS5IZW5yaTE5IiwNCgkJCSJyZW5kZXJUb1NjcmVlbiI6IHRydWUsDQoJCQkicnVuT24iOiBbOCwwLDAsMF0sDQoJCQkicnVuT2ZmIjogWzI0LDAsMCwwXSwNCgkJCSJleHRyYSI6IiIsDQoJCQkiZm9yY2VOZXdQYXJ0IjogZmFsc2UNCgkJfSwNCgkJew0KCQkJInBhcnRJZCI6ICJzcGFjZWludHJvLlNwYWNlSW50cm8iLA0KCQkJInR5cGUiOiAic3BhY2VpbnRyby5TcGFjZUludHJvIiwNCgkJCSJyZW5kZXJUb1NjcmVlbiI6IHRydWUsDQoJCQkicnVuT24iOiBbMjQsMCwwLDBdLA0KCQkJInJ1bk9mZiI6IFs0MCwwLDAsMF0sDQoJCQkiZXh0cmEiOiIiLA0KCQkJImZvcmNlTmV3UGFydCI6IGZhbHNlDQoJCX0sDQoJCXsNCgkJCSJwYXJ0SWQiOiAibGF2YXBsYW5ldC5MYXZhUGxhbmV0IiwNCgkJCSJ0eXBlIjogImxhdmFwbGFuZXQuTGF2YVBsYW5ldCIsDQoJCQkicmVuZGVyVG9TY3JlZW4iOiB0cnVlLA0KCQkJInJ1bk9uIjogWzQwLDAsMCwwXSwNCgkJCSJydW5PZmYiOiBbNTAsMCwwLDBdLA0KCQkJImV4dHJhIjoiIiwNCgkJCSJmb3JjZU5ld1BhcnQiOiBmYWxzZQ0KCQl9DQoJXSwNCgkNCgkNCgkiYXVkaW8iOiB7DQoJCSJiZWF0c1Blck1pbnV0ZSI6IDEyNSwNCgkJImJlYXRzUGVyQmFyIiA6IDQsDQoJCSJ0aWNrc1BlckJlYXQiOiAxMiwNCgkJIm11c2ljQmVnaW4iOiAwLA0KCQkic29uZ1BhdGgiOiAiYXNtMTkub2dnIiwNCgkJImVuYWJsZUZGVCI6IHRydWUNCgl9LA0KCSJ2aXN1YWwiOiB7DQoJCSJ0YXJnZXRGcHMiOiAtMSwNCgkJInJlc29sdXRpb24iOiBbMTI4MCw3MjBdLA0KCQkiYW50aUFsaWFzIjogdHJ1ZSwNCgkJImVuYWJsZVNoYWRvd3MiOiB0cnVlLA0KCQkiY2xlYXJDb2xvciI6ICIjMDAwMDAwZmYiLA0KCQkic2hhZG93TWFwU2l6ZSI6WzIwNDgsMjA0OF0NCgl9DQp9"},{ name : "cga.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "simple.vert", data : "DQphdHRyaWJ1dGUgdmVjMyBwb3NpdGlvbjsNCmF0dHJpYnV0ZSB2ZWMyIHV2Ow0KDQojaW5jbHVkZTxpbnN0YW5jZXNEZWNsYXJhdGlvbj4NCnVuaWZvcm0gbWF0NCB2aWV3UHJvamVjdGlvbjsNCg0Kb3V0IHZlYzIgdlV2Ow0KDQp2b2lkIG1haW4oKSB7DQoJI2luY2x1ZGU8aW5zdGFuY2VzVmVydGV4Pg0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gdmlld1Byb2plY3Rpb24gKiBmaW5hbFdvcmxkICogdmVjNChwb3NpdGlvbiwgMS4wKTsNCn0"},{ name : "space.vert", data : "I2lmZGVmIEdMX0VTDQoJcHJlY2lzaW9uIGhpZ2hwIGZsb2F0Ow0KI2VuZGlmDQoNCi8vIEF0dHJpYnV0ZXMNCmF0dHJpYnV0ZSB2ZWMzIHBvc2l0aW9uOw0KYXR0cmlidXRlIHZlYzIgdXY7DQoNCi8vIFVuaWZvcm1zDQp1bmlmb3JtIG1hdDQgd29ybGRWaWV3UHJvamVjdGlvbjsNCg0KLy8gTm9ybWFsDQp2YXJ5aW5nIHZlYzIgdlVWOw0KDQp2b2lkIG1haW4odm9pZCkgDQp7DQoJZ2xfUG9zaXRpb24gPSB3b3JsZFZpZXdQcm9qZWN0aW9uICogdmVjNChwb3NpdGlvbiwgMS4wKTsNCg0KCXZVViA9IHV2Ow0KfQ"},{ name : "displacement.frag", data : "I2luY2x1ZGU8aGVscGVyRnVuY3Rpb25zPg0KDQp1bmlmb3JtIGZsb2F0IHNjYWxlWDsNCnVuaWZvcm0gZmxvYXQgc2NhbGVZOw0KdW5pZm9ybSBmbG9hdCB6b29tOw0KdW5pZm9ybSB2ZWMyIG9mZnNldDsNCnVuaWZvcm0gc2FtcGxlcjJEIHRleHR1cmVTYW1wbGVyOwkvLyBvcmlnaW5hbCBjb2xvcg0KdW5pZm9ybSBzYW1wbGVyMkQgdERpc3BNYXA7DQoNCnZhcnlpbmcgdmVjMiB2VVY7DQoNCnZvaWQgbWFpbigpIHsNCgl2ZWMyIHV2ID0gdlVWOw0KCXZlYzQgY2QgPSB0ZXh0dXJlMkQodERpc3BNYXAsKHV2K29mZnNldCkqem9vbSk7DQoJDQoJLy9jYWxjdWxhdGUgb2Zmc2V0DQoJdmVjMiBvZmZzZXQgPXZlYzIoIGNkLnIgKiBzY2FsZVgsIGNkLmcqc2NhbGVZKSAtIHZlYzIoc2NhbGVYKjAuNSxzY2FsZVkqMC41KTsNCgkNCgl2ZWM0IGMgPSB0ZXh0dXJlMkQodGV4dHVyZVNhbXBsZXIsdXYrb2Zmc2V0KTsNCgkNCglnbF9GcmFnQ29sb3IgPSBjOw0KfQ0K"},{ name : "texturemix.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "colorhilight.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "pixelate.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gdmVjMiBwaXhlbGFtb3VudDsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgl1di54ID0gZmxvb3IodXYueCpwaXhlbGFtb3VudC54KS9waXhlbGFtb3VudC54Ow0KCXV2LnkgPSBmbG9vcih1di55KnBpeGVsYW1vdW50LnkpL3BpeGVsYW1vdW50Lnk7DQoJdmVjNCBjID0gdGV4dHVyZTJEKHREaWZmdXNlLHV2KTsNCglnbF9GcmFnQ29sb3IgPSBjOw0KfQ0K"},{ name : "aspect.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gaW50IHR5cGU7DQp1bmlmb3JtIGZsb2F0IGFzcGVjdDsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdW5pZm9ybSB2ZWMyIHJlc29sdXRpb247DQp1bmlmb3JtIHZlYzQgY29sb3I7DQoNCnZvaWQgbWFpbigpIHsNCglmbG9hdCBtcCA9IDAuMDsNCglmbG9hdCByZXNBc3BlY3QgPSByZXNvbHV0aW9uLngvcmVzb2x1dGlvbi55Ow0KCXZlYzIgdXYgPSB2VXY7DQoJCQ0KCS8vQmxhY2sgbGluZXMgbGVmdCBhbmQgcmlnaHQNCglpZihyZXNBc3BlY3QgPiBhc3BlY3QpDQoJew0KCQlmbG9hdCBkaWYgPSByZXNBc3BlY3QtYXNwZWN0Ow0KCQltcCA9IHV2LnggPiBkaWYvMi4gJiYgdXYueCA8IDEuLWRpZi8yLiA/IDAuIDogMS47DQoJfQ0KCWVsc2UNCgl7DQoJCS8vQmxhY2sgaW5lcyB0b3AgJiBib3R0b20NCgkJZmxvYXQgZGlmID0gYXNwZWN0LXJlc0FzcGVjdDsNCgkJbXAgPSB1di55ID4gZGlmLzIuICYmIHV2LnkgPCAxLi1kaWYvMi4gPyAwLiA6IDEuOw0KCQkNCgl9DQoJDQoJLy9UT0RPIC0gaW4gZmlsbCBjaGFuZ2UgdXYgYWxzby4gDQoJdmVjNCBjID0gbWl4KHRleHR1cmUyRCh0RGlmZnVzZSx1diksIGNvbG9yLG1wKTsNCg0KCWdsX0ZyYWdDb2xvciA9IGM7DQp9DQo"},{ name : "testshader.frag", data : "I2RlZmluZSBQSSAzLjE0MTU5Mg0KDQp1bmlmb3JtIGZsb2F0IHQ7DQppbiB2ZWMyIHZVVjsNCg0Kdm9pZCBtYWluKCl7DQoJdmVjMiB1diA9IHZVVjsNCgkNCgl2ZWMyIHV2TyA9IHV2Ow0KICAgIHV2LngrPXQqMC4wMTsNCiAgICB1di55Kz10KjAuMDAyNTsNCiAgICBmbG9hdCBpbnRlbnNpdHkgPSANCiAgICAgICAgY29zKHV2LnkqMTUuKyB1di54KjE0LisgdCArIGNvcyh1di55KjAuICt1di54KjE1LikqNS4wICkqNS4gKw0KICAgICAgICBzaW4odXYueSozNS4tIHV2LngqMjQuKyB0KjIuNjcgKyBjb3ModXYueSowLiArdXYueCoxNS4pKjQuNyApKjMuICsNCiAgICAgICAgc2luKHV2LngqMjAuK3V2LnkqMTAuLXQqMi41KSozLjArDQogICAgICAgIHNpbih1di54KiB1di55ICsxLjUrIHQqMC41KSoxLjA7DQogICAgaW50ZW5zaXR5Lz0gMTQuOyANCiAgICAgICAgLy9zaW4odXYueCozMC4wK3QrMTcuMCp1di55KmNvcyh0K3V2LngqNS4wKSkNCiAgICAgICAvLyArc2luKHV2LnkqMTkuKzUwLjA1KmNvcyh1di54KjMuK3QqMC4wMikpKjEuMDsNCiAgICANCiAgICBpbnRlbnNpdHkgPSAxLi1zbW9vdGhzdGVwKDAuMiwgMC4yNSwgaW50ZW5zaXR5KTsNCiAgICANCiAgICBmbG9hdCBkID0gbGVuZ3RoKHV2Ty55LTAuNSk7DQogICAgaW50ZW5zaXR5ICo9IHNtb290aHN0ZXAoMC4wLCAwLjUsIDAuNS1kKTsNCiAgICAvLyBUaW1lIHZhcnlpbmcgcGl4ZWwgY29sb3INCiAgICB2ZWM0IGNvbCA9IHZlYzQoMS4wLCAxLjAsIDEuMCwgMS4wKSppbnRlbnNpdHk7DQoNCgkNCgkNCglnbF9GcmFnQ29sb3IgPSBjb2w7DQp9DQo"},{ name : "pixelate.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "standard.frag", data : "dW5pZm9ybSBmbG9hdCBicmlnaHRuZXNzOw0KdW5pZm9ybSBmbG9hdCBnYW1tYTsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzIgdXYgPSB2VXY7DQoJdmVjNCBjID0gdGV4dHVyZTJEKHREaWZmdXNlLHV2KTsNCgljID0gcG93KGMsIHZlYzQoMS4wL2dhbW1hKSk7DQoJYys9YnJpZ2h0bmVzczsNCglnbF9GcmFnQ29sb3IgPSBjOw0KfQ"},{ name : "shipshader.frag", data : "I2RlZmluZSBQSSAzLjE0MTU5Mg0KDQp1bmlmb3JtIGZsb2F0IHQ7DQppbiB2ZWMyIHZVVjsNCg0Kdm9pZCBtYWluKCl7DQoJdmVjMiB1diA9IHZVVjsNCgkNCgl2ZWMyIHV2TyA9IHV2Ow0KICAgIHV2LngrPXQqMC4wMTsNCiAgICB1di55Kz10KjAuMDAyNTsNCiAgICBmbG9hdCBpbnRlbnNpdHkgPSANCiAgICAgICAgY29zKHV2LnkqMTUuKyB1di54KjE0LisgdCArIGNvcyh1di55KjAuICt1di54KjE1LikqNS4wICkqNS4gKw0KICAgICAgICBzaW4odXYueSozNS4tIHV2LngqMjQuKyB0KjIuNjcgKyBjb3ModXYueSowLiArdXYueCoxNS4pKjQuNyApKjMuICsNCiAgICAgICAgc2luKHV2LngqMjAuK3V2LnkqMTAuLXQqMi41KSozLjArDQogICAgICAgIHNpbih1di54KiB1di55ICsxLjUrIHQqMC41KSoxLjA7DQogICAgaW50ZW5zaXR5Lz0gMTQuOyANCiAgICAgICAgLy9zaW4odXYueCozMC4wK3QrMTcuMCp1di55KmNvcyh0K3V2LngqNS4wKSkNCiAgICAgICAvLyArc2luKHV2LnkqMTkuKzUwLjA1KmNvcyh1di54KjMuK3QqMC4wMikpKjEuMDsNCiAgICANCiAgICBpbnRlbnNpdHkgPSAxLi1zbW9vdGhzdGVwKDAuMSwgMC4yLCBpbnRlbnNpdHkpOw0KICAgIA0KIC8vICAgZmxvYXQgZCA9IGxlbmd0aCh1dk8ueS0wLjUpOw0KICAvLyAgaW50ZW5zaXR5ICo9IHNtb290aHN0ZXAoMC4wLCAwLjUsIDAuNS1kKTsNCiAgICAvLyBUaW1lIHZhcnlpbmcgcGl4ZWwgY29sb3INCiAgICB2ZWM0IGNvbCA9IHZlYzQoMS4wLCAxLjAsIDEuMCwgMS4wKSppbnRlbnNpdHk7DQoNCgkNCgkNCglnbF9GcmFnQ29sb3IgPSBjb2w7DQp9DQo"},{ name : "rgbshift.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gZmxvYXQgcnNoaWZ0Ow0KdW5pZm9ybSBmbG9hdCBnc2hpZnQ7DQp1bmlmb3JtIGZsb2F0IGJzaGlmdDsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KDQp2b2lkIG1haW4oKSB7DQoJdmVjNCBjID0gdGV4dHVyZTJEKHREaWZmdXNlLHZVdik7DQoJZmxvYXQgcm8gPSB0ZXh0dXJlMkQodERpZmZ1c2UsdmVjMih2VXYueC1yc2hpZnQsIHZVdi55KSkucjsNCglmbG9hdCBnbyA9IHRleHR1cmUyRCh0RGlmZnVzZSx2ZWMyKHZVdi54LWdzaGlmdCwgdlV2LnkpKS5nOw0KCWZsb2F0IGJvID0gdGV4dHVyZTJEKHREaWZmdXNlLHZlYzIodlV2LngtYnNoaWZ0LCB2VXYueSkpLmI7DQoJZ2xfRnJhZ0NvbG9yID0gdmVjNChybywgZ28sIGJvLCBjLncpOw0KfQ"},{ name : "dof.frag", data : "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"},{ name : "distortedTv.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "standard.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "texturemix.frag", data : "I2luY2x1ZGU8aGVscGVyRnVuY3Rpb25zPg0KDQp1bmlmb3JtIGZsb2F0IHBoYXNlOw0KdW5pZm9ybSBmbG9hdCB0aW1lOw0KdW5pZm9ybSBzYW1wbGVyMkQgdGV4dHVyZVNhbXBsZXI7CS8vIG9yaWdpbmFsIGNvbG9yDQp1bmlmb3JtIHNhbXBsZXIyRCBtaXhtYXA7DQp1bmlmb3JtIHNhbXBsZXIyRCB0ZXh0dXJlU2FtcGxlcjI7DQoNCnZhcnlpbmcgdmVjMiB2VVY7DQoNCnZvaWQgbWFpbigpIHsNCgl2ZWMyIHV2ID0gdlVWOw0KCQ0KCQ0KCXZlYzQgYzEgPSB0ZXh0dXJlMkQodGV4dHVyZVNhbXBsZXIsIHV2KTsNCgl2ZWM0IGMyID0gdGV4dHVyZTJEKHRleHR1cmVTYW1wbGVyMiwgdXYpOw0KCQ0KCXZlYzIgb2ZmMSA9IHZlYzIoIDAuMiwgMC4zKSAqIHRpbWU7DQoJdmVjMiBvZmYyID0gdmVjMiggMC4yLCAwLjMpICogdGltZTsNCgl2ZWMyIG9mZjMgPSB2ZWMyKCAwLjIsIDAuMykgKiB0aW1lOw0KCXZlYzIgb2ZmNCA9IHZlYzIoIDAuMiwgMC4zKSAqIHRpbWU7DQoJDQoJdmVjNCBuMSA9IHRleHR1cmUyRChtaXhtYXAsIHV2ICogMC41ICsgb2ZmMSk7DQoJdmVjNCBuMiA9IHRleHR1cmUyRChtaXhtYXAsIHV2ICogMC44ICsgb2ZmMik7DQoJdmVjNCBuMyA9IHRleHR1cmUyRChtaXhtYXAsIHV2ICogMS4yICsgb2ZmMyk7DQoJdmVjNCBuNCA9IHRleHR1cmUyRChtaXhtYXAsIHV2ICogMS41ICsgb2ZmNCk7DQoJDQoJdmVjNCBjb2wgPSBuMSArIG4yICogMC43ICsgbjMgKiAwLjUgKyBuNCAqIDAuMzsNCgkNCgljb2wgLz0gNC47DQoJDQoJY29sID0gc21vb3Roc3RlcCggdmVjNCggMC4yOCksIHZlYzQoMC4yOSksIGNvbCpwaGFzZSk7DQoJDQoJZ2xfRnJhZ0NvbG9yID0gbWl4KCBjMSwgYzIsIGNvbC5yKTsNCgkNCgkvL2dsX0ZyYWdDb2xvciA9ICBjMiArdmVjNCgxLiwwLiwwLiwxLik7DQoJDQoJLy9nbF9GcmFnQ29sb3IgPSBjMjsNCn0NCg"},{ name : "distort.frag", data : "I2luY2x1ZGU8aGVscGVyRnVuY3Rpb25zPg0KDQovLyBzYW1wbGVycw0KdW5pZm9ybSBzYW1wbGVyMkQgdGV4dHVyZVNhbXBsZXI7CS8vIG9yaWdpbmFsIGNvbG9yDQoNCi8vIHVuaWZvcm1zDQp1bmlmb3JtIGZsb2F0IGludGVuc2l0eTsNCnVuaWZvcm0gZmxvYXQgaW50ZW5zaXR5WTsNCnVuaWZvcm0gZmxvYXQgaGVpZ2h0Ow0KdW5pZm9ybSBmbG9hdCBvZmZzZXRZOw0KdW5pZm9ybSBmbG9hdCBicmlnaHRuZXNzOw0KDQovLyB2YXJ5aW5ncw0KdmFyeWluZyB2ZWMyIHZVVjsNCg0KZmxvYXQgcmFuZCh2ZWMyIGNvKXsNCiAgICByZXR1cm4gZnJhY3Qoc2luKGRvdChjby54eSAsdmVjMigxMi45ODk4LDc4LjIzMykpKSAqIDQuNTQ1Myk7DQp9DQoNCnZvaWQgbWFpbih2b2lkKQ0Kew0KCXZlYzIgdXYgPSB2VVY7DQoJdmVjMiBzcXVhcmUgPSBzdGVwKCB2ZWMyKCBpbnRlbnNpdHkqMC4xK3JhbmQodmVjMihvZmZzZXRZKSkqMC4xKSwgbW9kKHV2K29mZnNldFksIHZlYzIoMC4yK3JhbmQodmVjMihvZmZzZXRZKSkqMC4xKmludGVuc2l0eSkpKTsNCglpZihyYW5kKHNxdWFyZStvZmZzZXRZKSA8IDAuMSkNCgl7DQoJCXNxdWFyZSArPSB2ZWMyKHJhbmQoc3F1YXJlKS0uNSk7DQoJLy8JdXYrPXNxdWFyZSppbnRlbnNpdHk7DQoJfQ0KCQ0KCWZsb2F0IGFkZFZhbCA9IChzdGVwKDAuNSxtb2QoKHV2LnkqaGVpZ2h0K29mZnNldFkpLCAxLjApKS0wLjUpOw0KLy8JdXYueCArPSBhZGRWYWwqaW50ZW5zaXR5Ow0KICAgIA0KCWZsb2F0IGFkZFZhbFkgPSAoc3RlcCgwLjUsbW9kKCh1di54KmhlaWdodCtvZmZzZXRZKSwgMS4wKSktMC41KTsNCgl1di55ICs9IGFkZFZhbFkqaW50ZW5zaXR5WTsNCgkNCgkvL3V2ICo9MS4taW50ZW5zaXR5KiBsZW5ndGgodXYtdmVjMigwLjUpKTsNCgkNCgl2ZWMyIGZyb21DZW50ZXIgPSB2VVYgLSB2ZWMyKDAuNSk7DQoJZmxvYXQgZGlzdGZyb2xlbiA9IGxlbmd0aCggZnJvbUNlbnRlcik7DQoJZmxvYXQgY21wID0xLjsNCglpZihkaXN0ZnJvbGVuID4wLjQ1KQ0KCXsNCgkJdXYgKz0gIC1mcm9tQ2VudGVyKihsZW5ndGgoIGZyb21DZW50ZXIpLTAuNDUpKjAuMjU7DQoJCWNtcCA9IDEuKyhkaXN0ZnJvbGVuLTAuNDUpKjQuOw0KCX0NCgkNCglmbG9hdCBzY2FuID0gc3RlcCgzLixtb2QoZ2xfRnJhZ0Nvb3JkLnksNC4pKSowLjI7DQoJDQoJdmVjNCBiYXNlID0gdGV4dHVyZTJEKHRleHR1cmVTYW1wbGVyLCB1dikqKDEuLXNjYW4pKmNtcDsNCgliYXNlICs9IHBvdyhiYXNlLHZlYzQoMS4yNStpbnRlbnNpdHkpKSoxLjg7DQoJDQogICAgZ2xfRnJhZ0NvbG9yID0gYmFzZSticmlnaHRuZXNzOw0KfQ"},{ name : "distortedTv.frag", data : "dW5pZm9ybSBmbG9hdCBkaXN0b3J0QW1vdW50Ow0KdW5pZm9ybSBzYW1wbGVyMkQgdERpZmZ1c2U7DQp1bmlmb3JtIGZsb2F0IHRpbWU7DQp1bmlmb3JtIGZsb2F0IGdyZWVuYW1wbGlmeTsNCnVuaWZvcm0gZmxvYXQgYmx1ZWFtcGxpZnk7DQp1bmlmb3JtIGZsb2F0IHZpZ25BbW91bnQ7DQp1bmlmb3JtIGZsb2F0IG9mZnNldEFtb3VudDsNCnVuaWZvcm0gZmxvYXQgYnJpZ2h0TXVsdGlwbGllcjsNCnVuaWZvcm0gZmxvYXQgYnJpZ2h0TGltaXQ7DQp2YXJ5aW5nIHZlYzIgdlV2Ow0KDQp2b2lkIG1haW4oKQ0Kew0KCXZlYzIgdXYgPSB2VXY7DQogICAgZmxvYXQgb2Zmc2V0ID0gbW9kKGNlaWwodXYueSpkaXN0b3J0QW1vdW50K3RpbWUpKnRpbWUsMC4wMTIpOw0KICAgIHZlYzQgdENvbG9yID0gdGV4dHVyZTJEKHREaWZmdXNlLHZlYzIodXYueCtvZmZzZXRBbW91bnQqb2Zmc2V0LHV2LnkpKTsNCiAgICB0Q29sb3IuZyAqPSBncmVlbmFtcGxpZnk7DQogICAgdENvbG9yLmIgKj0gYmx1ZWFtcGxpZnk7DQogICAgZmxvYXQgdmlnbiA9IDEuMC1sZW5ndGgodmVjMigwLjUsMC41KS11dikqdmlnbkFtb3VudDsNCiAgICANCgl2ZWMzIGJyaWdodG5lc3MgPSB0Q29sb3IucmdiOw0KCXZlYzMgbXAgPSB2ZWMzKDEuKS1zbW9vdGhzdGVwKHZlYzMoYnJpZ2h0TGltaXQpLCB2ZWMzKDEuKSwgYnJpZ2h0bmVzcykqYnJpZ2h0TXVsdGlwbGllcjsNCgl0Q29sb3IqPXZlYzQobXAsMS4pOw0KCQ0KICAgIHRDb2xvciAqPSB2aWduOw0KCWdsX0ZyYWdDb2xvciA9IHRDb2xvcjsNCn0"},{ name : "displacement.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "vhs.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "planetmateria.frag", data : "dmVjMiBvZmYxID0gdmVjMigwLjEsIDAuMikgKiB0aW1lOw0KdmVjMiBvZmYyID0gdmVjMigtMC4yNywgMC4yMikgKiB0aW1lOw0KdmVjMiBvZmYzID0gdmVjMiggMC40MiwgMC4zNCkgKiB0aW1lOw0KDQpmbG9hdCBuMSA9IHRleHR1cmUyRChub2lzZU1hcCwgdkRpZmZ1c2VVVi54eSoyLjUrb2ZmMSkucjsNCmZsb2F0IG4yID0gdGV4dHVyZTJEKG5vaXNlTWFwLCB2RGlmZnVzZVVWLnh5KjEuMCtvZmYyKS5yKjAuNjsNCmZsb2F0IG4zID0gdGV4dHVyZTJEKG5vaXNlTWFwLCB2RGlmZnVzZVVWLnh5KjAuMjUrb2ZmMykuciowLjMzOw0KDQpmbG9hdCBuID0gbjErbjIrbjM7DQpuID0gc21vb3Roc3RlcCggMC4sIDAuNSwgbi8zLikqMS4wOw0KDQpjb2xvciArPSBjb2xvcioobitzaW4odGltZSkpKjAuMzsNCmNvbG9yLmEgPSAxLjsNCmNvbG9yID0gbWl4KGNvbG9yLCBuKnZlYzQoY2xvdWRDb2xvciwxLiksbik7DQo"}];
var __map_reserved = {}
var ArrayBuffer = $global.ArrayBuffer || js_html_compat_ArrayBuffer;
if(ArrayBuffer.prototype.slice == null) {
	ArrayBuffer.prototype.slice = js_html_compat_ArrayBuffer.sliceImpl;
}
var Float32Array = $global.Float32Array || js_html_compat_Float32Array._new;
var Uint8Array = $global.Uint8Array || js_html_compat_Uint8Array._new;
DemoMain.DEMO_READY = new wl_core_Signal();
DemoMain.HILIGHT = BABYLON.Color3.FromHexString("#F12522");
DemoMain.LIGHT = BABYLON.Color3.FromHexString("#F3B129");
DemoMain.BASE_1 = BABYLON.Color3.FromHexString("#03A1DA");
DemoMain.BASE_2 = BABYLON.Color3.FromHexString("#86BF28");
DemoMain.BASE_3 = BABYLON.Color3.FromHexString("#CEDA07");
DemoMain.WHITE = new BABYLON.Color3(1,1,1);
DemoMain.BLACK = BABYLON.Color3.FromHexString("#000000");
DemoMain.historyind = 0;
haxe_crypto_Base64.CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
haxe_crypto_Base64.BYTES = haxe_io_Bytes.ofString(haxe_crypto_Base64.CHARS);
haxe_ds_ObjectMap.count = 0;
js_Boot.__toStr = ({ }).toString;
js_html_compat_Float32Array.BYTES_PER_ELEMENT = 4;
js_html_compat_Uint8Array.BYTES_PER_ELEMENT = 1;
lavaplanet_LavaGroundHeightMap.value = "data:image/png;base64,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";
spaceintro_SpaceIntro.loopText = ["0xe191f [WARNING] - Detected Anomaly","0xe2929 [WARNING] - Space-time error detection detected","0xe0110 [WARNING] - Vacuum substance replacement imminent","0xef123 [WARNING] - Sauna heat shields failing","0xe2935 [WARNING] - Alumni casing missing","0xe8581 [WARNING] - MFX tubes broken","0xe2902 [WARNING] - Byterapers roaming free","0xe2033 [WARNING] - Artline Desings stolen from the palace","0xea039 [WARNING] - Paraguay occupied by foreign forces","0xaa223 [WARNING] - Pyrotech flamethrowers are now standard issue weapons","0x7a223 [WARNING] - API key invalid","0xff223 [WARNING] - Adapt or die","0xa5222 [WARNING] - Damones are now playing on recreation deck","0x33225 [WARNING] - Darklite issued to all personnel","0x7a223 [WARNING] - ASD implementation in effect","0x32451 [WARNING] - Dekadence feeling is imminent","0x11223 [WARNING] - HBC leak detected","0x17827 [WARNING] - CNCD error - please retry","0x11B28 [WARNING] - Ananasmurska found in the kitchen","0x11222 [WARNING] - FGJ levels dangerously high","0xera23 [WARNING] - TÄhtituho detected","0xabb25 [WARNING] - Epoch achieved - calculation complete","0x12423 [WARNING] - Fairlight activated for security measures","0x99724 [WARNING] - Jumalauta help not accepted","0x76117 [WARNING] - Kewlers evacuating now on deck 3","0x11613 [WARNING] - Matt Current, you are needed on the bridge","0x11223 [WARNING] - Mercury contamination detected","0x16123 [WARNING] - Primitive lifeforms appearing on radar","0x11211 [WARNING] - Traction beam actiivated","0x9867e [WARNING] - Quadtrip offers holidays for incredible prices","0x689fa [WARNING] - Scenesat activated - tunes detected","0x1c22c [WARNING] - XZM warning activated"];
wl_core_Assets._assets = new haxe_ds_StringMap();
wl_core_Config.BEATS_PER_MINUTE = 104;
wl_core_Config.BEATS_PER_BAR = 4;
wl_core_Config.TICKS_PER_BEAT = 12;
wl_core_Config.MUSIC_BEGIN = 500;
wl_core_Config.SONG_PATH = "bg.ogg";
wl_core_Config.ENABLE_FFT = false;
wl_core_Config.MUTED = false;
wl_core_Config.FPS = 24;
wl_core_Config.RESOLUTION = [1280,720];
wl_core_Config.RATIO = 1.7777777777777777;
wl_core_Config.ANTIALIAS = true;
wl_core_Config.ENABLE_SHADOWS = false;
wl_core_Config.CLEAR_COLOR = new BABYLON.Color4(0.0,0.0,0.0);
wl_core_Config.SHADOW_MAP_SIZE = [512,512];
wl_core_Config.SEED = 123;
wl_core_Config.DEBUG = false;
wl_core_Config.TIMELINE = [];
wl_core_TimeSig.ABSOLUTE = "absolute";
wl_core_TimeSig.RELATIVE = "relative";
wl_core_TimeSig.PATTERN = "pattern";
wl_debug_Debug.paused = false;
wl_debug_Debug.editMode = false;
wl_debug_Debug.usedFolderNames = [];
wl_debug_ManualControl.parts = [];
wl_debug_ManualControl.storedPoints = [];
wl_demo_CameraController.STOPPED = false;
wl_demo_CameraController.STATIC = "static";
wl_demo_CameraController.LINEAR = "linear";
wl_demo_CameraController.BEZIER = "bezier";
wl_demo_CameraController.FOLLOW = "follow";
wl_demo_TransformNodeController.STOPPED = false;
wl_demo_TransformNodeController.STATIC = "static";
wl_demo_TransformNodeController.LINEAR = "linear";
wl_demo_TransformNodeController.BEZIER = "bezier";
wl_demo_TransformNodeController.FOLLOW = "follow";
wl_sounds_SoundWL.FFT_PRECISION = 1024;
wl_sounds_SoundWL.onSoundLoaded = new wl_core_Signal();
wl_sounds_SoundWL.onSoundComplete = new wl_core_Signal();
wl_sounds_SoundWL.onSoundReady = new wl_core_Signal();
wl_sounds_SoundWL.time = new wl_core_TimeSig();
wl_sounds_SoundWL.volume = 1;
wl_sounds_SoundWL.startTime = 0;
wl_sounds_SoundWL.loaded = false;
wl_sounds_SoundWL.lastFFT = 0;
wl_sounds_SoundWL.FFT = { dbLeft : null, frequencyLeft : null, waveformLeft : null, dbRight : null, frequencyRight : null, waveformRight : null, fftsize : 1024, sampleRate : 44100};
wl_util_LoadManager._totalCount = 0;
wl_util_LoadManager.loadersWaiting = [];
wl_util_LoadManager.managerDone = false;
wl_util_Random.instance = new wl_util_Random(123);
Main.main();
})(typeof exports != "undefined" ? exports : typeof window != "undefined" ? window : typeof self != "undefined" ? self : this, typeof window != "undefined" ? window : typeof global != "undefined" ? global : typeof self != "undefined" ? self : this);
