#version 330 core

layout(location = 0) in vec3 squareVertices;
layout(location = 1) in vec2 xys; // Position of the center of the particule and size of the square

out vec2 uv;
out vec4 oColor;
out vec4 oPos;

uniform sampler2D state;
uniform sampler2D colorbuffer;
uniform vec3 camr;
uniform vec3 camu;
uniform vec3 campos;
uniform mat4 VpMtx;

uniform float diameter;
uniform vec2 iResolution;
uniform float focus;
uniform float lifetime;

uniform float fogB;
uniform vec3 fogSunDir;
uniform vec3 fogColor;
uniform vec3 fogSunColor;

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec3 applyFog( in vec3  rgb,      // original color of the pixel
               in float distance, // camera to point distance
               in vec3  rayDir,   // camera to point vector
               in vec3  sunDir )  // sun light direction
{
    float fogAmount = 1.0 - exp( -distance*fogB );
    float sunAmount = max( dot( rayDir, sunDir ), 0.0 );
    vec3  fogColor  = mix( vec3(0.6,0.6,0.7), // bluish fog
                           vec3(1.0),         // yellowish
                           pow(sunAmount,8.0) );
    return mix( rgb, fogColor, fogAmount );
}

void main()
{
	vec4 partikle = texture(state, xys.xy);
	vec3 particleCenter_wordspace = partikle.xyz;

	/// DOF	
    vec2 r = iResolution.xy;
    float aperture = diameter * pow(length(r.xy)/length(vec2(1920.,1080.)), 1.0/(1.5*sqrt(2.0)));
    const float F = 0.03;
    float depth = length(partikle.xyz - campos);
    float cock = abs(aperture*(F*(depth-focus))/(depth*max(0.5/aperture, focus-F)));
    //// DOF

	//float s = float(lifetime > 0.0) * (0.0175 * ((lifetime == 0.0) ? 1.0 : smoothstep(lifetime/3.0, lifetime/2.0, partikle.w) * (1.0 - smoothstep(lifetime - 0.5, lifetime, partikle.w))));
	//float s = float(lifetime > 0.0) * (0.0175 * (1.0 - smoothstep(lifetime - 0.5, lifetime, partikle.w)));
	float s = float(lifetime > 0.0) * (0.0175 * (1.0 - smoothstep(lifetime - 0.01, lifetime, partikle.w)));
	const float is2 = 0.70710678118;
	const mat2 kaeaensimmekernelin = mat2(is2, is2, is2, -is2);
	vec2 jitter = kaeaensimmekernelin*(vec2(rand(xys.xy), rand(xys.yx)) - 0.5) * 2.0 * cock;
	vec3 vertexPosition_worldspace = 
		particleCenter_wordspace
		+ s*normalize(camr)*squareVertices.x
		+ s*normalize(camu)*squareVertices.y
		+ jitter.x*normalize(camr)
		+ jitter.y*normalize(camu);

	// Output position of the vertex
	gl_Position = VpMtx * vec4(vertexPosition_worldspace, 1.0);
	uv =  .5 *(1.0 + squareVertices.xy);
	oColor = texture(colorbuffer, xys.xy); //vec4(xys.xxy, 1.0);
	oColor.rgb = applyFog(oColor.rgb,
		                  length(campos - particleCenter_wordspace),
		                  normalize(particleCenter_wordspace - campos),
		                  normalize(fogSunDir));
	oPos = vec4(vertexPosition_worldspace.xyz, 1.0);
}
