#version 330 core

in vec2 UV;
uniform sampler2D inputtex;
uniform vec2 resolution;

out vec4 color;

#ifndef FXAA_REDUCE_MIN
    #define FXAA_REDUCE_MIN   (1.0/ 128.0)
#endif
#ifndef FXAA_REDUCE_MUL
    #define FXAA_REDUCE_MUL   (1.0 / 8.0)
#endif
#ifndef FXAA_SPAN_MAX
    #define FXAA_SPAN_MAX     8.0
#endif

float rand(vec2 co){
    return 2.0*(fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453) - 0.5);
}

void main(){
   vec2 uv = UV;

   vec2 inverse_resolution=vec2(1.0/resolution.x,1.0/resolution.y);
   vec3 rgbNW = texture(inputtex, uv.xy + (vec2(-1.0,-1.0) * inverse_resolution)).xyz;
   vec3 rgbNE = texture(inputtex, uv.xy + (vec2(1.0,-1.0) * inverse_resolution)).xyz;
   vec3 rgbSW = texture(inputtex, uv.xy + (vec2(-1.0,1.0) * inverse_resolution)).xyz;
   vec3 rgbSE = texture(inputtex, uv.xy + (vec2(1.0,1.0) * inverse_resolution)).xyz;
   vec3 rgbM  = texture(inputtex,  uv.xy).xyz;
   vec3 luma = vec3(0.299, 0.587, 0.114);
   float lumaNW = dot(rgbNW, luma);
   float lumaNE = dot(rgbNE, luma);
   float lumaSW = dot(rgbSW, luma);
   float lumaSE = dot(rgbSE, luma);
   float lumaM  = dot(rgbM,  luma);
   float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));
   float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE))); 
   vec2 dir;
   dir.x = -((lumaNW + lumaNE) - (lumaSW + lumaSE));
   dir.y =  ((lumaNW + lumaSW) - (lumaNE + lumaSE));
   float dirReduce = max((lumaNW + lumaNE + lumaSW + lumaSE) * (0.25 * FXAA_REDUCE_MUL),FXAA_REDUCE_MIN);
   float rcpDirMin = 1.0/(min(abs(dir.x), abs(dir.y)) + dirReduce);
   dir = min(vec2( FXAA_SPAN_MAX,  FXAA_SPAN_MAX),max(vec2(-FXAA_SPAN_MAX, -FXAA_SPAN_MAX),dir * rcpDirMin)) * inverse_resolution;
   vec3 rgbA = 0.5 * (texture(inputtex,   uv.xy   + dir * (1.0/3.0 - 0.5)).xyz + texture(inputtex,   uv.xy   + dir * (2.0/3.0 - 0.5)).xyz);
   vec3 rgbB = rgbA * 0.5 + 0.25 * (texture(inputtex,  uv.xy   + dir *  - 0.5).xyz + texture(inputtex,  uv.xy   + dir * 0.5).xyz);
   float lumaB = dot(rgbB, luma);
   if((lumaB < lumaMin) || (lumaB > lumaMax)) {
      color = vec4(rgbA,1.0);
   } else {
      color = vec4(rgbB,1.0);
   }
   //color = abs(color - texture(inputtex, UV));
   //color = texture(inputtex, UV);
}
