/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.tabulardataio;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.XYDataItem;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.function.MaskFunctionImpl;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.BitRateMapping;
import org.seamcat.model.functions.BlockingMask;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.IntermodulationRejectionMask;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.types.result.BarChartResultType;
import org.seamcat.model.types.result.BarChartValue;
import org.seamcat.model.types.result.FunctionResultType;
import org.seamcat.model.types.result.ScatterDiagramResultType;
import org.seamcat.model.types.result.SingleValueTypes;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.presentation.display.SingleValueGroupResultType;
import org.seamcat.presentation.display.VectorHelper;
import org.seamcat.presentation.propagationtest.VectorHolder;
import org.seamcat.tabulardataio.DataResultType;
import org.seamcat.tabulardataio.TabularDataFactory;
import org.seamcat.tabulardataio.TabularDataLoader;
import org.seamcat.tabulardataio.TabularDataSaver;

public class FileDataIO {
    private File file;

    public void setFile(File _file) {
        this.file = _file;
    }

    public File getFile() {
        return this.file;
    }

    public void savePropogationHolders(DataResultType type, List<VectorHolder> propagationHolders) {
        Object[] row;
        Object[] titles;
        TabularDataSaver dataSaver = TabularDataFactory.newSaverForFile(this.file);
        int length = 0;
        if (type == DataResultType.vector) {
            titles = new String[2 * propagationHolders.size()];
            row = new Double[2 * propagationHolders.size()];
        } else if (type == DataResultType.cdf) {
            titles = new String[propagationHolders.size() * 3];
            row = new Double[propagationHolders.size() * 3];
        } else if (type == DataResultType.graph || type == DataResultType.pdf) {
            titles = new String[propagationHolders.size() * 2];
            row = new Double[propagationHolders.size() * 2];
        } else {
            titles = new String[propagationHolders.size()];
            row = new Double[propagationHolders.size()];
        }
        for (int i = 0; i < propagationHolders.size(); ++i) {
            VectorHolder holder = propagationHolders.get(i);
            length = Math.max(length, holder.getData().length);
            if (type == DataResultType.vector) {
                titles[2 * i] = "Event number";
                titles[2 * i + 1] = this.toTitleWithUnit(holder.getTitle(), holder.getUnit());
                continue;
            }
            if (type == DataResultType.cdf) {
                titles[2 * i] = "Event number";
                titles[2 * i + 1] = this.toTitleWithUnit(holder.getTitle(), holder.getUnit());
                titles[2 * i + 2] = "Cumulative";
                continue;
            }
            if (type == DataResultType.graph) {
                titles[2 * i] = holder.getSortedTitle();
                titles[2 * i + 1] = holder.getTitle();
                continue;
            }
            if (type != DataResultType.pdf) continue;
            titles[2 * i] = "Bin";
            titles[2 * i + 1] = "Probability";
        }
        dataSaver.addRow(titles);
        HistogramDataset data = null;
        if (type == DataResultType.pdf) {
            int bins = propagationHolders.get((int)0).binCount;
            data = VectorHelper.getDensityHistogram(propagationHolders, bins);
            length = bins;
        }
        for (int j = 0; j < length; ++j) {
            for (int i = 0; i < propagationHolders.size(); ++i) {
                VectorHolder holder = propagationHolders.get(i);
                if (type == DataResultType.vector) {
                    row[2 * i] = (double)j;
                    if (holder.getData().length < j) {
                        row[2 * i + 1] = 0.0;
                        continue;
                    }
                    row[2 * i + 1] = holder.getData()[j];
                    continue;
                }
                if (type == DataResultType.cdf) {
                    if (holder.getData().length < j) {
                        row[2 * i] = 0.0;
                        row[2 * i + 1] = 0.0;
                        continue;
                    }
                    int[] eventNb = holder.getCumulativeEventNumber();
                    row[2 * i] = (double)eventNb[j];
                    XYDataItem xy = holder.getCumulativeDataSeries().getDataItem(j);
                    row[2 * i + 1] = xy.getX().doubleValue();
                    row[2 * i + 2] = xy.getY().doubleValue();
                    continue;
                }
                if (type == DataResultType.graph) {
                    if (holder.getData().length < j) {
                        row[2 * i] = 0.0;
                        row[2 * i + 1] = 0.0;
                        continue;
                    }
                    row[2 * i] = holder.getSortedDistributions()[j];
                    row[2 * i + 1] = holder.getData()[j];
                    continue;
                }
                if (type != DataResultType.pdf) continue;
                row[2 * i] = data.getX(i, j).doubleValue();
                row[2 * i + 1] = data.getY(i, j).doubleValue();
            }
            dataSaver.addRow(row);
        }
        dataSaver.close();
    }

    public void savePoints(List<Point2D> points) {
        TabularDataSaver dataSaver = TabularDataFactory.newSaverForFile(this.file);
        for (Point2D point : points) {
            dataSaver.addRow(point.getX(), point.getY());
        }
        dataSaver.close();
    }

    public void saveFunction(Function function, String ... units) {
        TabularDataSaver dataSaver = TabularDataFactory.newSaverForFile(this.file);
        dataSaver.addRow(units);
        List<Point2D> points = function.getPoints();
        if (function instanceof MaskFunction) {
            MaskFunction mask = (MaskFunction)function;
            for (Point2D point : points) {
                dataSaver.addRow(point.getX(), point.getY(), mask.getMask(point));
            }
        } else {
            if (function instanceof BlockingMask || function instanceof IntermodulationRejectionMask || function instanceof BitRateMapping) {
                // empty if block
            }
            for (Point2D point : points) {
                dataSaver.addRow(point.getX(), point.getY());
            }
        }
        dataSaver.close();
    }

    public void saveValues(BarChartResultType barChart) {
        TabularDataSaver dataSaver = TabularDataFactory.newSaverForFile(this.file);
        dataSaver.addRow(barChart.def().unit(), barChart.def().yUnit());
        Iterator iterator = barChart.value().iterator();
        while (iterator.hasNext()) {
            BarChartValue value = (BarChartValue)iterator.next();
            dataSaver.addRow(value.getName(), value.getValue());
        }
        dataSaver.close();
    }

    public void saveValues(SingleValueGroupResultType single) {
        TabularDataSaver dataSaver = TabularDataFactory.newSaverForFile(this.file);
        dataSaver.addRow(single.getName(), "Value", "Unit");
        for (SingleValueTypes<?> value : single.getValues()) {
            dataSaver.addRow(value.def().name(), value.value(), value.def().unit());
        }
        dataSaver.close();
    }

    public void saveValues(ScatterDiagramResultType scatter) {
        TabularDataSaver dataSaver = TabularDataFactory.newSaverForFile(this.file);
        dataSaver.addRow(scatter.def().unit(), scatter.def().yUnit());
        Iterator iterator = scatter.value().iterator();
        while (iterator.hasNext()) {
            Point2D value = (Point2D)iterator.next();
            dataSaver.addRow(value.getX(), value.getY());
        }
        dataSaver.close();
    }

    public void saveValues(double[] x, String xUnit, double[] y, String yUnit) {
        TabularDataSaver dataSaver = TabularDataFactory.newSaverForFile(this.file);
        dataSaver.addRow(xUnit, yUnit);
        int size = x.length > y.length ? y.length : x.length;
        for (int i = 0; i < size; ++i) {
            dataSaver.addRow(x[i], y[i]);
        }
        dataSaver.close();
    }

    public void saveValues(FunctionResultType function) {
        TabularDataSaver dataSaver = TabularDataFactory.newSaverForFile(this.file);
        dataSaver.addRow(function.def().unit(), function.def().yUnit());
        Function val = function.value();
        for (Point2D value : val.getPoints()) {
            dataSaver.addRow(value.getX(), value.getY());
        }
        dataSaver.close();
    }

    private String toTitleWithUnit(String title, String unit) {
        return title + " [" + unit + "]";
    }

    private String[] fromTitleWithUnit(String raw) {
        String[] result = new String[]{raw, "No unit"};
        if (raw.contains("[") && raw.contains("]")) {
            int begin = raw.indexOf("[");
            int end = raw.indexOf("]");
            result[0] = raw.substring(0, begin);
            result[1] = raw.substring(begin + 1, end);
        }
        return result;
    }

    public VectorResultType loadVector() {
        TabularDataLoader loader = TabularDataFactory.newLoaderForFile(this.file);
        Object[] row = loader.getRow();
        String name = "Vector";
        String unit = "No unit";
        if (row == null) {
            return null;
        }
        if (row.length < 2) {
            return null;
        }
        if (row[1] instanceof String) {
            String[] tAndU = this.fromTitleWithUnit((String)row[1]);
            name = tAndU[0];
            unit = tAndU[1];
        }
        ArrayList<Double> vector = new ArrayList<Double>();
        while (null != (row = loader.getRow())) {
            Object o;
            if (row.length <= 1 || !((o = row[1]) instanceof Double)) continue;
            vector.add((Double)o);
        }
        return new VectorResultType(Factory.results().value(name, unit), vector);
    }

    public Function loadFunction() {
        Object[] row;
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        ArrayList<Double> mask = new ArrayList<Double>();
        TabularDataLoader loader = TabularDataFactory.newLoaderForFile(this.file);
        boolean isMask = false;
        while (null != (row = loader.getRow())) {
            isMask = this.row(points, mask, row, isMask);
        }
        if (isMask) {
            return new MaskFunctionImpl(points, mask);
        }
        return new DiscreteFunction(points);
    }

    private boolean row(List<Point2D> points, List<Double> mask, Object[] row, boolean isMask) {
        double[] doubleRow = new double[3];
        int cols = 0;
        for (Object o : row) {
            if (o instanceof String) {
                return false;
            }
            if (o instanceof Double && cols <= 2) {
                doubleRow[cols] = (Double)o;
            }
            ++cols;
        }
        if (cols > 2) {
            points.add(new Point2D(doubleRow[0], doubleRow[1]));
            mask.add(doubleRow[2]);
            isMask = true;
        } else {
            points.add(new Point2D(doubleRow[0], doubleRow[1]));
        }
        return isMask;
    }
}

