/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.tabulardataio;

import java.io.File;
import java.io.FileOutputStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.seamcat.tabulardataio.TabularDataSaver;
import org.seamcat.util.StringHelper;

public class ExcelDataSaver
implements TabularDataSaver {
    private File file;
    private Workbook workbook;
    private Sheet sheet;
    private int nextRowNumber = 0;

    public ExcelDataSaver(File file, Class<? extends Workbook> workbookImplementationClass) {
        try {
            this.file = file;
            this.workbook = workbookImplementationClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addSheet(String title) {
        this.sheet = this.workbook.createSheet(title);
        this.nextRowNumber = 0;
    }

    @Override
    public void addRow(Object ... data) {
        if (this.sheet == null) {
            this.sheet = this.workbook.createSheet();
        }
        Row row = this.sheet.createRow(this.nextRowNumber++);
        for (int i = 0; i < data.length; ++i) {
            Cell cell = row.createCell(i);
            if (data[i] instanceof Number) {
                cell.setCellValue(((Number)data[i]).doubleValue());
                continue;
            }
            cell.setCellValue(StringHelper.objectToString(data[i]));
        }
    }

    @Override
    public void close() {
        try {
            this.workbook.write(new FileOutputStream(this.file));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void flush() {
    }
}

