/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.tabulardataio;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.seamcat.tabulardataio.TabularDataLoader;

public class ExcelDataLoader
implements TabularDataLoader {
    private final FileInputStream stream;
    private Workbook workbook;
    private Sheet sheet;
    private int nextRowNumber = 0;

    public ExcelDataLoader(File file, Class<? extends Workbook> workbookImplementationClass) {
        try {
            this.stream = new FileInputStream(file);
            this.workbook = workbookImplementationClass.getConstructor(InputStream.class).newInstance(this.stream);
            this.sheet = this.workbook.getSheetAt(0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object[] getRow() {
        Row row;
        if ((row = this.sheet.getRow(this.nextRowNumber++)) == null) {
            return null;
        }
        int size = row.getLastCellNum();
        Object[] result = new Object[size];
        for (int i = 0; i < size; ++i) {
            result[i] = row.getCell(i).getCellType() == 0 ? Double.valueOf(row.getCell(i).getNumericCellValue()) : row.getCell(i).getStringCellValue();
        }
        return result;
    }

    @Override
    public void close() {
        try {
            this.stream.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

