/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.tabulardataio;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.seamcat.tabulardataio.TabularDataSaver;
import org.seamcat.util.StringHelper;

public class DelimiterSeparatedDataSaver
implements TabularDataSaver {
    private String delimiter = "\t";
    private BufferedWriter writer;
    private int unflushedRows = 0;

    public DelimiterSeparatedDataSaver(File file) {
        try {
            this.writer = new BufferedWriter(new FileWriter(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addSheet(String title) {
    }

    @Override
    public void addRow(Object ... data) {
        try {
            this.tryAddRow(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void tryAddRow(Object ... data) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            this.writer.write(StringHelper.objectToString(data[i]));
            if (i >= data.length - 1) continue;
            this.writer.write(this.delimiter);
        }
        this.writer.newLine();
        ++this.unflushedRows;
        if (this.unflushedRows > 2000) {
            this.flush();
            this.unflushedRows = 0;
        }
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

