/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.settings;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.plugin.system.CorrelationMode;
import org.seamcat.model.types.CorrelationSetting;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.workspace.CorrelationSettingsUI;

public class CorrelationSettingImpl
implements CorrelationSetting {
    protected CorrelationSettingsUI ui;
    private InterferenceLink coLocated;

    public CorrelationSettingImpl(CorrelationSettingsUI ui, InterferenceLink coLocated) {
        this.ui = ui;
        this.coLocated = coLocated;
    }

    @Override
    public CorrelationMode getCorrelationMode() {
        return this.ui.mode();
    }

    @Override
    public Distribution getDeltaX() {
        return this.ui.deltaX();
    }

    @Override
    public Distribution getDeltaY() {
        return this.ui.deltaY();
    }

    @Override
    public Point2D trialDelta() {
        return new Point2D(this.ui.deltaX().trial(), this.ui.deltaY().trial());
    }

    @Override
    public Distribution getMinimumCouplingLoss() {
        return this.ui.minimumCouplingLoss();
    }

    @Override
    public String getPositionRelativeTo() {
        return this.ui.positionRelativeTo();
    }

    @Override
    public String getCorrelationTarget() {
        return this.ui.correlationTarget();
    }

    @Override
    public boolean isCoLocated() {
        return this.ui.isCoLocated();
    }

    @Override
    public InterferenceLink getCoLocatedWith() {
        return this.coLocated;
    }

    @Override
    public <T> T getCorrelationConfiguration(Class<T> clazz) {
        Object t = this.ui.customUI().get(clazz);
        if (t == null) {
            t = ProxyHelper.newInstance(clazz);
        }
        return (T)t;
    }
}

