/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.result;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seamcat.model.functions.Function;
import org.seamcat.model.simulation.result.MultiValueDef;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.types.result.BarChartResultType;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.model.types.result.FunctionResultType;
import org.seamcat.model.types.result.IntegerResultType;
import org.seamcat.model.types.result.LongResultType;
import org.seamcat.model.types.result.ResultType;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.SamplesResultType;
import org.seamcat.model.types.result.ScatterDiagramResultType;
import org.seamcat.model.types.result.SingleValueTypes;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.plugin.PostProcessingUIState;

public class ResultsImpl
implements Results {
    private List<SingleValueTypes<?>> singleValueTypes = new ArrayList();
    private List<VectorResultType> vectorResultTypes = new ArrayList<VectorResultType>();
    private List<ScatterDiagramResultType> scatterDiagramResultTypes = new ArrayList<ScatterDiagramResultType>();
    private List<BarChartResultType> barChartResultTypes = new ArrayList<BarChartResultType>();
    private List<FunctionResultType> functionResultTypes = new ArrayList<FunctionResultType>();
    private List<PostProcessingUIState> postProcessingState = new ArrayList<PostProcessingUIState>();
    private List<SamplesResultType> samplesResultTypes = new ArrayList<SamplesResultType>();
    private String id;
    private String name;

    public ResultsImpl(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public ResultsImpl(String name) {
        this.id = "seamcatResult";
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<SingleValueTypes<?>> getSingleValueTypes() {
        return this.singleValueTypes;
    }

    @Override
    public List<VectorResultType> getVectorResultTypes() {
        return this.vectorResultTypes;
    }

    @Override
    public List<FunctionResultType> getFunctionResultTypes() {
        return this.functionResultTypes;
    }

    @Override
    public Function findFunction(UniqueValueDef def) {
        for (FunctionResultType type : this.functionResultTypes) {
            if (!type.def().equals(def)) continue;
            return type.value();
        }
        return null;
    }

    @Override
    public VectorResultType findVector(VectorDef def) {
        for (VectorResultType vector : this.vectorResultTypes) {
            if (!vector.def().equals(def)) continue;
            return vector;
        }
        return null;
    }

    @Override
    public double findDoubleValue(UniqueValueDef def) {
        for (SingleValueTypes<?> single : this.singleValueTypes) {
            if (!single.def().equals(def) || !(single instanceof DoubleResultType)) continue;
            return ((DoubleResultType)single).value();
        }
        return -1.0;
    }

    @Override
    public boolean hasSingleValue(UniqueValueDef def) {
        for (SingleValueTypes<?> type : this.singleValueTypes) {
            if (!type.def().equals(def)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int findIntValue(UniqueValueDef def) {
        for (SingleValueTypes<?> single : this.singleValueTypes) {
            if (!single.def().equals(def) || !(single instanceof IntegerResultType)) continue;
            return ((IntegerResultType)single).value();
        }
        return -1;
    }

    @Override
    public long findLongValue(UniqueValueDef def) {
        for (SingleValueTypes<?> single : this.singleValueTypes) {
            if (!single.def().equals(def) || !(single instanceof LongResultType)) continue;
            return ((LongResultType)single).value();
        }
        return -1L;
    }

    @Override
    public BarChartResultType findBarChart(MultiValueDef def) {
        for (BarChartResultType type : this.barChartResultTypes) {
            if (!type.def().equals(def)) continue;
            return type;
        }
        return null;
    }

    @Override
    public ScatterDiagramResultType findScatterDiagram(MultiValueDef def) {
        for (ScatterDiagramResultType scatter : this.scatterDiagramResultTypes) {
            if (!scatter.def().equals(def)) continue;
            return scatter;
        }
        return null;
    }

    @Override
    public List<SamplesResultType> getSamplesResultTypes() {
        return this.samplesResultTypes;
    }

    @Override
    public List<ScatterDiagramResultType> getScatterDiagramResultTypes() {
        return this.scatterDiagramResultTypes;
    }

    @Override
    public List<BarChartResultType> getBarChartResultTypes() {
        return this.barChartResultTypes;
    }

    @Override
    public boolean isEmpty() {
        return this.singleValueTypes.isEmpty() && this.vectorResultTypes.isEmpty() && this.barChartResultTypes.isEmpty() && this.scatterDiagramResultTypes.isEmpty();
    }

    @Override
    public List<VectorResultType> findGroup(String group) {
        ArrayList<VectorResultType> vectorGroup = new ArrayList<VectorResultType>();
        for (VectorResultType type : this.vectorResultTypes) {
            if (!type.def().isGrouped() || !type.def().group().equals(group)) continue;
            vectorGroup.add(type);
        }
        return vectorGroup;
    }

    @Override
    public List<VectorResultType> nonGrouped() {
        ArrayList<VectorResultType> nonGroup = new ArrayList<VectorResultType>();
        for (VectorResultType type : this.vectorResultTypes) {
            if (type.def().isGrouped()) continue;
            nonGroup.add(type);
        }
        return nonGroup;
    }

    @Override
    public Map<String, List<VectorResultType>> allGroups() {
        LinkedHashMap<String, List<VectorResultType>> groups = new LinkedHashMap<String, List<VectorResultType>>();
        for (VectorResultType type : this.vectorResultTypes) {
            if (!type.def().isGrouped()) continue;
            ArrayList<VectorResultType> group = (ArrayList<VectorResultType>)groups.get(type.def().group());
            if (group == null) {
                group = new ArrayList<VectorResultType>();
                groups.put(type.def().group(), group);
            }
            group.add(type);
        }
        return groups;
    }

    @Override
    public List<SingleValueTypes> findSingleValueGroup(String group) {
        ArrayList<SingleValueTypes> result = new ArrayList<SingleValueTypes>();
        for (SingleValueTypes<?> type : this.singleValueTypes) {
            if (!type.def().isGrouped() || !type.def().group().equals(group)) continue;
            result.add(type);
        }
        return result;
    }

    @Override
    public Map<String, List<SingleValueTypes>> allSingleValueGroups() {
        LinkedHashMap<String, List<SingleValueTypes>> all = new LinkedHashMap<String, List<SingleValueTypes>>();
        for (SingleValueTypes<?> type : this.singleValueTypes) {
            if (!type.def().isGrouped()) continue;
            ArrayList group = (ArrayList)all.get(type.def().group());
            if (group == null) {
                group = new ArrayList();
                all.put(type.def().group(), group);
            }
            group.add(type);
        }
        return all;
    }

    private <T extends ResultType<?>> List<T> non(List<T> all) {
        ArrayList<ResultType> list = new ArrayList<ResultType>();
        for (ResultType resultType : all) {
            if (resultType.def().isGrouped()) continue;
            list.add(resultType);
        }
        return list;
    }

    private <T extends ResultType<?>> Map<String, List<T>> grouped(List<T> all) {
        LinkedHashMap<String, List<T>> grouped = new LinkedHashMap<String, List<T>>();
        for (ResultType type : all) {
            if (!type.def().isGrouped()) continue;
            ArrayList<ResultType> group = (ArrayList<ResultType>)grouped.get(type.def().group());
            if (group == null) {
                group = new ArrayList<ResultType>();
                grouped.put(type.def().group(), group);
            }
            group.add(type);
        }
        return grouped;
    }

    @Override
    public List<SingleValueTypes> nonGroupedSingleValues() {
        ArrayList<SingleValueTypes> nonGroup = new ArrayList<SingleValueTypes>();
        for (SingleValueTypes<?> type : this.singleValueTypes) {
            if (type.def().isGrouped()) continue;
            nonGroup.add(type);
        }
        return nonGroup;
    }

    @Override
    public List<ScatterDiagramResultType> nonGroupedScatter() {
        return this.non(this.scatterDiagramResultTypes);
    }

    @Override
    public List<BarChartResultType> nonGroupedBarChart() {
        return this.non(this.barChartResultTypes);
    }

    @Override
    public List<FunctionResultType> nonGroupedFunction() {
        return this.non(this.functionResultTypes);
    }

    @Override
    public Map<String, List<ScatterDiagramResultType>> allGroupedScatter() {
        return this.grouped(this.scatterDiagramResultTypes);
    }

    @Override
    public Map<String, List<FunctionResultType>> allGroupedFunction() {
        return this.grouped(this.functionResultTypes);
    }

    @Override
    public Map<String, List<BarChartResultType>> allGroupedBarChart() {
        return this.grouped(this.barChartResultTypes);
    }

    public List<PostProcessingUIState> getPostProcessingState() {
        return this.postProcessingState;
    }

    public ResultsImpl copy() {
        ResultsImpl copy = new ResultsImpl(this.id, this.name);
        copy.singleValueTypes = new ArrayList(this.singleValueTypes);
        copy.vectorResultTypes = new ArrayList<VectorResultType>(this.vectorResultTypes);
        copy.scatterDiagramResultTypes = new ArrayList<ScatterDiagramResultType>(this.scatterDiagramResultTypes);
        copy.barChartResultTypes = new ArrayList<BarChartResultType>(this.barChartResultTypes);
        copy.functionResultTypes = new ArrayList<FunctionResultType>(this.functionResultTypes);
        copy.postProcessingState = new ArrayList<PostProcessingUIState>(this.postProcessingState);
        copy.samplesResultTypes = new ArrayList<SamplesResultType>(this.samplesResultTypes);
        return copy;
    }
}

