/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.result;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.plugin.system.LocalEnvironmentUI;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.MultiValueDef;
import org.seamcat.model.simulation.result.ResultFactory;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.types.LocalEnvironment;
import org.seamcat.simulation.result.AntennaResultImpl;
import org.seamcat.simulation.result.FunctionDefImpl;
import org.seamcat.simulation.result.LinkResultImpl;
import org.seamcat.simulation.result.MultiPlotDefImpl;
import org.seamcat.simulation.result.OptionalValueImpl;
import org.seamcat.simulation.result.SingleValueDefImpl;
import org.seamcat.simulation.result.VectorDefImpl;
import org.seamcat.simulation.settings.LocalEnvironmentImpl;

public class ResultFactoryImpl
implements ResultFactory {
    @Override
    public LinkResult linkResult() {
        return new LinkResultImpl();
    }

    @Override
    public LinkResult linkResult(RadioSystem system, double frequency) {
        LinkResultImpl link = new LinkResultImpl();
        link.setFrequency(frequency);
        return link;
    }

    @Override
    public AntennaResult antennaResult() {
        return new AntennaResultImpl();
    }

    @Override
    public VectorDef value(String name, String unit) {
        return new VectorDefImpl(name, unit, false);
    }

    @Override
    public VectorDef intermediateValue(String name, String unit) {
        return new VectorDefImpl(name, unit, true);
    }

    @Override
    public VectorDef group(String group, String name, String unit) {
        return new VectorDefImpl(group, name, unit, false);
    }

    @Override
    public VectorDef intermediateGroup(String group, String name, String unit, boolean intermediate) {
        return new VectorDefImpl(group, name, unit, true);
    }

    @Override
    public MultiValueDef multi(String name, String xAxis, String yAxis) {
        return new MultiPlotDefImpl(name, xAxis, yAxis, false);
    }

    @Override
    public MultiValueDef intermediateMulti(String name, String xAxis, String yAxis) {
        return new MultiPlotDefImpl(name, xAxis, yAxis, true);
    }

    @Override
    public MultiValueDef multiGroup(String group, String name, String xAxis, String yAxis) {
        return new MultiPlotDefImpl(group, name, xAxis, yAxis, false);
    }

    @Override
    public MultiValueDef intermediateMultiGroup(String group, String name, String xAxis, String yAxis) {
        return new MultiPlotDefImpl(group, name, xAxis, yAxis, true);
    }

    @Override
    public UniqueValueDef function(String name, String xAxis, String yAxis) {
        return new FunctionDefImpl(name, xAxis, yAxis, false);
    }

    @Override
    public UniqueValueDef single(String name, String unit) {
        return new SingleValueDefImpl(name, unit, false);
    }

    @Override
    public UniqueValueDef intermediateSingle(String name, String unit) {
        return new SingleValueDefImpl(name, unit, true);
    }

    @Override
    public UniqueValueDef singleGroup(String group, String name, String unit) {
        return new SingleValueDefImpl(group, name, unit, false);
    }

    @Override
    public UniqueValueDef intermediateSingleGroup(String group, String name, String unit) {
        return new SingleValueDefImpl(group, name, unit, true);
    }

    @Override
    public List<LocalEnvironment> convert(List<LocalEnvironmentUI> uis) {
        ArrayList<LocalEnvironment> result = new ArrayList<LocalEnvironment>();
        for (LocalEnvironmentUI ui : uis) {
            result.add(new LocalEnvironmentImpl(ui.environment(), ui.prop(), ui.useBEL(), ui.wallLoss(), ui.stdDev(), ui.probExceeding(), ui.traditionalBuildings(), ui.applyOutdoorClutter(), ui.outdoorModel(), ui.percentageOfLocations(), ui.localClutter(), ui.userDefined(), ui.height(), ui.width()));
        }
        return result;
    }

    @Override
    public <T> OptionalValue<T> optional(boolean relevant, T t) {
        return new OptionalValueImpl<T>(relevant, t);
    }
}

