/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.result;

import java.util.List;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.simulation.cellular.GridPositionCalculator;
import org.seamcat.simulation.result.LinkResultImpl;
import org.seamcat.simulation.result.MutableSimulationElement;

public abstract class MutableBaseStationResult
extends MutableSimulationElement {
    private final int HEXAGONAL = 6;
    private AntennaGainConfiguration[] antennas;
    private Point2D[] geometry = new Point2D[6];
    private int cellId;
    private int cellLocationId;
    private double maximumTransmitPower;
    private double noiseRise;
    private double noiseRiseLinearFactor;
    private double relativeCellNoiseRise;
    private double initialCellNoiseRise;
    private int sectorId;
    private boolean upLinkMode;
    private double currentChannelTransmitPower;
    private double overheadFraction;
    private double overheadTransmitPower;
    private double pilotFraction;
    private double pilotTransmitPower;
    private int subCarriersInUse;

    public MutableBaseStationResult(AntennaGainConfiguration[] antennas) {
        this.antennas = antennas;
        this.upLinkMode = false;
    }

    public List<LinkResultImpl> getActiveConnections() {
        return null;
    }

    public void calculateHexagon(double cellRadius) {
        GridPositionCalculator.calculateHexagon(this.getPosition(), cellRadius, this.geometry);
    }

    public boolean isInside(Point2D p) {
        return GridPositionCalculator.isInside(p, this.geometry);
    }

    public int getCellId() {
        return this.cellId;
    }

    public int getCellLocationId() {
        return this.cellLocationId;
    }

    public double getMaximumTransmitPower() {
        return this.maximumTransmitPower;
    }

    public double getNoiseRise() {
        return this.noiseRise;
    }

    public double getNoiseRiseLinearFactor() {
        return this.noiseRiseLinearFactor;
    }

    public double getRelativeCellNoiseRise() {
        return this.relativeCellNoiseRise;
    }

    public double getInitialCellNoiseRise() {
        return this.initialCellNoiseRise;
    }

    public int getSectorId() {
        return this.sectorId;
    }

    public boolean isUpLinkMode() {
        return this.upLinkMode;
    }

    public double getCurrentChannelTransmitPower() {
        return this.currentChannelTransmitPower;
    }

    public double getOverheadFraction() {
        return this.overheadFraction;
    }

    public double getOverheadTransmitPower() {
        return this.overheadTransmitPower;
    }

    public double getPilotFraction() {
        return this.pilotFraction;
    }

    public double getPilotTransmitPower() {
        return this.pilotTransmitPower;
    }

    public int getSubCarriersInUse() {
        return this.subCarriersInUse;
    }

    public void setCellId(int cellId) {
        this.cellId = cellId;
    }

    public void setCellLocationId(int cellLocationId) {
        this.cellLocationId = cellLocationId;
    }

    public void setMaximumTransmitPower(double maximumTransmitPower) {
        this.maximumTransmitPower = maximumTransmitPower;
    }

    public void setNoiseRise(double noiseRise) {
        this.noiseRise = noiseRise;
    }

    public void setNoiseRiseLinearFactor(double noiseRiseLinearFactor) {
        this.noiseRiseLinearFactor = noiseRiseLinearFactor;
    }

    public void setRelativeCellNoiseRise(double relativeCellNoiseRise) {
        this.relativeCellNoiseRise = relativeCellNoiseRise;
    }

    public void setInitialCellNoiseRise(double initialCellNoiseRise) {
        this.initialCellNoiseRise = initialCellNoiseRise;
    }

    public void setSectorId(int sectorId) {
        this.sectorId = sectorId;
    }

    public void setUpLinkMode(boolean upLinkMode) {
        this.upLinkMode = upLinkMode;
    }

    public void setCurrentChannelTransmitPower(double currentChannelTransmitPower) {
        this.currentChannelTransmitPower = currentChannelTransmitPower;
    }

    public void setOverheadFraction(double overheadFraction) {
        this.overheadFraction = overheadFraction;
    }

    public void setOverheadTransmitPower(double overheadTransmitPower) {
        this.overheadTransmitPower = overheadTransmitPower;
    }

    public void setPilotFraction(double pilotFraction) {
        this.pilotFraction = pilotFraction;
    }

    public void setPilotTransmitPower(double pilotTransmitPower) {
        this.pilotTransmitPower = pilotTransmitPower;
    }

    public void setSubCarriersInUse(int subCarriersInUse) {
        this.subCarriersInUse = subCarriersInUse;
    }

    public AntennaGainConfiguration getAntennaGain() {
        if (this.antennas.length == 1) {
            return this.antennas[0];
        }
        return this.antennas[this.sectorId - 1];
    }
}

