/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.result;

import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaMobile;
import org.seamcat.model.simulation.result.DefaultInterfererImpl;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.AntennaGain;

public class InterfererImpl
extends DefaultInterfererImpl<InterfererImpl> {
    private boolean uplink;
    private int cellid;
    private AbstractDmaBaseStation bs;
    private AbstractDmaMobile ms;

    public InterfererImpl(int linkIndex, boolean uplink, AbstractDmaBaseStation bs, AbstractDmaMobile ms, LinkResult result, AntennaGain antennaGain, double minimumCouplingLoss) {
        super(linkIndex, antennaGain, result, minimumCouplingLoss);
        this.uplink = uplink;
        this.cellid = bs.getCellid();
        this.bs = bs;
        this.ms = ms;
    }

    public String toString() {
        LinkResult result = this.getLinkResult();
        return "Interferer at " + result.txAntenna().getPosition() + " : Transmit Power = " + result.getTxPower() + " dBm; Frequency = " + result.getFrequency() + "MHz; Antenna Height = " + result.txAntenna().getHeight() + " m";
    }

    @Override
    public boolean isSameRx(InterfererImpl other) {
        if (this.uplink) {
            return other.cellid == this.cellid;
        }
        return other == this;
    }

    @Override
    public boolean isSameTx(InterfererImpl other) {
        if (this.uplink) {
            return other == this;
        }
        return other.cellid == this.cellid;
    }

    @Override
    public String getRxName() {
        if (this.uplink) {
            return this.bs.getName();
        }
        return "MS " + (this.ms == null ? "?" : Integer.valueOf(this.ms.getUserId()));
    }

    @Override
    public String getTxName() {
        if (this.uplink) {
            return "MS " + (this.ms == null ? "?" : Integer.valueOf(this.ms.getUserId()));
        }
        return this.bs.getName();
    }
}

