/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.result;

import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.Direction;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.Interferer;
import org.seamcat.model.simulation.result.InterfererResultCollector;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.simulation.result.LinkResultImpl;

public class InterferenceLinkResultImpl
extends LinkResultImpl
implements InterferenceLinkResult {
    private InterferenceLink interferenceLink;
    private LinkResult victimLink;
    private Victim victim;
    private LinkResult interfererLink;
    private double riRSSUnwantedValue;
    private double riRSSBlockingValue;
    private double blockingAttenuation;
    private Double rxBandwidth;
    private AntennaResult tx;
    private AntennaResult rx;
    private Interferer interferer;
    private VictimResultCollector victimCollector;
    private InterfererResultCollector interfererResultCollector;

    public InterferenceLinkResultImpl(InterferenceLink interferenceLink, Victim victim, Interferer interferer, VictimResultCollector victimCollector, InterfererResultCollector interfererResultCollector) {
        this.interferenceLink = interferenceLink;
        this.victimLink = victim.getLinkResult();
        this.victim = victim;
        this.interfererLink = interferer.getLinkResult();
        this.interferer = interferer;
        this.victimCollector = victimCollector;
        this.interfererResultCollector = interfererResultCollector;
        AntennaResult vlr = this.victimLink.rxAntenna();
        AntennaResult ilt = this.interfererLink.txAntenna();
        this.setTxRxAngle(Mathematics.calculateKartesianAngle(vlr.getPosition(), ilt.getPosition()));
        this.setTxRxDistance(Mathematics.distance(ilt.getPosition(), vlr.getPosition()));
        this.tx = super.txAntenna();
        this.tx.setPosition(ilt.getPosition());
        this.tx.setHeight(ilt.getHeight());
        this.tx.setAzimuthCompensation(ilt.getAzimuthCompensation());
        this.tx.setElevationCompensation(ilt.getElevationCompensation());
        this.tx.setTilt(ilt.getTilt());
        this.rx = super.rxAntenna();
        this.rx.setPosition(vlr.getPosition());
        this.rx.setHeight(vlr.getHeight());
        this.rx.setAzimuthCompensation(vlr.getAzimuthCompensation());
        this.rx.setElevationCompensation(vlr.getElevationCompensation());
        this.rx.setTilt(vlr.getTilt());
        this.assignLocalEnvironment(interferenceLink.getInterferer().getSystem().getTransmitter().getLocalEnvironments(), Direction.To_TX);
        this.assignLocalEnvironment(interferenceLink.getVictim().getSystem().getReceiver().getLocalEnvironments(), Direction.To_RX);
        this.tx.setAzimuth(Mathematics.convertAngleToConfineToHorizontalDefinedRange(this.getTxRxAngle() - ilt.getAzimuthCompensation()));
        this.tx.setElevation(Mathematics.convertAngleToConfineToVerticalDefinedRange(Mathematics.calculateElevation(this.tx, this.rx)));
        this.rx.setAzimuth(Mathematics.convertAngleToConfineToHorizontalDefinedRange(this.getTxRxAngle() + 180.0 - vlr.getAzimuthCompensation()));
        this.rx.setElevation(Mathematics.convertAngleToConfineToVerticalDefinedRange(Mathematics.calculateElevation(this.rx, this.tx)));
    }

    @Override
    public AntennaResult txAntenna() {
        return this.tx;
    }

    @Override
    public AntennaResult rxAntenna() {
        return this.rx;
    }

    @Override
    public double getRiRSSUnwantedValue() {
        return this.riRSSUnwantedValue;
    }

    @Override
    public void setRiRSSUnwantedValue(double riRSSUnwantedValue) {
        this.mutate();
        this.riRSSUnwantedValue = riRSSUnwantedValue;
    }

    @Override
    public double getRiRSSBlockingValue() {
        return this.riRSSBlockingValue;
    }

    @Override
    public void setRiRSSBlockingValue(double riRSSBlockingValue) {
        this.mutate();
        this.riRSSBlockingValue = riRSSBlockingValue;
    }

    @Override
    public double getFrequency() {
        return this.interfererLink.getFrequency();
    }

    @Override
    public double getTxPower() {
        return this.interfererLink.getTxPower();
    }

    @Override
    public InterferenceLink getInterferenceLink() {
        return this.interferenceLink;
    }

    @Override
    public LinkResult getVictimSystemLink() {
        return this.victimLink;
    }

    @Override
    public Victim getVictim() {
        return this.victim;
    }

    @Override
    public LinkResult getInterferingSystemLink() {
        return this.interfererLink;
    }

    @Override
    public Interferer getInterferer() {
        return this.interferer;
    }

    @Override
    public double getRxBandwidth() {
        if (this.rxBandwidth == null) {
            return this.interferenceLink.getVictim().getSystem().getReceiver().getBandwidth();
        }
        return this.rxBandwidth;
    }

    @Override
    public void setRxBandwidth(double rxBandwidth) {
        this.mutate();
        this.rxBandwidth = rxBandwidth;
    }

    @Override
    public double getBlockingAttenuation() {
        return this.blockingAttenuation;
    }

    @Override
    public void setBlockingAttenuation(double blockingAttenuation) {
        this.mutate();
        this.blockingAttenuation = blockingAttenuation;
    }

    @Override
    public void lock(String key) {
        super.lock(key);
        ((LinkResultImpl)this.victimLink).lock(key);
        ((LinkResultImpl)this.interfererLink).lock(key);
    }

    @Override
    public void unlock(String key) {
        super.unlock(key);
        ((LinkResultImpl)this.victimLink).unlock(key);
        ((LinkResultImpl)this.interfererLink).unlock(key);
    }

    @Override
    public VictimResultCollector getVictimSystemResult() {
        return this.victimCollector;
    }

    @Override
    public InterfererResultCollector getInterferingSystemResult() {
        return this.interfererResultCollector;
    }
}

