/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.result;

import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.VectorSpace;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.ContexedSystemPlugin;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.plugin.system.TransceiverSettings;
import org.seamcat.model.plugin.system.optional.TransceiverConsistencyCheck;
import org.seamcat.model.plugin.system.optional.TransceiverConsistencyCheckImpl;
import org.seamcat.model.types.CorrelationSetting;
import org.seamcat.model.types.InterferenceLink;

public class ConsistencyCheckContextImpl
implements ConsistencyCheckContext {
    private Origin origin;
    private ContexedSystemPlugin plugin;
    private Distribution frequency;
    private InterferenceLink link;
    private Scenario scenario;
    private Object object;
    private TransceiverConsistencyCheck cc;

    private ConsistencyCheckContextImpl() {
    }

    public ConsistencyCheckContextImpl(ContexedSystemPlugin plugin, Distribution frequency) {
        this.origin = Origin.SYSTEM;
        this.frequency = frequency;
        this.plugin = plugin;
        this.assignCC();
    }

    public ConsistencyCheckContextImpl(InterferenceLink link) {
        this.origin = Origin.INTERFERENCE_LINK;
        this.plugin = link.getInterferer();
        this.frequency = link.getFrequency();
        this.link = link;
        this.assignCC();
    }

    private void assignCC() {
        this.cc = this.plugin.getSystemPlugin() instanceof TransceiverConsistencyCheck ? (TransceiverConsistencyCheck)((Object)this.plugin.getSystemPlugin()) : new TransceiverConsistencyCheckImpl();
    }

    public ConsistencyCheckContextImpl(Scenario scenario) {
        this.origin = Origin.EPP;
        this.scenario = scenario;
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public Distribution getFrequency() {
        return this.frequency;
    }

    @Override
    public RadioSystem getSystem() {
        return this.plugin.getSystem();
    }

    @Override
    public SystemPlugin getSystemPlugin() {
        return this.plugin.getSystemPlugin();
    }

    @Override
    public InterferenceLink getInterferenceLink() {
        return this.link;
    }

    @Override
    public Object getContextObject() {
        return this.object;
    }

    @Override
    public ConsistencyCheckContext setContextObject(Object context) {
        ConsistencyCheckContextImpl ctx = new ConsistencyCheckContextImpl();
        ctx.origin = this.origin;
        ctx.plugin = this.plugin;
        ctx.frequency = this.frequency;
        ctx.link = this.link;
        ctx.scenario = this.scenario;
        ctx.object = context;
        ctx.assignCC();
        return ctx;
    }

    @Override
    public Bounds getCoverage() {
        CorrelationSetting settings;
        switch (this.origin) {
            case EPP: {
                return Bounds.ZERO;
            }
            case SYSTEM: {
                return this.plugin.getSystemPlugin().getSystemCoverage();
            }
        }
        InterferenceLink link = this.getInterferenceLink();
        VectorSpace coLocationDelta = VectorSpace.ZERO;
        if (link.isCoLocated()) {
            link = link.getCorrelationSettings().getCoLocatedWith();
            settings = link.getCorrelationSettings();
            coLocationDelta = new VectorSpace(settings.getDeltaX().getBounds(), settings.getDeltaY().getBounds());
            coLocationDelta = coLocationDelta.negate();
        }
        settings = link.getCorrelationSettings();
        VectorSpace delta = new VectorSpace(settings.getDeltaX().getBounds(), settings.getDeltaY().getBounds());
        delta = delta.negate().add(coLocationDelta);
        VectorSpace victim = link.getVictim().getSystemPlugin().getInterferenceLinkSystemCoverage(true, this);
        VectorSpace interferer = link.getInterferer().getSystemPlugin().getInterferenceLinkSystemCoverage(false, this);
        VectorSpace sum = victim.add(interferer).add(delta);
        sum = sum.addCircle(settings.getCorrelationMode().getBounds(link));
        return sum.getCoverage();
    }

    @Override
    public TransceiverSettings getTxSettings() {
        return this.cc.getTxSettings(this);
    }

    @Override
    public TransceiverSettings getRxSettings() {
        return this.cc.getRxSettings(this);
    }

    @Override
    public Scenario getScenario() {
        return this.scenario;
    }
}

