/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.hybrid;

import java.util.List;
import org.seamcat.cdma.CDMASystem;
import org.seamcat.cdma.CDMAUplinkSystem;
import org.seamcat.dmasystems.AbstractDmaSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.ofdma.UplinkOfdmaSystem;
import org.seamcat.simulation.cellular.CDMADownLinkVictimSystemSimulation;
import org.seamcat.simulation.cellular.CDMAUpLinkVictimSystemSimulation;
import org.seamcat.simulation.cellular.CellularInterfererInterferenceLinkSimulation;
import org.seamcat.simulation.cellular.CellularVictimSystemSimulation;
import org.seamcat.simulation.cellular.OFDMADownLinkVictimSystemSimulation;
import org.seamcat.simulation.cellular.OFDMAUpLinkVictimSystemSimulation;

public class HybridCellularSimulation
implements SimulationInstance {
    private CellularVictimSystemSimulation vSim;
    private CellularInterfererInterferenceLinkSimulation iSim;
    private AbstractDmaSystem system;

    public HybridCellularSimulation(boolean victim, Scenario scenario, AbstractDmaSystem dmaSystem) {
        if (victim) {
            this.vSim = dmaSystem instanceof CDMASystem ? (dmaSystem instanceof CDMAUplinkSystem ? new CDMAUpLinkVictimSystemSimulation(scenario, dmaSystem) : new CDMADownLinkVictimSystemSimulation(scenario, dmaSystem)) : (dmaSystem instanceof UplinkOfdmaSystem ? new OFDMAUpLinkVictimSystemSimulation(scenario, dmaSystem) : new OFDMADownLinkVictimSystemSimulation(scenario, dmaSystem));
        } else {
            this.iSim = new CellularInterfererInterferenceLinkSimulation(dmaSystem);
        }
    }

    @Override
    public void postEvent(EventResult eventResult) {
        if (this.vSim instanceof CDMADownLinkVictimSystemSimulation) {
            this.adjustIRSS(eventResult);
        } else if (this.vSim instanceof OFDMADownLinkVictimSystemSimulation) {
            this.adjustIRSS(eventResult);
        }
    }

    private void adjustIRSS(EventResult eventResult) {
        VictimResultCollector vCollector = eventResult.getVictimResult();
        List<Victim> victims = this.getResultingVictims(vCollector);
        if (!victims.isEmpty()) {
            for (VectorDef def : vCollector.getVectorDefinitions()) {
                if (!def.name().startsWith("iRSS Unwanted") && !def.name().startsWith("iRSS Blocking")) continue;
                vCollector.add(def, Mathematics.linear2dB(Mathematics.dB2Linear(vCollector.get(def)) / (double)victims.size()));
            }
        }
    }

    public AbstractDmaSystem getSystem() {
        return this.system;
    }

    @Override
    public void victimSimulation(VictimResultCollector collector) {
        this.vSim.simulate(collector);
    }

    @Override
    public void interferingSystemSimulation(EventResult eventResult, InterferenceLink link, Point2D position) {
        this.iSim.simulate(eventResult.getInterferingSystemResult(link), link, position);
        this.system = this.iSim.getSystem();
    }

    @Override
    public void interferingSystemSimulation(EventResult eventResult, InterferenceLink link, Point2D position, LinkResult positionFromCoLocation) {
    }

    @Override
    public void interferedVictimSimulation(EventResult eventResult) {
        this.vSim.simulateWithInterference(eventResult, eventResult.getVictimResult(), eventResult.getAllInterferingSystemResults());
        this.system = this.vSim.getVictim();
    }

    public Point2D getSystemPosition() {
        return this.vSim.getSystemPosition();
    }

    @Override
    public List<Victim> getResultingVictims(VictimResultCollector vCollector) {
        return this.vSim.getResultingVictims(vCollector);
    }
}

