/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.generic.ice;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.types.result.FunctionResultType;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.presentation.LabeledPairLayout;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.display.FunctionPanel;
import org.seamcat.presentation.display.VectorPanel;
import org.seamcat.simulation.generic.GenericSystemPlugin;
import org.seamcat.simulation.generic.ice.Compatibility;
import org.seamcat.simulation.generic.ice.ICResult;
import org.seamcat.simulation.generic.ice.TranslationPanel;

public class ICResultDetailPanel
extends JPanel {
    private FunctionPanel functionPanel;

    public ICResultDetailPanel(Scenario scenario, ICResult result) {
        super(new BorderLayout());
        JSplitPane split = new JSplitPane(1);
        split.setDividerLocation(300);
        JPanel side = new JPanel(new LabeledPairLayout());
        this.add("Events", "" + scenario.numberOfEvents(), side);
        this.add("Compatibility", result.compatibility().toString(), side);
        this.add("Interference criterion", result.criteria().toString(), side);
        ArrayList<String> types = new ArrayList<String>();
        if (result.unwanted()) {
            types.add("unwanted");
        }
        if (result.blocking()) {
            types.add("blocking");
        }
        if (result.overloading()) {
            types.add("overloading");
        }
        if (result.intermodulation()) {
            types.add("intermodulation");
        }
        this.add("Signal type(s)", ((Object)types).toString(), side);
        if (result.compatibility() == Compatibility.Translation) {
            this.add("Translation", TranslationPanel.nameFromIndex(scenario, result.translation()), side);
            this.add("Min", "" + result.min(), side);
            this.add("Max", "" + result.max(), side);
            this.add("# points", "" + result.points(), side);
        }
        split.add(new BorderPanel(side, "Inputs"));
        GenericSystemPlugin plugin = (GenericSystemPlugin)scenario.getVictim().getSystemPlugin();
        if (result.compatibility() == Compatibility.Compatibility) {
            JPanel results = new JPanel(new LabeledPairLayout());
            this.add("Events (dRSS > sensitivity)", "" + Double.valueOf(result.drssLargerThanSensitivityResult()).intValue(), results);
            this.add("Sensitivity (dBm)", "" + plugin.getSensitivity(), results);
            this.add("Probability", "" + result.probabilityResult(), results);
            JSplitPane resSplit = new JSplitPane(0);
            resSplit.setDividerLocation(150);
            split.add(resSplit);
            resSplit.add(new BorderPanel(results, "Result"));
            VectorPanel vector = new VectorPanel(MainWindow.getInstance());
            VectorResultType type = result.compositeVector();
            double criteria = 0.0;
            switch (result.criteria()) {
                case CI: {
                    criteria = plugin.getProtectionRatio();
                    break;
                }
                case CNI: {
                    criteria = plugin.getExtendedProtectionRatio();
                    break;
                }
                case NIN: {
                    criteria = plugin.getNoiseAugmentation();
                    break;
                }
                case IN: {
                    criteria = plugin.getInterferenceToNoiseRatio();
                }
            }
            vector.show(type.getValue().asArray(), type.getName(), type.getUnit(), "Events", "interference criterion", criteria);
            resSplit.add(new BorderPanel(vector, "Criteria Vector"));
        } else {
            this.functionPanel = new FunctionPanel();
            UniqueValueDef def = Factory.results().function("Translation (probability function of translation parameters)", "", "Probability");
            this.functionPanel.setModel(Collections.singletonList(new FunctionResultType(def, result.translationResult())));
            split.add(this.functionPanel);
        }
        this.add((Component)split, "Center");
    }

    private void add(String label, String field, JPanel panel) {
        panel.add((Component)new JLabel(label + ":"), "label");
        panel.add((Component)new JLabel(field), "field");
    }
}

