/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.generic.ice;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPanel;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.genericgui.GenericPanel;
import org.seamcat.presentation.genericgui.item.BooleanItem;
import org.seamcat.presentation.genericgui.item.DoubleItem;
import org.seamcat.presentation.genericgui.item.SelectionItem;
import org.seamcat.simulation.generic.GenericSystemPlugin;
import org.seamcat.simulation.generic.ice.Compatibility;
import org.seamcat.simulation.generic.ice.Criteria;
import org.seamcat.simulation.generic.ice.ICResult;
import org.seamcat.simulation.generic.ice.ICTranslations;
import org.seamcat.simulation.generic.ice.TranslationPanel;
import org.seamcat.simulation.generic.ice.TypePanel;

public class ICInputPanel
extends JPanel {
    private TranslationPanel translations;
    private TypePanel types;
    private SelectionItem<Compatibility> compatibility;
    private SelectionItem<Criteria> criteria;
    private BooleanItem filterSensitivity;

    public ICInputPanel(Scenario scenario) {
        super(new GridLayout(1, 4));
        RadioSystem system = scenario.getVictim().getSystem();
        GenericSystemPlugin plugin = (GenericSystemPlugin)scenario.getVictim().getSystemPlugin();
        GenericPanel ciSettings = new GenericPanel();
        ciSettings.addItem(this.make("C / I", plugin.getProtectionRatio()));
        ciSettings.addItem(this.make("C / (N + I)", plugin.getExtendedProtectionRatio()));
        ciSettings.addItem(this.make("(N + I) / N", plugin.getNoiseAugmentation()));
        ciSettings.addItem(this.make("I / N", plugin.getInterferenceToNoiseRatio()));
        ciSettings.initializeWidgets();
        GenericPanel selections = new GenericPanel();
        List<Compatibility> list = Arrays.asList(Compatibility.values());
        this.compatibility = new SelectionItem<Compatibility>().values(list);
        selections.addItem(this.compatibility);
        this.compatibility.initialize();
        List<Criteria> values = Arrays.asList(Criteria.values());
        this.criteria = new SelectionItem<Criteria>().values(values);
        selections.addItem(this.criteria);
        this.criteria.initialize();
        this.filterSensitivity = new BooleanItem().label("Compute only events where C > receiver sensitivity");
        selections.addItem(this.filterSensitivity);
        this.filterSensitivity.initialize();
        this.filterSensitivity.setValue(true);
        selections.initializeWidgets();
        this.add(new BorderPanel(selections, "Mode & Criteria"));
        this.types = new TypePanel(system);
        this.add(new BorderPanel(this.types, "Signal type"));
        this.add(new BorderPanel(ciSettings, "Interference Criterion"));
        this.translations = new TranslationPanel(scenario);
        this.add(new BorderPanel(this.translations, "Translation parameters"));
        this.translations.setGlobalRelevance(false);
        this.compatibility.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ICInputPanel.this.translations.setGlobalRelevance(ICInputPanel.this.compatibility.getValue() == Compatibility.Translation);
                ICInputPanel.this.filterSensitivity.setRelevant(ICInputPanel.this.compatibility.getValue() == Compatibility.Compatibility);
            }
        });
    }

    private DoubleItem make(String name, double value) {
        DoubleItem item = new DoubleItem().label(name).unit("dB");
        item.initialize();
        item.setValue(value);
        item.setRelevant(false);
        return item;
    }

    public ICResult getInputsAsResult() {
        ICResult prototype = Factory.prototype(ICResult.class);
        Factory.when(prototype.compatibility()).thenReturn(this.compatibility.getValue());
        Factory.when(prototype.criteria()).thenReturn(this.criteria.getValue());
        ICTranslations model = this.translations.getModel();
        Factory.when(prototype.translation()).thenReturn(model.translation());
        Factory.when(prototype.min()).thenReturn(model.min());
        Factory.when(prototype.max()).thenReturn(model.max());
        Factory.when(prototype.points()).thenReturn(model.points());
        Factory.when(prototype.unwanted()).thenReturn(this.types.isUnwanted());
        Factory.when(prototype.blocking()).thenReturn(this.types.isBlocking());
        Factory.when(prototype.overloading()).thenReturn(this.types.isOverloading());
        Factory.when(prototype.intermodulation()).thenReturn(this.types.isIntermodulation());
        return Factory.build(prototype);
    }

    public boolean filterSensitivity() {
        return this.filterSensitivity.getValue();
    }
}

