/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.generic.ice;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.model.Scenario;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.simulation.generic.GenericSystemPlugin;
import org.seamcat.simulation.generic.Intermodulation;
import org.seamcat.simulation.generic.Overloading;
import org.seamcat.simulation.generic.ice.Criteria;

public class ICCompatibilityCalculator {
    private GenericSystemPlugin plugin;
    private int size;
    private boolean unw;
    private boolean blo;
    private boolean imod;
    private Criteria criteria;
    private double[] unwanted;
    private double[] blocking;
    private double[] drss;
    private double[] overloading;
    private double[] intermodulation;
    private boolean hasOverloading = false;
    private boolean hasIntermodulation = false;

    public ICCompatibilityCalculator(Scenario scenario, Results results) {
        this.plugin = (GenericSystemPlugin)scenario.getVictim().getSystemPlugin();
        this.size = scenario.numberOfEvents();
        List<VectorResultType> vectors = results.getVectorResultTypes();
        this.unwanted = vectors.get(0).getValue().asArray();
        this.blocking = vectors.get(1).getValue().asArray();
        this.drss = vectors.get(2).getValue().asArray();
        VectorResultType vector = results.findVector(Overloading.OVERL);
        if (vector != null) {
            this.hasOverloading = true;
            this.overloading = vector.getValue().asArray();
        }
        if ((vector = results.findVector(Intermodulation.INTERMOD_SUMMATION)) != null) {
            this.hasIntermodulation = true;
            this.intermodulation = vector.getValue().asArray();
        }
    }

    public double compatibility(Criteria criteria, boolean unw, boolean blo, boolean over, boolean imod) {
        this.criteria = criteria;
        this.unw = unw;
        this.blo = blo;
        this.imod = imod;
        double rSensVr = this.plugin.getSensitivity();
        double[] noiseFloor = new double[this.size];
        Distribution pNoiseFloor = this.plugin.getNoiseFloor();
        for (int i = 0; i < this.size; ++i) {
            noiseFloor[i] = pNoiseFloor.trial();
        }
        double rProbD = 0.0;
        int rProbN = 0;
        double[] iRSSVectorComposite = this.cfcCompositeIRSSVector();
        double[] critVector = this.cfcCritVector(iRSSVectorComposite, noiseFloor);
        for (int i = 0; i < this.size; ++i) {
            boolean bResultTest = true;
            double rdRSSTrial = this.drss[i];
            if (!(rdRSSTrial > rSensVr)) continue;
            rProbD += 1.0;
            if (over && this.overloading[i] >= 0.0) {
                bResultTest = false;
            }
            if (bResultTest && (unw || blo || imod)) {
                double rCrit = critVector[i];
                bResultTest = this.testProbComplete(rdRSSTrial, rCrit);
            }
            if (!bResultTest) continue;
            ++rProbN;
        }
        double probResult = rProbD == 0.0 ? 0.0 : 1.0 - (double)rProbN / rProbD;
        return probResult * 100.0;
    }

    public boolean hasOverloading() {
        return this.hasOverloading;
    }

    public boolean hasIntermodulation() {
        return this.hasIntermodulation;
    }

    private double[] cfcCompositeIRSSVector() {
        ArrayList<double[]> iRssVectors = new ArrayList<double[]>();
        double[] pResult = new double[this.size];
        if (this.unw) {
            iRssVectors.add(this.unwanted);
        }
        if (this.blo) {
            iRssVectors.add(this.blocking);
        }
        if (this.imod) {
            iRssVectors.add(this.intermodulation);
        }
        for (int j = 0; j < this.size; ++j) {
            double rSum = 0.0;
            for (double[] iRssVector : iRssVectors) {
                rSum += Mathematics.dB2Linear(iRssVector[j]);
            }
            pResult[j] = Mathematics.linear2dB(rSum);
        }
        return pResult;
    }

    private double[] cfcCritVector(double[] iRSSComp, double[] NoiseFloor) {
        double[] pResult = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            if (this.criteria == Criteria.CI) {
                pResult[i] = this.drss[i] - iRSSComp[i];
                continue;
            }
            if (this.criteria == Criteria.CNI) {
                pResult[i] = Mathematics.linear2dB(Mathematics.dB2Linear(this.drss[i]) / (Mathematics.dB2Linear(iRSSComp[i]) + Mathematics.dB2Linear(NoiseFloor[i])));
                continue;
            }
            if (this.criteria == Criteria.NIN) {
                double rC = Mathematics.dB2Linear(NoiseFloor[i]);
                pResult[i] = Mathematics.linear2dB((rC + Mathematics.dB2Linear(iRSSComp[i])) / rC);
                continue;
            }
            pResult[i] = iRSSComp[i] - NoiseFloor[i];
        }
        return pResult;
    }

    private boolean testProbComplete(double dRSS, double crit) {
        double rSens = this.plugin.getSensitivity();
        double rCI = this.plugin.getProtectionRatio();
        double rCNI = this.plugin.getExtendedProtectionRatio();
        double rINI = this.plugin.getNoiseAugmentation();
        double rIN = this.plugin.getInterferenceToNoiseRatio();
        switch (this.criteria) {
            case CI: {
                return crit > rCI && dRSS > rSens;
            }
            case CNI: {
                return crit > rCNI && dRSS > rSens;
            }
            case NIN: {
                return crit < rINI && dRSS > rSens;
            }
            case IN: {
                return crit < rIN && dRSS > rSens;
            }
        }
        return false;
    }
}

