/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.generic;

import org.seamcat.model.correlation.ActiveTransmitters;
import org.seamcat.model.correlation.UniformDensity;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.distributions.UniformPolarDistanceDistributionImpl;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.plugin.system.CorrelationMode;
import org.seamcat.model.types.CorrelationSetting;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.Results;
import org.seamcat.simulation.generic.GenericSystemPlugin;

public enum UniformMode implements CorrelationMode
{
    MODE{

        public String toString() {
            return "Uniform";
        }

        @Override
        public Point2D getCorrelationVector(InterferenceLink link, Results preSimulation) {
            CorrelationSetting settings = link.getCorrelationSettings();
            UniformDensity uniform = settings.getCorrelationConfiguration(UniformDensity.class);
            return this.itVrLocUniformCorrelated(uniform.protectionDistance(), uniform.pathAzimuth(), preSimulation.findDoubleValue(UniformDensity.SIMULATION_RADIUS));
        }

        @Override
        public Bounds getBounds(InterferenceLink link) {
            GenericSystemPlugin plugin = (GenericSystemPlugin)link.getInterferer().getSystemPlugin();
            double max = Math.sqrt((double)link.getCorrelationSettings().getCorrelationConfiguration(ActiveTransmitters.class).activeTx() / plugin.getTransmitterDensity().getDensityTx() / plugin.getTransmitterDensity().getProbabilityOfTransmission() / plugin.getTransmitterDensity().getHourOfDay() / Math.PI);
            UniformDensity uniform = link.getCorrelationSettings().getCorrelationConfiguration(UniformDensity.class);
            Distribution protectionDistance = uniform.protectionDistance();
            double min = 0.0;
            if (protectionDistance.getBounds().getMax() > 0.0) {
                min = Math.min(protectionDistance.getBounds().getMin(), min);
                max = Math.sqrt(max * max + protectionDistance.getBounds().getMax() * protectionDistance.getBounds().getMax());
            }
            return new Bounds(min, max, true);
        }

        private Point2D itVrLocUniformCorrelated(Distribution protectionDistance, Distribution pathAzimuth, double rRsimu) {
            double pDistance = protectionDistance.trial();
            double rItVrDistTrial = new UniformPolarDistanceDistributionImpl(1.0).trial();
            double rItVrAngleTrial = pathAzimuth.trial();
            double rResultItVrDistance = Math.sqrt((Math.pow(rRsimu, 2.0) - Math.pow(pDistance, 2.0)) * Math.pow(rItVrDistTrial, 2.0) + Math.pow(pDistance, 2.0));
            double value = rItVrAngleTrial * Math.PI / 180.0;
            return new Point2D(rResultItVrDistance * Math.cos(value), rResultItVrDistance * Math.sin(value));
        }

        @Override
        public String information() {
            return "<html>This mode uses the parameters specified in the \u201cTransmitter Density and Traffic\u201d<br>section of the Systems/Transmitter to Receiver Path tab\u201d<br><br>Note that changing mode will reset all correlation parameters</html>";
        }
    };

}

