/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.generic;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Function;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.Transmitter;
import org.seamcat.model.types.Unit;
import org.seamcat.simulation.generic.GenericSystemSimulation;
import org.seamcat.simulation.generic.IRSSOverloadingValue;

public class Overloading {
    private static Logger LOG = Logger.getLogger(Overloading.class);
    public static final VectorDef OVERL = Factory.results().value("Delta Overloading", Unit.dBm.name());
    private final RadioSystem victimSystem;
    private final Scenario scenario;

    public Overloading(Scenario scenario) {
        this.scenario = scenario;
        this.victimSystem = scenario.getVictim().getSystem();
    }

    public void collect(EventResult result) {
        LOG.debug("Overloading summation");
        double vrFreq = result.getVictimResult().getVictims().get(0).getLinkResult().getFrequency();
        Function oF = this.victimSystem.getReceiver().getOverloadingMask();
        ArrayList<Double> sumFreq = new ArrayList<Double>();
        ArrayList<Double> sumIRSSo = new ArrayList<Double>();
        int sumN = 0;
        for (InterferenceLink iLink : this.scenario.getInterferenceLinks()) {
            for (InterferenceLinkResult linkResult : result.getInterferenceLinkResult(iLink)) {
                IRSSOverloadingValue iRSSoValue = this.overloadingInterference(linkResult);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Summarizing iTx (freq=%f,iRSSo=%f)", iRSSoValue.getFrequency(), iRSSoValue.getiRSSo()));
                }
                boolean existingSum = false;
                for (int y = 0; y < sumN && !existingSum; ++y) {
                    if (((Double)sumFreq.get(y)).doubleValue() != iRSSoValue.getFrequency()) continue;
                    sumIRSSo.set(y, Mathematics.powerSummation((Double)sumIRSSo.get(y), iRSSoValue.getiRSSo()));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Adding to existing sum (freq=%f,sum(iRSSo)=%f)", iRSSoValue.getFrequency(), sumIRSSo.get(y)));
                    }
                    existingSum = true;
                }
                if (existingSum) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("New sum (sumN=%d, freq=%f,sum(iRSSo)=%f)", sumN, iRSSoValue.getFrequency(), iRSSoValue.getiRSSo()));
                }
                sumIRSSo.add(iRSSoValue.getiRSSo());
                sumFreq.add(iRSSoValue.getFrequency());
                ++sumN;
            }
        }
        LOG.debug("Subtracting overload thresholds");
        LOG.debug("Selecting strongest overload");
        double rSumO = -9.99999999E8;
        for (int x = 0; x < sumN; ++x) {
            double dFreq = (Double)sumFreq.get(x) - vrFreq;
            double oth = oF.evaluate(dFreq);
            sumIRSSo.set(x, (Double)sumIRSSo.get(x) - oth);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("New sum (sumN=%d,freq=%f,dFreq=%f,oth=%f,delta_overload=%f)", x, sumFreq.get(x), dFreq, oth, sumIRSSo.get(x)));
            }
            rSumO = Math.max(rSumO, (Double)sumIRSSo.get(x));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("rSumO = %f", rSumO));
        }
        result.getVictimResult().add(OVERL, rSumO);
    }

    private IRSSOverloadingValue overloadingInterference(InterferenceLinkResult result) {
        double rItPower = result.getInterferingSystemLink().getTxPower();
        Transmitter it = result.getInterferenceLink().getInterferer().getSystem().getTransmitter();
        GenericSystemSimulation.pathAntGains(result, this.victimSystem.getReceiver(), it);
        double rItVrEffectivePathLoss = result.getEffectiveTxRxPathLoss();
        double rFreqIt = result.getInterferingSystemLink().getFrequency();
        double rFreqVr = result.getVictimSystemLink().getFrequency();
        double dFreq = rFreqIt - rFreqVr;
        double rFilter = this.victimSystem.getReceiver().getReceiverFilter().evaluate(dFreq);
        double riRSSValue = rItPower - rItVrEffectivePathLoss - rFilter;
        double rItPowerControlGain = 0.0;
        if (it.isUsingPowerControl()) {
            rItPowerControlGain = (Double)result.getInterferingSystemLink().getValue(SystemPlugin.TX_POWER_CONTROL_GAIN);
        }
        IRSSOverloadingValue overloading = new IRSSOverloadingValue(result.getFrequency(), riRSSValue += rItPowerControlGain);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Victim receiver overloading calculations");
            LOG.debug(String.format("Interfering Transmitter power = %f", rItPower));
            LOG.debug(String.format("Interfering Transmitter -> Victim Receiver Effective Path Loss (with MCL) = %f", rItVrEffectivePathLoss));
            LOG.debug(String.format("Interfering Transmitter frequency %f", result.getInterferingSystemLink().getFrequency()));
            LOG.debug(String.format("Delta frequency = %f", dFreq));
            LOG.debug(String.format("Victim Receiver Filtering = %f", rFilter));
            LOG.debug("IT power control gain = " + rItPowerControlGain);
        }
        return overloading;
    }
}

