/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.generic;

import java.util.List;
import org.apache.log4j.Logger;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.correlation.CorrelationModeCalculator;
import org.seamcat.model.engines.SingleEvent;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.DefaultInterfererImpl;
import org.seamcat.model.simulation.result.DefaultVictimImpl;
import org.seamcat.model.simulation.result.Direction;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.Interferer;
import org.seamcat.model.simulation.result.InterfererResultCollector;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.types.CorrelationSetting;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.Transmitter;
import org.seamcat.model.types.result.Results;
import org.seamcat.simulation.generic.CognitiveRadio;
import org.seamcat.simulation.generic.GenericCorrelationSettings;
import org.seamcat.simulation.generic.GenericSystemPlugin;
import org.seamcat.simulation.generic.RelativeLocation;

public class GenericSystemSimulation
implements SimulationInstance {
    private static Logger LOG = Logger.getLogger(GenericSystemSimulation.class);
    public static final String dBm = "dBm";
    private final RadioSystem system;
    private final GenericSystemPlugin plugin;
    private Scenario scenario;

    public GenericSystemSimulation(RadioSystem system, GenericSystemPlugin plugin, Scenario scenario) {
        this.system = system;
        this.scenario = scenario;
        this.plugin = plugin;
    }

    @Override
    public void victimSimulation(VictimResultCollector collector) {
        LOG.debug("Victim system is generic");
        double frequency = this.scenario.getVictim().getFrequency().trial();
        LinkResult result = Factory.results().linkResult(this.system, frequency);
        collector.add(new DefaultVictimImpl(this.system.getReceiver().getAntennaGain(), result));
        double drss = GenericSystemSimulation.dRSSLinkBudgetDef(result, this.system, this.plugin, collector);
        if (this.plugin.isUseUserDefinedDRSS()) {
            drss = this.plugin.getUserDefinedDRSS().trial();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Overriding calculated dRSS with value from user-defined distribution, trialed as = " + drss + " dBm");
            }
        }
        collector.add(GenericSystemPlugin.DRSS, drss);
        if (LOG.isDebugEnabled()) {
            LOG.debug("dRSSValue = " + drss);
        }
    }

    @Override
    public void interferingSystemSimulation(EventResult eventResult, InterferenceLink link, Point2D position) {
        LOG.debug("The Interferer is a generic system");
        InterfererResultCollector collector = eventResult.getInterferingSystemResult(link);
        CorrelationSetting settings = link.getCorrelationSettings();
        GenericCorrelationSettings gs = new GenericCorrelationSettings(settings);
        Point2D victimPosition = link.getVictim().getCorrelationDefinitions().getVictimPosition(eventResult.getVictimResult(), link.getCorrelationSettings().getPositionRelativeTo());
        int activeTx = gs.getNumberOfActiveTx();
        for (int i = 0; i < activeTx; ++i) {
            if (i > 0) {
                Point2D correlationVector = settings.getCorrelationMode().getCorrelationVector(link, eventResult.getInterferingSystemResult(link).getPreSimulationResults());
                Point2D deltaVector = settings.trialDelta();
                position = victimPosition.add(deltaVector).add(correlationVector);
                collector.add(SingleEvent.SYSTEM_CENTER, position);
            }
            double frequency = link.getFrequency().trial();
            if (link.getVictim().getSystemPlugin() instanceof GenericSystemPlugin && this.plugin.isInterfererCognitiveRadio()) {
                frequency = eventResult.getVictimResult().getVictims().get(0).getLinkResult().getFrequency();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Interfering Transmitter frequency = " + frequency);
            }
            LinkResult txRx = Factory.results().linkResult(this.system, frequency);
            if (gs.isILRCenter()) {
                txRx.txAntenna().setPosition(position);
                txRx.rxAntenna().setPosition(settings.trialDelta());
            } else {
                Point2D rx = GenericSystemSimulation.generateRelativeRxPosition((GenericSystemPlugin)link.getInterferer().getSystemPlugin(), collector.getPreSimulationResults());
                if (gs.isTarget("ILR")) {
                    position = position.subtract(rx);
                }
                txRx.txAntenna().setPosition(position);
                txRx.rxAntenna().setPosition(position.add(rx));
            }
            txRx.setTxRxAngle(Mathematics.calculateKartesianAngle(txRx.rxAntenna().getPosition(), txRx.txAntenna().getPosition()));
            txRx.setTxRxDistance(Mathematics.distance(txRx.txAntenna().getPosition(), txRx.rxAntenna().getPosition()));
            collector.add(GenericSystemSimulation.simulateInterferenceLink(link, txRx, this.plugin));
        }
    }

    @Override
    public void interferingSystemSimulation(EventResult eventResult, InterferenceLink link, Point2D position, LinkResult positionFromCoLocation) {
        InterfererResultCollector collector = eventResult.getInterferingSystemResult(link);
        double frequency = link.getFrequency().trial();
        if (link.getVictim().getSystemPlugin() instanceof GenericSystemPlugin && this.plugin.isInterfererCognitiveRadio()) {
            frequency = eventResult.getVictimResult().getVictims().get(0).getLinkResult().getFrequency();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Interfering Transmitter frequency = " + frequency);
        }
        positionFromCoLocation.setFrequency(frequency);
        positionFromCoLocation.assignLocalEnvironment(this.system.getReceiver().getLocalEnvironments(), Direction.To_RX);
        positionFromCoLocation.assignLocalEnvironment(this.system.getTransmitter().getLocalEnvironments(), Direction.To_TX);
        collector.add(GenericSystemSimulation.simulateInterferenceLink(link, positionFromCoLocation, this.plugin));
    }

    @Override
    public List<Victim> getResultingVictims(VictimResultCollector vCollector) {
        return vCollector.getVictims();
    }

    @Override
    public void interferedVictimSimulation(EventResult eventResult) {
        if (CognitiveRadio.isActive(this.scenario.getInterferenceLinks())) {
            new CognitiveRadio(this.scenario, this.system).cognitiveRadio(eventResult, eventResult.getVictimResult(), eventResult.getAllInterferingSystemResults());
        }
    }

    @Override
    public void postEvent(EventResult eventResult) {
    }

    public static double dRSSLinkBudgetDef(LinkResult result, RadioSystem system, GenericSystemPlugin plugin, Collector pre) {
        GenericSystemSimulation.wtTrial(result, system.getTransmitter(), plugin);
        GenericSystemSimulation.vrTrial(result, system, plugin);
        GenericSystemSimulation.calculateRelativeTxRxLocation(result, plugin, pre, "VLT -> VLR");
        GenericSystemSimulation.calculatePathAntAziElev(result, plugin, "Victim System Link");
        GenericSystemSimulation.pathAntGains(result, system.getReceiver(), system.getTransmitter());
        result.assignLocalEnvironment(system.getReceiver().getLocalEnvironments(), Direction.To_RX);
        result.assignLocalEnvironment(system.getTransmitter().getLocalEnvironments(), Direction.To_TX);
        PropagationModel propagationModel = system.getPropagationModel();
        result.setTxRxPathLoss(propagationModel.evaluate(result));
        double rWtPower = result.getTxPower();
        double rWtGain = result.txAntenna().getGain();
        double rVrGain = result.rxAntenna().getGain();
        double rPcmax = plugin.getPowerControlThreshold();
        double rSens = plugin.getSensitivity();
        double rPathLoss = result.getTxRxPathLoss();
        double rdRSSValue = rWtPower + rWtGain + rVrGain - rPathLoss;
        if (LOG.isDebugEnabled()) {
            LOG.debug("dRSS Value = " + rdRSSValue + " [(wtPower = " + rWtPower + ") + (wtGain = " + rWtGain + ") + (VrGain = " + rVrGain + ") - (pathloss = " + rPathLoss + ")]");
        }
        if (plugin.isUsingPowerControlThreshold() && rdRSSValue > rSens + rPcmax) {
            rdRSSValue = rSens + rPcmax;
            if (LOG.isDebugEnabled()) {
                LOG.debug("(getVictimLinkReceiver().getCheckPcMax()) && (rdRSSValue > (Sensitivity + Pcmax)) is true -> dRSS Value [" + rdRSSValue + "] = Sensitivity [" + rSens + "] + Pcmax [" + rPcmax + "]");
            }
        }
        return rdRSSValue;
    }

    private static Interferer simulateInterferenceLink(InterferenceLink link, LinkResult iLink, GenericSystemPlugin plugin) {
        RadioSystem system = link.getInterferer().getSystem();
        GenericSystemSimulation.itTrial(iLink, system.getTransmitter(), plugin);
        GenericSystemSimulation.irTrial(iLink, system.getReceiver());
        GenericSystemSimulation.calculatePathAntAziElev(iLink, plugin, "Interfering System Link");
        GenericSystemSimulation.pathAntGains(iLink, system.getReceiver(), system.getTransmitter());
        iLink.setTxRxPathLoss(system.getPropagationModel().evaluate(iLink));
        if (system.getTransmitter().isUsingPowerControl()) {
            LOG.debug("Using Power Control");
            GenericSystemSimulation.powerControlGain(iLink, plugin);
        }
        DefaultInterfererImpl interferer = new DefaultInterfererImpl(link.linkIndex(), system.getTransmitter().getAntennaGain(), iLink, link.getCorrelationSettings().getMinimumCouplingLoss().trial());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding external interferer to victim: " + interferer);
        }
        return interferer;
    }

    public static double calculateItVictimAzimuth(double linkAngle, double azimuthInput, double itVrLinkAngle, String string) {
        double txRxAzimuth = -linkAngle + azimuthInput + 180.0 + itVrLinkAngle;
        if (LOG.isDebugEnabled()) {
            LOG.debug(string + " Azimuth Result = " + txRxAzimuth + " = - LinkAngle (" + linkAngle + ") + azimuthInput (" + azimuthInput + ") + PI + itVrLinkAngle (" + itVrLinkAngle + ")");
        }
        return txRxAzimuth;
    }

    private static void wtTrial(LinkResult result, Transmitter transmitter, GenericSystemPlugin plugin) {
        double rResultAntHeight = transmitter.getHeight().trial();
        double rResultPower = plugin.getPower().trial();
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("WT power trial = %f", rResultPower));
            LOG.debug(String.format("WT Antenna height trial = %f", rResultAntHeight));
        }
        result.txAntenna().setHeight(rResultAntHeight);
        result.setTxPower(rResultPower);
    }

    private static void itTrial(LinkResult result, Transmitter transmitter, GenericSystemPlugin plugin) {
        result.txAntenna().setHeight(transmitter.getHeight().trial());
        result.setTxPower(plugin.getPower().trial());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Interfering Transmitter supplied power = " + result.getTxPower());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Interfering Transmitter frequency = " + result.getFrequency());
        }
    }

    private static void vrTrial(LinkResult result, RadioSystem system, GenericSystemPlugin plugin) {
        result.rxAntenna().setHeight(system.getReceiver().getHeight().trial());
        result.setValue(GenericSystemPlugin.RX_NOISE_FLOOR, plugin.getNoiseFloor().trial());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Trialed VR antenna height = " + result.rxAntenna().getHeight());
            LOG.debug("Trialed VR frequency = " + result.getFrequency());
            LOG.debug("Trialed VR noise floor = " + result.getValue(GenericSystemPlugin.RX_NOISE_FLOOR));
        }
    }

    private static void irTrial(LinkResult result, Receiver receiver) {
        result.rxAntenna().setHeight(receiver.getHeight().trial());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Interfering System Receiver antenna height = " + result.rxAntenna().getHeight());
        }
    }

    public static void calculateRelativeTxRxLocation(LinkResult result, GenericSystemPlugin plugin, Collector pre, String string) {
        Point2D rRx;
        RelativeLocation rl = plugin.getLocation();
        if (rl.useCorrelatedDistance()) {
            rRx = rl.getDeltaPosition();
            if (LOG.isDebugEnabled()) {
                LOG.debug(string + " path is correlated");
            }
        } else {
            double rTxRxDistTrial = rl.getPathDistanceFactor().trial();
            double rTxRxAngleTrial = rl.getPathAzimuth().trial();
            double rRmax = pre.getDouble(GenericSystemPlugin.COVERAGE_RADIUS);
            if (rl.usePolygon()) {
                double turnTrial = rl.turnCCW().trial();
                rRmax = CorrelationModeCalculator.shapeTransformer(turnTrial, rRmax, rl.shape(), rTxRxAngleTrial);
            }
            rRx = new Point2D(Mathematics.cosD(rTxRxAngleTrial), Mathematics.sinD(rTxRxAngleTrial)).scale(rRmax * rTxRxDistTrial).add(rl.getDeltaPosition());
            result.setValue(GenericSystemPlugin.PATH_DISTANCE_FACTOR, rTxRxDistTrial);
            result.setValue(GenericSystemPlugin.PATH_AZIMUTH, rTxRxAngleTrial);
            if (LOG.isDebugEnabled()) {
                LOG.debug(string + " path is NOT correlated (i.e. random)");
            }
        }
        double rTxRxAngle = Mathematics.calculateKartesianAngle(rRx);
        double rTxRxDistance = Mathematics.distance(rRx);
        result.setTxRxAngle(rTxRxAngle);
        result.rxAntenna().setPosition(rRx);
        result.setTxRxDistance(rTxRxDistance);
        if (LOG.isDebugEnabled()) {
            LOG.debug(string + " angle = " + rTxRxAngle);
            LOG.debug(string + " distance = " + rTxRxDistance);
            LOG.debug("raw/temporary position of Tx and Rx - these positions will change depending on the Interferer/victim path definition");
            LOG.debug(string + " Rx - temporary position: " + result.rxAntenna().getPosition());
            LOG.debug(string + " Tx - temporary position X: " + 0);
            LOG.debug(string + " Tx - temporary position Y: " + 0);
        }
    }

    public static Point2D generateRelativeRxPosition(GenericSystemPlugin sys, Results pre) {
        Point2D rRx;
        RelativeLocation rl = sys.getLocation();
        if (rl.useCorrelatedDistance()) {
            rRx = rl.getDeltaPosition();
        } else {
            double rTxRxDistTrial = rl.getPathDistanceFactor().trial();
            double rTxRxAngleTrial = rl.getPathAzimuth().trial();
            double rRmax = pre.findDoubleValue(GenericSystemPlugin.COVERAGE_RADIUS);
            if (rl.usePolygon()) {
                double turnTrial = rl.turnCCW().trial();
                rRmax = CorrelationModeCalculator.shapeTransformer(turnTrial, rRmax, rl.shape(), rTxRxAngleTrial);
            }
            rRx = new Point2D(Mathematics.cosD(rTxRxAngleTrial), Mathematics.sinD(rTxRxAngleTrial)).scale(rRmax * rTxRxDistTrial).add(rl.getDeltaPosition());
        }
        return rRx;
    }

    private static void calculatePathAntAziElev(LinkResult result, GenericSystemPlugin plugin, String string) {
        double rTxRxAziComp;
        double rTxRxAziResult;
        double rRxTxAziComp;
        double rRxTxAziResult;
        double rTxRxElevCompensation = 0.0;
        double rRxTxElevCompensation = 0.0;
        double txRxAziTrial = plugin.getTxPointing().getAzimuth().trial();
        double txRxElevTrial = plugin.getTxPointing().getElevation().trial();
        double rxTxAziTrial = plugin.getRxPointing().getAzimuth().trial();
        double rxTxElevTrial = plugin.getRxPointing().getElevation().trial();
        String stringText = string + " Rx -> Tx";
        double rxTxAngle = Mathematics.calculateKartesianAngle(result.txAntenna().getPosition(), result.rxAntenna().getPosition());
        if (plugin.getRxPointing().getAntennaPointingAzimuth()) {
            rRxTxAziResult = 0.0;
            rRxTxAziComp = rxTxAngle;
        } else {
            rRxTxAziResult = rxTxAngle - rxTxAziTrial;
            rRxTxAziComp = rxTxAziTrial;
        }
        double rRxTxTilt = rxTxElevTrial;
        double rRxTxElevResult = GenericSystemSimulation.calculateElevationWithTilt(result.txAntenna(), result.rxAntenna(), stringText);
        if (plugin.getRxPointing().getAntennaPointingElevation()) {
            rRxTxElevCompensation = rRxTxElevResult;
            rRxTxElevResult = 0.0;
        }
        stringText = string + " Tx -> Rx";
        double txRxAngle = Mathematics.calculateKartesianAngle(result.rxAntenna().getPosition(), result.txAntenna().getPosition());
        if (plugin.getTxPointing().getAntennaPointingAzimuth()) {
            rTxRxAziResult = 0.0;
            rTxRxAziComp = txRxAngle;
        } else {
            rTxRxAziResult = txRxAngle - txRxAziTrial;
            rTxRxAziComp = txRxAziTrial;
        }
        double rTxRxTilt = txRxElevTrial;
        double rTxRxElevResult = GenericSystemSimulation.calculateElevationWithTilt(result.rxAntenna(), result.txAntenna(), stringText);
        if (plugin.getTxPointing().getAntennaPointingElevation()) {
            rTxRxElevCompensation = rTxRxElevResult;
            rTxRxElevResult = 0.0;
        }
        rRxTxAziResult = Mathematics.convertAngleToConfineToHorizontalDefinedRange(rRxTxAziResult);
        rTxRxAziResult = Mathematics.convertAngleToConfineToHorizontalDefinedRange(rTxRxAziResult);
        GenericSystemSimulation.setDirectionResult(result.rxAntenna(), rRxTxAziResult, rRxTxAziComp, rRxTxElevResult, rRxTxTilt, rRxTxElevCompensation);
        GenericSystemSimulation.setDirectionResult(result.txAntenna(), rTxRxAziResult, rTxRxAziComp, rTxRxElevResult, rTxRxTilt, rTxRxElevCompensation);
    }

    public static double convertAngleToConfineToVerticalDefinedRange(double angle) {
        if (angle < -90.0) {
            return -(angle + 180.0);
        }
        if (angle > 90.0) {
            return -(angle - 180.0);
        }
        if (Double.isNaN(angle)) {
            return 0.0;
        }
        return angle;
    }

    public static double calculateElevationWithTilt(AntennaResult from, AntennaResult to, String string) {
        double elevation = -Mathematics.calculateElevation(from, to);
        if (LOG.isDebugEnabled()) {
            LOG.debug(string + " Elevation Result = " + elevation);
        }
        return elevation;
    }

    private static void setDirectionResult(AntennaResult res, double azimuth, double azimuthComp, double elevation, double tilt, double elevationComp) {
        res.setAzimuth(azimuth);
        res.setAzimuthCompensation(azimuthComp);
        res.setElevation(elevation);
        res.setTilt(tilt);
        res.setElevationCompensation(elevationComp);
    }

    static void pathAntGains(LinkResult result, Receiver receiver, Transmitter transmitter) {
        result.rxAntenna().setGain(receiver.getAntennaGain().evaluate(result, result.rxAntenna()));
        result.txAntenna().setGain(transmitter.getAntennaGain().evaluate(result, result.txAntenna()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Link Rx->Tx Azimuth = " + result.rxAntenna().getAzimuth());
            LOG.debug("Link Rx->Tx Elevation = " + result.rxAntenna().getElevation());
            LOG.debug("Link Tx->Rx Azimuth = " + result.txAntenna().getAzimuth());
            LOG.debug("Link Tx->Rx Elevation = " + result.txAntenna().getElevation());
            LOG.debug("Link Receiver peak gain = " + receiver.getAntennaGain().peakGain());
            LOG.debug("Link Receiver Antenna Gain = " + result.rxAntenna().getGain());
            LOG.debug("Link Transmitter peak gain = " + transmitter.getAntennaGain().peakGain());
            LOG.debug("Link Transmitter Antenna Gain = " + result.txAntenna().getGain());
        }
    }

    private static void powerControlGain(LinkResult result, GenericSystemPlugin plugin) {
        double rPowerSupplied = result.getTxPower();
        double rGainItWr = result.txAntenna().getGain();
        double rGainWrIt = result.rxAntenna().getGain();
        double rPathLossItWr = result.getTxRxPathLoss();
        double rStep = plugin.getPowerControlStepSize();
        double rPmin = plugin.getPowerControlMinThreshold();
        double rRange = plugin.getPowerControlDynamicRange();
        double rPinit = rPowerSupplied + rGainItWr - rPathLossItWr + rGainWrIt;
        double rResultPowerGain = rPinit > rPmin && rPinit < rPmin + rRange ? -rStep * Math.floor((rPinit - rPmin) / rStep) : (rPinit <= rPmin ? 0.0 : -rRange);
        if (LOG.isDebugEnabled()) {
            LOG.debug("IT Power control initial Wr received power = " + rPinit);
            LOG.debug("IT Power control calculated gain = " + rResultPowerGain);
        }
        result.setValue(SystemPlugin.TX_POWER_CONTROL_GAIN, rResultPowerGain);
    }
}

