/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.generic;

import org.seamcat.model.correlation.ActiveTransmitters;
import org.seamcat.model.correlation.Correlated;
import org.seamcat.model.correlation.ILRAtCenter;
import org.seamcat.model.correlation.NoneMode;
import org.seamcat.model.types.CorrelationSetting;
import org.seamcat.simulation.generic.UniformMode;

class GenericCorrelationSettings {
    protected static final String VLR = "VLR";
    protected static final String VLT = "VLT";
    protected static final String ILR = "ILR";
    protected static final String ILT = "ILT";
    private final CorrelationSetting setting;

    GenericCorrelationSettings(CorrelationSetting setting) {
        this.setting = setting;
    }

    boolean isILRCenter() {
        if (this.setting.getCorrelationMode() != Correlated.MODE) {
            return this.setting.getCorrelationConfiguration(ILRAtCenter.class).ilrAtTheCenter();
        }
        return false;
    }

    boolean isRelativeTo(String relativeTo) {
        return this.setting.getPositionRelativeTo().equals(relativeTo);
    }

    boolean isTarget(String target) {
        return this.setting.getCorrelationTarget().equals(target);
    }

    int getNumberOfActiveTx() {
        if (this.setting.getCorrelationMode() == NoneMode.MODE || this.setting.getCorrelationMode() == UniformMode.MODE) {
            return this.setting.getCorrelationConfiguration(ActiveTransmitters.class).activeTx();
        }
        return 1;
    }
}

