/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.generic;

import org.seamcat.model.correlation.Closest;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.distributions.RayleighDistributionImpl;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.plugin.system.CorrelationMode;
import org.seamcat.model.types.CorrelationSetting;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.Results;
import org.seamcat.simulation.generic.GenericSystemPlugin;
import org.seamcat.simulation.generic.TransmitterDensityAndTraffic;

public enum ClosestMode implements CorrelationMode
{
    MODE{

        public String toString() {
            return "Closest interferer";
        }

        @Override
        public Point2D getCorrelationVector(InterferenceLink link, Results preSimulation) {
            CorrelationSetting settings = link.getCorrelationSettings();
            GenericSystemPlugin system = (GenericSystemPlugin)link.getInterferer().getSystemPlugin();
            Closest closest = settings.getCorrelationConfiguration(Closest.class);
            return this.itVrLocClosest(closest, system.getTransmitterDensity());
        }

        @Override
        public Bounds getBounds(InterferenceLink link) {
            Closest closest = link.getCorrelationSettings().getCorrelationConfiguration(Closest.class);
            Distribution protectionDistance = closest.protectionDistance();
            GenericSystemPlugin plugin = (GenericSystemPlugin)link.getInterferer().getSystemPlugin();
            double max = Math.sqrt(1.0 / plugin.getTransmitterDensity().getDensityTx() / plugin.getTransmitterDensity().getProbabilityOfTransmission() / plugin.getTransmitterDensity().getHourOfDay() / Math.PI);
            double min = 0.0;
            if (protectionDistance.getBounds().getMax() > 0.0) {
                min = protectionDistance.getBounds().getMin();
                max += protectionDistance.getBounds().getMax();
            }
            return new Bounds(min, max, true);
        }

        @Override
        public String information() {
            return "<html>This mode uses the parameters specified in the \u201cTransmitter Density and Traffic\u201d<br>section of the Systems/Transmitter to Receiver Path tab\u201d.<br><br><font style='color: #FF0000; font-weight:bold; font-style: normal;'>The most appropriate relative positioning selection is reference component = ILT<br>and  Position relative to = VLR (for generic systems) or BS in reference cell (for cellular systems)</font><br><br>Note that changing mode will reset all correlation parameters</html>";
        }

        private Point2D itVrLocClosest(Closest closest, TransmitterDensityAndTraffic density) {
            double dens = GenericSystemPlugin.itDensityActive(density);
            double sDistanceStdDev = 1.0 / Math.sqrt(Math.PI * 2 * dens);
            RayleighDistributionImpl itVrDistance = new RayleighDistributionImpl(0.0, sDistanceStdDev);
            double protectionDistance = closest.protectionDistance().trial();
            double rItVictimDistTrial = 0.0;
            for (int i = 0; i < 10 && !((rItVictimDistTrial = itVrDistance.trial()) >= protectionDistance); ++i) {
                rItVictimDistTrial = protectionDistance;
            }
            double rItVrAngleTrial = closest.pathAzimuth().trial();
            return new Point2D(rItVictimDistTrial * Math.cos(rItVrAngleTrial * Math.PI / 180.0), rItVictimDistTrial * Math.sin(rItVrAngleTrial * Math.PI / 180.0));
        }
    };

}

