/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.cellular.ofdma;

import org.seamcat.model.functions.BitRateMapping;
import org.seamcat.model.functions.Function;
import org.seamcat.simulation.cellular.PathLossCorrelation;
import org.seamcat.simulation.cellular.ofdma.OFDMADownLink;
import org.seamcat.simulation.cellular.ofdma.OFDMAUpLink;

public class OFDMASettings {
    private OFDMADownLink downLink;
    private OFDMAUpLink uplink;
    private int maxSubCarriersPerBaseStation = 51;
    private int numberOfSubCarriersPerUser = 17;
    private double bandwidthOfResourceBlock = 180.0;
    private PathLossCorrelation pathLossCorrelation = PathLossCorrelation.defaultInstance;
    private BitRateMapping bitrateMapping;

    public OFDMASettings(BitRateMapping bitrateMapping) {
        this.bitrateMapping = bitrateMapping;
    }

    public int getMaxSubCarriersPerBaseStation() {
        return this.maxSubCarriersPerBaseStation;
    }

    public void setMaxSubCarriersPerBaseStation(int maxNumberOfSubCarriersPerBaseStation) {
        this.maxSubCarriersPerBaseStation = maxNumberOfSubCarriersPerBaseStation;
    }

    public int getNumberOfSubCarriersPerMobileStation() {
        return this.numberOfSubCarriersPerUser;
    }

    public void setNumberOfSubCarriersPerMobileStation(int numberOfSubCarriersPerMobileStation) {
        this.numberOfSubCarriersPerUser = numberOfSubCarriersPerMobileStation;
    }

    public double getBandwidthOfResourceBlock() {
        return this.bandwidthOfResourceBlock;
    }

    public void setBandwidthOfResourceBlock(double bandwidthOfResourceBlock) {
        this.bandwidthOfResourceBlock = bandwidthOfResourceBlock;
    }

    public Function getBitrateMapping() {
        return this.bitrateMapping.getFunction();
    }

    public PathLossCorrelation getPathLossCorrelation() {
        return this.pathLossCorrelation;
    }

    public void setPathLossCorrelation(PathLossCorrelation pathLossCorrelation) {
        this.pathLossCorrelation = pathLossCorrelation;
    }

    public OFDMAUpLink getUpLinkSettings() {
        return this.uplink;
    }

    public OFDMADownLink getDownLinkSettings() {
        return this.downLink;
    }

    public void setDownLinkSettings(OFDMADownLink downLink) {
        this.downLink = downLink;
    }

    public void setUpLinkSettings(OFDMAUpLink uplink) {
        this.uplink = uplink;
    }
}

