/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.cellular;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.dmasystems.AbstractDmaSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.distributions.GaussianDistribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.generic.PathLossCorrelationUI;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.Interferer;
import org.seamcat.model.simulation.result.InterfererResultCollector;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.ofdma.UplinkOfdmaBaseStation;
import org.seamcat.ofdma.UplinkOfdmaSystem;
import org.seamcat.simulation.cellular.CellularVictimSystemSimulation;
import org.seamcat.simulation.cellular.OFDMAUpLinkVictim;
import org.seamcat.simulation.result.VectorDefImpl;

public class OFDMAUpLinkVictimSystemSimulation
extends CellularVictimSystemSimulation {
    public OFDMAUpLinkVictimSystemSimulation(Scenario scenario, AbstractDmaSystem dmaSystem) {
        super(scenario, dmaSystem);
    }

    @Override
    public AbstractDmaSystem getVictim() {
        AbstractDmaSystem victim = (AbstractDmaSystem)victimSystem.get();
        if (victim == null) {
            victim = new UplinkOfdmaSystem(this.dmaSystem);
            victimSystem.set(victim);
        }
        return victim;
    }

    @Override
    public void simulate(VictimResultCollector collector) {
        super.simulate(collector);
        UplinkOfdmaSystem system = (UplinkOfdmaSystem)this.getVictim();
        collector.add(initialVictimOutage, system.getReferenceCellMeasurement());
        double _averageAchievedBitrate = system.calculateAverageAchievedBitrate();
        this.add(collector, avgAchievedBitRateSystem, "kbps", _averageAchievedBitrate);
        for (AbstractDmaBaseStation baseStation : system.getAllBaseStations()) {
            for (AbstractDmaLink abstractDmaLink : baseStation.getOldTypeActiveConnections()) {
                collector.add(new OFDMAUpLinkVictim((UplinkOfdmaBaseStation)baseStation, abstractDmaLink));
            }
        }
        LinkedHashMap<VectorDef, List<Double>> vectors = new LinkedHashMap<VectorDef, List<Double>>();
        List<AbstractDmaBaseStation> allBaseStations = system.getAllBaseStations();
        for (AbstractDmaBaseStation abstractDmaBaseStation : allBaseStations) {
            for (AbstractDmaLink link : abstractDmaBaseStation.getOldTypeActiveConnections()) {
                this.handle(vectors, false, link);
            }
        }
        for (AbstractDmaLink abstractDmaLink : system.getReferenceCell().getOldTypeActiveConnections()) {
            this.handle(vectors, true, abstractDmaLink);
        }
        for (Map.Entry entry : vectors.entrySet()) {
            collector.add((VectorDef)entry.getKey(), (List)entry.getValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Average achieved bit rate (initial): " + _averageAchievedBitrate + " kbps");
            LOG.debug("Initial Victim Capacity = " + system.getNumberOfActiveServedMobilesInReferenceCell() + " users in reference cell");
            LOG.debug("Initial Victim Outage = " + collector.get(initialVictimOutage) + "% in reference cell");
        }
    }

    @Override
    public void simulateWithInterference(EventResult eventResult, VictimResultCollector vCollector, List<InterfererResultCollector> iCollector) {
        UplinkOfdmaSystem system = (UplinkOfdmaSystem)victimSystem.get();
        for (InterfererResultCollector col : iCollector) {
            for (Interferer interferer : col.getInterferingElements()) {
                PathLossCorrelationUI ui = col.getLink().getCorrelationSettings().getCorrelationConfiguration(PathLossCorrelationUI.class);
                if (!ui.usePathLossCorrelation()) continue;
                GaussianDistribution var = Factory.distributionFactory().getGaussianDistribution(0.0, ui.pathLossVariance());
                double x = var.trial();
                double correlationExternalInterferer = ui.correlationFactor();
                double a_ext = Math.sqrt(Math.abs(correlationExternalInterferer));
                double b_ext = Math.sqrt(1.0 - Math.abs(correlationExternalInterferer));
                double y = var.trial();
                double pathloss = interferer.getLinkResult().getTxRxPathLoss();
                interferer.getLinkResult().setTxRxPathLoss(pathloss += a_ext * x + b_ext * y);
            }
        }
        double sinrSum = 0.0;
        double sinrRefCellSum = 0.0;
        int refCellCount = 0;
        int size = vCollector.getVictims().size();
        double refCellBitrate = 0.0;
        double totalBitrate = 0.0;
        for (Victim victim : vCollector.getVictims()) {
            OFDMAUpLinkVictim vi = (OFDMAUpLinkVictim)victim;
            double sinr = vi.calculateInterferedSINRWatt();
            double ach = vi.calculateAchievedBitrate(system, Mathematics.linear2dB(sinr));
            totalBitrate += ach;
            if (vi.isConnectedToReferenceCell()) {
                sinrRefCellSum += sinr;
                ++refCellCount;
                refCellBitrate += ach;
            }
            sinrSum += sinr;
        }
        double sinrAvg = size == 0 ? 0.0 : sinrSum / (double)size;
        this.add(vCollector, avgInterferedBitRateSystem, "kbps", totalBitrate / (double)system.getNumberOfBaseStations());
        vCollector.add((VectorDef)new VectorDefImpl(sinrVictimSystem, "dB", false), Mathematics.linear2dB(sinrAvg));
        double avg = refCellCount == 0 ? 0.0 : sinrRefCellSum / (double)refCellCount;
        vCollector.add((VectorDef)new VectorDefImpl(sinrRefCell, "dB", false), Mathematics.linear2dB(avg));
        this.add(vCollector, "Interfered Bitrate, ref. cell", "kbps", refCellBitrate);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Victim OFDMA interfered bit rate = " + refCellBitrate + " bit rate in reference cell");
            LOG.debug(system.toString());
        }
    }

    @Override
    public List<Victim> getResultingVictims(VictimResultCollector vCollector) {
        ArrayList<Victim> relevantVictims = new ArrayList<Victim>();
        for (Victim victim : vCollector.getVictims()) {
            if (!((OFDMAUpLinkVictim)victim).isConnectedToReferenceCell()) continue;
            relevantVictims.add(victim);
        }
        return relevantVictims;
    }
}

