/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.cellular;

import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.FunctionException;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.DefaultVictimImpl;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.ofdma.OfdmaUplink;
import org.seamcat.ofdma.UplinkOfdmaBaseStation;
import org.seamcat.ofdma.UplinkOfdmaMobile;
import org.seamcat.ofdma.UplinkOfdmaSystem;
import org.seamcat.simulation.cellular.ofdma.OFDMASettings;
import org.seamcat.simulation.result.LinkResultImpl;

public class OFDMAUpLinkVictim
extends DefaultVictimImpl<OFDMAUpLinkVictim> {
    private UplinkOfdmaBaseStation<UplinkOfdmaMobile> baseStation;
    private OfdmaUplink link;

    public OFDMAUpLinkVictim(UplinkOfdmaBaseStation<UplinkOfdmaMobile> baseStation, AbstractDmaLink link) {
        super(baseStation.getAntennaGain(), link.asLinkResult());
        this.baseStation = baseStation;
        baseStation.setVictim(this);
        this.link = (OfdmaUplink)link;
    }

    @Override
    public LinkResult getLinkResult() {
        LinkResultImpl result = (LinkResultImpl)super.getLinkResult();
        result.setFrequency(this.link.calculateFrequency());
        return result;
    }

    @Override
    public void adjustTotalInterference(double totalU, double totalB) {
        super.adjustTotalInterference(totalU, totalB);
        double u_dB = Mathematics.dB2Linear(this.baseStation.getExternalInterferenceUnwanted()) + Mathematics.dB2Linear(totalU);
        double b_dB = Mathematics.dB2Linear(this.baseStation.getExternalInterferenceBlocking()) + Mathematics.dB2Linear(totalB);
        this.baseStation.setExternalInterferenceUnwanted(Mathematics.linear2dB(u_dB));
        this.baseStation.setExternalInterferenceBlocking(Mathematics.linear2dB(b_dB));
    }

    public boolean isConnectedToReferenceCell() {
        AbstractDmaBaseStation cell = this.baseStation.getSystem().getReferenceCell();
        return this.baseStation == cell;
    }

    @Override
    public boolean isSameRx(OFDMAUpLinkVictim other) {
        return this.baseStation.getCellid() == other.baseStation.getCellid();
    }

    public double calculateInterferedSINRWatt() {
        double rPowerWatt = Mathematics.fromdBm2Watt(this.link.getUserTerminal().getServingLink().calculateCurrentReceivePower_dBm());
        double totalInterferenceWatt = this.link.getUserTerminal().getTotalInterference();
        double extIntWatt = Mathematics.fromdBm2Watt(this.getTotalInterferenceBlocking()) + Mathematics.fromdBm2Watt(this.getTotalInterferenceUnwanted());
        return rPowerWatt / (totalInterferenceWatt + extIntWatt);
    }

    public double calculateAchievedBitrate(UplinkOfdmaSystem system, double sinr) {
        double maxAch = this.getMaxAchievableBitRate(system, sinr);
        int requestedSubCarriers = system.getOFDMASettings().getNumberOfSubCarriersPerMobileStation();
        return (double)requestedSubCarriers * (maxAch / (double)system.getOFDMASettings().getMaxSubCarriersPerBaseStation());
    }

    protected double getMaxAchievableBitRate(UplinkOfdmaSystem system, double sinrAchieved) {
        OFDMASettings settings = system.getOFDMASettings();
        Function function = settings.getBitrateMapping();
        double value = 0.0;
        if (sinrAchieved < function.getBounds().getMin()) {
            value = function.evaluateMin();
        } else if (sinrAchieved > function.getBounds().getMax()) {
            value = function.evaluateMax();
        } else {
            try {
                value = function.evaluate(sinrAchieved);
            }
            catch (FunctionException ex) {
                throw new RuntimeException(ex);
            }
        }
        return settings.getBandwidthOfResourceBlock() * (double)settings.getNumberOfSubCarriersPerMobileStation() * value;
    }

    @Override
    public String getRxName() {
        return this.baseStation.getName();
    }

    @Override
    public String getTxName() {
        return this.link.getUserTerminal().getName();
    }
}

