/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.cellular;

import org.seamcat.function.Exp;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;

public class GridPositionCalculator {
    private static final Exp[][] locationTransformer = new Exp[19][];

    public static Point2D standard(int cellNo, Point2D p, double d) {
        return locationTransformer[cellNo][0].evaluate(p, d);
    }

    public static Point2D ppg2(int cellNo, Point2D p, double d) {
        return locationTransformer[cellNo][1].evaluate(p, d);
    }

    public static boolean isInside(Point2D p, Point2D[] hexagon) {
        for (int i = 0; i < hexagon.length; ++i) {
            int j = (i + 1) % hexagon.length;
            if (!(hexagon[i].getX() * (hexagon[j].getY() - p.getY()) + hexagon[j].getX() * (p.getY() - hexagon[i].getY()) + p.getX() * (hexagon[i].getY() - hexagon[j].getY()) < 0.0)) continue;
            return false;
        }
        return true;
    }

    public static void calculateHexagon(Point2D position, double cellRadius, Point2D[] hexagon) {
        for (int k = 0; k < hexagon.length; ++k) {
            hexagon[k] = position.add(Mathematics.cosD(k * 60) * cellRadius, Mathematics.sinD(k * 60) * cellRadius);
        }
    }

    static {
        GridPositionCalculator.locationTransformer[0] = new Exp[2];
        GridPositionCalculator.locationTransformer[1] = new Exp[2];
        GridPositionCalculator.locationTransformer[2] = new Exp[2];
        GridPositionCalculator.locationTransformer[3] = new Exp[2];
        GridPositionCalculator.locationTransformer[4] = new Exp[2];
        GridPositionCalculator.locationTransformer[5] = new Exp[2];
        GridPositionCalculator.locationTransformer[6] = new Exp[2];
        GridPositionCalculator.locationTransformer[7] = new Exp[2];
        GridPositionCalculator.locationTransformer[8] = new Exp[2];
        GridPositionCalculator.locationTransformer[9] = new Exp[2];
        GridPositionCalculator.locationTransformer[10] = new Exp[2];
        GridPositionCalculator.locationTransformer[11] = new Exp[2];
        GridPositionCalculator.locationTransformer[12] = new Exp[2];
        GridPositionCalculator.locationTransformer[13] = new Exp[2];
        GridPositionCalculator.locationTransformer[14] = new Exp[2];
        GridPositionCalculator.locationTransformer[15] = new Exp[2];
        GridPositionCalculator.locationTransformer[16] = new Exp[2];
        GridPositionCalculator.locationTransformer[17] = new Exp[2];
        GridPositionCalculator.locationTransformer[18] = new Exp[2];
        GridPositionCalculator.locationTransformer[0][0] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p;
            }
        };
        GridPositionCalculator.locationTransformer[1][0] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(-d, 0.0);
            }
        };
        GridPositionCalculator.locationTransformer[2][0] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(-d / 2.0, -d * (Mathematics.SQRT3 / 2.0));
            }
        };
        GridPositionCalculator.locationTransformer[3][0] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(d / 2.0, -d * (Mathematics.SQRT3 / 2.0));
            }
        };
        GridPositionCalculator.locationTransformer[4][0] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(d, 0.0);
            }
        };
        GridPositionCalculator.locationTransformer[5][0] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(d / 2.0, d * (Mathematics.SQRT3 / 2.0));
            }
        };
        GridPositionCalculator.locationTransformer[6][0] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(-d / 2.0, d * (Mathematics.SQRT3 / 2.0));
            }
        };
        GridPositionCalculator.locationTransformer[7][0] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(-2.0 * d, 0.0);
            }
        };
        GridPositionCalculator.locationTransformer[8][0] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(-3.0 * d / 2.0, -d * (Mathematics.SQRT3 / 2.0));
            }
        };
        GridPositionCalculator.locationTransformer[9][0] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(-d, -d * Mathematics.SQRT3);
            }
        };
        GridPositionCalculator.locationTransformer[10][0] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(0.0, -Mathematics.SQRT3 * d);
            }
        };
        GridPositionCalculator.locationTransformer[11][0] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(d, -d * Mathematics.SQRT3);
            }
        };
        GridPositionCalculator.locationTransformer[12][0] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(3.0 * d / 2.0, -Mathematics.SQRT3 / 2.0 * d);
            }
        };
        GridPositionCalculator.locationTransformer[13][0] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(2.0 * d, 0.0);
            }
        };
        GridPositionCalculator.locationTransformer[14][0] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(3.0 * d / 2.0, Mathematics.SQRT3 / 2.0 * d);
            }
        };
        GridPositionCalculator.locationTransformer[15][0] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(d, Mathematics.SQRT3 * d);
            }
        };
        GridPositionCalculator.locationTransformer[16][0] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(0.0, Mathematics.SQRT3 * d);
            }
        };
        GridPositionCalculator.locationTransformer[17][0] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(-d, Mathematics.SQRT3 * d);
            }
        };
        GridPositionCalculator.locationTransformer[18][0] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(-3.0 * d / 2.0, Mathematics.SQRT3 / 2.0 * d);
            }
        };
        GridPositionCalculator.locationTransformer[0][1] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p;
            }
        };
        GridPositionCalculator.locationTransformer[1][1] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(-1.5 * d / Mathematics.SQRT3, -d / 2.0);
            }
        };
        GridPositionCalculator.locationTransformer[2][1] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(0.0, -d);
            }
        };
        GridPositionCalculator.locationTransformer[3][1] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(1.5 * d / Mathematics.SQRT3, -d / 2.0);
            }
        };
        GridPositionCalculator.locationTransformer[4][1] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(1.5 * d / Mathematics.SQRT3, d / 2.0);
            }
        };
        GridPositionCalculator.locationTransformer[5][1] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(0.0, d);
            }
        };
        GridPositionCalculator.locationTransformer[6][1] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(-1.5 * d / Mathematics.SQRT3, d / 2.0);
            }
        };
        GridPositionCalculator.locationTransformer[7][1] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(-3.0 * d / Mathematics.SQRT3, 0.0);
            }
        };
        GridPositionCalculator.locationTransformer[8][1] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(-3.0 * d / Mathematics.SQRT3, -d);
            }
        };
        GridPositionCalculator.locationTransformer[9][1] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(-1.5 * d / Mathematics.SQRT3, -1.5 * d);
            }
        };
        GridPositionCalculator.locationTransformer[10][1] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(0.0, -2.0 * d);
            }
        };
        GridPositionCalculator.locationTransformer[11][1] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(1.5 * d / Mathematics.SQRT3, -1.5 * d);
            }
        };
        GridPositionCalculator.locationTransformer[12][1] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(3.0 * d / Mathematics.SQRT3, -d);
            }
        };
        GridPositionCalculator.locationTransformer[13][1] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(3.0 * d / Mathematics.SQRT3, 0.0);
            }
        };
        GridPositionCalculator.locationTransformer[14][1] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(3.0 * d / Mathematics.SQRT3, d);
            }
        };
        GridPositionCalculator.locationTransformer[15][1] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(1.5 * d / Mathematics.SQRT3, 1.5 * d);
            }
        };
        GridPositionCalculator.locationTransformer[16][1] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(0.0, 2.0 * d);
            }
        };
        GridPositionCalculator.locationTransformer[17][1] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(-1.5 * d / Mathematics.SQRT3, 1.5 * d);
            }
        };
        GridPositionCalculator.locationTransformer[18][1] = new Exp(){

            @Override
            public Point2D evaluate(Point2D p, double d) {
                return p.subtract(-3.0 * d / Mathematics.SQRT3, d);
            }
        };
    }
}

