/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.cellular;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.seamcat.cdma.CDMASystem;
import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.dmasystems.AbstractDmaMobile;
import org.seamcat.dmasystems.AbstractDmaSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterfererResultCollector;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.types.Unit;
import org.seamcat.ofdma.DownlinkOfdmaMobile;
import org.seamcat.ofdma.UplinkOfdmaMobile;
import org.seamcat.simulation.cellular.OFDMADownLinkVictimSystemSimulation;
import org.seamcat.simulation.result.VectorDefImpl;

public abstract class CellularVictimSystemSimulation {
    protected static Logger LOG = Logger.getLogger(CellularVictimSystemSimulation.class);
    protected AbstractDmaSystem dmaSystem;
    private Scenario scenario;
    protected static ThreadLocal<AbstractDmaSystem> victimSystem = new ThreadLocal();
    public static final String UNW = "iRSS Unwanted (external Interference)";
    public static final String BLO = "iRSS Blocking (external Interference)";
    public static String nonInterferedCapacity = "Non Interfered Capacity, ref cell";
    public static VectorDef interferedCapacity = Factory.results().value("Interfered Capacity (active users only), ref cell", Unit.users.name());
    public static VectorDef initialVictimOutage;
    public static String interferedCapacitySystem;
    public static String avgAchievedBitRateSystem;
    public static String avgInterferedBitRateSystem;
    static String sinrRefCell;
    static String sinrVictimSystem;
    public static VectorDef nonInterferedCapacityCombinedRefCell;
    public static String interferedCapacityCombinedRefCell;
    public static String initialCapacitySystem;
    static VectorDef nonInterferedCapacityCombinedSystem;
    static String interferedCapacityCombinedSystem;
    static String initialOutageSystem;
    static String interferedOutageSystemPercentage;
    public static String totalDroppedUsers;
    public static String simulatedUsers;
    static VectorDef capacityLossDroppedSystem;
    public static VectorDef capacityLossCombinedRefCell;
    public static VectorDef capacityLossCombinedSystem;
    static String capacityLossWorstCell;
    public static final String avgNetworkNoiseRiseInitialNoExt = "Average network noise rise, (initial - no Ext. interference)";
    public static final String avgNetworkNoiseRiseInitial = "Average network noise rise, (initial)";
    public static final String avgNetworkNoiseRise = "Average network rise, (resulting)";
    public static final VectorDef numberOfAffectedCells;
    public static final VectorDef droppedBeforeInterference;
    public static final VectorDef highestPCLoopCount;

    public CellularVictimSystemSimulation(Scenario scenario, AbstractDmaSystem dmaSystem) {
        this.scenario = scenario;
        this.dmaSystem = dmaSystem;
        if (dmaSystem instanceof CDMASystem) {
            initialVictimOutage = Factory.results().value("Initial Outage Percentage, ref cell", "%");
            interferedCapacitySystem = "Interfered Capacity (active users only), system";
        } else {
            initialVictimOutage = Factory.results().value("Non Interfered Bitrate, ref cell", Unit.kbps.name());
        }
    }

    protected Scenario getScenario() {
        return this.scenario;
    }

    protected void add(Collector collector, String name, String unit, double value) {
        collector.add((VectorDef)new VectorDefImpl(name, unit, false), value);
    }

    public abstract AbstractDmaSystem getVictim();

    public void simulate(VictimResultCollector collector) {
        victimSystem.remove();
        AbstractDmaSystem victim = this.getVictim();
        victim.initialize(collector.getPreSimulationResults(), collector);
        victim.resetSystem();
        victim.setLocation(Point2D.ORIGIN);
        victim.generateSystemCells();
        victim.setFrequency(collector.getPreSimulationResults().findDoubleValue(AbstractDmaSystem.TRIAL_FREQUENCY));
        long start = System.currentTimeMillis();
        victim.simulate();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Simulate a DMA System in " + (System.currentTimeMillis() - start) + " millis");
        }
    }

    public Point2D getSystemPosition() {
        return this.getVictim().getReferenceCell().getPosition();
    }

    public abstract List<Victim> getResultingVictims(VictimResultCollector var1);

    public abstract void simulateWithInterference(EventResult var1, VictimResultCollector var2, List<InterfererResultCollector> var3);

    protected void handle(Map<VectorDef, List<Double>> vectors, boolean refcell, AbstractDmaLink link) {
        AbstractDmaMobile ue = link.getUserTerminal();
        AbstractDmaBaseStation bs = link.getBaseStation();
        if (refcell) {
            this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.FREQUENCY).add(ue.getFrequency());
            this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.BIT_RATE_ACHIEVED).add(ue.getBitRateAchieved());
            this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.RECEIVED_POWER).add(ue.getReceivedPower());
            this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.SINR_ACHIEVED).add(ue.getSINRAchieved());
            this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.PATH_LOSS).add(link.getTxRxPathLoss());
            this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.EFFECTIVE_PATH_LOSS).add(link.getEffectivePathloss());
        } else {
            this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.FREQUENCY_ALL).add(ue.getFrequency());
            this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.BIT_RATE_ACHIEVED_ALL).add(ue.getBitRateAchieved());
            this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.RECEIVED_POWER_ALL).add(ue.getReceivedPower());
            this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.SINR_ACHIEVED_ALL).add(ue.getSINRAchieved());
            this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.PATH_LOSS_ALL).add(link.getTxRxPathLoss());
            this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.EFFECTIVE_PATH_LOSS_ALL).add(link.getEffectivePathloss());
        }
        if (ue instanceof DownlinkOfdmaMobile) {
            if (refcell) {
                this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.INTERFERENCE_POWER).add(((DownlinkOfdmaMobile)ue).getInterferencePower());
                this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.CURRENT_TRANSMIT_POWER).add(bs.getCurrentTransmitPower_dBm());
                this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.INTER_SYSTEM_INTERFERENCE).add(ue.getInterSystemInterference());
            } else {
                this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.INTERFERENCE_POWER_ALL).add(((DownlinkOfdmaMobile)ue).getInterferencePower());
                this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.CURRENT_TRANSMIT_POWER_ALL).add(bs.getCurrentTransmitPower_dBm());
                this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.INTER_SYSTEM_INTERFERENCE_ALL).add(ue.getInterSystemInterference());
            }
        } else if (ue instanceof UplinkOfdmaMobile) {
            if (refcell) {
                this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.CURRENT_TRANSMIT_POWER).add(ue.getCurrentTransmitPowerIndBm());
                this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.INTER_SYSTEM_INTERFERENCE).add(bs.getInterSystemInterference());
            } else {
                this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.CURRENT_TRANSMIT_POWER_ALL).add(ue.getCurrentTransmitPowerIndBm());
                this.ensure(vectors, OFDMADownLinkVictimSystemSimulation.INTER_SYSTEM_INTERFERENCE_ALL).add(bs.getInterSystemInterference());
            }
        }
    }

    private List<Double> ensure(Map<VectorDef, List<Double>> vectors, VectorDef def) {
        List<Double> values = vectors.get(def);
        if (values == null) {
            values = new ArrayList<Double>();
            vectors.put(def, values);
        }
        return values;
    }

    static {
        avgAchievedBitRateSystem = "Avg Non Interfered Bitrate, system";
        avgInterferedBitRateSystem = "Avg Interfered Bitrate, system";
        sinrRefCell = "SINR, Victim ref cell";
        sinrVictimSystem = "SINR, Victim system";
        nonInterferedCapacityCombinedRefCell = Factory.results().value("Non Interfered Capacity (active and inactive users), ref cell", Unit.users.name());
        interferedCapacityCombinedRefCell = "Interfered Capacity (active and inactive users), ref cell";
        initialCapacitySystem = "Non Interfered Capacity (combined), system";
        nonInterferedCapacityCombinedSystem = Factory.results().value("Non Interfered Capacity (active and inactive users), system", Unit.users.name());
        interferedCapacityCombinedSystem = "Interfered Capacity (active and inactive users), system";
        initialOutageSystem = "Initial Outage, system";
        interferedOutageSystemPercentage = "Interfered Outage, system";
        totalDroppedUsers = "Number of Dropped users, System";
        simulatedUsers = "Number of Simulated users, System";
        capacityLossDroppedSystem = Factory.results().value("Capacity Loss, system", Unit.users.name());
        capacityLossCombinedRefCell = Factory.results().value("Capacity Loss (active and inactive users), ref cell", "%");
        capacityLossCombinedSystem = Factory.results().value("Capacity Loss (active and inactive users), system", "%");
        capacityLossWorstCell = "Capacity Loss (active and inactive users), worst cell";
        numberOfAffectedCells = Factory.results().value("Number of Affected Cells", "#");
        droppedBeforeInterference = Factory.results().value("Dropped before interference", Unit.users.name());
        highestPCLoopCount = Factory.results().value("Highest PC loop count", "#");
    }
}

