/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.cellular;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.seamcat.cdma.CDMADownlinkSystem;
import org.seamcat.cdma.CDMASystem;
import org.seamcat.cdma.CDMAUplinkSystem;
import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.dmasystems.AbstractDmaMobile;
import org.seamcat.dmasystems.AbstractDmaSystem;
import org.seamcat.model.engines.InterferenceSimulationEngine;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.InterfererResultCollector;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.ofdma.DownlinkOfdmaSystem;
import org.seamcat.ofdma.OfdmaSystem;
import org.seamcat.ofdma.OfdmaUplink;
import org.seamcat.ofdma.UplinkOfdmaSystem;
import org.seamcat.simulation.result.InterfererImpl;

public class CellularInterfererInterferenceLinkSimulation {
    private static Logger LOG = Logger.getLogger(CellularInterfererInterferenceLinkSimulation.class);
    private static ThreadLocal<AbstractDmaSystem> system = new ThreadLocal();
    private AbstractDmaSystem original;

    private AbstractDmaSystem copy() {
        AbstractDmaSystem system = CellularInterfererInterferenceLinkSimulation.system.get();
        if (system == null) {
            system = this.original.isCdma() ? (this.original.isUplink() ? new CDMAUplinkSystem(this.original) : new CDMADownlinkSystem(this.original)) : (this.original.isUplink() ? new UplinkOfdmaSystem(this.original) : new DownlinkOfdmaSystem(this.original));
            CellularInterfererInterferenceLinkSimulation.system.set(system);
        }
        return system;
    }

    public CellularInterfererInterferenceLinkSimulation(AbstractDmaSystem system) {
        this.original = system;
    }

    public AbstractDmaSystem getSystem() {
        return system.get();
    }

    public void simulate(InterfererResultCollector collector, InterferenceLink link, Point2D position) {
        system.remove();
        AbstractDmaSystem dmasystem = this.copy();
        if (LOG.isDebugEnabled()) {
            if (dmasystem instanceof CDMASystem) {
                LOG.debug("The Interferer is a CDMA system");
            } else if (dmasystem instanceof OfdmaSystem) {
                LOG.debug("The Interferer is a OFDMA system");
            }
        }
        dmasystem.initialize(collector.getPreSimulationResults(), collector);
        dmasystem.resetSystem();
        dmasystem.setLocation(position);
        dmasystem.generateSystemCells();
        dmasystem.setFrequency(collector.getPreSimulationResults().findDoubleValue(AbstractDmaSystem.TRIAL_FREQUENCY));
        if (dmasystem.isOfdma()) {
            dmasystem.getPlugin().setMeasureInterferenceFromEntireCluster(true);
        }
        if (dmasystem.isOfdma() && dmasystem.isDownlink()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping simulation of OFDMA Downlink Interferer (" + link.getInterferer().getName() + ")");
            }
            DownlinkOfdmaSystem ofdma = (DownlinkOfdmaSystem)dmasystem;
            for (AbstractDmaBaseStation base : ofdma.getAllBaseStations()) {
                base.setSubCarriersInUse(ofdma.getOFDMASettings().getMaxSubCarriersPerBaseStation());
            }
        } else {
            long start = System.currentTimeMillis();
            dmasystem.simulate();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Balanced CDMA System in " + (System.currentTimeMillis() - start) + " millis");
            }
        }
        this.getInterferenceLinkVictimSimulation(dmasystem, link, collector);
    }

    private void getInterferenceLinkVictimSimulation(AbstractDmaSystem<?> dmasystem, InterferenceLink link, InterfererResultCollector collector) {
        boolean entireCluster = dmasystem.getPlugin().measureInterferenceFromEntireCluster();
        if (dmasystem.isUplink()) {
            if (dmasystem.isOfdma()) {
                UplinkOfdmaSystem system = (UplinkOfdmaSystem)dmasystem;
                List<AbstractDmaLink> users = system.getActiveConnections();
                for (AbstractDmaLink user : users) {
                    OfdmaUplink m = (OfdmaUplink)user;
                    LinkResult linkResult = m.asLinkResult();
                    InterfererImpl in = new InterfererImpl(link.linkIndex(), true, user.getBaseStation(), user.getUserTerminal(), Factory.results().linkResult(), Factory.antennaGainFactory().getPeakGainAntenna(linkResult.txAntenna().getGain()), link.getCorrelationSettings().getMinimumCouplingLoss().trial());
                    in.getLinkResult().txAntenna().setPosition(m.getUserTerminal().getPosition());
                    in.getLinkResult().txAntenna().setHeight(m.getUserTerminal().getAntennaHeight());
                    in.getLinkResult().txAntenna().setTilt(m.getUserTerminal().getAntennaTilt());
                    in.getLinkResult().setRxAntennaValues(linkResult.rxAntenna());
                    in.getLinkResult().setTxPower(m.getUserTerminal().getCurrentTransmitPowerIndBm());
                    in.getLinkResult().setFrequency(m.calculateFrequency());
                    collector.add(in);
                }
            } else {
                ArrayList<Object> list = new ArrayList<Object>();
                if (entireCluster) {
                    list.addAll(dmasystem.getActiveUsers());
                } else {
                    for (AbstractDmaLink abstractDmaLink : dmasystem.getReferenceCell().getOldTypeActiveConnections()) {
                        list.add(abstractDmaLink.getUserTerminal());
                    }
                }
                for (AbstractDmaMobile abstractDmaMobile : list) {
                    double txPower = Mathematics.fromWatt2dBm(abstractDmaMobile.getCurrentTransmitPower());
                    double txGain = abstractDmaMobile.getAntennaGain();
                    AbstractDmaBaseStation baseStation = abstractDmaMobile.getServingLink().getBaseStation();
                    InterfererImpl interferer = new InterfererImpl(link.linkIndex(), true, baseStation, abstractDmaMobile, Factory.results().linkResult(), Factory.antennaGainFactory().getPeakGainAntenna(txGain), link.getCorrelationSettings().getMinimumCouplingLoss().trial());
                    interferer.getLinkResult().txAntenna().setPosition(abstractDmaMobile.getPosition());
                    interferer.getLinkResult().txAntenna().setHeight(abstractDmaMobile.getAntennaHeight());
                    interferer.getLinkResult().txAntenna().setTilt(abstractDmaMobile.getAntennaTilt());
                    interferer.getLinkResult().rxAntenna().setPosition(baseStation.getPosition());
                    interferer.getLinkResult().rxAntenna().setHeight(baseStation.getAntennaHeight());
                    interferer.getLinkResult().rxAntenna().setTilt(baseStation.getAntennaTilt());
                    interferer.getLinkResult().setTxPower(txPower);
                    interferer.getLinkResult().setFrequency(dmasystem.getFrequency());
                    collector.add(interferer);
                }
            }
        } else {
            ArrayList<AbstractDmaBaseStation> itCells = new ArrayList<AbstractDmaBaseStation>();
            if (entireCluster) {
                itCells.addAll(dmasystem.getAllBaseStations());
            } else {
                itCells.add(dmasystem.getReferenceCell());
            }
            for (AbstractDmaBaseStation abstractDmaBaseStation : itCells) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Interferer Cell ID: " + abstractDmaBaseStation.getCellid() + ", Sector ID: " + abstractDmaBaseStation.getSectorId());
                }
                InterfererImpl interferer = new InterfererImpl(link.linkIndex(), false, abstractDmaBaseStation, null, Factory.results().linkResult(), abstractDmaBaseStation.getAntennaGain(), link.getCorrelationSettings().getMinimumCouplingLoss().trial());
                interferer.getLinkResult().txAntenna().setPosition(abstractDmaBaseStation.getPosition());
                interferer.getLinkResult().txAntenna().setTilt(abstractDmaBaseStation.getAntennaTilt());
                interferer.getLinkResult().txAntenna().setHeight(abstractDmaBaseStation.getAntennaHeight());
                interferer.getLinkResult().setTxPower(abstractDmaBaseStation.getCurrentTransmitPower_dBm());
                interferer.getLinkResult().setFrequency(dmasystem.getFrequency());
                interferer.getLinkResult().setValue(InterferenceSimulationEngine.RX_NOT_SIMULATED, "");
                collector.add(interferer);
            }
        }
    }
}

