/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.cellular;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seamcat.cdma.CDMAUplinkSystem;
import org.seamcat.cdma.CdmaBaseStation;
import org.seamcat.cdma.CdmaUserTerminal;
import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterfererResultCollector;
import org.seamcat.model.simulation.result.MultiValueDef;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.types.Unit;
import org.seamcat.model.types.result.BarChartValue;
import org.seamcat.simulation.cellular.CDMAUpLinkVictim;
import org.seamcat.simulation.cellular.CellularVictimSystemSimulation;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;
import org.seamcat.simulation.result.MultiPlotDefImpl;
import org.seamcat.simulation.result.VectorDefImpl;

public class CDMAUpLinkVictimSystemSimulation
extends CellularVictimSystemSimulation {
    public CDMAUpLinkVictimSystemSimulation(Scenario scenario, AbstractDmaSystem dmaSystem) {
        super(scenario, dmaSystem);
    }

    @Override
    public AbstractDmaSystem getVictim() {
        AbstractDmaSystem victim = (AbstractDmaSystem)victimSystem.get();
        if (victim == null) {
            victim = new CDMAUplinkSystem(this.dmaSystem);
            victimSystem.set(victim);
        }
        return victim;
    }

    @Override
    public void simulate(VictimResultCollector collector) {
        super.simulate(collector);
        CDMAUplinkSystem system = (CDMAUplinkSystem)this.getVictim();
        int numBS = system.getNumberOfCellSitesInPowerControlCluster();
        int numSector = system.cellsPerSite();
        system.setInitialVictimCapacityActiveAndInactiveUsersWorstCell(new double[numBS][numSector]);
        for (int j = 0; j < numBS; ++j) {
            for (int k = 0; k < numSector; ++k) {
                system.getInitialVictimCapacityActiveAndInactiveUsersWorstCell()[j][k] = system.getNumberOfServedMobilesInCell(j, k);
            }
        }
        collector.add(droppedBeforeInterference, (double)system.countDroppedUsers());
        this.add(collector, nonInterferedCapacity, Unit.users.name(), system.getNumberOfActiveServedMobilesInReferenceCell());
        this.add(collector, initialCapacitySystem, Unit.users.name(), system.getNumberOfActiveServedMobilesInSystem());
        collector.add(nonInterferedCapacityCombinedRefCell, (double)system.getNumberOfServedMobilesInReferenceCell());
        collector.add(nonInterferedCapacityCombinedSystem, (double)system.getNumberOfServedMobilesInSystem());
        collector.add((VectorDef)new VectorDefImpl(initialOutageSystem, "%", false), system.getSystemMeasurement());
        double referenceCellMeasurement = system.getReferenceCellMeasurement();
        collector.add(initialVictimOutage, referenceCellMeasurement);
        for (AbstractDmaBaseStation baseStation : system.getAllBaseStations()) {
            if (baseStation.getOldTypeActiveConnections().size() <= 0) continue;
            collector.add(new CDMAUpLinkVictim((CdmaBaseStation)baseStation));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initial Victim Capacity = " + system.getNumberOfActiveServedMobilesInReferenceCell() + " users in reference cell");
            LOG.debug("Initial Victim Bit rate = " + referenceCellMeasurement + " kbps in reference cell");
        }
    }

    @Override
    public void simulateWithInterference(EventResult eventResult, VictimResultCollector vCollector, List<InterfererResultCollector> iCollectors) {
        double worstCellCapacityLossPercentage;
        int n;
        CDMAUplinkSystem system = (CDMAUplinkSystem)this.getVictim();
        system.balanceInterferedSystem();
        system.getCollector().add((VectorDef)new VectorDefImpl("NEW VALUE: Dropped UEs", "#", false), (double)system.getDroppedUsers().size());
        HashMap<String, Integer> dropReasons = new HashMap<String, Integer>();
        for (CdmaUserTerminal cdmaUserTerminal : system.getDroppedUsers()) {
            if (!dropReasons.containsKey(cdmaUserTerminal.getDropReason())) {
                dropReasons.put(cdmaUserTerminal.getDropReason(), 1);
                continue;
            }
            dropReasons.put(cdmaUserTerminal.getDropReason(), (Integer)dropReasons.get(cdmaUserTerminal.getDropReason()) + 1);
        }
        MultiPlotDefImpl droppedReasons = new MultiPlotDefImpl("Dropped users", "Drop reason", "Users", false);
        for (Map.Entry entry : dropReasons.entrySet()) {
            system.getCollector().add((MultiValueDef)droppedReasons, new BarChartValue((String)entry.getKey(), ((Integer)entry.getValue()).intValue()));
        }
        int n2 = system.getNumberOfServedMobilesInWorstCell();
        int n3 = this.getVictim().getNumberOfCellSitesInPowerControlCluster();
        int numSector = this.getVictim().cellsPerSite();
        int worstCellID = 0;
        int triSectorWorstCellSelection = 0;
        for (int j = 0; j < n3; ++j) {
            for (int k = 0; k < numSector; ++k) {
                if (!system.getWorstCell(j, k)) continue;
                worstCellID = j;
                triSectorWorstCellSelection = k;
                system.resetWorstCell(j, k);
            }
        }
        double temp = system.getInitialVictimCapacityActiveAndInactiveUsersWorstCell()[worstCellID][triSectorWorstCellSelection];
        if (n2 == -1) {
            n = (int)temp;
        }
        if ((worstCellCapacityLossPercentage = HybridSystemPlugin.calculateLossAvgPercentagePerEvent(temp, n)) < 0.0) {
            worstCellCapacityLossPercentage = 0.0;
        }
        vCollector.add((VectorDef)new VectorDefImpl(capacityLossWorstCell, "%", false), worstCellCapacityLossPercentage);
        this.add(vCollector, "Interfered Outage, ref. cell", "%", system.getReferenceCellMeasurement());
        double systemCapacityLossPercentage = HybridSystemPlugin.calculateLossAvgPercentageSystemPerEvent(system.countDroppedUsers(), system.countTotalNumberOfUsers());
        vCollector.add(capacityLossDroppedSystem, systemCapacityLossPercentage);
        double SystemCapacityLossActiveAndInactivePercentage = HybridSystemPlugin.calculateLossAvgPercentagePerEvent(vCollector.get(nonInterferedCapacityCombinedSystem), system.getNumberOfServedMobilesInSystem());
        vCollector.add(capacityLossCombinedSystem, SystemCapacityLossActiveAndInactivePercentage);
        double referenceCellCapacityLossPercentage = HybridSystemPlugin.calculateLossAvgPercentagePerEvent(vCollector.get(nonInterferedCapacityCombinedRefCell), system.getNumberOfServedMobilesInReferenceCell());
        vCollector.add(capacityLossCombinedRefCell, referenceCellCapacityLossPercentage);
        vCollector.add(interferedCapacity, (double)system.getNumberOfActiveServedMobilesInReferenceCell());
        this.add(vCollector, totalDroppedUsers, "#", system.countDroppedUsers());
        this.add(vCollector, simulatedUsers, Unit.users.name(), system.countTotalNumberOfUsers());
        this.add(vCollector, interferedCapacitySystem, Unit.users.name(), system.getNumberOfActiveServedMobilesInSystem());
        vCollector.add((VectorDef)new VectorDefImpl(interferedCapacityCombinedSystem, Unit.users.name(), false), (double)system.getNumberOfServedMobilesInSystem());
        this.add(vCollector, interferedCapacityCombinedRefCell, Unit.users.name(), system.getNumberOfServedMobilesInReferenceCell());
        vCollector.add((VectorDef)new VectorDefImpl(interferedOutageSystemPercentage, "%", false), system.getSystemMeasurement());
    }

    @Override
    public List<Victim> getResultingVictims(VictimResultCollector vCollector) {
        for (Victim victim : vCollector.getVictims()) {
            if (!((CDMAUpLinkVictim)victim).isConnectedToReferenceCell()) continue;
            return Collections.singletonList(victim);
        }
        return Collections.emptyList();
    }
}

