/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.cellular;

import org.seamcat.cdma.CdmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.model.simulation.result.DefaultVictimImpl;

public class CDMAUpLinkVictim
extends DefaultVictimImpl<CDMAUpLinkVictim> {
    private final AbstractDmaLink activeLink;
    private CdmaBaseStation baseStation;

    public CDMAUpLinkVictim(CdmaBaseStation baseStation) {
        super(baseStation.getAntennaGain(), baseStation.getOldTypeActiveConnections().get(0).asLinkResult());
        this.baseStation = baseStation;
        baseStation.setVictim(this);
        this.activeLink = baseStation.getOldTypeActiveConnections().get(0);
    }

    @Override
    public void adjustTotalInterference(double totalU, double totalB) {
        this.baseStation.setExternalInterferenceUnwanted(totalU);
        this.baseStation.setExternalInterferenceBlocking(totalB);
    }

    public boolean isConnectedToReferenceCell() {
        return this.baseStation.getSystem().getReferenceCell() == this.baseStation;
    }

    @Override
    public boolean isSameRx(CDMAUpLinkVictim other) {
        return this.baseStation.getCellid() == other.baseStation.getCellid();
    }

    @Override
    public String getRxName() {
        return this.baseStation.getName();
    }

    @Override
    public String getTxName() {
        return "MS " + this.activeLink.getUserTerminal().getUserId();
    }
}

