/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.cellular;

import org.seamcat.cdma.CDMADownlinkSystem;
import org.seamcat.cdma.CdmaUserTerminal;
import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.simulation.result.DefaultVictimImpl;
import org.seamcat.simulation.result.LinkResultImpl;

public class CDMADownLinkVictim
extends DefaultVictimImpl<CDMADownLinkVictim> {
    private CdmaUserTerminal user;
    private int bsId;
    private AbstractDmaBaseStation bs;

    public CDMADownLinkVictim(CdmaUserTerminal user) {
        super(Factory.antennaGainFactory().getPeakGainAntenna(user.getAntennaGain()), user.getActiveList().get(0).asLinkResult());
        this.user = user;
        user.setVictim(this);
        LinkResultImpl linkResult = (LinkResultImpl)this.getLinkResult();
        this.bs = user.getActiveList().get(0).getBaseStation();
        linkResult.rxAntenna().setTilt(this.bs.getAntennaTilt());
        this.bsId = this.bs.getCellId();
    }

    @Override
    public void adjustTotalInterference(double totalU, double totalB) {
        this.user.setExternalInterferenceUnwanted(totalU);
        this.user.setExternalInterferenceBlocking(totalB);
        CDMADownlinkSystem system = (CDMADownlinkSystem)this.user.getSystem();
        this.user.calculateTotalInterference_dBm();
        this.user.calculateGeometry(system.getLinkLevelData().getInitialMinimumGeometry(), system.getLinkLevelData().getInitialMaximumGeometry());
        this.user.findLinkLevelDataPoint(system.getLinkLevelData());
        if (this.user.getLinkLevelData().getEcIor() > 0.0) {
            system.dropActiveUser(this.user, "Ec/Ior requirement to high");
        }
    }

    public CdmaUserTerminal getUser() {
        return this.user;
    }

    public boolean isConnectedToReferenceCell() {
        if (!this.user.isConnected()) {
            return false;
        }
        AbstractDmaBaseStation cell = this.user.getSystem().getReferenceCell();
        for (AbstractDmaLink link : this.user.getActiveList()) {
            if (link.getBaseStation() != cell) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSameTx(CDMADownLinkVictim other) {
        return other.bsId == this.bsId;
    }

    @Override
    public String getRxName() {
        return "MS " + this.user.getUserId();
    }

    @Override
    public String getTxName() {
        return this.bs.getName();
    }
}

