/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.scenario;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.model.InterferenceLinkElement;
import org.seamcat.model.Scenario;
import org.seamcat.model.Workspace;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.plugin.system.ContexedSystemPlugin;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.simulation.consistency.ConsistencyError;
import org.seamcat.model.systems.aggregate.AggregateSystemPlugin;
import org.seamcat.model.types.EventProcessing;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.workspace.CorrelationSettingsUI;
import org.seamcat.plugin.PropagationModelConfiguration;
import org.seamcat.scenario.ScenarioConsistencyCheck;
import org.seamcat.simulation.result.ContextImpl;
import org.seamcat.simulation.settings.InterferenceLinkImpl;

public class WorkspaceScenario
implements Scenario {
    private final ContexedSystemPlugin vicPlug;
    private int numberOfEvents;
    private List<InterferenceLink> interferenceLinks;
    private List<EventProcessing> eventProcessingList;
    private List<ConsistencyError> errors;

    public WorkspaceScenario(Workspace workspace) {
        int i;
        this.numberOfEvents = workspace.getSimulationControl().numberOfEvents();
        this.eventProcessingList = new ArrayList<EventProcessing>();
        this.eventProcessingList.addAll(workspace.getEventProcessingList());
        this.errors = new ArrayList<ConsistencyError>();
        ArrayList<AggregateSystemPlugin> aggregates = new ArrayList<AggregateSystemPlugin>();
        for (SystemPlugin plugin : workspace.getSystemPlugins()) {
            if (!(plugin instanceof AggregateSystemPlugin)) continue;
            aggregates.add((AggregateSystemPlugin)plugin);
        }
        ContextImpl context = new ContextImpl();
        SystemPlugin victimSystem = workspace.getVictimSystem();
        AggregateSystemPlugin aggregate = this.getAggregate(aggregates, victimSystem);
        this.vicPlug = new ContexedSystemPlugin(victimSystem, context, aggregate);
        if (aggregate != null) {
            aggregate.selectVictim(victimSystem);
        }
        this.vicPlug.setFrequency(workspace.getVictimFrequency());
        context.setSystemPlugin(this.vicPlug);
        List<InterferenceLink> links = workspace.getInterferenceLinks();
        links.clear();
        List<InterferenceLinkElement> interferenceLinkUIs = workspace.getInterferenceLinkUIs();
        for (i = 0; i < interferenceLinkUIs.size(); ++i) {
            InterferenceLinkElement interferenceLinkElement = interferenceLinkUIs.get(i);
            for (SystemPlugin iPlugin : workspace.getSystemPluginsRecursive()) {
                if (!iPlugin.getUI().id().equals(interferenceLinkElement.getInterferingSystemId())) continue;
                aggregate = this.getAggregate(aggregates, iPlugin);
                InterferenceLinkImpl link = new InterferenceLinkImpl(i, this.vicPlug, iPlugin, aggregate);
                if (aggregate != null) {
                    aggregate.setInterferenceLinkIndex(link);
                }
                link.setCorrelationSettings(ProxyHelper.copy(CorrelationSettingsUI.class, interferenceLinkElement.getSettings().path().correlationSettings()));
                link.setPropagationModel((PropagationModelConfiguration)interferenceLinkElement.getSettings().path().propagationModel());
                links.add(link);
            }
        }
        for (i = 0; i < interferenceLinkUIs.size(); ++i) {
            InterferenceLinkElement interferenceLinkElement = interferenceLinkUIs.get(i);
            if (!interferenceLinkElement.getSettings().path().correlationSettings().isCoLocated()) continue;
            int index = this.getIndexOfLink(interferenceLinkElement.getSettings().path().correlationSettings().coLocatedWith(), interferenceLinkUIs);
            InterferenceLink link = links.get(i);
            ((InterferenceLinkImpl)link).setCoLocation(links.get(index));
        }
        this.interferenceLinks = new ArrayList<InterferenceLink>(workspace.getInterferenceLinks());
        for (i = 0; i < this.interferenceLinks.size(); ++i) {
            InterferenceLink interferenceLink = this.interferenceLinks.get(i);
            interferenceLink.setFrequency(workspace.getInterferingLinkFrequency().get(i));
        }
        for (SystemPlugin systemPlugin : workspace.getSystemPluginsRecursive()) {
            if (systemPlugin instanceof AggregateSystemPlugin) continue;
            systemPlugin.prepareSimulation(this);
        }
        this.errors = ScenarioConsistencyCheck.checkScenario(this);
    }

    private AggregateSystemPlugin getAggregate(List<AggregateSystemPlugin> aggregates, SystemPlugin component) {
        for (AggregateSystemPlugin aggregate : aggregates) {
            List<SystemPlugin> components = aggregate.getComponents();
            if (!components.contains(component) || components.indexOf(component) != components.size() - 1) continue;
            return aggregate;
        }
        return null;
    }

    private int getIndexOfLink(String linkId, List<InterferenceLinkElement> links) {
        for (int i = 0; i < links.size(); ++i) {
            InterferenceLinkElement link = links.get(i);
            if (!link.getId().equals(linkId)) continue;
            return i;
        }
        throw new RuntimeException("Unable to locate link with id: " + linkId);
    }

    @Override
    public int numberOfEvents() {
        return this.numberOfEvents;
    }

    @Override
    public List<InterferenceLink> getInterferenceLinks() {
        return this.interferenceLinks;
    }

    @Override
    public ContexedSystemPlugin getVictim() {
        return this.vicPlug;
    }

    @Override
    public List<EventProcessing> getEventProcessingList() {
        return this.eventProcessingList;
    }

    @Override
    public List<ConsistencyError> getConsistencyErrors() {
        return this.errors;
    }
}

