/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.scenario;

import java.util.List;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.types.LocalEnvironment;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.presentation.WarningColors;

public class LocalEnvironmentsConsistencyCheck {
    public static void checkEnvironments(List<LocalEnvironment> rxEnvs, List<LocalEnvironment> txEnvs, Distribution frequency, PropagationModel pm, Validator validator) {
        for (LocalEnvironment rxEnv : rxEnvs) {
            if (rxEnv.getEnvironment() != LocalEnvironment.Environment.Outdoor || !rxEnv.isUsingClutter()) continue;
            LocalEnvironmentsConsistencyCheck.frequencyCheck(frequency, rxEnv, validator);
        }
        for (LocalEnvironment txEnv : txEnvs) {
            if (txEnv.getEnvironment() != LocalEnvironment.Environment.Outdoor || !txEnv.isUsingClutter()) continue;
            LocalEnvironmentsConsistencyCheck.frequencyCheck(frequency, txEnv, validator);
        }
    }

    private static void frequencyCheck(Distribution frequency, LocalEnvironment le, Validator validator) {
        Bounds fBounds = frequency.getBounds();
        if (le.getEnvironment() == LocalEnvironment.Environment.Outdoor) {
            if (le.isUsingClutter()) {
                if (le.getOutdoorModel() == LocalEnvironment.OutdoorClutterMode.SPECIFIC) {
                    if (fBounds.getMin() < 30.0 || fBounds.getMax() > 3000.0) {
                        validator.error("Outdoor clutter (Site specific) is valid for frequencies in the range [0.03, 3] GHz<p " + (Object)((Object)WarningColors.ABORT_WARNING) + ">This will cause a runtime exception aborting the simulation.</p>");
                    }
                } else if (le.getOutdoorModel() == LocalEnvironment.OutdoorClutterMode.GENERAL) {
                    if (fBounds.getMin() < 2000.0 || fBounds.getMax() > 67000.0) {
                        validator.error("Outdoor clutter (Site-general terrestrial) is valid for frequencies in the range [2, 67] GHz<p " + (Object)((Object)WarningColors.ABORT_WARNING) + ">This will cause a runtime exception aborting the simulation.</p>");
                    }
                } else if (le.getOutdoorModel() == LocalEnvironment.OutdoorClutterMode.EARTH_TO_SPACE && (fBounds.getMin() < 10000.0 || fBounds.getMax() > 100000.0)) {
                    validator.error("Outdoor clutter (Site-general Earth-to-space) is valid for frequencies in the range [10, 100] GHz<p " + (Object)((Object)WarningColors.ABORT_WARNING) + ">This will cause a runtime exception aborting the simulation.</p>");
                }
            }
        } else if (le.isUsingBEL() && (fBounds.getMin() < 80.0 || fBounds.getMax() > 100000.0)) {
            validator.error("Indoor (ITU-R P.2109): is valid for frequencies in the range [0.08, 100] GHz");
        }
    }
}

