/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.scenario;

import org.seamcat.model.Scenario;
import org.seamcat.model.plugin.system.ContexedSystemPlugin;
import org.seamcat.model.simulation.consistency.ValidationResult;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.plugin.ValidatorImpl;
import org.seamcat.presentation.WarningColors;
import org.seamcat.scenario.GeneralInterfererConsistencyCheck;
import org.seamcat.scenario.GeneralVictimConsistencyCheck;

public class GeneralSystemConsistencyCheck {
    public static ValidationResult check(boolean victim, Scenario scenario, ContexedSystemPlugin plugin, InterferenceLink link) {
        ValidatorImpl validator = new ValidatorImpl();
        try {
            plugin.simulationInstance();
        }
        catch (RuntimeException e) {
            String msg = e.getMessage() + "<p " + (Object)((Object)WarningColors.ABORT_WARNING) + ">This will cause a Runtime Exception aborting the simulation.</p>";
            validator.error(msg);
        }
        if (victim) {
            GeneralVictimConsistencyCheck.victim(scenario, plugin.getSystem(), validator);
        } else {
            GeneralInterfererConsistencyCheck.interferer(scenario, plugin.getFrequency(), plugin.getSystem(), link, validator, plugin.getSystemPlugin());
        }
        return validator.getResult();
    }
}

