/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.scenario;

import java.util.Locale;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.correlation.Closest;
import org.seamcat.model.correlation.None;
import org.seamcat.model.correlation.NoneMode;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.Function;
import org.seamcat.model.plugin.system.CorrelationMode;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.Transmitter;
import org.seamcat.presentation.WarningColors;
import org.seamcat.simulation.generic.ClosestMode;
import org.seamcat.simulation.generic.GenericSystemPlugin;
import org.seamcat.simulation.generic.TransmitterDensityAndTraffic;

public class GeneralInterfererConsistencyCheck {
    public static void interferer(Scenario scenario, Distribution frequency, RadioSystem is, InterferenceLink link, Validator validator, SystemPlugin plugin) {
        Bounds vslBounds = scenario.getVictim().getFrequency().getBounds();
        boolean bFreqVrBounded = vslBounds.isBounded();
        double rFreqVrMin = vslBounds.getMin();
        double rFreqVrMax = vslBounds.getMax();
        Receiver vlr = scenario.getVictim().getSystem().getReceiver();
        double overloadingMaskMin = 0.0;
        double overloadingMaskMax = 0.0;
        double receiverFilterMin = 0.0;
        double receiverFilterMax = 0.0;
        boolean bIntermodBounded = false;
        Function overloadingMask = null;
        Function receiverFilter = null;
        boolean isUsingOverloading = vlr.isUsingOverloading();
        if (isUsingOverloading) {
            overloadingMask = vlr.getOverloadingMask();
            overloadingMaskMin = overloadingMask.getBounds().getMin();
            overloadingMaskMax = overloadingMask.getBounds().getMax();
            receiverFilter = vlr.getReceiverFilter();
            receiverFilterMin = receiverFilter.getBounds().getMin();
            receiverFilterMax = receiverFilter.getBounds().getMax();
        }
        if (vlr.isIntermodulationRejectionOption()) {
            bIntermodBounded = vlr.getIntermodulationRejection().getBounds().isBounded();
        }
        Transmitter it = is.getTransmitter();
        Locale localeForFormat = Locale.forLanguageTag("us");
        CorrelationMode mode = null;
        if (link.getInterferer().getSystem() == is) {
            mode = link.getCorrelationSettings().getCorrelationMode();
            if (mode == NoneMode.MODE) {
                Distribution pathDistance = link.getCorrelationSettings().getCorrelationConfiguration(None.class).pathDistanceFactor();
                Distribution protectionDistance = link.getCorrelationSettings().getCorrelationConfiguration(None.class).protectionDistance();
                double rSimu = link.getCorrelationSettings().getCorrelationConfiguration(None.class).simulationRadius();
                if (rSimu * pathDistance.getBounds().getMax() <= protectionDistance.getBounds().getMax()) {
                    String msg = String.format(localeForFormat, "<br/>The trialled simulation radius of %2.1f km, resulting from the multiplication of the <em>Path distance factor %2.1f</em> and <em>Simulation radius of %2.1f km.</em> <br/>must be greater than the <em>Protection distance set to %2.1f km</em>.", pathDistance.getBounds().getMax() * rSimu, pathDistance.getBounds().getMax(), rSimu, protectionDistance.getBounds().getMax());
                    validator.error(msg);
                }
            } else if (mode == ClosestMode.MODE) {
                Closest config = link.getCorrelationSettings().getCorrelationConfiguration(Closest.class);
                Distribution protectionDistance = config.protectionDistance();
                SystemPlugin system = link.getInterferer().getSystemPlugin();
                if (system instanceof GenericSystemPlugin) {
                    TransmitterDensityAndTraffic density = ((GenericSystemPlugin)system).getTransmitterDensity();
                    double rActivity = density.getActivity().evaluate(density.getHourOfDay());
                    double dens = density.getDensityTx() * density.getProbabilityOfTransmission() * rActivity;
                    double sDistanceStdDev = 1.0 / Math.sqrt(Math.PI * 2 * dens);
                    if (protectionDistance.getBounds().getMax() > 3.0 * sDistanceStdDev) {
                        String msg = String.format(localeForFormat, "<br>Applying a <em>Protection distance of %2.1f km</em> might overrule the intended functionality of the Relative Positioning mode 'Closest' <br/>by simulating interference distances, even if not equal, but always very close to this protection distance. <br/>Note that the settings specified in <strong>\u201cTransmitter Density and Traffic\u201d</strong> are used to calculate the distances between the ILT and the VLR for the mode \u201cClosest\u201d. <br>According to the current settings, there is a probability of about 85 percent that the ILT will be positioned at distances less than %2.2f km from the VLR.", protectionDistance.getBounds().getMax(), 3.0 * sDistanceStdDev);
                        validator.error(msg);
                    }
                }
            }
        }
        if (plugin instanceof GenericSystemPlugin && (it.getBandwidth() / is.getReceiver().getBandwidth() > 1.4 || it.getBandwidth() / is.getReceiver().getBandwidth() < 0.7)) {
            String msg = "<HtMl><br/>The bandwidth of the emission mask [" + it.getBandwidth() + " MHz] does not comply with the Reception Bandwidth of the system receiver of " + is.getReceiver().getBandwidth() + " MHz.";
            String bandwidthWarning = "<HtMl><p " + (Object)((Object)WarningColors.MASK_WARNING) + ">These parameters are used for the averaging of the mask values and should be aligned to obtain correct results.</p>";
            msg = msg + bandwidthWarning;
            validator.error(msg);
        }
        double rUnwantedFloorMin = 0.0;
        double rUnwantedFloorMax = 0.0;
        boolean bFreqItBounded = false;
        boolean bUnwantedBounded = false;
        boolean bUnwantedFloorBounded = false;
        Bounds bounds = frequency.getBounds();
        double rFreqItMin = bounds.getMin();
        double rFreqItMax = bounds.getMax();
        bFreqItBounded = bounds.isBounded();
        bounds = it.getEmissionsMask().getEmissionMask().getBounds();
        double rUnwantedMin = bounds.getMin();
        double rUnwantedMax = bounds.getMax();
        bUnwantedBounded = bounds.isBounded();
        if (it.isUsingEmissionsFloor()) {
            bounds = it.getEmissionsFloor().getBounds();
            rUnwantedFloorMin = bounds.getMin();
            rUnwantedFloorMax = bounds.getMax();
            bUnwantedFloorBounded = bounds.isBounded();
        }
        String name = plugin.getUI().description().name();
        if (!bFreqItBounded) {
            validator.error("Unbounded frequency distribution in " + name);
        }
        double rBlockingMin = 0.0;
        double rBlockingMax = 0.0;
        boolean bBlockingBounded = false;
        double rIntermodMin = 0.0;
        double rIntermodMax = 0.0;
        double rBVr = vlr.getBandwidth();
        if (bFreqItBounded && bFreqVrBounded) {
            if (bBlockingBounded && (rFreqItMax - rFreqVrMin > rBlockingMax || rFreqItMin - rFreqVrMax < rBlockingMin)) {
                validator.error("Blocking response range (" + GeneralInterfererConsistencyCheck.fAndU(rBlockingMin) + ", " + GeneralInterfererConsistencyCheck.fAndU(rBlockingMax) + ")does not match interfering transmitter frequency range (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMin) + ", " + GeneralInterfererConsistencyCheck.fAndU(rFreqItMax) + " )<br>and victim receiver frequency range (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMin) + " , " + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMax) + " ) in interferer: " + name + "<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
            }
            if (bIntermodBounded) {
                // empty if block
            }
            if (bUnwantedBounded) {
                if (rUnwantedMax < rUnwantedMin) {
                    validator.error("Unwanted emissions range is not valid: [" + rUnwantedMin + " to " + rUnwantedMax + "]");
                } else if (rFreqVrMax - rFreqItMin + rBVr / 2.0 > rUnwantedMax || rFreqVrMin - rFreqItMax - rBVr / 2.0 < rUnwantedMin) {
                    validator.error("Unwanted emissions range (" + GeneralInterfererConsistencyCheck.fAndU(rUnwantedMin) + ", " + GeneralInterfererConsistencyCheck.fAndU(rUnwantedMax) + ") does not match interfering transmitter frequency range (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMin) + " , " + GeneralInterfererConsistencyCheck.fAndU(rFreqItMax) + " )<br>and victim receiver frequency range (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMin) + " , " + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMax) + " ) +/- receiver bandwidth (" + GeneralInterfererConsistencyCheck.fAndU(rBVr) + ") in interferer: " + name + "<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                }
            }
            if (it.isUsingEmissionsFloor() && bUnwantedFloorBounded && (rFreqVrMax - rFreqItMin + rBVr / 1000.0 / 2.0 > rUnwantedFloorMax || rFreqVrMin - rFreqItMax - rBVr / 1000.0 / 2.0 < rUnwantedFloorMin)) {
                validator.error("Unwanted emissions floor range (" + rUnwantedMin + ", " + rUnwantedMax + ") does not match interfering transmitter frequency range (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMin) + " , " + GeneralInterfererConsistencyCheck.fAndU(rFreqItMax) + " )<br>and victim receiver frequency range (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMin) + " , " + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMax) + " ) +/- receiver bandwidth (" + GeneralInterfererConsistencyCheck.fAndU(rBVr / 1000.0) + ") in interferer: " + name + "<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
            }
        }
        if (isUsingOverloading) {
            if (!overloadingMask.isConstant()) {
                if (rFreqVrMin == rFreqVrMax && rFreqItMax == rFreqItMin) {
                    if (rFreqVrMax - rFreqItMax == 0.0) {
                        if (overloadingMaskMax < rFreqItMax - rFreqVrMax) {
                            validator.error("Overloading Mask upper limit (" + GeneralInterfererConsistencyCheck.fAndU(overloadingMaskMax) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMax) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                        if (overloadingMaskMin > rFreqVrMax - rFreqItMin) {
                            validator.error("Overloading Mask lower limit (" + GeneralInterfererConsistencyCheck.fAndU(overloadingMaskMin) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMax) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                    }
                    if (rFreqVrMax - rFreqItMax < 0.0 && overloadingMaskMax < rFreqItMax - rFreqVrMax) {
                        validator.error("Overloading Mask upper limit (" + GeneralInterfererConsistencyCheck.fAndU(overloadingMaskMax) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMax) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                    if (rFreqVrMax - rFreqItMax > 0.0 && overloadingMaskMin > rFreqItMin - rFreqVrMax) {
                        validator.error("Overloading Mask lower limit (" + GeneralInterfererConsistencyCheck.fAndU(overloadingMaskMin) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMax) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                } else {
                    if (rFreqVrMin - rFreqItMin < 0.0 && rFreqVrMax - rFreqItMin < 0.0 && overloadingMaskMax < rFreqItMax - rFreqVrMin) {
                        validator.error("Overloading Mask upper limit (" + GeneralInterfererConsistencyCheck.fAndU(overloadingMaskMax) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMax) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                    if (rFreqVrMin - rFreqItMin < 0.0 && rFreqVrMax - rFreqItMin >= 0.0 && rFreqVrMax - rFreqItMax < 0.0) {
                        if (overloadingMaskMax < rFreqItMax - rFreqVrMin) {
                            validator.error("Overloading Mask upper limit (" + GeneralInterfererConsistencyCheck.fAndU(overloadingMaskMax) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMax) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                        if (overloadingMaskMin > rFreqItMin - rFreqVrMax) {
                            validator.error("Overloading Mask lower limit (" + GeneralInterfererConsistencyCheck.fAndU(overloadingMaskMin) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMin) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                    }
                    if (rFreqVrMin - rFreqItMin >= 0.0 && rFreqVrMax - rFreqItMax <= 0.0) {
                        if (overloadingMaskMax < rFreqItMax - rFreqVrMin) {
                            validator.error("Overloading Mask upper limit (" + GeneralInterfererConsistencyCheck.fAndU(overloadingMaskMax) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMax) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                        if (overloadingMaskMin > rFreqItMin - rFreqVrMax) {
                            validator.error("Overloading Mask lower limit (" + GeneralInterfererConsistencyCheck.fAndU(overloadingMaskMin) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMin) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                    }
                    if (rFreqVrMin - rFreqItMin > 0.0 && rFreqVrMin - rFreqItMax <= 0.0 && rFreqVrMax - rFreqItMax > 0.0) {
                        if (overloadingMaskMax < rFreqItMax - rFreqVrMin) {
                            validator.error("Overloading Mask upper limit (" + GeneralInterfererConsistencyCheck.fAndU(overloadingMaskMax) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMax) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                        if (overloadingMaskMin > rFreqItMin - rFreqVrMax) {
                            validator.error("Overloading Mask lower limit (" + GeneralInterfererConsistencyCheck.fAndU(overloadingMaskMin) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMin) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                    }
                    if (rFreqVrMin - rFreqItMax > 0.0 && rFreqVrMax - rFreqItMax > 0.0 && overloadingMaskMin > rFreqItMin - rFreqVrMax) {
                        validator.error("Overloading Mask lower limit (" + GeneralInterfererConsistencyCheck.fAndU(overloadingMaskMin) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMin) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                }
            }
            if (!receiverFilter.isConstant()) {
                if (rFreqVrMin == rFreqVrMax && rFreqItMax == rFreqItMin) {
                    if (rFreqVrMax - rFreqItMax == 0.0) {
                        if (receiverFilterMax < rFreqItMax - rFreqVrMax) {
                            validator.error("Overloading receiver filter mask upper limit (" + GeneralInterfererConsistencyCheck.fAndU(receiverFilterMax) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMax) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                        if (receiverFilterMin > rFreqVrMax - rFreqItMin) {
                            validator.error("Overloading receiver filter mask lower limit (" + GeneralInterfererConsistencyCheck.fAndU(receiverFilterMin) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMax) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                    }
                    if (rFreqVrMax - rFreqItMax < 0.0 && receiverFilterMax < rFreqItMax - rFreqVrMax) {
                        validator.error("Overloading receiver filter mask upper limit (" + GeneralInterfererConsistencyCheck.fAndU(receiverFilterMax) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMax) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                    if (rFreqVrMax - rFreqItMax > 0.0 && receiverFilterMin > rFreqItMin - rFreqVrMax) {
                        validator.error("Overloading receiver filter mask lower limit (" + GeneralInterfererConsistencyCheck.fAndU(receiverFilterMin) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMax) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                } else {
                    if (rFreqVrMin - rFreqItMin < 0.0 && rFreqVrMax - rFreqItMin < 0.0 && receiverFilterMax < rFreqItMax - rFreqVrMin) {
                        validator.error("Overloading receiver filter mask upper limit (" + GeneralInterfererConsistencyCheck.fAndU(receiverFilterMax) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMax) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                    if (rFreqVrMin - rFreqItMin < 0.0 && rFreqVrMax - rFreqItMin >= 0.0 && rFreqVrMax - rFreqItMax < 0.0) {
                        if (receiverFilterMax < rFreqItMax - rFreqVrMin) {
                            validator.error("Overloading receiver filter mask upper limit (" + GeneralInterfererConsistencyCheck.fAndU(receiverFilterMax) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMax) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                        if (receiverFilterMin > rFreqItMin - rFreqVrMax) {
                            validator.error("Overloading receiver filter mask lower limit (" + GeneralInterfererConsistencyCheck.fAndU(receiverFilterMin) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMin) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                    }
                    if (rFreqVrMin - rFreqItMin >= 0.0 && rFreqVrMax - rFreqItMax <= 0.0) {
                        if (receiverFilterMax < rFreqItMax - rFreqVrMin) {
                            validator.error("Overloading receiver filter mask upper limit (" + GeneralInterfererConsistencyCheck.fAndU(receiverFilterMax) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMax) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                        if (receiverFilterMin > rFreqItMin - rFreqVrMax) {
                            validator.error("Overloading receiver filter mask lower limit (" + GeneralInterfererConsistencyCheck.fAndU(receiverFilterMin) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMin) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                    }
                    if (rFreqVrMin - rFreqItMin > 0.0 && rFreqVrMin - rFreqItMax <= 0.0 && rFreqVrMax - rFreqItMax > 0.0) {
                        if (receiverFilterMax < rFreqItMax - rFreqVrMin) {
                            validator.error("Overloading receiver filter mask upper limit (" + GeneralInterfererConsistencyCheck.fAndU(receiverFilterMax) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMax) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                        if (receiverFilterMin > rFreqItMin - rFreqVrMax) {
                            validator.error("Overloading receiver filter mask lower limit (" + GeneralInterfererConsistencyCheck.fAndU(receiverFilterMin) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMin) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                    }
                    if (rFreqVrMin - rFreqItMax > 0.0 && rFreqVrMax - rFreqItMax > 0.0 && receiverFilterMin > rFreqItMin - rFreqVrMax) {
                        validator.error("Overloading receiver filter mask lower limit (" + GeneralInterfererConsistencyCheck.fAndU(receiverFilterMin) + ") does not match the interfering transmitter frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqItMin) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + GeneralInterfererConsistencyCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                }
            }
        }
    }

    private static String fAndU(double freq) {
        if (freq > 1.0 || freq < -1.0) {
            return freq + " MHz";
        }
        return 1000.0 * freq + " kHz";
    }
}

