/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.valuepreview;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.model.functions.Function;
import org.seamcat.presentation.components.DiscreteFunctionGraph;
import org.seamcat.presentation.components.DiscreteFunctionTableModelAdapter;
import org.seamcat.presentation.valuepreview.ValuePreviewable;

public class ValuePreviewableFunctionAdapter
implements ValuePreviewable {
    private Function function;
    private String xAxisName;
    private String yAxisName;

    public ValuePreviewableFunctionAdapter(Function function) {
        this.function = function;
    }

    public ValuePreviewableFunctionAdapter axisNames(String xAxisName, String yAxisName) {
        this.xAxisName = xAxisName;
        this.yAxisName = yAxisName;
        return this;
    }

    @Override
    public boolean isDrawable() {
        return !this.function.isConstant();
    }

    @Override
    public Dimension getDrawablePreviewPreferredSize() {
        return new Dimension(300, 300);
    }

    @Override
    public void drawValuePreview(Graphics2D g, Rectangle r) {
        if (!(this.function instanceof DiscreteFunction)) {
            throw new RuntimeException("Function not drawable: " + this.function.getClass().getName());
        }
        this.drawDiscreteFunction((DiscreteFunction)this.function, g, r);
    }

    private void drawDiscreteFunction(DiscreteFunction function, Graphics2D g, Rectangle r) {
        DiscreteFunctionTableModelAdapter dataset = new DiscreteFunctionTableModelAdapter();
        dataset.setDiscreteFunction(function);
        String actualXAxisName = this.xAxisName != null ? this.xAxisName : "X";
        String actualYAxisName = this.yAxisName != null ? this.yAxisName : "Y";
        new DiscreteFunctionGraph(dataset, actualXAxisName, actualYAxisName).drawGraphToGraphics(g, r);
    }

    @Override
    public String getValuePreviewText() {
        return DiscreteFunction.pretty(this.function);
    }
}

