/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.valuepreview;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.function.MaskFunctionImpl;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.presentation.components.DiscreteFunction2TableModelAdapter;
import org.seamcat.presentation.components.UnwantedEmissionGraph2;
import org.seamcat.presentation.model.VictimCharacteristics;
import org.seamcat.presentation.valuepreview.ValuePreviewable;

public class ValuePreviewableFunction2Adapter
implements ValuePreviewable {
    private MaskFunction function;
    private String xAxisName;
    private String yAxisName;
    VictimCharacteristics victimCharacteristics;

    public ValuePreviewableFunction2Adapter(MaskFunction function) {
        this.function = function;
    }

    public ValuePreviewableFunction2Adapter axisNames(String xAxisName, String yAxisName) {
        this.xAxisName = xAxisName;
        this.yAxisName = yAxisName;
        return this;
    }

    public void setVictimCharacteristics(VictimCharacteristics victimCharacteristics) {
        this.victimCharacteristics = victimCharacteristics;
    }

    @Override
    public boolean isDrawable() {
        return !this.function.isConstant();
    }

    @Override
    public Dimension getDrawablePreviewPreferredSize() {
        if (this.victimCharacteristics != null) {
            return new Dimension(350, 300);
        }
        return new Dimension(300, 300);
    }

    @Override
    public void drawValuePreview(Graphics2D g, Rectangle r) {
        if (!(this.function instanceof MaskFunctionImpl)) {
            throw new RuntimeException("Function not drawable: " + this.function.getClass().getName());
        }
        this.drawDiscreteFunction2((MaskFunctionImpl)this.function, g, r);
    }

    private void drawDiscreteFunction2(MaskFunctionImpl function, Graphics2D g, Rectangle r) {
        DiscreteFunction2TableModelAdapter dataset = new DiscreteFunction2TableModelAdapter();
        UnwantedEmissionGraph2 graph = new UnwantedEmissionGraph2(dataset);
        if (this.xAxisName != null && this.yAxisName != null) {
            graph.setLabels(this.xAxisName, this.yAxisName);
        }
        if (this.victimCharacteristics != null) {
            graph.setVictimCharacteristics(this.victimCharacteristics.getVictimBandwidth(), this.victimCharacteristics.getFrequencyOffset(), this.victimCharacteristics.isShowACLR());
        } else {
            graph.setVictimCharacteristics(-1.0, -1.0, false);
        }
        dataset.setDiscreteFunction2(function);
        graph.drawGraphToGraphics(g, r);
    }

    @Override
    public String getValuePreviewText() {
        return DiscreteFunction.pretty(this.function);
    }
}

