/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.generic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.generic.InterferenceCriteria;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.components.NavigateButtonPanel;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.genericgui.panelbuilder.ChangeListener;
import org.seamcat.presentation.genericgui.panelbuilder.GenericPanelEditor;
import org.seamcat.presentation.systems.generic.CriteriaChanged;
import org.seamcat.presentation.systems.generic.ICTable;
import org.seamcat.presentation.systems.generic.ICWSValuesTable;
import org.seamcat.presentation.systems.generic.InterferenceCriteriaCalculator;
import org.seamcat.presentation.systems.generic.WSConsistency;

public class InterferenceCriteriaDialog
extends EscapeDialog {
    private final ICTable exampleValuesTable;
    private static final DecimalFormat formatter = new DecimalFormat("0.0#");
    private final JTable values;
    private final GenericPanelEditor<WSConsistency> ws;

    public InterferenceCriteriaDialog(Distribution noiseFloor, double sensitivity, InterferenceCriteria criteria) {
        super(MainWindow.getInstance(), "Interference Criteria Calculator", true);
        WSConsistency prototype = Factory.prototype(WSConsistency.class);
        Factory.when(prototype.noiseFloor()).thenReturn(noiseFloor.trial());
        Factory.when(prototype.sensitivity()).thenReturn(sensitivity);
        this.ws = new GenericPanelEditor<WSConsistency>(MainWindow.getInstance(), WSConsistency.class, Factory.build(prototype));
        this.getContentPane().setLayout(new BorderLayout());
        this.ws.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 30));
        this.getContentPane().add(this.ws, "North");
        JPanel tables = new JPanel(new BorderLayout());
        final ICWSValuesTable dm = new ICWSValuesTable(criteria, new CriteriaChanged(){

            @Override
            public void changed(InterferenceCriteria criteria) {
                InterferenceCriteriaDialog.this.setValues((WSConsistency)InterferenceCriteriaDialog.this.ws.getModel(), criteria);
            }
        });
        this.ws.addChangeListener(new ChangeListener<WSConsistency>(){

            @Override
            public void handle(WSConsistency model, List<AbstractItem> items, AbstractItem changedItem) {
                if (model.wsConsistency()) {
                    InterferenceCriteria icProto = Factory.prototype(InterferenceCriteria.class, dm.getModel());
                    Factory.when(icProto.extended_protection_ratio()).thenReturn(model.sensitivity() - model.noiseFloor());
                    InterferenceCriteria criteria = Factory.build(icProto);
                    InterferenceCriteriaDialog.this.setValues(model, criteria);
                    dm.setModel(criteria, true);
                    dm.fireTableDataChanged();
                } else {
                    InterferenceCriteriaDialog.this.setValues(model, dm.getModel());
                    dm.setModel(dm.getModel(), false);
                }
            }
        });
        JTable table = new JTable(dm);
        table.setCellSelectionEnabled(true);
        JScrollPane sp = new JScrollPane(table);
        sp.setPreferredSize(new Dimension(50, 50));
        sp.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 5));
        tables.add((Component)sp, "West");
        this.exampleValuesTable = new ICTable();
        this.values = new JTable(this.exampleValuesTable);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                if (value != null) {
                    value = formatter.format((Number)value);
                }
                return super.getTableCellRendererComponent(jTable, value, isSelected, hasFocus, row, col);
            }
        };
        this.values.getColumnModel().getColumn(0).setCellRenderer(renderer);
        this.values.getColumnModel().getColumn(1).setCellRenderer(renderer);
        this.values.getColumnModel().getColumn(2).setCellRenderer(renderer);
        this.values.getColumnModel().getColumn(3).setCellRenderer(renderer);
        this.values.getColumnModel().getColumn(4).setCellRenderer(renderer);
        this.values.setColumnSelectionAllowed(true);
        this.values.setRowSelectionAllowed(false);
        JScrollPane sp2 = new JScrollPane(this.values);
        sp.setPreferredSize(new Dimension(180, 50));
        sp2.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 30));
        tables.add((Component)sp2, "Center");
        this.setValues(this.ws.getModel(), criteria);
        this.getContentPane().add((Component)tables, "Center");
        this.getContentPane().add((Component)new NavigateButtonPanel(this, false){

            @Override
            public void btnOkActionPerformed() {
                if (!InterferenceCriteriaDialog.this.validateSelection()) {
                    DialogHelper.illegalCriteriaSelection();
                    return;
                }
                super.btnOkActionPerformed();
            }
        }, "South");
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.setSize(800, 400);
    }

    public WSConsistency getWSConsistency() {
        return this.ws.getModel();
    }

    private boolean validateSelection() {
        Double[][] calculatedValues = this.exampleValuesTable.getCalculatedValues();
        int selectedColumn = this.values.getSelectedColumn();
        return selectedColumn >= 0 && calculatedValues[0][selectedColumn] != null;
    }

    public InterferenceCriteria getSelectedCriteria() {
        Double[][] calculatedValues = this.exampleValuesTable.getCalculatedValues();
        int selectedColumn = this.values.getSelectedColumn();
        InterferenceCriteria prototype = Factory.prototype(InterferenceCriteria.class);
        Factory.when(prototype.protection_ratio()).thenReturn(calculatedValues[0][selectedColumn]);
        Factory.when(prototype.extended_protection_ratio()).thenReturn(calculatedValues[1][selectedColumn]);
        Factory.when(prototype.noise_augmentation()).thenReturn(calculatedValues[2][selectedColumn]);
        Factory.when(prototype.interference_to_noise_ratio()).thenReturn(calculatedValues[3][selectedColumn]);
        return Factory.build(prototype);
    }

    private void setValues(WSConsistency model, InterferenceCriteria criteria) {
        double target = model.sensitivity() - model.noiseFloor();
        this.exampleValuesTable.setCalculatedValues(InterferenceCriteriaCalculator.calculate(model.wsConsistency(), target, criteria));
        this.exampleValuesTable.fireTableDataChanged();
        this.alignSelection();
    }

    private void alignSelection() {
        int selectedColumn = this.values.getSelectedColumn();
        if (selectedColumn < 0) {
            selectedColumn = 0;
        }
        if (this.exampleValuesTable.getCalculatedValues()[0][selectedColumn] == null) {
            selectedColumn = 0;
        }
        this.values.setColumnSelectionInterval(selectedColumn, selectedColumn);
    }
}

