/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.generic;

import org.seamcat.model.generic.InterferenceCriteria;
import org.seamcat.model.mathematics.Mathematics;

public class InterferenceCriteriaCalculator {
    public static Double[][] calculate(double c_i, double c_n_i, double n_i_n, double i_n) {
        double i_n_value;
        double factor;
        Double[] c_i_results = new Double[5];
        Double[] c_n_i_results = new Double[5];
        Double[] n_i_n_results = new Double[5];
        Double[] i_n_results = new Double[5];
        if (c_i > c_n_i) {
            factor = 0.1 * (c_i - c_n_i);
            c_i_results[0] = c_i;
            c_n_i_results[0] = c_n_i;
            n_i_n_results[0] = InterferenceCriteriaCalculator.twoDecimals(Mathematics.linear2dB(1.0 + 1.0 / (Math.pow(10.0, factor) - 1.0)));
            i_n_results[0] = InterferenceCriteriaCalculator.twoDecimals(-Mathematics.linear2dB(Math.pow(10.0, factor) - 1.0));
        }
        factor = 0.1 * i_n;
        c_i_results[1] = c_i;
        i_n_results[1] = i_n;
        c_n_i_results[1] = InterferenceCriteriaCalculator.twoDecimals(c_i + Mathematics.linear2dB(1.0 / (1.0 + Math.pow(10.0, -factor))));
        n_i_n_results[1] = InterferenceCriteriaCalculator.twoDecimals(Mathematics.linear2dB(1.0 + Math.pow(10.0, factor)));
        if (n_i_n > 0.0) {
            c_i_results[2] = c_i;
            n_i_n_results[2] = n_i_n;
            i_n_value = Mathematics.linear2dB(Math.pow(10.0, 0.1 * n_i_n) - 1.0);
            i_n_results[2] = InterferenceCriteriaCalculator.twoDecimals(i_n_value);
            c_n_i_results[2] = InterferenceCriteriaCalculator.twoDecimals(c_i + Mathematics.linear2dB(1.0 / (1.0 + Math.pow(10.0, -0.1 * i_n_value))));
        }
        factor = 0.1 * i_n;
        c_n_i_results[3] = c_n_i;
        i_n_results[3] = i_n;
        c_i_results[3] = InterferenceCriteriaCalculator.twoDecimals(c_n_i - Mathematics.linear2dB(1.0 / (1.0 + Math.pow(10.0, -factor))));
        n_i_n_results[3] = InterferenceCriteriaCalculator.twoDecimals(Mathematics.linear2dB(1.0 + Math.pow(10.0, factor)));
        c_n_i_results[4] = c_n_i;
        n_i_n_results[4] = n_i_n;
        i_n_value = Mathematics.linear2dB(Math.pow(10.0, 0.1 * n_i_n) - 1.0);
        i_n_results[4] = InterferenceCriteriaCalculator.twoDecimals(i_n_value);
        c_i_results[4] = InterferenceCriteriaCalculator.twoDecimals(c_n_i - Mathematics.linear2dB(1.0 / (1.0 + Math.pow(10.0, -0.1 * i_n_value))));
        Double[][] result = new Double[4][5];
        result[0] = c_i_results;
        result[1] = c_n_i_results;
        result[2] = n_i_n_results;
        result[3] = i_n_results;
        return result;
    }

    public static Double[][] calculate(boolean wsConsistent, double target, InterferenceCriteria criteria) {
        int i;
        Double[][] result = InterferenceCriteriaCalculator.calculate(criteria.protection_ratio(), criteria.extended_protection_ratio(), criteria.noise_augmentation(), criteria.interference_to_noise_ratio());
        Double[] saved = new Double[]{result[0][0], result[1][0], result[2][0], result[3][0]};
        if (wsConsistent) {
            for (i = 0; i < result[1].length; ++i) {
                Double c_n_i_result = result[1][i];
                if (InterferenceCriteriaCalculator.doubleEquals(c_n_i_result, target)) continue;
                InterferenceCriteriaCalculator.clear(result, i);
            }
        }
        InterferenceCriteriaCalculator.ifEqualsRemove(result, 0, 1);
        InterferenceCriteriaCalculator.ifEqualsRemove(result, 0, 2);
        InterferenceCriteriaCalculator.ifEqualsRemove(result, 0, 3);
        InterferenceCriteriaCalculator.ifEqualsRemove(result, 0, 4);
        InterferenceCriteriaCalculator.ifEqualsRemove(result, 1, 2);
        InterferenceCriteriaCalculator.ifEqualsRemove(result, 1, 3);
        InterferenceCriteriaCalculator.ifEqualsRemove(result, 1, 4);
        InterferenceCriteriaCalculator.ifEqualsRemove(result, 2, 3);
        InterferenceCriteriaCalculator.ifEqualsRemove(result, 2, 4);
        InterferenceCriteriaCalculator.ifEqualsRemove(result, 3, 4);
        for (i = 0; i < 5; ++i) {
            if (!InterferenceCriteriaCalculator.equals(result, criteria.protection_ratio(), criteria.extended_protection_ratio(), criteria.noise_augmentation(), criteria.interference_to_noise_ratio(), i)) continue;
            InterferenceCriteriaCalculator.clear(result, i);
        }
        for (i = 0; i < 5; ++i) {
            if (result[0][i] == null || InterferenceCriteriaCalculator.isConsistent(result[0][i], result[1][i], result[2][i], result[3][i])) continue;
            InterferenceCriteriaCalculator.clear(result, i);
        }
        if (InterferenceCriteriaCalculator.isEmpty(result)) {
            result[0][0] = saved[0];
            result[1][0] = saved[1];
            result[2][0] = saved[2];
            result[3][0] = saved[3];
        }
        return result;
    }

    private static boolean isEmpty(Double[][] result) {
        return result[0][0] == null && result[0][1] == null && result[0][2] == null && result[0][3] == null && result[0][4] == null;
    }

    public static boolean isConsistent(double c_i, double c_n_i, double n_i_n, double i_n) {
        Double[][] result = InterferenceCriteriaCalculator.calculate(c_i, c_n_i, n_i_n, i_n);
        for (int i = 0; i < 5; ++i) {
            if (!InterferenceCriteriaCalculator.equals(result, c_i, c_n_i, n_i_n, i_n, i)) continue;
            return true;
        }
        return false;
    }

    private static void clear(Double[][] result, int row) {
        result[0][row] = null;
        result[1][row] = null;
        result[2][row] = null;
        result[3][row] = null;
    }

    private static void ifEqualsRemove(Double[][] result, int result1, int result2) {
        if (InterferenceCriteriaCalculator.equals(result, result[0][result1], result[1][result1], result[2][result1], result[3][result1], result2)) {
            InterferenceCriteriaCalculator.clear(result, result2);
        }
    }

    private static boolean equals(Double[][] result, Double c_i, Double c_n_i, Double n_i_n, Double i_n, int row2) {
        return InterferenceCriteriaCalculator.doubleEquals(c_i, result[0][row2]) && InterferenceCriteriaCalculator.doubleEquals(c_n_i, result[1][row2]) && InterferenceCriteriaCalculator.doubleEquals(n_i_n, result[2][row2]) && InterferenceCriteriaCalculator.doubleEquals(i_n, result[3][row2]);
    }

    private static double twoDecimals(double value) {
        return (double)Math.round(value * 100.0) / 100.0;
    }

    public static boolean doubleEquals(Double a, Double b) {
        if (a == null || b == null) {
            return false;
        }
        return Math.abs(a - b) < 1.0E-4;
    }
}

