/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.generic;

import javax.swing.table.DefaultTableModel;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.generic.InterferenceCriteria;
import org.seamcat.presentation.systems.generic.CriteriaChanged;

public class ICWSValuesTable
extends DefaultTableModel {
    private final CriteriaChanged changed;
    private String[] criterias = new String[]{"C/I", "C/(N+I)", "(N+I)/N", "I/N"};
    private double[] inputValues;
    private boolean wsConsistency;

    public ICWSValuesTable(InterferenceCriteria criteria, CriteriaChanged changed) {
        this.changed = changed;
        this.setModel(criteria, false);
    }

    public void setModel(InterferenceCriteria criteria, boolean wsConsistency) {
        this.inputValues = new double[]{criteria.protection_ratio(), criteria.extended_protection_ratio(), criteria.noise_augmentation(), criteria.interference_to_noise_ratio()};
        this.wsConsistency = wsConsistency;
    }

    @Override
    public int getRowCount() {
        return 4;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        return column == 0 ? "Criteria" : "Current";
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.wsConsistency && row == 1) {
            return false;
        }
        return column == 1;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return this.criterias[row];
        }
        return this.inputValues[row];
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        try {
            this.inputValues[row] = Double.parseDouble(aValue.toString());
            this.changed.changed(this.getModel());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public InterferenceCriteria getModel() {
        InterferenceCriteria prototype = Factory.prototype(InterferenceCriteria.class);
        Factory.when(prototype.protection_ratio()).thenReturn(this.inputValues[0]);
        Factory.when(prototype.extended_protection_ratio()).thenReturn(this.inputValues[1]);
        Factory.when(prototype.noise_augmentation()).thenReturn(this.inputValues[2]);
        Factory.when(prototype.interference_to_noise_ratio()).thenReturn(this.inputValues[3]);
        return Factory.build(prototype);
    }
}

