/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.correlation;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.seamcat.model.distributions.AbstractDistribution;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.system.CorrelationMode;
import org.seamcat.model.plugin.system.DefaultCorrelationDefinitions;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.plugin.system.optional.CorrelationDefinitions;
import org.seamcat.model.workspace.CorrelationSettingsUI;
import org.seamcat.presentation.DistributionDialog;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.SeamcatIcons;
import org.seamcat.presentation.valuepreview.ButtonWithValuePreviewTip;
import org.seamcat.presentation.valuepreview.LabelWithValuePreviewTip;
import org.seamcat.presentation.valuepreview.ValuePreviewTextUtil;
import org.seamcat.presentation.valuepreview.ValuePreviewableDistributionAdapter;

public class ModePanel
extends JPanel {
    private String[] deltaEnablements = new String[]{"CONSTANT", "USER_DEFINED", "UNIFORM", "UNIFORM_POLAR_DISTANCE", "STAIR", "DISCRETE_UNIFORM", "GAUSSIAN", "GAUSSIAN_LIMITED", "RAYLEIGH", "RAYLEIGH_LIMITED"};
    private String[] mclEnablements = new String[]{"CONSTANT", "USER_DEFINED", "UNIFORM", "STAIR", "DISCRETE_UNIFORM"};
    private final List<CorrelationMode> modeList;
    private final CorrelationDefinitions iCorr;
    private final CorrelationSettingsUI model;
    private LabelWithValuePreviewTip deltaXValueLabel = new LabelWithValuePreviewTip();
    private LabelWithValuePreviewTip deltaYValueLabel = new LabelWithValuePreviewTip();
    private LabelWithValuePreviewTip mclValueLabel = new LabelWithValuePreviewTip();
    private ButtonWithValuePreviewTip deltaXButton = new ButtonWithValuePreviewTip("Distribution");
    private ButtonWithValuePreviewTip deltaYButton = new ButtonWithValuePreviewTip("Distribution");
    private ButtonWithValuePreviewTip mclButton = new ButtonWithValuePreviewTip("Distribution");
    private JLabel mode = new JLabel("Mode");
    private JComboBox<String> modes;
    private JLabel pos = new JLabel("Position relative to");
    private JComboBox<String> vPointSelector;
    private JLabel refc = new JLabel("Reference component");
    private JComboBox<String> iPoints;
    private Distribution deltaX;
    private Distribution deltaY;
    private Distribution mcl;
    private JLabel info;

    public ModePanel(SystemPlugin victim, SystemPlugin interferer, CorrelationSettingsUI model) {
        this.iCorr = interferer instanceof CorrelationDefinitions ? (CorrelationDefinitions)((Object)interferer) : DefaultCorrelationDefinitions.instance;
        CorrelationDefinitions vCorr = DefaultCorrelationDefinitions.instance;
        if (victim instanceof CorrelationDefinitions) {
            vCorr = (CorrelationDefinitions)((Object)victim);
        }
        this.model = model;
        CellConstraints cc = new CellConstraints();
        this.setLayout(new FormLayout("65dlu, $lcgap, 10dlu:grow, $lcgap, 60dlu, $lcgap, 13dlu", "17*(default, $lgap), default"));
        List<String> targets = this.iCorr.getInterfererTargetPointNames();
        this.iPoints = new JComboBox();
        DefaultComboBoxModel<String> iModel = new DefaultComboBoxModel<String>();
        for (String target : targets) {
            iModel.addElement(target);
        }
        this.iPoints.setModel(iModel);
        List<String> vPoints = vCorr.getVictimCorrelationPoints();
        this.vPointSelector = new JComboBox();
        DefaultComboBoxModel<String> vModel = new DefaultComboBoxModel<String>();
        for (String vPoint : vPoints) {
            vModel.addElement(vPoint);
        }
        this.vPointSelector.setModel(vModel);
        this.initializeFromModel();
        this.modeList = this.iCorr.getCorrelationModes();
        this.modes = new JComboBox();
        DefaultComboBoxModel<String> mod = new DefaultComboBoxModel<String>();
        for (CorrelationMode mode : this.modeList) {
            mod.addElement(mode.toString());
        }
        this.modes.setModel(mod);
        this.modes.setSelectedItem(model.mode().toString());
        this.add((Component)this.mode, cc.xy(1, 1));
        this.add(this.modes, cc.xywh(3, 1, 3, 1));
        if (this.info != null) {
            this.add((Component)this.info, cc.xy(7, 1));
        }
        this.add((Component)this.refc, cc.xy(1, 3));
        this.add(this.iPoints, cc.xywh(3, 3, 3, 1));
        this.add((Component)this.pos, cc.xy(1, 5));
        this.add(this.vPointSelector, cc.xywh(3, 5, 3, 1));
        this.add((Component)new JLabel("Delta X"), cc.xy(1, 7));
        this.add((Component)this.deltaXValueLabel, cc.xy(3, 7));
        this.deltaXButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModePanel.this.deltaX = ModePanel.this.distButtonClicked(ModePanel.this.deltaX, ModePanel.this.deltaXValueLabel, ModePanel.this.deltaXButton, ModePanel.this.deltaEnablements);
            }
        });
        this.add((Component)this.deltaXButton, cc.xy(5, 7));
        this.add((Component)new JLabel("km"), cc.xy(7, 7));
        this.add((Component)new JLabel("Delta Y"), cc.xy(1, 9));
        this.add((Component)this.deltaYValueLabel, cc.xy(3, 9));
        this.deltaYButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModePanel.this.deltaY = ModePanel.this.distButtonClicked(ModePanel.this.deltaY, ModePanel.this.deltaYValueLabel, ModePanel.this.deltaYButton, ModePanel.this.deltaEnablements);
            }
        });
        this.add((Component)this.deltaYButton, cc.xy(5, 9));
        this.add((Component)new JLabel("km"), cc.xy(7, 9));
        this.add((Component)new JLabel("Minimum coupling loss"), cc.xy(1, 11));
        this.add((Component)this.mclValueLabel, cc.xy(3, 11));
        this.mclButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModePanel.this.mcl = ModePanel.this.distButtonClicked(ModePanel.this.mcl, ModePanel.this.mclValueLabel, ModePanel.this.mclButton, ModePanel.this.mclEnablements);
            }
        });
        this.add((Component)this.mclButton, cc.xy(5, 11));
        this.add((Component)new JLabel("dB"), cc.xy(7, 11));
    }

    private void initializeFromModel() {
        this.deltaX = this.model.deltaX();
        this.deltaY = this.model.deltaY();
        this.mcl = this.model.minimumCouplingLoss();
        this.distValuePreview(this.deltaX, this.deltaXValueLabel, this.deltaXButton);
        this.distValuePreview(this.deltaY, this.deltaYValueLabel, this.deltaYButton);
        this.distValuePreview(this.mcl, this.mclValueLabel, this.mclButton);
        this.vPointSelector.setSelectedItem(this.model.positionRelativeTo());
        this.iPoints.setSelectedItem(this.model.correlationTarget());
        String information = this.model.mode().information();
        if (information != null) {
            this.info = new JLabel(SeamcatIcons.getImageIcon("SEAMCAT_ICON_INFORMATION", 0));
            this.info.setToolTipText(information);
        }
    }

    private Distribution distButtonClicked(Distribution current, LabelWithValuePreviewTip label, ButtonWithValuePreviewTip button, String[] enablements) {
        DistributionDialog distributionDialog = new DistributionDialog((Frame)MainWindow.getInstance(), true, enablements);
        Distribution distribution = this.distributionDialog(distributionDialog, current);
        this.distValuePreview(distribution, label, button);
        return distribution;
    }

    private void distValuePreview(Distribution distribution, LabelWithValuePreviewTip label, ButtonWithValuePreviewTip button) {
        label.setText(ValuePreviewTextUtil.previewLabelText(distribution.toString()));
        ValuePreviewableDistributionAdapter previewable = new ValuePreviewableDistributionAdapter((AbstractDistribution)distribution);
        label.setPreviewable(previewable);
        button.setPreviewable(previewable);
    }

    private Distribution distributionDialog(DistributionDialog distributionDialog, Distribution distribution) {
        if (distributionDialog.showDistributionDialog((AbstractDistribution)distribution, "Edit distribution")) {
            return distributionDialog.getDistribution();
        }
        return distribution;
    }

    public void addActionListener(ActionListener listener) {
        this.modes.addActionListener(listener);
    }

    public CorrelationSettingsUI getModel() {
        CorrelationSettingsUI prototype = Factory.prototype(CorrelationSettingsUI.class, this.model);
        Factory.when(prototype.deltaX()).thenReturn(this.deltaX);
        Factory.when(prototype.deltaY()).thenReturn(this.deltaY);
        Factory.when(prototype.minimumCouplingLoss()).thenReturn(this.mcl);
        Factory.when(prototype.mode()).thenReturn(this.modeList.get(this.modes.getSelectedIndex()));
        Factory.when(prototype.positionRelativeTo()).thenReturn((String)this.vPointSelector.getSelectedItem());
        Factory.when(prototype.correlationTarget()).thenReturn((String)this.iPoints.getSelectedItem());
        CorrelationSettingsUI build = Factory.build(prototype);
        return build;
    }

    public void coLocationEnabled(boolean enabled) {
        boolean relevant = !enabled;
        this.mode.setEnabled(relevant);
        this.modes.setEnabled(relevant);
        this.pos.setEnabled(relevant);
        this.vPointSelector.setEnabled(relevant);
        this.refc.setEnabled(relevant);
        this.iPoints.setEnabled(relevant);
    }
}

