/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.correlation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.seamcat.model.InterferenceLinkElement;
import org.seamcat.model.Workspace;
import org.seamcat.model.correlation.None;
import org.seamcat.model.correlation.NoneMode;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.system.CorrelationMode;
import org.seamcat.model.plugin.system.DefaultCorrelationDefinitions;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.plugin.system.optional.AsVictimInterferingLink;
import org.seamcat.model.plugin.system.optional.AsVictimInterferingLinkDefinition;
import org.seamcat.model.plugin.system.optional.CorrelationDefinitions;
import org.seamcat.model.plugin.system.optional.CustomCorrelationDefinitions;
import org.seamcat.model.workspace.CorrelationSettingsUI;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.components.ScrollingBorderPanel;
import org.seamcat.presentation.genericgui.item.ValueWithUsageFlag;
import org.seamcat.presentation.genericgui.panelbuilder.CompositeEditor;
import org.seamcat.presentation.genericgui.panelbuilder.GenericPanelEditor;
import org.seamcat.presentation.systems.correlation.CoLocationPanel;
import org.seamcat.presentation.systems.correlation.ModePanel;

public class CorrelationModePanel
extends JPanel {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private final SystemPlugin victim;
    private final SystemPlugin interferer;
    private final JSplitPane main;
    private ModePanel modePanel;
    private CorrelationMode currentMode;
    private List<GenericPanelEditor<?>> editors = new ArrayList();
    private Workspace workspace;
    private InterferenceLinkElement link;
    private CoLocationPanel coLocationPanel;

    public CorrelationModePanel(Workspace workspace, InterferenceLinkElement link) {
        super(new BorderLayout());
        this.workspace = workspace;
        this.link = link;
        this.victim = workspace.getSystemPlugin(workspace.getVictimSystemId());
        this.interferer = workspace.getSystemPlugin(link.getInterferingSystemId());
        this.main = new JSplitPane(0);
        this.add((Component)this.main, "Center");
        this.initialize(link.getSettings().path().correlationSettings());
    }

    /*
     * WARNING - void declaration
     */
    private void initialize(CorrelationSettingsUI model) {
        this.main.removeAll();
        JSplitPane container = this.main;
        container.add(new JLabel());
        this.editors.clear();
        this.currentMode = model.mode();
        CorrelationDefinitions corr = DefaultCorrelationDefinitions.instance;
        if (this.interferer instanceof CorrelationDefinitions) {
            corr = (CorrelationDefinitions)((Object)this.interferer);
        }
        if (!corr.getCorrelationModes().contains(this.currentMode)) {
            CorrelationSettingsUI prototype = Factory.prototype(CorrelationSettingsUI.class, model);
            Factory.when(prototype.mode()).thenReturn(corr.getCorrelationModes().get(0));
            this.initialize(Factory.build(prototype));
            return;
        }
        Map<Class, String> titles = this.getTitles();
        LinkedHashMap<Class, Object> updated = new LinkedHashMap<Class, Object>();
        Map<Class, Object> current = model.customUI();
        if (this.currentMode == NoneMode.MODE) {
            this.ensure(current, updated, None.class);
        }
        boolean hasCoLocationPanel = false;
        if (corr.allowCoLocation()) {
            for (InterferenceLinkElement element : this.workspace.getInterferenceLinkUIs()) {
                if (this.link == element || element.getSettings().path().correlationSettings().isCoLocated()) continue;
                hasCoLocationPanel = true;
                break;
            }
        }
        if (this.interferer instanceof CustomCorrelationDefinitions) {
            CustomCorrelationDefinitions ocs = (CustomCorrelationDefinitions)((Object)this.interferer);
            Map<Class, String> extras = ocs.extraInputForMode(this.currentMode);
            for (Map.Entry<Class<Object>, String> entry : extras.entrySet()) {
                this.ensure(current, updated, entry.getKey());
            }
            titles.putAll(extras);
        }
        HashMap<Class, String> info = new HashMap<Class, String>();
        List<AsVictimInterferingLinkDefinition> definitions = null;
        if (this.victim instanceof AsVictimInterferingLink) {
            definitions = ((AsVictimInterferingLink)((Object)this.victim)).definitions();
        }
        if (definitions != null) {
            for (AsVictimInterferingLinkDefinition asVictimInterferingLinkDefinition : definitions) {
                this.ensure(current, updated, asVictimInterferingLinkDefinition.getUIClass());
                titles.put(asVictimInterferingLinkDefinition.getUIClass(), asVictimInterferingLinkDefinition.getName());
                if (STRINGLIST.containsKey(asVictimInterferingLinkDefinition.getInformation())) {
                    info.put(asVictimInterferingLinkDefinition.getUIClass(), CompositeEditor.replaceIMG(STRINGLIST.getString(asVictimInterferingLinkDefinition.getInformation())));
                    continue;
                }
                info.put(asVictimInterferingLinkDefinition.getUIClass(), asVictimInterferingLinkDefinition.getInformation());
            }
        }
        current.clear();
        current.putAll(updated);
        this.modePanel = new ModePanel(this.victim, this.interferer, model);
        this.modePanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CorrelationModePanel.this.initialize(CorrelationModePanel.this.modePanel.getModel());
            }
        });
        container = CorrelationModePanel.append(container, new ScrollingBorderPanel(this.modePanel, "Relative Positioning", "See SEAMCAT manual", "http://confluence.seamcat.org/pages/viewpage.action?pageId=1409621"));
        int size = current.size();
        boolean bl = false;
        for (Map.Entry<Class, Object> entry : current.entrySet()) {
            void var11_17;
            GenericPanelEditor<Object> ui = new GenericPanelEditor<Object>(MainWindow.getInstance(), entry.getKey(), entry.getValue());
            this.editors.add(ui);
            ScrollingBorderPanel panel = info.containsKey(entry.getKey()) ? new ScrollingBorderPanel(ui, titles.get(entry.getKey()), (String)info.get(entry.getKey())) : new ScrollingBorderPanel(ui, titles.get(entry.getKey()));
            if (++var11_17 == size) {
                if (hasCoLocationPanel) {
                    container = CorrelationModePanel.append(container, panel);
                    this.coLocationPanel = new CoLocationPanel(this.link, this.workspace, this);
                    container.add(new ScrollingBorderPanel(this.coLocationPanel, "Co-Location Configuration"));
                    continue;
                }
                container.add(panel);
                continue;
            }
            container = CorrelationModePanel.append(container, panel);
        }
        this.coLocationEnabled(model.isCoLocated());
        this.main.revalidate();
        this.main.repaint();
    }

    private Map<Class, String> getTitles() {
        LinkedHashMap<Class, String> titles = new LinkedHashMap<Class, String>();
        titles.put(None.class, "Mode 'None' Configuration");
        return titles;
    }

    private void ensure(Map<Class, Object> current, Map<Class, Object> updated, Class clazz) {
        if (current.containsKey(clazz)) {
            updated.put(clazz, current.get(clazz));
        } else {
            updated.put(clazz, Factory.instance(clazz));
        }
    }

    private static JSplitPane append(JSplitPane container, JPanel component) {
        JSplitPane embedded = new JSplitPane(0);
        embedded.add(component);
        container.add(embedded);
        return embedded;
    }

    public CorrelationSettingsUI getModel() {
        CorrelationSettingsUI model = this.modePanel.getModel();
        if (this.coLocationPanel != null) {
            ValueWithUsageFlag<InterferenceLinkElement> selection = this.coLocationPanel.getSelection();
            CorrelationSettingsUI prototype = Factory.prototype(CorrelationSettingsUI.class, model);
            Factory.when(prototype.isCoLocated()).thenReturn(selection.useValue);
            Factory.when(prototype.coLocatedWith()).thenReturn(((InterferenceLinkElement)selection.value).getId());
            model = Factory.build(prototype);
        }
        for (GenericPanelEditor<?> editor : this.editors) {
            model.customUI().put(editor.getModelClass(), editor.getModel());
        }
        return model;
    }

    public void coLocationEnabled(boolean enabled) {
        for (GenericPanelEditor<?> editor : this.editors) {
            editor.setGlobalRelevance(!enabled);
        }
        this.modePanel.coLocationEnabled(enabled);
    }
}

