/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.cdma.tablemodels;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.Interferer;
import org.seamcat.presentation.systems.cdma.tablemodels.CDMAElementTableValue;

public class ExternalInteferenceLinkTableModel
implements TableModel {
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private List<CDMAElementTableValue> tableentries = new ArrayList<CDMAElementTableValue>();
    private Interferer link;

    public void initTableModel() {
        this.tableentries.clear();
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Pathloss (dB)";
                }
                return Double.toString(Mathematics.round(ExternalInteferenceLinkTableModel.this.link.getLinkResult().getTxRxPathLoss()));
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Distance (km)";
                }
                return Double.toString(Mathematics.round(ExternalInteferenceLinkTableModel.this.link.getLinkResult().getTxRxDistance()));
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "TX Power (dBm)";
                }
                return Double.toString(Mathematics.round(ExternalInteferenceLinkTableModel.this.link.getLinkResult().getTxPower()));
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "TX antenna gain (dB)";
                }
                return Double.toString(Mathematics.round(ExternalInteferenceLinkTableModel.this.link.getLinkResult().txAntenna().getGain()));
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "TX antenna height (m)";
                }
                return Double.toString(Mathematics.round(ExternalInteferenceLinkTableModel.this.link.getLinkResult().txAntenna().getHeight()));
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "RX antenna gain (dB)";
                }
                return Double.toString(Mathematics.round(ExternalInteferenceLinkTableModel.this.link.getLinkResult().rxAntenna().getGain()));
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "RX antenna (m)";
                }
                return Double.toString(Mathematics.round(ExternalInteferenceLinkTableModel.this.link.getLinkResult().rxAntenna().getHeight()));
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "MCL (dB)";
                }
                return Double.toString(Mathematics.round(ExternalInteferenceLinkTableModel.this.link.getMinimumCouplingLoss()));
            }
        });
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Value";
            }
        }
        return "Unknown";
    }

    @Override
    public int getRowCount() {
        if (this.link == null) {
            return 0;
        }
        return this.tableentries.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object obj = this.tableentries.get(rowIndex).getValue(columnIndex);
        if (obj instanceof Double) {
            obj = Mathematics.round((Double)obj);
        }
        return obj;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    public void setLink(Interferer _link) {
        this.link = _link;
        this.initTableModel();
        int stop = this.listeners.size();
        for (int i = 0; i < stop; ++i) {
            this.listeners.get(i).tableChanged(new TableModelEvent(this));
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }
}

