/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.cdma.tablemodels;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.seamcat.cdma.CDMASystem;
import org.seamcat.dmasystems.AbstractDmaMobile;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.types.result.BarChartValue;
import org.seamcat.presentation.systems.cdma.CDMAPlotModel;
import org.seamcat.presentation.systems.cdma.tablemodels.CDMAElementTableValue;
import org.seamcat.simulation.cellular.CellularVictimSystemSimulation;
import org.seamcat.simulation.hybrid.HybridCDMADownLinkPlugin;
import org.seamcat.simulation.hybrid.HybridCDMAUpLinkPlugin;
import org.seamcat.simulation.hybrid.HybridOFDMADownLinkPlugin;
import org.seamcat.simulation.hybrid.HybridOFDMAUpLinkPlugin;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class CDMASystemTableModel
implements TableModel {
    private CDMAPlotModel cdma;
    private List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private List<CDMAElementTableValue> tableentries = new ArrayList<CDMAElementTableValue>();
    private RadioSystem system;

    protected void initTableModel() {
        this.tableentries.clear();
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Link Direction";
                }
                return ((CDMASystemTableModel)CDMASystemTableModel.this).cdma.isUplink ? "Uplink" : "Downlink";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Frequency";
                }
                return CDMASystemTableModel.this.cdma.getFrequency() + " MHz";
            }
        });
        final HybridSystemPlugin plugin = this.cdma.getPlugin();
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Bandwidth";
                }
                return plugin.getBandwidth() + " MHz";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Cell Radius";
                }
                return plugin.getCellRadius() + " km";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Number of External Interferers";
                }
                return CDMASystemTableModel.this.cdma.getExternalInterferers().size();
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Propagation Model";
                }
                return CDMASystemTableModel.this.system.getPropagationModel();
            }
        });
        if (plugin instanceof HybridCDMADownLinkPlugin || plugin instanceof HybridCDMAUpLinkPlugin) {
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return "Bit rate";
                    }
                    return Mathematics.round(((CDMASystemTableModel)CDMASystemTableModel.this).cdma.plugin.getCDMASettings().getVoiceBitRate()) + " kbps";
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return "Link Level Data";
                    }
                    return ((CDMASystemTableModel)CDMASystemTableModel.this).cdma.plugin.getCDMASettings().getLld();
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return "Total Non Interfered Capacity";
                    }
                    return ((CDMASystemTableModel)CDMASystemTableModel.this).cdma.collector.getInt(CDMASystem.NON_INTERFERED_CAPACITY) * CDMASystemTableModel.this.cdma.getNumberOfBaseStations() + " users";
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return "Non Interfered Capacity per Cell";
                    }
                    return ((CDMASystemTableModel)CDMASystemTableModel.this).cdma.collector.getInt(CDMASystem.NON_INTERFERED_CAPACITY) + " users";
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return "Active users";
                    }
                    return CDMASystemTableModel.this.cdma.getActiveUsers().size() + " users";
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return "Dropped users";
                    }
                    return CDMASystemTableModel.this.cdma.getDroppedUsers().size() + " users";
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return "Users dropped before interference";
                    }
                    return ((CDMASystemTableModel)CDMASystemTableModel.this).cdma.collector.get(CellularVictimSystemSimulation.droppedBeforeInterference) + " users";
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return "Number of trials during capacity test";
                    }
                    return ((CDMASystemTableModel)CDMASystemTableModel.this).cdma.plugin.getCDMASettings().getNumberOfTrials();
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return ((CDMASystemTableModel)CDMASystemTableModel.this).cdma.isUplink ? "Average Noise Rise, last event" : "Obtained succes rate";
                    }
                    if (!((CDMASystemTableModel)CDMASystemTableModel.this).cdma.isUplink) {
                        List<BarChartValue> values = ((CDMASystemTableModel)CDMASystemTableModel.this).cdma.collector.getBarChartValues(CDMASystem.CAPACITY_UP_LINK);
                        if (values == null) {
                            return "0";
                        }
                        BarChartValue value = values.get(values.size() - 1);
                        return value.getValue();
                    }
                    return "N/A";
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return "Number of ignored users (due to LLD)";
                    }
                    return CDMASystemTableModel.this.cdma.getNumberOfLLDFound();
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return "Number of ignored users (due to LLD)";
                    }
                    return CDMASystemTableModel.this.cdma.getNumberOfLLDFound();
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return ((CDMASystemTableModel)CDMASystemTableModel.this).cdma.isUplink ? "Highest PC loop count" : "Maximum Traffic Channel Proportion";
                    }
                    return ((CDMASystemTableModel)CDMASystemTableModel.this).cdma.isUplink ? Long.valueOf(Math.round(((CDMASystemTableModel)CDMASystemTableModel.this).cdma.collector.get(CellularVictimSystemSimulation.highestPCLoopCount))) : CDMASystemTableModel.this.cdma.getMaxTrafficChannelPower() + " dBm";
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return "Percentage of active users in soft handover";
                    }
                    List<AbstractDmaMobile> users = CDMASystemTableModel.this.cdma.getActiveUsers();
                    int softHandover = 0;
                    for (AbstractDmaMobile user : users) {
                        if (!user.isInSoftHandover()) continue;
                        ++softHandover;
                    }
                    double percentage = (double)softHandover / (double)users.size() * 100.0;
                    return Mathematics.round(percentage) + "%";
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return "Percentage of dropped users in soft handover";
                    }
                    if (CDMASystemTableModel.this.cdma.getDroppedUsers().size() > 0) {
                        List<AbstractDmaMobile> users = CDMASystemTableModel.this.cdma.getDroppedUsers();
                        int softHandover = 0;
                        for (AbstractDmaMobile user : users) {
                            if (!user.isInSoftHandover()) continue;
                            ++softHandover;
                        }
                        double percentage = (double)softHandover / (double)users.size() * 100.0;
                        return Mathematics.round(percentage) + "%";
                    }
                    return "No dropped Users";
                }
            });
        } else if (plugin instanceof HybridOFDMAUpLinkPlugin || plugin instanceof HybridOFDMADownLinkPlugin) {
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return "Processing Gain";
                    }
                    return Mathematics.round(CDMASystemTableModel.this.cdma.getProcessingGain());
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return "Percentage of active users in handover";
                    }
                    List<AbstractDmaMobile> users = CDMASystemTableModel.this.cdma.getActiveUsers();
                    int softHandover = 0;
                    for (AbstractDmaMobile user : users) {
                        if (!user.isInSoftHandover()) continue;
                        ++softHandover;
                    }
                    double percentage = (double)softHandover / (double)users.size() * 100.0;
                    return Mathematics.round(percentage) + "%";
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return "Percentage of dropped users in handover";
                    }
                    if (CDMASystemTableModel.this.cdma.getDroppedUsers().size() > 0) {
                        List<AbstractDmaMobile> users = CDMASystemTableModel.this.cdma.getDroppedUsers();
                        int softHandover = 0;
                        for (AbstractDmaMobile user : users) {
                            if (!user.isInSoftHandover()) continue;
                            ++softHandover;
                        }
                        double percentage = (double)softHandover / (double)users.size() * 100.0;
                        return Mathematics.round(percentage) + "%";
                    }
                    return "No dropped Users";
                }
            });
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnIndex == 0 ? "Name" : "Value";
    }

    @Override
    public int getRowCount() {
        return this.tableentries.size();
    }

    public CDMAPlotModel getSelectedCell() {
        return this.cdma;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object obj = this.tableentries.get(rowIndex).getValue(columnIndex);
        if (obj instanceof Double) {
            obj = Mathematics.round((Double)obj);
        }
        return obj;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    public void setDmaSystem(CDMAPlotModel cdmasystem) {
        this.cdma = cdmasystem;
        this.system = cdmasystem.getCellularSystem();
        this.initTableModel();
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).tableChanged(new TableModelEvent(this));
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }
}

