/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.cdma.tablemodels;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.ofdma.OfdmaMobile;
import org.seamcat.presentation.systems.cdma.tablemodels.CDMAElementTableValue;

public class CDMALinkInfoTableModel
implements TableModel {
    private AbstractDmaLink link;
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private List<CDMAElementTableValue> tableentries = new ArrayList<CDMAElementTableValue>();

    public void initTableModel() {
        this.tableentries.clear();
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                return columnIndex == 0 ? "Userid" : Integer.valueOf(CDMALinkInfoTableModel.this.link.getUserTerminal().getUserId());
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                return columnIndex == 0 ? "In users active list" : Boolean.valueOf(CDMALinkInfoTableModel.this.link.getUserTerminal().getActiveList().contains(CDMALinkInfoTableModel.this.link));
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                return columnIndex == 0 ? "Cellid" : Integer.valueOf(CDMALinkInfoTableModel.this.link.getBaseStation().getCellid());
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                return columnIndex == 0 ? "Cell location id" : Integer.valueOf(CDMALinkInfoTableModel.this.link.getBaseStation().getCellLocationId());
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                return columnIndex == 0 ? "Connected sector of cell location" : Integer.valueOf(CDMALinkInfoTableModel.this.link.getBaseStation().getSectorId());
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                return columnIndex == 0 ? "User Position" : "(" + Mathematics.round(CDMALinkInfoTableModel.this.link.getUserTerminal().getPosition().getX()) + ", " + Mathematics.round(CDMALinkInfoTableModel.this.link.getUserTerminal().getPosition().getY()) + ")";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                return columnIndex == 0 ? "Cell Position" : "(" + Mathematics.round(CDMALinkInfoTableModel.this.link.getBaseStation().getPosition().getX()) + ", " + Mathematics.round(CDMALinkInfoTableModel.this.link.getBaseStation().getPosition().getY()) + ")";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                return columnIndex == 0 ? "Using WrapAround" : Boolean.valueOf(CDMALinkInfoTableModel.this.link.isUsingWrapAround());
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                return columnIndex == 0 ? "Distance" : Mathematics.round(CDMALinkInfoTableModel.this.link.getDistance()) + " km";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                return columnIndex == 0 ? "BS antenna gain" : Mathematics.round(CDMALinkInfoTableModel.this.link.isUpLink() ? CDMALinkInfoTableModel.this.link.asLinkResult().rxAntenna().getGain() : CDMALinkInfoTableModel.this.link.asLinkResult().txAntenna().getGain()) + " dB";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                return columnIndex == 0 ? "UE antenna gain" : (CDMALinkInfoTableModel.this.link.isUpLink() ? Double.valueOf(CDMALinkInfoTableModel.this.link.asLinkResult().txAntenna().getGain()) : CDMALinkInfoTableModel.this.link.asLinkResult().rxAntenna().getGain() + " dB");
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                return columnIndex == 0 ? "Pathloss" : CDMALinkInfoTableModel.this.link.getTxRxPathLoss() + " dB";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                return columnIndex == 0 ? "Effective Pathloss" : Mathematics.round(CDMALinkInfoTableModel.this.link.getEffectivePathloss()) + " dB";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                return columnIndex == 0 ? "Horizontal Angle" : Double.valueOf(Mathematics.round(CDMALinkInfoTableModel.this.link.asLinkResult().rxAntenna().getAzimuth()) + 176.0);
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                return columnIndex == 0 ? "Vertical Angle" : Double.valueOf(Mathematics.round(CDMALinkInfoTableModel.this.link.asLinkResult().rxAntenna().getElevation()) + 176.0);
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (!CDMALinkInfoTableModel.this.link.isUpLink()) {
                    return columnIndex == 0 ? "Total Transmit Power" : Mathematics.round(CDMALinkInfoTableModel.this.link.getBaseStation().getCurrentTransmitPower_dBm()) + " dBm";
                }
                return columnIndex == 0 ? "Total Transmit Power" : Mathematics.round(CDMALinkInfoTableModel.this.link.getUserTerminal().getCurrentTransmitPowerIndBm()) + " dBm";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                return columnIndex == 0 ? "Power scaled down to max" : Boolean.valueOf(CDMALinkInfoTableModel.this.link.isPowerScaledDownToMax());
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                return columnIndex == 0 ? "Power scaled down to max by" : (CDMALinkInfoTableModel.this.link.isPowerScaledDownToMax() ? "CDMAlink.scaleTransmitPower" : "power not scaled");
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                return columnIndex == 0 ? "Total Received power" : Mathematics.round(CDMALinkInfoTableModel.this.link.getReceivePower_dB()) + " dBm";
            }
        });
        if (this.link.getUserTerminal() instanceof OfdmaMobile) {
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int column) {
                    return column == 0 ? "Bitrate with interference" : Mathematics.round(CDMALinkInfoTableModel.this.link.getUserTerminal().getBitRateAchieved()) + " kbps";
                }
            });
        }
        if (this.link.getUserTerminal() instanceof OfdmaMobile) {
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int column) {
                    return column == 0 ? "SINR" : Double.valueOf(Mathematics.round(CDMALinkInfoTableModel.this.link.getUserTerminal().getSINRAchieved()));
                }
            });
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Value";
            }
        }
        return "Unknown";
    }

    public AbstractDmaLink getLink() {
        return this.link;
    }

    @Override
    public int getRowCount() {
        if (this.link == null) {
            return 0;
        }
        return this.tableentries.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object obj = this.tableentries.get(rowIndex).getValue(columnIndex);
        if (obj instanceof Double) {
            obj = Mathematics.round((Double)obj);
        }
        return obj;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    public void setCDMALink(AbstractDmaLink _link) {
        this.link = _link;
        this.initTableModel();
        int stop = this.listeners.size();
        for (int i = 0; i < stop; ++i) {
            this.listeners.get(i).tableChanged(new TableModelEvent(this));
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }
}

