/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.cdma;

import java.awt.Font;
import java.awt.GridLayout;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.seamcat.presentation.components.DiscreteFunctionGraph;
import org.seamcat.presentation.systems.cdma.CDMAEditModel;

public class LLDGraphPanel
extends JPanel {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private final XYSeriesCollection dataSet = new XYSeriesCollection();
    private final JFreeChart chart = ChartFactory.createXYLineChart("", STRINGLIST.getString("LIBRARY_CDMA_LLD_DETAILS_GEOMETRY"), "Eb/No target [dB]", this.dataSet, PlotOrientation.VERTICAL, true, true, false);
    private CDMAEditModel model;

    public LLDGraphPanel() {
        super(new GridLayout());
        for (int x = 1; x < CDMAEditModel.COLUMN_NAMES.length; ++x) {
            this.dataSet.addSeries(new XYSeries((Comparable)((Object)CDMAEditModel.COLUMN_NAMES[x])));
        }
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)this.chart.getXYPlot().getRenderer();
        renderer.setShapesVisible(true);
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setMouseZoomable(true, false);
        Font f = new Font(this.getFont().getName(), this.getFont().getStyle(), 12);
        DiscreteFunctionGraph.applyStyles(chartPanel, f, true);
        this.add(chartPanel);
    }

    public void setGraph(CDMAEditModel model) {
        this.model = model;
        this.dataSet.removeAllSeries();
        if (model != null) {
            XYSeriesCollection collection = model.getXYSeriesCollection();
            int stop = collection.getSeriesCount();
            for (int x = 0; x < stop; ++x) {
                this.dataSet.addSeries(collection.getSeries(x));
            }
        }
    }

    public void setRangeLabel(String pct, String targetType) {
        String label = String.format(STRINGLIST.getString("LIBRARY_CDMA_LLD_DETAILS_GRAPH_RANGE_LABEL"), pct, targetType);
        this.chart.getXYPlot().getRangeAxis().setLabel(label);
    }

    public void updateGraph() {
        this.setGraph(this.model);
    }
}

